/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.protobuf.MessageLite;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.CodegenUtilKt;
import org.jetbrains.kotlin.backend.common.DataClassMethodGenerator;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.ArgumentAndDeclIndex;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallBasedArgumentGenerator;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBodyCodegen;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.CollectionStubMethodGenerator;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.DefaultParameterValueSubstitutor;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.InterfaceImplBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.WriteAnnotationUtilKt;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.ConstructorContext;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.extensions.ExpressionCodegenExtension;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializerExtension;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmClassSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class ImplementationBodyCodegen
extends ClassBodyCodegen {
    private static final String ENUM_VALUES_FIELD_NAME = "$VALUES";
    private Type superClassAsmType;
    @Nullable
    private KotlinType superClassType;
    private final Type classAsmType;
    private final boolean isLocal;
    private List<PropertyAndDefaultValue> companionObjectPropertiesToCopy;
    private final DelegationFieldsInfo delegationFieldsInfo;
    private final List<Function2<ImplementationBodyCodegen, ClassBuilder, Unit>> additionalTasks;
    private static final Map<FqName, String> KOTLIN_MARKER_INTERFACES = new HashMap<FqName, String>();

    public ImplementationBodyCodegen(@NotNull KtClassOrObject aClass2, @NotNull ClassContext context, @NotNull ClassBuilder v, @NotNull GenerationState state, @Nullable MemberCodegen<?> parentCodegen, boolean isLocal) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "<init>"));
        }
        super(aClass2, context, v, state, parentCodegen);
        this.additionalTasks = new ArrayList<Function2<ImplementationBodyCodegen, ClassBuilder, Unit>>();
        this.classAsmType = this.typeMapper.mapClass(this.descriptor);
        this.isLocal = isLocal;
        this.delegationFieldsInfo = this.getDelegationFieldsInfo(this.myClass.getSuperTypeListEntries());
    }

    @Override
    protected void generateDeclaration() {
        boolean isStatic;
        this.getSuperClass();
        JvmClassSignature signature = this.signature();
        boolean isAbstract = false;
        boolean isInterface = false;
        boolean isFinal = false;
        boolean isAnnotation = false;
        boolean isEnum = false;
        if (this.myClass instanceof KtClass) {
            KtClass ktClass = (KtClass)this.myClass;
            if (ktClass.hasModifier(KtTokens.ABSTRACT_KEYWORD) || ktClass.isSealed()) {
                isAbstract = true;
            }
            if (ktClass.isInterface()) {
                isAbstract = true;
                isInterface = true;
            } else if (this.descriptor.getKind() == ClassKind.ANNOTATION_CLASS) {
                isAbstract = true;
                isInterface = true;
                isAnnotation = true;
            } else if (ktClass.isEnum()) {
                isAbstract = JvmCodegenUtil.hasAbstractMembers(this.descriptor);
                isEnum = true;
            }
            if (DescriptorUtils.isObject(this.descriptor)) {
                isFinal = true;
            }
            if (!ktClass.hasModifier(KtTokens.OPEN_KEYWORD) && !isAbstract) {
                isFinal = !ktClass.isEnum() || this.state.getClassBuilderMode() != ClassBuilderMode.LIGHT_CLASSES;
            }
            isStatic = !ktClass.isInner();
        } else {
            isStatic = DescriptorUtils.isCompanionObject(this.descriptor);
            isFinal = true;
        }
        int access = 0;
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES && !DescriptorUtils.isTopLevelDeclaration(this.descriptor)) {
            access |= AsmUtil.getVisibilityAccessFlag(this.descriptor);
            if (isStatic) {
                access |= 8;
            }
        } else {
            access |= AsmUtil.getVisibilityAccessFlagForClass(this.descriptor);
        }
        if (isAbstract) {
            access |= 0x400;
        }
        access = isInterface ? (access |= 0x200) : (access |= 0x20);
        if (isFinal) {
            access |= 0x10;
        }
        if (isAnnotation) {
            access |= 0x2000;
        }
        if (KotlinBuiltIns.isDeprecated(this.descriptor)) {
            access |= 0x20000;
        }
        if (isEnum) {
            for (KtDeclaration declaration : this.myClass.getDeclarations()) {
                if (!(declaration instanceof KtEnumEntry) || !CodegenBinding.enumEntryNeedSubclass(this.bindingContext, (KtEnumEntry)declaration)) continue;
                access &= 0xFFFFFFEF;
            }
            access |= 0x4000;
        }
        this.v.defineClass(this.myClass, 50, access, signature.getName(), signature.getJavaGenericSignature(), signature.getSuperclassName(), ArrayUtil.toStringArray(signature.getInterfaces()));
        this.v.visitSource(this.myClass.getContainingFile().getName(), null);
        InlineCodegenUtil.initDefaultSourceMappingIfNeeded(this.context, this, this.state);
        this.writeEnclosingMethod();
        AnnotationCodegen.forClass(this.v.getVisitor(), this.typeMapper).genAnnotations(this.descriptor, null);
        this.generateEnumEntries();
    }

    @Override
    protected void generateDefaultImplsIfNeeded() {
        if (DescriptorUtils.isInterface(this.descriptor) && !this.isLocal) {
            Type defaultImplsType = this.state.getTypeMapper().mapDefaultImpls(this.descriptor);
            ClassBuilder defaultImplsBuilder = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.TraitImpl(this.myClass, this.descriptor), defaultImplsType, this.myClass.getContainingFile());
            CodegenContext parentContext = this.context.getParentContext();
            assert (parentContext != null) : "Parent context of interface declaration should not be null";
            ClassContext defaultImplsContext = parentContext.intoDefaultImplsClass(this.descriptor, (ClassContext)this.context, this.state);
            new InterfaceImplBodyCodegen(this.myClass, defaultImplsContext, defaultImplsBuilder, this.state, this).generate();
        }
    }

    @Override
    protected void generateKotlinAnnotation() {
        final DescriptorSerializer serializer = DescriptorSerializer.create(this.descriptor, new JvmSerializerExtension(this.v.getSerializationBindings(), this.state));
        final ProtoBuf.Class classProto = serializer.classProto(this.descriptor).build();
        WriteAnnotationUtilKt.writeKotlinMetadata(this.v, KotlinClassHeader.Kind.CLASS, (Function1<? super AnnotationVisitor, Unit>)new Function1<AnnotationVisitor, Unit>(){

            public Unit invoke(AnnotationVisitor av) {
                AsmUtil.writeAnnotationData(av, serializer, (MessageLite)classProto, false);
                return Unit.INSTANCE;
            }
        });
        AnnotationVisitor av = this.v.getVisitor().visitAnnotation(AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_CLASS), true);
        JvmCodegenUtil.writeAbiVersion(av);
        AsmUtil.writeAnnotationData(av, serializer, (MessageLite)classProto, true);
        av.visitEnd();
    }

    private void writeEnclosingMethod() {
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) {
            return;
        }
        if (DescriptorUtils.isAnonymousObject(this.descriptor) || !(this.descriptor.getContainingDeclaration() instanceof ClassOrPackageFragmentDescriptor)) {
            this.writeOuterClassAndEnclosingMethod();
        }
    }

    @NotNull
    private JvmClassSignature signature() {
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.CLASS);
        this.typeMapper.writeFormalTypeParameters(this.descriptor.getDeclaredTypeParameters(), sw);
        sw.writeSuperclass();
        if (this.superClassType == null) {
            sw.writeClassBegin(this.superClassAsmType);
            sw.writeClassEnd();
        } else {
            this.typeMapper.mapSupertype(this.superClassType, sw);
        }
        sw.writeSuperclassEnd();
        LinkedHashSet<String> superInterfaces = new LinkedHashSet<String>();
        LinkedHashSet<String> kotlinMarkerInterfaces = new LinkedHashSet<String>();
        for (KotlinType supertype : this.descriptor.getTypeConstructor().getSupertypes()) {
            if (!JvmCodegenUtil.isJvmInterface(supertype.getConstructor().getDeclarationDescriptor())) continue;
            sw.writeInterface();
            Type jvmInterfaceType = this.typeMapper.mapSupertype(supertype, sw);
            sw.writeInterfaceEnd();
            String jvmInterfaceInternalName = jvmInterfaceType.getInternalName();
            superInterfaces.add(jvmInterfaceInternalName);
            FqName kotlinInterfaceName = DescriptorUtils.getFqName(supertype.getConstructor().getDeclarationDescriptor()).toSafe();
            String kotlinMarkerInterfaceInternalName = KOTLIN_MARKER_INTERFACES.get(kotlinInterfaceName);
            if (kotlinMarkerInterfaceInternalName == null) continue;
            kotlinMarkerInterfaces.add(kotlinMarkerInterfaceInternalName);
        }
        for (String kotlinMarkerInterface : kotlinMarkerInterfaces) {
            sw.writeInterface();
            sw.writeAsmType(Type.getObjectType((String)kotlinMarkerInterface));
            sw.writeInterfaceEnd();
        }
        superInterfaces.addAll(kotlinMarkerInterfaces);
        JvmClassSignature jvmClassSignature = new JvmClassSignature(this.classAsmType.getInternalName(), this.superClassAsmType.getInternalName(), new ArrayList<String>(superInterfaces), sw.makeJavaGenericSignature());
        if (jvmClassSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "signature"));
        }
        return jvmClassSignature;
    }

    protected void getSuperClass() {
        this.superClassAsmType = AsmTypes.OBJECT_TYPE;
        this.superClassType = null;
        if (this.descriptor.getKind() == ClassKind.INTERFACE) {
            return;
        }
        for (KotlinType supertype : this.descriptor.getTypeConstructor().getSupertypes()) {
            ClassifierDescriptor superClass = supertype.getConstructor().getDeclarationDescriptor();
            if (superClass == null || JvmCodegenUtil.isJvmInterface(superClass)) continue;
            this.superClassAsmType = this.typeMapper.mapClass(superClass);
            this.superClassType = supertype;
            return;
        }
    }

    @Override
    protected void generateSyntheticParts() {
        this.generatePropertyMetadataArrayFieldIfNeeded(this.classAsmType);
        this.generateFieldForSingleton();
        this.generateCompanionObjectBackingFieldCopies();
        this.generateTraitMethods();
        this.generateDelegates(this.delegationFieldsInfo);
        if (!DescriptorUtils.isInterface(this.descriptor) || this.kind == OwnerKind.DEFAULT_IMPLS) {
            this.generateSyntheticAccessors();
        }
        this.generateEnumMethods();
        this.generateFunctionsForDataClasses();
        new CollectionStubMethodGenerator(this.state, this.descriptor, this.functionCodegen, this.v).generate();
        this.generateToArray();
        AsmUtil.genClosureFields(this.context.closure, this.v, this.typeMapper);
        for (ExpressionCodegenExtension extension : ExpressionCodegenExtension.Companion.getInstances(this.state.getProject())) {
            extension.generateClassSyntheticParts(this.v, this.state, this.myClass, this.descriptor);
        }
    }

    @Override
    protected void generateConstructors() {
        try {
            this.lookupConstructorExpressionsInClosureIfPresent();
            this.generatePrimaryConstructor(this.delegationFieldsInfo);
            for (ConstructorDescriptor secondaryConstructor : DescriptorUtilsKt.getSecondaryConstructors(this.descriptor)) {
                this.generateSecondaryConstructor(secondaryConstructor);
            }
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error generating constructors of class " + this.myClass.getName() + " with kind " + (Object)((Object)this.kind), e);
        }
    }

    private boolean isGenericToArrayPresent() {
        Collection<FunctionDescriptor> functions2 = this.descriptor.getDefaultType().getMemberScope().getContributedFunctions(Name.identifier("toArray"), NoLookupLocation.FROM_BACKEND);
        for (FunctionDescriptor function2 : functions2) {
            KotlinType elementType;
            if (CallResolverUtilKt.isOrOverridesSynthesized(function2) || function2.getValueParameters().size() != 1 || function2.getTypeParameters().size() != 1) continue;
            KotlinType returnType2 = function2.getReturnType();
            assert (returnType2 != null) : function2.toString();
            KotlinType paramType = function2.getValueParameters().get(0).getType();
            if (!KotlinBuiltIns.isArray(returnType2) || !KotlinBuiltIns.isArray(paramType) || !KotlinTypeChecker.DEFAULT.equalTypes(elementType = function2.getTypeParameters().get(0).getDefaultType(), DescriptorUtilsKt.getBuiltIns(this.descriptor).getArrayElementType(returnType2)) || !KotlinTypeChecker.DEFAULT.equalTypes(elementType, DescriptorUtilsKt.getBuiltIns(this.descriptor).getArrayElementType(paramType))) continue;
            return true;
        }
        return false;
    }

    private void generateToArray() {
        InstructionAdapter iv;
        MethodVisitor mv;
        int access;
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(this.descriptor);
        if (!DescriptorUtils.isSubclass(this.descriptor, builtIns.getCollection())) {
            return;
        }
        int n = access = this.descriptor.getKind() == ClassKind.INTERFACE ? 1025 : 1;
        if (CodegenUtil.getDeclaredFunctionByRawSignature(this.descriptor, Name.identifier("toArray"), builtIns.getArray(), new ClassifierDescriptor[0]) == null) {
            mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, access, "toArray", "()[Ljava/lang/Object;", null, null);
            if (this.descriptor.getKind() != ClassKind.INTERFACE) {
                iv = new InstructionAdapter(mv);
                mv.visitCode();
                iv.load(0, this.classAsmType);
                iv.invokestatic("kotlin/jvm/internal/CollectionToArray", "toArray", "(Ljava/util/Collection;)[Ljava/lang/Object;", false);
                iv.areturn(Type.getType((String)"[Ljava/lang/Object;"));
                FunctionCodegen.endVisit(mv, "toArray", this.myClass);
            }
        }
        if (!this.isGenericToArrayPresent()) {
            mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, access, "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;", null, null);
            if (this.descriptor.getKind() != ClassKind.INTERFACE) {
                iv = new InstructionAdapter(mv);
                mv.visitCode();
                iv.load(0, this.classAsmType);
                iv.load(1, Type.getType((String)"[Ljava/lang/Object;"));
                iv.invokestatic("kotlin/jvm/internal/CollectionToArray", "toArray", "(Ljava/util/Collection;[Ljava/lang/Object;)[Ljava/lang/Object;", false);
                iv.areturn(Type.getType((String)"[Ljava/lang/Object;"));
                FunctionCodegen.endVisit(mv, "toArray", this.myClass);
            }
        }
    }

    private void generateFunctionsForDataClasses() {
        if (!this.descriptor.isData()) {
            return;
        }
        new DataClassMethodGeneratorImpl(this.myClass, this.bindingContext).generate();
    }

    @NotNull
    private static ConstructorDescriptor getPrimaryConstructorOfDataClass(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "getPrimaryConstructorOfDataClass"));
        }
        ConstructorDescriptor constructor = classDescriptor.getUnsubstitutedPrimaryConstructor();
        assert (constructor != null) : "Data class must have primary constructor: " + classDescriptor;
        ConstructorDescriptor constructorDescriptor = constructor;
        if (constructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "getPrimaryConstructorOfDataClass"));
        }
        return constructorDescriptor;
    }

    private void generateEnumMethods() {
        if (DescriptorUtils.isEnumClass(this.descriptor)) {
            this.generateEnumValuesMethod();
            this.generateEnumValueOfMethod();
        }
    }

    private void generateEnumValuesMethod() {
        Type type2 = this.typeMapper.mapType(DescriptorUtilsKt.getBuiltIns(this.descriptor).getArrayType(Variance.INVARIANT, this.descriptor.getDefaultType()));
        VariableDescriptor valuesProperty = (VariableDescriptor)CollectionsKt.single(this.descriptor.getStaticScope().getContributedVariables(DescriptorUtils.ENUM_VALUES, NoLookupLocation.FROM_BACKEND), (Function1)new Function1<VariableDescriptor, Boolean>(){

            public Boolean invoke(VariableDescriptor descriptor2) {
                return CodegenUtil.isEnumValuesProperty(descriptor2);
            }
        });
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(this.myClass, valuesProperty), 9, DescriptorUtils.ENUM_VALUES.asString(), "()" + type2.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        mv.visitCode();
        mv.visitFieldInsn(178, this.classAsmType.getInternalName(), ENUM_VALUES_FIELD_NAME, type2.getDescriptor());
        mv.visitMethodInsn(182, type2.getInternalName(), "clone", "()Ljava/lang/Object;", false);
        mv.visitTypeInsn(192, type2.getInternalName());
        mv.visitInsn(176);
        FunctionCodegen.endVisit(mv, "values()", this.myClass);
    }

    private void generateEnumValueOfMethod() {
        FunctionDescriptor valueOfFunction = (FunctionDescriptor)CollectionsKt.single(this.descriptor.getStaticScope().getContributedFunctions(DescriptorUtils.ENUM_VALUE_OF, NoLookupLocation.FROM_BACKEND), (Function1)new Function1<FunctionDescriptor, Boolean>(){

            public Boolean invoke(FunctionDescriptor descriptor2) {
                return CodegenUtil.isEnumValueOfMethod(descriptor2);
            }
        });
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(this.myClass, valueOfFunction), 9, DescriptorUtils.ENUM_VALUE_OF.asString(), "(Ljava/lang/String;)" + this.classAsmType.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        mv.visitCode();
        mv.visitLdcInsn((Object)this.classAsmType);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/Enum", "valueOf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;", false);
        mv.visitTypeInsn(192, this.classAsmType.getInternalName());
        mv.visitInsn(176);
        FunctionCodegen.endVisit(mv, "valueOf()", this.myClass);
    }

    private void generateFieldForSingleton() {
        if (DescriptorUtils.isEnumEntry(this.descriptor) || DescriptorUtils.isCompanionObject(this.descriptor)) {
            return;
        }
        if (DescriptorUtils.isNonCompanionObject(this.descriptor)) {
            StackValue.Field field2 = StackValue.singletonViaInstance(this.descriptor, this.typeMapper);
            this.v.newField(JvmDeclarationOriginKt.OtherOrigin(this.myClass), 25, field2.name, field2.type.getDescriptor(), null, null);
            if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
                return;
            }
            InstructionAdapter v = this.createOrGetClInitCodegen().v;
            ImplementationBodyCodegen.markLineNumberForElement((PsiElement)this.element, v);
            v.anew(this.classAsmType);
            v.invokespecial(this.classAsmType.getInternalName(), "<init>", "()V", false);
            return;
        }
        ClassDescriptor companionObjectDescriptor2 = this.descriptor.getCompanionObjectDescriptor();
        if (companionObjectDescriptor2 == null) {
            return;
        }
        KtObjectDeclaration companionObject = (KtObjectDeclaration)CollectionsKt.firstOrNull(((KtClass)this.myClass).getCompanionObjects());
        assert (companionObject != null) : "Companion object not found: " + this.myClass.getText();
        StackValue.Field field3 = StackValue.singleton(companionObjectDescriptor2, this.typeMapper);
        this.v.newField(JvmDeclarationOriginKt.OtherOrigin(companionObject), 25, field3.name, field3.type.getDescriptor(), null, null);
    }

    private void generateCompanionObjectBackingFieldCopies() {
        if (this.companionObjectPropertiesToCopy == null) {
            return;
        }
        for (PropertyAndDefaultValue info : this.companionObjectPropertiesToCopy) {
            PropertyDescriptor property2 = info.descriptor;
            Type type2 = this.typeMapper.mapType(property2);
            int modifiers = 25;
            FieldVisitor fv = this.v.newField(JvmDeclarationOriginKt.Synthetic(DescriptorToSourceUtils.descriptorToDeclaration(property2), property2), modifiers, this.context.getFieldName(property2, false), type2.getDescriptor(), this.typeMapper.mapFieldSignature(property2.getType(), property2), info.defaultValue);
            AnnotationCodegen.forField(fv, this.typeMapper).genAnnotations(property2, type2);
            if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL || info.defaultValue != null) continue;
            ExpressionCodegen codegen = this.createOrGetClInitCodegen();
            int companionObjectIndex = this.putCompanionObjectInLocalVar(codegen);
            StackValue.local(companionObjectIndex, AsmTypes.OBJECT_TYPE).put(AsmTypes.OBJECT_TYPE, codegen.v);
            this.copyFieldFromCompanionObject(property2);
        }
    }

    private int putCompanionObjectInLocalVar(ExpressionCodegen codegen) {
        FrameMap frameMap = codegen.myFrameMap;
        ClassDescriptor companionObjectDescriptor2 = this.descriptor.getCompanionObjectDescriptor();
        int companionObjectIndex = frameMap.getIndex(companionObjectDescriptor2);
        if (companionObjectIndex == -1) {
            companionObjectIndex = frameMap.enter(companionObjectDescriptor2, AsmTypes.OBJECT_TYPE);
            StackValue.Field companionObject = StackValue.singleton(companionObjectDescriptor2, this.typeMapper);
            StackValue.local(companionObjectIndex, companionObject.type).store(companionObject, codegen.v);
        }
        return companionObjectIndex;
    }

    private void copyFieldFromCompanionObject(PropertyDescriptor propertyDescriptor) {
        ExpressionCodegen codegen = this.createOrGetClInitCodegen();
        StackValue.Property property2 = codegen.intermediateValueForProperty(propertyDescriptor, false, null, StackValue.none());
        StackValue.Field field2 = StackValue.field(property2.type, this.classAsmType, propertyDescriptor.getName().asString(), true, StackValue.none(), propertyDescriptor);
        field2.store(property2, codegen.v);
    }

    private void generateCompanionObjectInitializer(@NotNull ClassDescriptor companionObject) {
        if (companionObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "companionObject", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateCompanionObjectInitializer"));
        }
        ExpressionCodegen codegen = this.createOrGetClInitCodegen();
        FunctionDescriptor constructor = (FunctionDescriptor)this.context.accessibleDescriptor((CallableMemberDescriptor)CollectionsKt.single(companionObject.getConstructors()), null);
        this.generateMethodCallTo(constructor, null, codegen.v);
        StackValue instance = StackValue.onStack(this.typeMapper.mapClass(companionObject));
        StackValue.singleton(companionObject, this.typeMapper).store(instance, codegen.v, true);
    }

    private void generatePrimaryConstructor(final DelegationFieldsInfo delegationFieldsInfo) {
        if (DescriptorUtils.isInterface(this.descriptor) || DescriptorUtils.isAnnotationClass(this.descriptor)) {
            return;
        }
        ConstructorDescriptor constructorDescriptor = this.descriptor.getUnsubstitutedPrimaryConstructor();
        if (constructorDescriptor == null) {
            return;
        }
        ConstructorContext constructorContext = this.context.intoConstructor(constructorDescriptor);
        final KtPrimaryConstructor primaryConstructor2 = this.myClass.getPrimaryConstructor();
        JvmDeclarationOrigin origin = JvmDeclarationOriginKt.OtherOrigin(primaryConstructor2 != null ? primaryConstructor2 : this.myClass, constructorDescriptor);
        this.functionCodegen.generateMethod(origin, constructorDescriptor, constructorContext, new FunctionGenerationStrategy.CodegenBased<ConstructorDescriptor>(this.state, constructorDescriptor){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                if (codegen == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$4", "doGenerateBody"));
                }
                if (signature == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$4", "doGenerateBody"));
                }
                ImplementationBodyCodegen.this.generatePrimaryConstructorImpl((ConstructorDescriptor)this.callableDescriptor, codegen, delegationFieldsInfo, primaryConstructor2);
            }
        });
        this.functionCodegen.generateDefaultIfNeeded(constructorContext, constructorDescriptor, OwnerKind.IMPLEMENTATION, DefaultParameterValueLoader.DEFAULT, null);
        new DefaultParameterValueSubstitutor(this.state).generatePrimaryConstructorOverloadsIfNeeded(constructorDescriptor, this.v, this.kind, this.myClass);
    }

    private void generateSecondaryConstructor(@NotNull ConstructorDescriptor constructorDescriptor) {
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSecondaryConstructor"));
        }
        if (!DescriptorUtils.canHaveDeclaredConstructors(this.descriptor)) {
            return;
        }
        ConstructorContext constructorContext = this.context.intoConstructor(constructorDescriptor);
        KtSecondaryConstructor constructor = (KtSecondaryConstructor)DescriptorToSourceUtils.descriptorToDeclaration(constructorDescriptor);
        this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOrigin(constructor, constructorDescriptor), constructorDescriptor, constructorContext, new FunctionGenerationStrategy.CodegenBased<ConstructorDescriptor>(this.state, constructorDescriptor){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                if (codegen == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$5", "doGenerateBody"));
                }
                if (signature == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$5", "doGenerateBody"));
                }
                ImplementationBodyCodegen.this.generateSecondaryConstructorImpl((ConstructorDescriptor)this.callableDescriptor, codegen);
            }
        });
        this.functionCodegen.generateDefaultIfNeeded(constructorContext, constructorDescriptor, OwnerKind.IMPLEMENTATION, DefaultParameterValueLoader.DEFAULT, null);
        new DefaultParameterValueSubstitutor(this.state).generateOverloadsIfNeeded(constructor, constructorDescriptor, constructorDescriptor, this.kind, this.v);
    }

    private void generatePrimaryConstructorImpl(@NotNull ConstructorDescriptor constructorDescriptor, @NotNull ExpressionCodegen codegen, @NotNull DelegationFieldsInfo fieldsInfo, @Nullable KtPrimaryConstructor primaryConstructor2) {
        ImplementationBodyCodegen parentCodegen;
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generatePrimaryConstructorImpl"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generatePrimaryConstructorImpl"));
        }
        if (fieldsInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldsInfo", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generatePrimaryConstructorImpl"));
        }
        InstructionAdapter iv = codegen.v;
        ImplementationBodyCodegen.markLineNumberForConstructor(constructorDescriptor, primaryConstructor2, codegen);
        this.generateClosureInitialization(iv);
        this.generateDelegatorToConstructorCall(iv, codegen, constructorDescriptor, BindingContextUtils.getDelegationConstructorCall(this.bindingContext, constructorDescriptor));
        if (DescriptorUtils.isNonCompanionObject(this.descriptor)) {
            StackValue.singletonViaInstance(this.descriptor, this.typeMapper).store(StackValue.LOCAL_0, iv);
        }
        for (KtSuperTypeListEntry specifier : this.myClass.getSuperTypeListEntries()) {
            if (!(specifier instanceof KtDelegatedSuperTypeEntry)) continue;
            this.genCallToDelegatorByExpressionSpecifier(iv, codegen, (KtDelegatedSuperTypeEntry)specifier, fieldsInfo);
        }
        int curParam = 0;
        List<ValueParameterDescriptor> parameters2 = constructorDescriptor.getValueParameters();
        for (KtParameter parameter : this.getPrimaryConstructorParameters()) {
            if (parameter.hasValOrVar()) {
                VariableDescriptor descriptor2 = parameters2.get(curParam);
                Type type2 = this.typeMapper.mapType(descriptor2);
                iv.load(0, this.classAsmType);
                iv.load(codegen.myFrameMap.getIndex(descriptor2), type2);
                PropertyDescriptor propertyDescriptor = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
                assert (propertyDescriptor != null) : "Property descriptor is not found for primary constructor parameter: " + parameter;
                iv.putfield(this.classAsmType.getInternalName(), this.context.getFieldName(propertyDescriptor, false), type2.getDescriptor());
            }
            ++curParam;
        }
        if (DescriptorUtils.isCompanionObject(this.descriptor)) {
            parentCodegen = (ImplementationBodyCodegen)this.getParentCodegen();
            parentCodegen.generateCompanionObjectInitializer(this.descriptor);
        }
        if (JvmAbi.isCompanionObjectWithBackingFieldsInOuter(this.descriptor)) {
            parentCodegen = (ImplementationBodyCodegen)this.getParentCodegen();
            this.generateInitializers(new Function0<ExpressionCodegen>(){

                public ExpressionCodegen invoke() {
                    return parentCodegen.createOrGetClInitCodegen();
                }
            });
        } else {
            this.generateInitializers(codegen);
        }
        iv.visitInsn(177);
    }

    private void generateSecondaryConstructorImpl(@NotNull ConstructorDescriptor constructorDescriptor, @NotNull ExpressionCodegen codegen) {
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSecondaryConstructorImpl"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSecondaryConstructorImpl"));
        }
        InstructionAdapter iv = codegen.v;
        KtSecondaryConstructor constructor = (KtSecondaryConstructor)DescriptorToSourceUtils.descriptorToDeclaration(constructorDescriptor);
        ImplementationBodyCodegen.markLineNumberForConstructor(constructorDescriptor, constructor, codegen);
        ResolvedCall<ConstructorDescriptor> constructorDelegationCall = BindingContextUtils.getDelegationConstructorCall(this.bindingContext, constructorDescriptor);
        ConstructorDescriptor delegateConstructor = constructorDelegationCall == null ? null : constructorDelegationCall.getResultingDescriptor();
        this.generateDelegatorToConstructorCall(iv, codegen, constructorDescriptor, constructorDelegationCall);
        if (!this.isSameClassConstructor(delegateConstructor)) {
            this.generateClosureInitialization(iv);
            this.generateInitializers(codegen);
        }
        assert (constructor != null);
        if (constructor.hasBody()) {
            codegen.gen(constructor.getBodyExpression(), Type.VOID_TYPE);
        }
        iv.visitInsn(177);
    }

    private static void markLineNumberForConstructor(@NotNull ConstructorDescriptor descriptor2, @Nullable KtConstructor constructor, @NotNull ExpressionCodegen codegen) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "markLineNumberForConstructor"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "markLineNumberForConstructor"));
        }
        if (constructor == null) {
            ImplementationBodyCodegen.markLineNumberForDescriptor(descriptor2.getContainingDeclaration(), codegen.v);
        } else if (constructor.hasBody() && (!(constructor instanceof KtSecondaryConstructor) || ((KtSecondaryConstructor)constructor).hasImplicitDelegationCall())) {
            List<Object> statements;
            KtBlockExpression bodyExpression = constructor.getBodyExpression();
            List<Object> list2 = statements = bodyExpression != null ? bodyExpression.getStatements() : Collections.emptyList();
            if (!statements.isEmpty()) {
                codegen.markStartLineNumber((KtElement)statements.iterator().next());
            } else {
                codegen.markStartLineNumber((KtElement)((Object)(bodyExpression != null ? bodyExpression : constructor)));
            }
        } else {
            codegen.markStartLineNumber(constructor);
        }
    }

    private void generateInitializers(final @NotNull ExpressionCodegen codegen) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateInitializers"));
        }
        this.generateInitializers(new Function0<ExpressionCodegen>(){

            public ExpressionCodegen invoke() {
                return codegen;
            }
        });
    }

    private void generateClosureInitialization(@NotNull InstructionAdapter iv) {
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateClosureInitialization"));
        }
        MutableClosure closure = this.context.closure;
        if (closure != null) {
            List<FieldInfo> argsFromClosure = ClosureCodegen.calculateConstructorParameters(this.typeMapper, closure, this.classAsmType);
            int k = 1;
            for (FieldInfo info : argsFromClosure) {
                k = AsmUtil.genAssignInstanceFieldFromParam(info, k, iv);
            }
        }
    }

    private void genSimpleSuperCall(InstructionAdapter iv) {
        iv.load(0, this.superClassAsmType);
        if (this.descriptor.getKind() == ClassKind.ENUM_CLASS || this.descriptor.getKind() == ClassKind.ENUM_ENTRY) {
            iv.load(1, AsmTypes.JAVA_STRING_TYPE);
            iv.load(2, Type.INT_TYPE);
            iv.invokespecial(this.superClassAsmType.getInternalName(), "<init>", "(Ljava/lang/String;I)V", false);
        } else {
            iv.invokespecial(this.superClassAsmType.getInternalName(), "<init>", "()V", false);
        }
    }

    @NotNull
    private DelegationFieldsInfo getDelegationFieldsInfo(@NotNull List<KtSuperTypeListEntry> delegationSpecifiers) {
        if (delegationSpecifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegationSpecifiers", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "getDelegationFieldsInfo"));
        }
        DelegationFieldsInfo result2 = new DelegationFieldsInfo();
        int n = 0;
        for (KtSuperTypeListEntry specifier : delegationSpecifiers) {
            if (!(specifier instanceof KtDelegatedSuperTypeEntry)) continue;
            KtExpression expression2 = ((KtDelegatedSuperTypeEntry)specifier).getDelegateExpression();
            PropertyDescriptor propertyDescriptor = CodegenUtil.getDelegatePropertyIfAny(expression2, this.descriptor, this.bindingContext);
            if (CodegenUtil.isFinalPropertyWithBackingField(propertyDescriptor, this.bindingContext)) {
                result2.addField((KtDelegatedSuperTypeEntry)specifier, propertyDescriptor);
            } else {
                KotlinType expressionType = expression2 != null ? this.bindingContext.getType(expression2) : null;
                Type asmType = expressionType != null ? this.typeMapper.mapType(expressionType) : this.typeMapper.mapType(this.getSuperClass(specifier));
                result2.addField((KtDelegatedSuperTypeEntry)specifier, asmType, "$delegate_" + n);
            }
            ++n;
        }
        DelegationFieldsInfo delegationFieldsInfo = result2;
        if (delegationFieldsInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "getDelegationFieldsInfo"));
        }
        return delegationFieldsInfo;
    }

    @NotNull
    private ClassDescriptor getSuperClass(@NotNull KtSuperTypeListEntry specifier) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "getSuperClass"));
        }
        ClassDescriptor classDescriptor = CodegenUtil.getSuperClassBySuperTypeListEntry(specifier, this.bindingContext);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "getSuperClass"));
        }
        return classDescriptor;
    }

    private void genCallToDelegatorByExpressionSpecifier(InstructionAdapter iv, ExpressionCodegen codegen, KtDelegatedSuperTypeEntry specifier, DelegationFieldsInfo fieldsInfo) {
        KtExpression expression2 = specifier.getDelegateExpression();
        DelegationFieldsInfo.Field fieldInfo = fieldsInfo.getInfo(specifier);
        if (fieldInfo.generateField) {
            iv.load(0, this.classAsmType);
            fieldInfo.getStackValue().store(codegen.gen(expression2), iv);
        }
    }

    private void lookupConstructorExpressionsInClosureIfPresent() {
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL || this.descriptor.getConstructors().isEmpty()) {
            return;
        }
        KtVisitorVoid visitor2 = new KtVisitorVoid(){

            @Override
            public void visitKtElement(@NotNull KtElement e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$8", "visitKtElement"));
                }
                e.acceptChildren(this);
            }

            @Override
            public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expr) {
                if (expr == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$8", "visitSimpleNameExpression"));
                }
                DeclarationDescriptor descriptor2 = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.REFERENCE_TARGET, expr);
                if (ExpressionTypingUtils.isLocalFunction(descriptor2)) {
                    this.lookupInContext(descriptor2);
                } else if (descriptor2 instanceof CallableMemberDescriptor) {
                    ResolvedCall<? extends CallableDescriptor> call = CallUtilKt.getResolvedCall(expr, ImplementationBodyCodegen.this.bindingContext);
                    if (call != null) {
                        this.lookupReceiver(call.getDispatchReceiver());
                        this.lookupReceiver((ReceiverValue)call.getExtensionReceiver());
                    }
                } else if (descriptor2 instanceof VariableDescriptor) {
                    ClassDescriptor classDescriptor;
                    if (descriptor2.getContainingDeclaration() instanceof ConstructorDescriptor && (classDescriptor = (ClassDescriptor)descriptor2.getContainingDeclaration().getContainingDeclaration()) == ImplementationBodyCodegen.this.descriptor) {
                        return;
                    }
                    this.lookupInContext(descriptor2);
                }
            }

            private void lookupReceiver(@Nullable ReceiverValue value2) {
                if (value2 instanceof ImplicitReceiver) {
                    if (value2 instanceof ExtensionReceiver) {
                        ReceiverParameterDescriptor parameter = ((ExtensionReceiver)value2).getDeclarationDescriptor().getExtensionReceiverParameter();
                        assert (parameter != null) : "Extension receiver should exist: " + ((ExtensionReceiver)value2).getDeclarationDescriptor();
                        this.lookupInContext(parameter);
                    } else {
                        this.lookupInContext(((ImplicitReceiver)value2).getDeclarationDescriptor());
                    }
                }
            }

            private void lookupInContext(@NotNull DeclarationDescriptor toLookup) {
                if (toLookup == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toLookup", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$8", "lookupInContext"));
                }
                ImplementationBodyCodegen.this.context.lookupInContext(toLookup, StackValue.LOCAL_0, ImplementationBodyCodegen.this.state, true);
            }

            @Override
            public void visitThisExpression(@NotNull KtThisExpression expression2) {
                ReceiverParameterDescriptor parameter;
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$8", "visitThisExpression"));
                }
                DeclarationDescriptor descriptor2 = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference());
                assert (descriptor2 instanceof CallableDescriptor || descriptor2 instanceof ClassDescriptor) : "'This' reference target should be class or callable descriptor but was " + descriptor2;
                if (descriptor2 instanceof ClassDescriptor) {
                    this.lookupInContext(descriptor2);
                }
                if (descriptor2 instanceof CallableDescriptor && (parameter = ((CallableDescriptor)descriptor2).getExtensionReceiverParameter()) != null) {
                    this.lookupInContext(parameter);
                }
            }
        };
        for (KtDeclaration declaration : this.myClass.getDeclarations()) {
            if (declaration instanceof KtProperty) {
                KtProperty property2 = (KtProperty)declaration;
                KtExpression initializer2 = property2.getDelegateExpressionOrInitializer();
                if (initializer2 == null) continue;
                initializer2.accept(visitor2);
                continue;
            }
            if (declaration instanceof KtAnonymousInitializer) {
                KtAnonymousInitializer initializer3 = (KtAnonymousInitializer)declaration;
                initializer3.accept(visitor2);
                continue;
            }
            if (!(declaration instanceof KtSecondaryConstructor)) continue;
            KtSecondaryConstructor constructor = (KtSecondaryConstructor)declaration;
            constructor.accept(visitor2);
        }
        for (KtSuperTypeListEntry specifier : this.myClass.getSuperTypeListEntries()) {
            if (!(specifier instanceof KtDelegatedSuperTypeEntry)) continue;
            KtExpression delegateExpression = ((KtDelegatedSuperTypeEntry)specifier).getDelegateExpression();
            assert (delegateExpression != null);
            delegateExpression.accept(visitor2);
        }
        ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassNotAny(this.descriptor);
        if (superClass != null) {
            ConstructorDescriptor primaryConstructor2;
            if (superClass.isInner()) {
                this.context.lookupInContext(superClass.getContainingDeclaration(), StackValue.LOCAL_0, this.state, true);
            }
            if ((primaryConstructor2 = this.descriptor.getUnsubstitutedPrimaryConstructor()) != null && !DescriptorUtils.isAnonymousObject(this.descriptor)) {
                KtValueArgumentList argumentList2;
                ResolvedCall<ConstructorDescriptor> delegationCall = BindingContextUtils.getDelegationConstructorCall(this.bindingContext, primaryConstructor2);
                KtValueArgumentList ktValueArgumentList = argumentList2 = delegationCall != null ? delegationCall.getCall().getValueArgumentList() : null;
                if (argumentList2 != null) {
                    argumentList2.accept(visitor2);
                }
            }
        }
    }

    private void generateTraitMethods() {
        if (DescriptorUtils.isInterface(this.descriptor)) {
            return;
        }
        for (Map.Entry<FunctionDescriptor, FunctionDescriptor> entry : CodegenUtil.getNonPrivateTraitMethods(this.descriptor).entrySet()) {
            FunctionDescriptor traitFun = entry.getKey();
            if (traitFun instanceof JavaCallableMemberDescriptor) continue;
            this.generateDelegationToTraitImpl(traitFun, entry.getValue());
        }
    }

    private void generateDelegationToTraitImpl(final @NotNull FunctionDescriptor traitFun, final @NotNull FunctionDescriptor inheritedFun) {
        if (traitFun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traitFun", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateDelegationToTraitImpl"));
        }
        if (inheritedFun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inheritedFun", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateDelegationToTraitImpl"));
        }
        this.functionCodegen.generateMethod(JvmDeclarationOriginKt.DelegationToTraitImpl(DescriptorToSourceUtils.descriptorToDeclaration(traitFun), traitFun), inheritedFun, new FunctionGenerationStrategy.CodegenBased<FunctionDescriptor>(this.state, inheritedFun){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                if (codegen == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$9", "doGenerateBody"));
                }
                if (signature == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$9", "doGenerateBody"));
                }
                DeclarationDescriptor containingDeclaration = traitFun.getContainingDeclaration();
                if (!DescriptorUtils.isInterface(containingDeclaration)) {
                    return;
                }
                DeclarationDescriptor declarationInheritedFun = inheritedFun.getContainingDeclaration();
                PsiElement classForInheritedFun = DescriptorToSourceUtils.descriptorToDeclaration(declarationInheritedFun);
                if (classForInheritedFun instanceof KtDeclaration) {
                    codegen.markLineNumber((KtElement)classForInheritedFun, false);
                }
                ClassDescriptor containingTrait = (ClassDescriptor)containingDeclaration;
                Type traitImplType = ImplementationBodyCodegen.this.typeMapper.mapDefaultImpls(containingTrait);
                Method traitMethod = ImplementationBodyCodegen.this.typeMapper.mapSignature(traitFun.getOriginal(), OwnerKind.DEFAULT_IMPLS).getAsmMethod();
                Type[] argTypes = signature.getAsmMethod().getArgumentTypes();
                Type[] originalArgTypes = traitMethod.getArgumentTypes();
                assert (originalArgTypes.length == argTypes.length + 1) : "Invalid trait implementation signature: " + signature + " vs " + traitMethod + " for " + traitFun;
                InstructionAdapter iv = codegen.v;
                iv.load(0, AsmTypes.OBJECT_TYPE);
                int reg = 1;
                for (int i = 0; i < argTypes.length; ++i) {
                    StackValue.local(reg, argTypes[i]).put(originalArgTypes[i + 1], iv);
                    reg += argTypes[i].getSize();
                }
                if (KotlinBuiltIns.isCloneable(containingTrait) && traitMethod.getName().equals("clone")) {
                    iv.invokespecial("java/lang/Object", "clone", "()Ljava/lang/Object;", false);
                } else {
                    iv.invokestatic(traitImplType.getInternalName(), traitMethod.getName(), traitMethod.getDescriptor(), false);
                }
                Type returnType2 = signature.getReturnType();
                StackValue.onStack(traitMethod.getReturnType()).put(returnType2, iv);
                iv.areturn(returnType2);
            }
        });
    }

    private void generateDelegatorToConstructorCall(@NotNull InstructionAdapter iv, @NotNull ExpressionCodegen codegen, @NotNull ConstructorDescriptor constructorDescriptor, @Nullable ResolvedCall<ConstructorDescriptor> delegationConstructorCall) {
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateDelegatorToConstructorCall"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateDelegatorToConstructorCall"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateDelegatorToConstructorCall"));
        }
        if (delegationConstructorCall == null) {
            this.genSimpleSuperCall(iv);
            return;
        }
        iv.load(0, AsmTypes.OBJECT_TYPE);
        ConstructorDescriptor delegateConstructor = SamCodegenUtil.resolveSamAdapter(codegen.getConstructorDescriptor(delegationConstructorCall));
        CallableMethod delegateConstructorCallable = this.typeMapper.mapToCallableMethod(delegateConstructor, false);
        CallableMethod callable = this.typeMapper.mapToCallableMethod(constructorDescriptor, false);
        List<JvmMethodParameterSignature> delegatingParameters = delegateConstructorCallable.getValueParameters();
        List<JvmMethodParameterSignature> parameters2 = callable.getValueParameters();
        ArgumentGenerator argumentGenerator = this.isSameClassConstructor(delegateConstructor) ? ImplementationBodyCodegen.generateThisCallImplicitArguments(iv, codegen, delegateConstructor, delegateConstructorCallable, delegatingParameters, parameters2) : this.generateSuperCallImplicitArguments(iv, codegen, constructorDescriptor, delegateConstructor, delegateConstructorCallable, delegatingParameters, parameters2);
        codegen.invokeMethodWithArguments(delegateConstructorCallable, delegationConstructorCall, StackValue.none(), codegen.defaultCallGenerator, argumentGenerator);
    }

    private boolean isSameClassConstructor(@Nullable ConstructorDescriptor delegatingConstructor) {
        return delegatingConstructor != null && delegatingConstructor.getContainingDeclaration() == this.descriptor;
    }

    @NotNull
    private ArgumentGenerator generateSuperCallImplicitArguments(@NotNull InstructionAdapter iv, @NotNull ExpressionCodegen codegen, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull ConstructorDescriptor superConstructor, @NotNull CallableMethod superCallable, @NotNull List<JvmMethodParameterSignature> superParameters, @NotNull List<JvmMethodParameterSignature> parameters2) {
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSuperCallImplicitArguments"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSuperCallImplicitArguments"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSuperCallImplicitArguments"));
        }
        if (superConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superConstructor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSuperCallImplicitArguments"));
        }
        if (superCallable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superCallable", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSuperCallImplicitArguments"));
        }
        if (superParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superParameters", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSuperCallImplicitArguments"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSuperCallImplicitArguments"));
        }
        int offset2 = 1;
        int superIndex = 0;
        for (JvmMethodParameterSignature parameter : parameters2) {
            if (superIndex >= superParameters.size()) break;
            JvmMethodParameterKind superKind = superParameters.get(superIndex).getKind();
            JvmMethodParameterKind kind2 = parameter.getKind();
            Type type2 = parameter.getAsmType();
            if (superKind == JvmMethodParameterKind.VALUE && kind2 == JvmMethodParameterKind.SUPER_CALL_PARAM) break;
            if (superKind == JvmMethodParameterKind.OUTER) {
                assert (kind2 == JvmMethodParameterKind.OUTER || kind2 == JvmMethodParameterKind.SUPER_CALL_PARAM) : String.format("Non-outer parameter incorrectly mapped to outer for %s: %s vs %s", constructorDescriptor, parameters2, superParameters);
                ClassDescriptor outerForSuper = (ClassDescriptor)superConstructor.getContainingDeclaration().getContainingDeclaration();
                StackValue outer = codegen.generateThisOrOuter(outerForSuper, true, true);
                outer.put(outer.type, codegen.v);
                ++superIndex;
            } else if (kind2 == JvmMethodParameterKind.SUPER_CALL_PARAM || kind2 == JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL) {
                iv.load(offset2, type2);
                ++superIndex;
            }
            offset2 += type2.getSize();
        }
        if (DescriptorUtils.isAnonymousObject(this.descriptor)) {
            List<JvmMethodParameterSignature> superValues = superParameters.subList(superIndex, superParameters.size());
            ObjectSuperCallArgumentGenerator objectSuperCallArgumentGenerator = new ObjectSuperCallArgumentGenerator(superValues, iv, offset2);
            if (objectSuperCallArgumentGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSuperCallImplicitArguments"));
            }
            return objectSuperCallArgumentGenerator;
        }
        CallBasedArgumentGenerator callBasedArgumentGenerator = new CallBasedArgumentGenerator(codegen, codegen.defaultCallGenerator, superConstructor.getValueParameters(), superCallable.getValueParameterTypes());
        if (callBasedArgumentGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateSuperCallImplicitArguments"));
        }
        return callBasedArgumentGenerator;
    }

    @NotNull
    private static ArgumentGenerator generateThisCallImplicitArguments(@NotNull InstructionAdapter iv, @NotNull ExpressionCodegen codegen, @NotNull ConstructorDescriptor delegatingConstructor, @NotNull CallableMethod delegatingCallable, @NotNull List<JvmMethodParameterSignature> delegatingParameters, @NotNull List<JvmMethodParameterSignature> parameters2) {
        int index2;
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateThisCallImplicitArguments"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateThisCallImplicitArguments"));
        }
        if (delegatingConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatingConstructor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateThisCallImplicitArguments"));
        }
        if (delegatingCallable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatingCallable", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateThisCallImplicitArguments"));
        }
        if (delegatingParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatingParameters", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateThisCallImplicitArguments"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateThisCallImplicitArguments"));
        }
        int offset2 = 1;
        for (index2 = 0; index2 < delegatingParameters.size(); ++index2) {
            JvmMethodParameterKind delegatingKind = delegatingParameters.get(index2).getKind();
            if (delegatingKind == JvmMethodParameterKind.VALUE) {
                assert (index2 == parameters2.size() || parameters2.get(index2).getKind() == JvmMethodParameterKind.VALUE) : "Delegating constructor has not enough implicit parameters";
                break;
            }
            assert (index2 < parameters2.size() && parameters2.get(index2).getKind() == delegatingKind) : "Constructors of the same class should have the same set of implicit arguments";
            JvmMethodParameterSignature parameter = parameters2.get(index2);
            iv.load(offset2, parameter.getAsmType());
            offset2 += parameter.getAsmType().getSize();
        }
        assert (index2 == parameters2.size() || parameters2.get(index2).getKind() == JvmMethodParameterKind.VALUE) : "Delegating constructor has not enough parameters";
        CallBasedArgumentGenerator callBasedArgumentGenerator = new CallBasedArgumentGenerator(codegen, codegen.defaultCallGenerator, delegatingConstructor.getValueParameters(), delegatingCallable.getValueParameterTypes());
        if (callBasedArgumentGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "generateThisCallImplicitArguments"));
        }
        return callBasedArgumentGenerator;
    }

    private void generateEnumEntries() {
        if (this.descriptor.getKind() != ClassKind.ENUM_CLASS) {
            return;
        }
        List enumEntries = CollectionsKt.filterIsInstance(((KtClassOrObject)this.element).getDeclarations(), KtEnumEntry.class);
        for (KtEnumEntry enumEntry : enumEntries) {
            ClassDescriptor descriptor2 = BindingContextUtils.getNotNull(this.bindingContext, BindingContext.CLASS, enumEntry);
            int isDeprecated = KotlinBuiltIns.isDeprecated(descriptor2) ? 131072 : 0;
            FieldVisitor fv = this.v.newField(JvmDeclarationOriginKt.OtherOrigin(enumEntry, descriptor2), 0x4019 | isDeprecated, descriptor2.getName().asString(), this.classAsmType.getDescriptor(), null, null);
            AnnotationCodegen.forField(fv, this.typeMapper).genAnnotations(descriptor2, null);
        }
        this.initializeEnumConstants(enumEntries);
    }

    private void initializeEnumConstants(@NotNull List<KtEnumEntry> enumEntries) {
        if (enumEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntries", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "initializeEnumConstants"));
        }
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        ExpressionCodegen codegen = this.createOrGetClInitCodegen();
        InstructionAdapter iv = codegen.v;
        Type arrayAsmType = this.typeMapper.mapType(DescriptorUtilsKt.getBuiltIns(this.descriptor).getArrayType(Variance.INVARIANT, this.descriptor.getDefaultType()));
        this.v.newField(JvmDeclarationOriginKt.OtherOrigin(this.myClass), 4122, ENUM_VALUES_FIELD_NAME, arrayAsmType.getDescriptor(), null, null);
        iv.iconst(enumEntries.size());
        iv.newarray(this.classAsmType);
        if (!enumEntries.isEmpty()) {
            iv.dup();
            int size = enumEntries.size();
            for (int ordinal = 0; ordinal < size; ++ordinal) {
                this.initializeEnumConstant(enumEntries, ordinal);
            }
        }
        iv.putstatic(this.classAsmType.getInternalName(), ENUM_VALUES_FIELD_NAME, arrayAsmType.getDescriptor());
    }

    private void initializeEnumConstant(@NotNull List<KtEnumEntry> enumEntries, int ordinal) {
        if (enumEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntries", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "initializeEnumConstant"));
        }
        ExpressionCodegen codegen = this.createOrGetClInitCodegen();
        InstructionAdapter iv = codegen.v;
        KtEnumEntry enumEntry = enumEntries.get(ordinal);
        iv.dup();
        iv.iconst(ordinal);
        ClassDescriptor classDescriptor = BindingContextUtils.getNotNull(this.bindingContext, BindingContext.CLASS, enumEntry);
        Type implClass = this.typeMapper.mapClass(classDescriptor);
        iv.anew(implClass);
        iv.dup();
        iv.aconst((Object)enumEntry.getName());
        iv.iconst(ordinal);
        List<KtSuperTypeListEntry> delegationSpecifiers = enumEntry.getSuperTypeListEntries();
        if (delegationSpecifiers.size() == 1 && !CodegenBinding.enumEntryNeedSubclass(this.bindingContext, enumEntry)) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCallWithAssert(delegationSpecifiers.get(0), this.bindingContext);
            CallableMethod method = this.typeMapper.mapToCallableMethod((ConstructorDescriptor)resolvedCall.getResultingDescriptor(), false);
            codegen.invokeMethodWithArguments(method, resolvedCall, StackValue.none());
        } else {
            iv.invokespecial(implClass.getInternalName(), "<init>", "(Ljava/lang/String;I)V", false);
        }
        iv.dup();
        iv.putstatic(this.classAsmType.getInternalName(), enumEntry.getName(), this.classAsmType.getDescriptor());
        iv.astore(AsmTypes.OBJECT_TYPE);
    }

    private void generateDelegates(DelegationFieldsInfo delegationFieldsInfo) {
        for (KtSuperTypeListEntry specifier : this.myClass.getSuperTypeListEntries()) {
            if (!(specifier instanceof KtDelegatedSuperTypeEntry)) continue;
            DelegationFieldsInfo.Field field2 = delegationFieldsInfo.getInfo((KtDelegatedSuperTypeEntry)specifier);
            this.generateDelegateField(field2);
            KtExpression delegateExpression = ((KtDelegatedSuperTypeEntry)specifier).getDelegateExpression();
            KotlinType delegateExpressionType = delegateExpression != null ? this.bindingContext.getType(delegateExpression) : null;
            this.generateDelegates(this.getSuperClass(specifier), delegateExpressionType, field2);
        }
    }

    private void generateDelegateField(DelegationFieldsInfo.Field fieldInfo) {
        if (!fieldInfo.generateField) {
            return;
        }
        this.v.newField(JvmDeclarationOrigin.NO_ORIGIN, 4114, fieldInfo.name, fieldInfo.type.getDescriptor(), null, null);
    }

    protected void generateDelegates(ClassDescriptor toTrait, KotlinType delegateExpressionType, DelegationFieldsInfo.Field field2) {
        for (Map.Entry<CallableMemberDescriptor, CallableDescriptor> entry : CodegenUtilKt.getDelegates(this.descriptor, toTrait, delegateExpressionType).entrySet()) {
            CallableMemberDescriptor callableMemberDescriptor = entry.getKey();
            CallableDescriptor delegateTo = entry.getValue();
            if (callableMemberDescriptor instanceof PropertyDescriptor) {
                this.propertyCodegen.genDelegate((PropertyDescriptor)callableMemberDescriptor, (PropertyDescriptor)delegateTo, field2.getStackValue());
                continue;
            }
            if (!(callableMemberDescriptor instanceof FunctionDescriptor)) continue;
            this.functionCodegen.genDelegate((FunctionDescriptor)callableMemberDescriptor, (FunctionDescriptor)delegateTo, field2.getStackValue());
        }
    }

    public void addCompanionObjectPropertyToCopy(@NotNull PropertyDescriptor descriptor2, Object defaultValue) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen", "addCompanionObjectPropertyToCopy"));
        }
        if (this.companionObjectPropertiesToCopy == null) {
            this.companionObjectPropertiesToCopy = new ArrayList<PropertyAndDefaultValue>();
        }
        this.companionObjectPropertiesToCopy.add(new PropertyAndDefaultValue(descriptor2, defaultValue));
    }

    @Override
    protected void done() {
        for (Function2<ImplementationBodyCodegen, ClassBuilder, Unit> task : this.additionalTasks) {
            task.invoke((Object)this, (Object)this.v);
        }
        super.done();
    }

    public void addAdditionalTask(Function2<ImplementationBodyCodegen, ClassBuilder, Unit> additionalTask) {
        this.additionalTasks.add(additionalTask);
    }

    static {
        KOTLIN_MARKER_INTERFACES.put(KotlinBuiltIns.FQ_NAMES.iterator, "kotlin/jvm/internal/markers/KMappedMarker");
        KOTLIN_MARKER_INTERFACES.put(KotlinBuiltIns.FQ_NAMES.iterable, "kotlin/jvm/internal/markers/KMappedMarker");
        KOTLIN_MARKER_INTERFACES.put(KotlinBuiltIns.FQ_NAMES.collection, "kotlin/jvm/internal/markers/KMappedMarker");
        KOTLIN_MARKER_INTERFACES.put(KotlinBuiltIns.FQ_NAMES.list, "kotlin/jvm/internal/markers/KMappedMarker");
        KOTLIN_MARKER_INTERFACES.put(KotlinBuiltIns.FQ_NAMES.listIterator, "kotlin/jvm/internal/markers/KMappedMarker");
        KOTLIN_MARKER_INTERFACES.put(KotlinBuiltIns.FQ_NAMES.set, "kotlin/jvm/internal/markers/KMappedMarker");
        KOTLIN_MARKER_INTERFACES.put(KotlinBuiltIns.FQ_NAMES.map, "kotlin/jvm/internal/markers/KMappedMarker");
        KOTLIN_MARKER_INTERFACES.put(KotlinBuiltIns.FQ_NAMES.mapEntry, "kotlin/jvm/internal/markers/KMappedMarker");
        KOTLIN_MARKER_INTERFACES.put(KotlinBuiltIns.FQ_NAMES.mutableIterator, "kotlin/jvm/internal/markers/KMutableIterator");
        KOTLIN_MARKER_INTERFACES.put(KotlinBuiltIns.FQ_NAMES.mutableIterable, "kotlin/jvm/internal/markers/KMutableIterable");
        KOTLIN_MARKER_INTERFACES.put(KotlinBuiltIns.FQ_NAMES.mutableCollection, "kotlin/jvm/internal/markers/KMutableCollection");
        KOTLIN_MARKER_INTERFACES.put(KotlinBuiltIns.FQ_NAMES.mutableList, "kotlin/jvm/internal/markers/KMutableList");
        KOTLIN_MARKER_INTERFACES.put(KotlinBuiltIns.FQ_NAMES.mutableListIterator, "kotlin/jvm/internal/markers/KMutableListIterator");
        KOTLIN_MARKER_INTERFACES.put(KotlinBuiltIns.FQ_NAMES.mutableSet, "kotlin/jvm/internal/markers/KMutableSet");
        KOTLIN_MARKER_INTERFACES.put(KotlinBuiltIns.FQ_NAMES.mutableMap, "kotlin/jvm/internal/markers/KMutableMap");
        KOTLIN_MARKER_INTERFACES.put(KotlinBuiltIns.FQ_NAMES.mutableMapEntry, "kotlin/jvm/internal/markers/KMutableMap$Entry");
    }

    private static class PropertyAndDefaultValue {
        public final PropertyDescriptor descriptor;
        public final Object defaultValue;

        public PropertyAndDefaultValue(@NotNull PropertyDescriptor descriptor2, Object defaultValue) {
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$PropertyAndDefaultValue", "<init>"));
            }
            this.descriptor = descriptor2;
            this.defaultValue = defaultValue;
        }
    }

    private static class ObjectSuperCallArgumentGenerator
    extends ArgumentGenerator {
        private final List<JvmMethodParameterSignature> parameters;
        private final InstructionAdapter iv;
        private int offset;

        public ObjectSuperCallArgumentGenerator(@NotNull List<JvmMethodParameterSignature> superParameters, @NotNull InstructionAdapter iv, int firstValueParamOffset) {
            if (superParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superParameters", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$ObjectSuperCallArgumentGenerator", "<init>"));
            }
            if (iv == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$ObjectSuperCallArgumentGenerator", "<init>"));
            }
            this.parameters = superParameters;
            this.iv = iv;
            this.offset = firstValueParamOffset;
        }

        @Override
        public void generateExpression(int i, @NotNull ExpressionValueArgument argument2) {
            if (argument2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$ObjectSuperCallArgumentGenerator", "generateExpression"));
            }
            this.generateSuperCallArgument(i);
        }

        @Override
        public void generateDefault(int i, @NotNull DefaultValueArgument argument2) {
            if (argument2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$ObjectSuperCallArgumentGenerator", "generateDefault"));
            }
            Type type2 = this.parameters.get(i).getAsmType();
            AsmUtil.pushDefaultValueOnStack(type2, this.iv);
        }

        @Override
        public void generateVararg(int i, @NotNull VarargValueArgument argument2) {
            if (argument2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$ObjectSuperCallArgumentGenerator", "generateVararg"));
            }
            this.generateSuperCallArgument(i);
        }

        private void generateSuperCallArgument(int i) {
            Type type2 = this.parameters.get(i).getAsmType();
            this.iv.load(this.offset, type2);
            this.offset += type2.getSize();
        }

        @Override
        protected void reorderArgumentsIfNeeded(@NotNull List<ArgumentAndDeclIndex> args) {
            if (args == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$ObjectSuperCallArgumentGenerator", "reorderArgumentsIfNeeded"));
            }
        }
    }

    private class DelegationFieldsInfo {
        private final Map<KtDelegatedSuperTypeEntry, Field> fields = new HashMap<KtDelegatedSuperTypeEntry, Field>();

        private DelegationFieldsInfo() {
        }

        @NotNull
        public Field getInfo(KtDelegatedSuperTypeEntry specifier) {
            Field field2 = this.fields.get(specifier);
            if (field2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DelegationFieldsInfo", "getInfo"));
            }
            return field2;
        }

        private void addField(KtDelegatedSuperTypeEntry specifier, PropertyDescriptor propertyDescriptor) {
            this.fields.put(specifier, new Field(ImplementationBodyCodegen.this.typeMapper.mapType(propertyDescriptor), propertyDescriptor.getName().asString(), false));
        }

        private void addField(KtDelegatedSuperTypeEntry specifier, Type type2, String name2) {
            this.fields.put(specifier, new Field(type2, name2, true));
        }

        private class Field {
            public final Type type;
            public final String name;
            public final boolean generateField;

            private Field(Type type2, String name2, boolean generateField) {
                this.type = type2;
                this.name = name2;
                this.generateField = generateField;
            }

            @NotNull
            public StackValue getStackValue() {
                StackValue.Field field2 = StackValue.field(this.type, ImplementationBodyCodegen.this.classAsmType, this.name, false, StackValue.none());
                if (field2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DelegationFieldsInfo$Field", "getStackValue"));
                }
                return field2;
            }
        }
    }

    private class DataClassMethodGeneratorImpl
    extends DataClassMethodGenerator {
        DataClassMethodGeneratorImpl(KtClassOrObject klass, BindingContext bindingContext2) {
            super(klass, bindingContext2);
        }

        @Override
        public void generateEqualsMethod(@NotNull FunctionDescriptor function2, @NotNull List<PropertyDescriptor> properties2) {
            if (function2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateEqualsMethod"));
            }
            if (properties2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateEqualsMethod"));
            }
            MethodContext context = ImplementationBodyCodegen.this.context.intoFunction(function2);
            MethodVisitor mv = ImplementationBodyCodegen.this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(function2), 1, "equals", "(Ljava/lang/Object;)Z", null, null);
            InstructionAdapter iv = new InstructionAdapter(mv);
            mv.visitCode();
            Label eq = new Label();
            Label ne = new Label();
            iv.load(0, AsmTypes.OBJECT_TYPE);
            iv.load(1, AsmTypes.OBJECT_TYPE);
            iv.ifacmpeq(eq);
            iv.load(1, AsmTypes.OBJECT_TYPE);
            iv.instanceOf(ImplementationBodyCodegen.this.classAsmType);
            iv.ifeq(ne);
            iv.load(1, AsmTypes.OBJECT_TYPE);
            iv.checkcast(ImplementationBodyCodegen.this.classAsmType);
            iv.store(2, AsmTypes.OBJECT_TYPE);
            for (PropertyDescriptor propertyDescriptor : properties2) {
                Type asmType = ImplementationBodyCodegen.this.typeMapper.mapType(propertyDescriptor);
                Type thisPropertyType = this.genPropertyOnStack(iv, context, propertyDescriptor, 0);
                StackValue.coerce(thisPropertyType, asmType, iv);
                Type otherPropertyType = this.genPropertyOnStack(iv, context, propertyDescriptor, 2);
                StackValue.coerce(otherPropertyType, asmType, iv);
                if (asmType.getSort() == 6) {
                    iv.invokestatic("java/lang/Float", "compare", "(FF)I", false);
                    iv.ifne(ne);
                    continue;
                }
                if (asmType.getSort() == 8) {
                    iv.invokestatic("java/lang/Double", "compare", "(DD)I", false);
                    iv.ifne(ne);
                    continue;
                }
                StackValue value2 = AsmUtil.genEqualsForExpressionsOnStack(KtTokens.EQEQ, StackValue.onStack(asmType), StackValue.onStack(asmType));
                value2.put(Type.BOOLEAN_TYPE, iv);
                iv.ifeq(ne);
            }
            iv.mark(eq);
            iv.iconst(1);
            iv.areturn(Type.INT_TYPE);
            iv.mark(ne);
            iv.iconst(0);
            iv.areturn(Type.INT_TYPE);
            FunctionCodegen.endVisit(mv, "equals", ImplementationBodyCodegen.this.myClass);
        }

        @Override
        public void generateHashCodeMethod(@NotNull FunctionDescriptor function2, @NotNull List<PropertyDescriptor> properties2) {
            if (function2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateHashCodeMethod"));
            }
            if (properties2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateHashCodeMethod"));
            }
            MethodContext context = ImplementationBodyCodegen.this.context.intoFunction(function2);
            MethodVisitor mv = ImplementationBodyCodegen.this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(function2), 1, "hashCode", "()I", null, null);
            InstructionAdapter iv = new InstructionAdapter(mv);
            mv.visitCode();
            boolean first = true;
            for (PropertyDescriptor propertyDescriptor : properties2) {
                if (!first) {
                    iv.iconst(31);
                    iv.mul(Type.INT_TYPE);
                }
                Type propertyType = this.genPropertyOnStack(iv, context, propertyDescriptor, 0);
                Type asmType = ImplementationBodyCodegen.this.typeMapper.mapType(propertyDescriptor);
                StackValue.coerce(propertyType, asmType, iv);
                Label ifNull = null;
                if (!AsmUtil.isPrimitive(asmType)) {
                    ifNull = new Label();
                    iv.dup();
                    iv.ifnull(ifNull);
                }
                AsmUtil.genHashCode(mv, iv, asmType);
                if (ifNull != null) {
                    Label end = new Label();
                    iv.goTo(end);
                    iv.mark(ifNull);
                    iv.pop();
                    iv.iconst(0);
                    iv.mark(end);
                }
                if (first) {
                    first = false;
                    continue;
                }
                iv.add(Type.INT_TYPE);
            }
            mv.visitInsn(172);
            FunctionCodegen.endVisit(mv, "hashCode", ImplementationBodyCodegen.this.myClass);
        }

        @Override
        public void generateToStringMethod(@NotNull FunctionDescriptor function2, @NotNull List<PropertyDescriptor> properties2) {
            if (function2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateToStringMethod"));
            }
            if (properties2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateToStringMethod"));
            }
            MethodContext context = ImplementationBodyCodegen.this.context.intoFunction(function2);
            MethodVisitor mv = ImplementationBodyCodegen.this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(function2), 1, "toString", "()Ljava/lang/String;", null, null);
            InstructionAdapter iv = new InstructionAdapter(mv);
            mv.visitCode();
            AsmUtil.genStringBuilderConstructor(iv);
            boolean first = true;
            for (PropertyDescriptor propertyDescriptor : properties2) {
                if (first) {
                    iv.aconst((Object)(ImplementationBodyCodegen.this.descriptor.getName() + "(" + propertyDescriptor.getName().asString() + "="));
                    first = false;
                } else {
                    iv.aconst((Object)(", " + propertyDescriptor.getName().asString() + "="));
                }
                AsmUtil.genInvokeAppendMethod(iv, AsmTypes.JAVA_STRING_TYPE);
                Type type2 = this.genPropertyOnStack(iv, context, propertyDescriptor, 0);
                if (type2.getSort() == 9) {
                    Type elementType = AsmUtil.correctElementType(type2);
                    if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                        iv.invokestatic("java/util/Arrays", "toString", "([Ljava/lang/Object;)Ljava/lang/String;", false);
                        type2 = AsmTypes.JAVA_STRING_TYPE;
                    } else if (elementType.getSort() != 2) {
                        iv.invokestatic("java/util/Arrays", "toString", "(" + type2.getDescriptor() + ")Ljava/lang/String;", false);
                        type2 = AsmTypes.JAVA_STRING_TYPE;
                    }
                }
                AsmUtil.genInvokeAppendMethod(iv, type2);
            }
            iv.aconst((Object)")");
            AsmUtil.genInvokeAppendMethod(iv, AsmTypes.JAVA_STRING_TYPE);
            iv.invokevirtual("java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
            iv.areturn(AsmTypes.JAVA_STRING_TYPE);
            FunctionCodegen.endVisit(mv, "toString", ImplementationBodyCodegen.this.myClass);
        }

        private Type genPropertyOnStack(InstructionAdapter iv, MethodContext context, @NotNull PropertyDescriptor propertyDescriptor, int index2) {
            if (propertyDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "genPropertyOnStack"));
            }
            iv.load(index2, ImplementationBodyCodegen.this.classAsmType);
            if (JvmCodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, true, false, context)) {
                Type type2 = ImplementationBodyCodegen.this.typeMapper.mapType(propertyDescriptor.getType());
                String fieldName = ((FieldOwnerContext)context.getParentContext()).getFieldName(propertyDescriptor, false);
                iv.getfield(ImplementationBodyCodegen.this.classAsmType.getInternalName(), fieldName, type2.getDescriptor());
                return type2.getReturnType();
            }
            Method method = ImplementationBodyCodegen.this.typeMapper.mapSignature(propertyDescriptor.getGetter()).getAsmMethod();
            iv.invokevirtual(ImplementationBodyCodegen.this.classAsmType.getInternalName(), method.getName(), method.getDescriptor(), false);
            return method.getReturnType();
        }

        @Override
        public void generateComponentFunction(@NotNull FunctionDescriptor function2, final @NotNull ValueParameterDescriptor parameter) {
            if (function2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateComponentFunction"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateComponentFunction"));
            }
            PsiElement originalElement = DescriptorToSourceUtils.descriptorToDeclaration(parameter);
            ImplementationBodyCodegen.this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOrigin(originalElement, function2), function2, new FunctionGenerationStrategy(){

                @Override
                public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature, @NotNull MethodContext context, @NotNull MemberCodegen<?> parentCodegen) {
                    if (mv == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$1", "generateBody"));
                    }
                    if (frameMap == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameMap", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$1", "generateBody"));
                    }
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$1", "generateBody"));
                    }
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$1", "generateBody"));
                    }
                    if (parentCodegen == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$1", "generateBody"));
                    }
                    Type componentType = signature.getReturnType();
                    InstructionAdapter iv = new InstructionAdapter(mv);
                    if (!componentType.equals((Object)Type.VOID_TYPE)) {
                        PropertyDescriptor property2 = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, DescriptorToSourceUtils.descriptorToDeclaration(parameter));
                        assert (property2 != null) : "Property descriptor is not found for primary constructor parameter: " + parameter;
                        Type propertyType = DataClassMethodGeneratorImpl.this.genPropertyOnStack(iv, context, property2, 0);
                        StackValue.coerce(propertyType, componentType, iv);
                    }
                    iv.areturn(componentType);
                }
            });
        }

        @Override
        public void generateCopyFunction(final @NotNull FunctionDescriptor function2, @NotNull List<KtParameter> constructorParameters) {
            if (function2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateCopyFunction"));
            }
            if (constructorParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorParameters", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateCopyFunction"));
            }
            final Type thisDescriptorType = ImplementationBodyCodegen.this.typeMapper.mapType(ImplementationBodyCodegen.this.descriptor);
            ImplementationBodyCodegen.this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOrigin(ImplementationBodyCodegen.this.myClass, function2), function2, new FunctionGenerationStrategy(){

                @Override
                public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature, @NotNull MethodContext context, @NotNull MemberCodegen<?> parentCodegen) {
                    if (mv == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$2", "generateBody"));
                    }
                    if (frameMap == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameMap", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$2", "generateBody"));
                    }
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$2", "generateBody"));
                    }
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$2", "generateBody"));
                    }
                    if (parentCodegen == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/kotlin/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$2", "generateBody"));
                    }
                    InstructionAdapter iv = new InstructionAdapter(mv);
                    iv.anew(thisDescriptorType);
                    iv.dup();
                    ConstructorDescriptor constructor = ImplementationBodyCodegen.getPrimaryConstructorOfDataClass(ImplementationBodyCodegen.this.descriptor);
                    assert (function2.getValueParameters().size() == constructor.getValueParameters().size()) : "Number of parameters of copy function and constructor are different. Copy: " + function2.getValueParameters().size() + ", " + "constructor: " + constructor.getValueParameters().size();
                    MutableClosure closure = ImplementationBodyCodegen.this.context.closure;
                    if (closure != null) {
                        this.pushCapturedFieldsOnStack(iv, closure);
                    }
                    int parameterIndex2 = 1;
                    for (ValueParameterDescriptor parameterDescriptor : function2.getValueParameters()) {
                        Type type2 = ImplementationBodyCodegen.this.typeMapper.mapType(parameterDescriptor.getType());
                        iv.load(parameterIndex2, type2);
                        parameterIndex2 += type2.getSize();
                    }
                    Method constructorAsmMethod = ImplementationBodyCodegen.this.typeMapper.mapSignature(constructor).getAsmMethod();
                    iv.invokespecial(thisDescriptorType.getInternalName(), "<init>", constructorAsmMethod.getDescriptor(), false);
                    iv.areturn(thisDescriptorType);
                }

                private void pushCapturedFieldsOnStack(InstructionAdapter iv, MutableClosure closure) {
                    KotlinType captureReceiver;
                    ClassDescriptor captureThis = closure.getCaptureThis();
                    if (captureThis != null) {
                        iv.load(0, ImplementationBodyCodegen.this.classAsmType);
                        Type type2 = ImplementationBodyCodegen.this.typeMapper.mapType(captureThis);
                        iv.getfield(ImplementationBodyCodegen.this.classAsmType.getInternalName(), "this$0", type2.getDescriptor());
                    }
                    if ((captureReceiver = closure.getCaptureReceiverType()) != null) {
                        iv.load(0, ImplementationBodyCodegen.this.classAsmType);
                        Type type3 = ImplementationBodyCodegen.this.typeMapper.mapType(captureReceiver);
                        iv.getfield(ImplementationBodyCodegen.this.classAsmType.getInternalName(), "receiver$0", type3.getDescriptor());
                    }
                    for (Map.Entry<DeclarationDescriptor, EnclosedValueDescriptor> entry : closure.getCaptureVariables().entrySet()) {
                        DeclarationDescriptor declarationDescriptor = entry.getKey();
                        EnclosedValueDescriptor enclosedValueDescriptor = entry.getValue();
                        StackValue capturedValue = enclosedValueDescriptor.getInstanceValue();
                        Type sharedVarType = ImplementationBodyCodegen.this.typeMapper.getSharedVarType(declarationDescriptor);
                        if (sharedVarType == null) {
                            sharedVarType = ImplementationBodyCodegen.this.typeMapper.mapType((VariableDescriptor)declarationDescriptor);
                        }
                        capturedValue.put(sharedVarType, iv);
                    }
                }
            });
            ImplementationBodyCodegen.this.functionCodegen.generateDefaultIfNeeded(ImplementationBodyCodegen.this.context.intoFunction(function2), function2, OwnerKind.IMPLEMENTATION, new DefaultParameterValueLoader(){

                @Override
                public StackValue genValue(ValueParameterDescriptor valueParameter, ExpressionCodegen codegen) {
                    assert (((ClassDescriptor)function2.getContainingDeclaration()).isData()) : "Function container must have [data] modifier: " + function2;
                    PropertyDescriptor property2 = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameter);
                    assert (property2 != null) : "Copy function doesn't correspond to any property: " + function2;
                    return codegen.intermediateValueForProperty(property2, false, null, StackValue.LOCAL_0);
                }
            }, null);
        }
    }
}

