/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.console.HistoryUpdateListener;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005J\u0006\u0010\u0016\u001a\u00020\u0014J\u0011\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u000bH\u0086\u0002J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/console/CommandHistory;", "", "()V", "entries", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/console/CommandHistory$Entry;", "listeners", "Lorg/jetbrains/kotlin/console/HistoryUpdateListener;", "getListeners", "()Ljava/util/ArrayList;", "<set-?>", "", "processedEntriesCount", "getProcessedEntriesCount", "()I", "setProcessedEntriesCount", "(I)V", "size", "getSize", "addEntry", "", "entry", "entryProcessed", "get", "i", "lastUnprocessedEntry", "Entry", "idea-repl"})
@KotlinClass(version={1, 1, 0}, data={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005J\u0006\u0010\u0016\u001a\u00020\u0014J\u0011\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u000bH\u0086\u0002J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u001b"}, strings={"Lorg/jetbrains/kotlin/console/CommandHistory;", "", "()V", "entries", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/console/CommandHistory$Entry;", "listeners", "Lorg/jetbrains/kotlin/console/HistoryUpdateListener;", "getListeners", "()Ljava/util/ArrayList;", "<set-?>", "", "processedEntriesCount", "getProcessedEntriesCount", "()I", "setProcessedEntriesCount", "(I)V", "size", "getSize", "addEntry", "", "entry", "entryProcessed", "get", "i", "lastUnprocessedEntry", "Entry", "idea-repl"})
public final class CommandHistory {
    private final ArrayList<Entry> entries = CollectionsKt.arrayListOf((Object[])new Entry[0]);
    private int processedEntriesCount;
    @NotNull
    private final ArrayList<HistoryUpdateListener> listeners = CollectionsKt.arrayListOf((Object[])new HistoryUpdateListener[0]);

    public final int getProcessedEntriesCount() {
        return this.processedEntriesCount;
    }

    private final void setProcessedEntriesCount(int n) {
        this.processedEntriesCount = n;
    }

    @NotNull
    public final ArrayList<HistoryUpdateListener> getListeners() {
        return this.listeners;
    }

    @NotNull
    public final Entry get(int i) {
        return this.entries.get(i);
    }

    public final void addEntry(@NotNull Entry entry) {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        this.entries.add(entry);
        Iterable $receiver$iv = this.listeners;
        for (Object element$iv : $receiver$iv) {
            HistoryUpdateListener it = (HistoryUpdateListener)element$iv;
            it.onNewEntry(entry);
        }
    }

    @Nullable
    public final Entry lastUnprocessedEntry() {
        if (this.processedEntriesCount < this.getSize()) {
            return this.get(this.processedEntriesCount);
        }
        return null;
    }

    public final void entryProcessed() {
        int n = this.processedEntriesCount++;
    }

    public final int getSize() {
        return this.entries.size();
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/console/CommandHistory$Entry;", "", "entryText", "", "rangeInHistoryDocument", "Lcom/intellij/openapi/util/TextRange;", "(Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;)V", "getEntryText", "()Ljava/lang/String;", "getRangeInHistoryDocument", "()Lcom/intellij/openapi/util/TextRange;", "idea-repl"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, strings={"Lorg/jetbrains/kotlin/console/CommandHistory$Entry;", "", "entryText", "", "rangeInHistoryDocument", "Lcom/intellij/openapi/util/TextRange;", "(Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;)V", "getEntryText", "()Ljava/lang/String;", "getRangeInHistoryDocument", "()Lcom/intellij/openapi/util/TextRange;", "idea-repl"})
    public static final class Entry {
        @NotNull
        private final String entryText;
        @NotNull
        private final TextRange rangeInHistoryDocument;

        @NotNull
        public final String getEntryText() {
            return this.entryText;
        }

        @NotNull
        public final TextRange getRangeInHistoryDocument() {
            return this.rangeInHistoryDocument;
        }

        public Entry(@NotNull String entryText, @NotNull TextRange rangeInHistoryDocument) {
            Intrinsics.checkParameterIsNotNull((Object)entryText, (String)"entryText");
            Intrinsics.checkParameterIsNotNull((Object)rangeInHistoryDocument, (String)"rangeInHistoryDocument");
            this.entryText = entryText;
            this.rangeInHistoryDocument = rangeInHistoryDocument;
        }
    }
}

