/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.ReplOutputHandlerKt;
import org.jetbrains.kotlin.console.ReplOutputProcessor;
import org.jetbrains.kotlin.console.SeverityDetails;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\b\u0010\u001b\u001a\u00020\u000fH\u0016J\u001e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00072\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0016J\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00072\b\b\u0002\u0010\"\u001a\u00020#H\u0002J\f\u0010$\u001a\u00020%*\u00020\u0007H\u0002R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/console/ReplOutputHandler;", "Lcom/intellij/execution/process/OSProcessHandler;", "runner", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "process", "Ljava/lang/Process;", "commandLine", "", "(Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;Ljava/lang/Process;Ljava/lang/String;)V", "dBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "kotlin.jvm.PlatformType", "inputBuffer", "Ljava/lang/StringBuilder;", "isBuildInfoChecked", "", "outputProcessor", "Lorg/jetbrains/kotlin/console/ReplOutputProcessor;", "buildWarningIfNeededBeforeInit", "", "content", "createCompilerMessages", "", "Lorg/jetbrains/kotlin/console/SeverityDetails;", "runtimeErrorsReport", "handleReplMessage", "text", "isSilentlyDestroyOnClose", "notifyTextAvailable", "key", "Lcom/intellij/openapi/util/Key;", "strToSource", "Lorg/xml/sax/InputSource;", "s", "encoding", "Ljava/nio/charset/Charset;", "toSeverity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "idea-repl"})
@KotlinClass(version={1, 1, 0}, data={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\b\u0010\u001b\u001a\u00020\u000fH\u0016J\u001e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00072\f\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0016J\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00072\b\b\u0002\u0010\"\u001a\u00020#H\u0002J\f\u0010$\u001a\u00020%*\u00020\u0007H\u0002R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, strings={"Lorg/jetbrains/kotlin/console/ReplOutputHandler;", "Lcom/intellij/execution/process/OSProcessHandler;", "runner", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "process", "Ljava/lang/Process;", "commandLine", "", "(Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;Ljava/lang/Process;Ljava/lang/String;)V", "dBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "kotlin.jvm.PlatformType", "inputBuffer", "Ljava/lang/StringBuilder;", "isBuildInfoChecked", "", "outputProcessor", "Lorg/jetbrains/kotlin/console/ReplOutputProcessor;", "buildWarningIfNeededBeforeInit", "", "content", "createCompilerMessages", "", "Lorg/jetbrains/kotlin/console/SeverityDetails;", "runtimeErrorsReport", "handleReplMessage", "text", "isSilentlyDestroyOnClose", "notifyTextAvailable", "key", "Lcom/intellij/openapi/util/Key;", "strToSource", "Lorg/xml/sax/InputSource;", "s", "encoding", "Ljava/nio/charset/Charset;", "toSeverity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "idea-repl"})
public final class ReplOutputHandler
extends OSProcessHandler {
    private boolean isBuildInfoChecked;
    private final DocumentBuilder dBuilder;
    private final ReplOutputProcessor outputProcessor;
    private final StringBuilder inputBuffer;
    private final KotlinConsoleRunner runner;

    public boolean isSilentlyDestroyOnClose() {
        return true;
    }

    public void notifyTextAvailable(@NotNull String text2, @Nullable Key<?> key) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        if (StringsKt.startsWith$default((String)text2, (String)"warning: classpath entry points to a non-existent location", (boolean)false, (int)2, null)) {
            return;
        }
        if (!StringsKt.startsWith$default((String)text2, (String)ReplOutputHandlerKt.access$getXML_PREFIX$p(), (boolean)false, (int)2, null) && this.inputBuffer.length() == 0) {
            super.notifyTextAvailable(text2, key);
            return;
        }
        this.inputBuffer.append(text2);
        String resultingText = this.inputBuffer.toString();
        if (StringsKt.endsWith$default((String)resultingText, (String)"\n", (boolean)false, (int)2, null)) {
            String string = resultingText;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resultingText");
            this.handleReplMessage(string);
            this.inputBuffer.setLength(0);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void handleReplMessage(String text) {
        block17: {
            block15: {
                block18: {
                    block19: {
                        block16: {
                            block23: {
                                block22: {
                                    block20: {
                                        block21: {
                                            block24: {
                                                output = this.dBuilder.parse(ReplOutputHandler.strToSource$default(this, text, null, 2, null));
                                                v0 = output.getFirstChild();
                                                if (v0 == null) {
                                                    throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
                                                }
                                                root = (Element)v0;
                                                outputType = root.getAttribute("type");
                                                content = StringUtil.replace((String)root.getTextContent(), (String[])ReplOutputHandlerKt.getXML_REPLACEMENTS(), (String[])ReplOutputHandlerKt.getSOURCE_CHARS());
                                                v1 = var6_6 = outputType;
                                                if (v1 == null) break block15;
                                                switch (v1.hashCode()) {
                                                    case -229373764: {
                                                        if (!var6_6.equals("COMPILE_ERROR")) ** break;
                                                        break block16;
                                                    }
                                                    case -1149187101: {
                                                        if (!var6_6.equals("SUCCESS")) ** break;
                                                        break block17;
                                                    }
                                                    case -1672278994: {
                                                        if (!var6_6.equals("REPL_INCOMPLETE")) ** break;
                                                        break block16;
                                                    }
                                                    case -485608986: {
                                                        if (!var6_6.equals("INTERNAL_ERROR")) ** break;
                                                        break block18;
                                                    }
                                                    case -401150303: {
                                                        if (!var6_6.equals("RUNTIME_ERROR")) ** break;
                                                        break block19;
                                                    }
                                                    case -426149139: {
                                                        if (!var6_6.equals("REPL_RESULT")) ** break;
                                                        break block20;
                                                    }
                                                    case 1956927199: {
                                                        if (!var6_6.equals("INITIAL_PROMPT")) ** break;
                                                        break;
                                                    }
                                                    case 224746485: {
                                                        if (!var6_6.equals("USER_OUTPUT")) ** break;
                                                        break block21;
                                                    }
                                                    case -2147099059: {
                                                        if (!var6_6.equals("READLINE_START")) ** break;
                                                        break block22;
                                                    }
                                                    case 1995515270: {
                                                        if (!var6_6.equals("READLINE_END")) ** break;
                                                        break block23;
                                                    }
                                                    case 1634273314: {
                                                        if (!var6_6.equals("HELP_PROMPT")) ** break;
                                                        break block24;
                                                    }
                                                }
                                                v2 = content;
                                                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"content");
                                                this.buildWarningIfNeededBeforeInit(v2);
                                                break block17;
                                            }
                                            v3 = content;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"content");
                                            this.outputProcessor.printHelp(v3);
                                            break block17;
                                        }
                                        v4 = content;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"content");
                                        this.outputProcessor.printUserOutput(v4);
                                        break block17;
                                    }
                                    v5 = content;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"content");
                                    this.outputProcessor.printResultWithGutterIcon(v5);
                                    break block17;
                                }
                                this.runner.setReadLineMode(true);
                                break block17;
                            }
                            this.runner.setReadLineMode(false);
                            break block17;
                        }
                        v6 = content;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"content");
                        this.outputProcessor.highlightCompilerErrors(this.createCompilerMessages(v6));
                        break block17;
                    }
                    this.outputProcessor.printRuntimeError(StringsKt.trim((String)content) + "\n");
                    break block17;
                }
                v7 = content;
                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"content");
                this.outputProcessor.printInternalErrorMessage(v7);
                break block17;
            }
            RunExecuteActionsKt.logError(ReplOutputHandler.class, "Unexpected output type:" + "\n" + outputType);
        }
        if (SetsKt.setOf((Object[])new String[]{"SUCCESS", "COMPILE_ERROR", "INTERNAL_ERROR", "RUNTIME_ERROR", "READLINE_END"}).contains(outputType)) {
            this.runner.getCommandHistory().entryProcessed();
        }
    }

    private final void buildWarningIfNeededBeforeInit(String content2) {
        if (!this.isBuildInfoChecked) {
            this.outputProcessor.printBuildInfoWarningIfNeeded();
            this.isBuildInfoChecked = true;
        }
        this.outputProcessor.printInitialPrompt(content2);
    }

    private final InputSource strToSource(String s, Charset encoding) {
        return new InputSource(new ByteArrayInputStream(StringsKt.toByteArray((String)s, (Charset)encoding)));
    }

    static /* bridge */ /* synthetic */ InputSource strToSource$default(ReplOutputHandler replOutputHandler, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return replOutputHandler.strToSource(string, charset);
    }

    static /* bridge */ /* synthetic */ InputSource strToSource$default(ReplOutputHandler replOutputHandler, String string, Charset charset, int n) {
        return ReplOutputHandler.strToSource$default(replOutputHandler, string, charset, n, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SeverityDetails> createCompilerMessages(String runtimeErrorsReport) {
        ArrayList compilerMessages = CollectionsKt.arrayListOf((Object[])new SeverityDetails[0]);
        int n = 0;
        Document report2 = this.dBuilder.parse(this.strToSource(runtimeErrorsReport, Charsets.UTF_16));
        NodeList entries2 = report2.getElementsByTagName("reportEntry");
        int n2 = entries2.getLength() - 1;
        if (n <= n2) {
            while (true) {
                String description;
                void i;
                Node node = entries2.item((int)i);
                if (node == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
                }
                Element reportEntry = (Element)node;
                Severity severityLevel = this.toSeverity(reportEntry.getAttribute("severity"));
                int rangeStart = StringsKt.toInt((String)reportEntry.getAttribute("rangeStart"));
                int rangeEnd = StringsKt.toInt((String)reportEntry.getAttribute("rangeEnd"));
                String string = description = reportEntry.getTextContent();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"description");
                compilerMessages.add(new SeverityDetails(severityLevel, string, new TextRange(rangeStart, rangeEnd)));
                if (i == n2) break;
                ++i;
            }
        }
        return compilerMessages;
    }

    private final Severity toSeverity(String $receiver) {
        Severity severity;
        switch ($receiver) {
            case "ERROR": {
                severity = Severity.ERROR;
                break;
            }
            case "WARNING": {
                severity = Severity.WARNING;
                break;
            }
            case "INFO": {
                severity = Severity.INFO;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unsupported Severity: '" + $receiver + "'");
            }
        }
        return severity;
    }

    public ReplOutputHandler(@NotNull KotlinConsoleRunner runner, @NotNull Process process2, @NotNull String commandLine) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)runner), (String)"runner");
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        super(process2, commandLine);
        this.runner = runner;
        this.dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.outputProcessor = new ReplOutputProcessor(this.runner);
        this.inputBuffer = new StringBuilder();
    }
}

