/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.filter;

import com.intellij.debugger.engine.SyntheticTypeComponentProvider;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.KotlinClass;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqNameUnsafe;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0012\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\f\u0010\u0010\u001a\u00020\b*\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/filter/KotlinSyntheticTypeComponentProvider;", "Lcom/intellij/debugger/engine/SyntheticTypeComponentProvider;", "()V", "LOAD_INSTRUCTIONS", "Lkotlin/ranges/IntRange;", "LOAD_INSTRUCTIONS_WITH_INDEX", "RETURN_INSTRUCTIONS", "hasInterfaceWithImplementation", "", "method", "Lcom/sun/jdi/Method;", "hasOnlyInvokeStatic", "m", "isSynthetic", "typeComponent", "Lcom/sun/jdi/TypeComponent;", "isDelegateToDefaultInterfaceImpl", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0012\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\f\u0010\u0010\u001a\u00020\b*\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, strings={"Lorg/jetbrains/kotlin/idea/debugger/filter/KotlinSyntheticTypeComponentProvider;", "Lcom/intellij/debugger/engine/SyntheticTypeComponentProvider;", "()V", "LOAD_INSTRUCTIONS", "Lkotlin/ranges/IntRange;", "LOAD_INSTRUCTIONS_WITH_INDEX", "RETURN_INSTRUCTIONS", "hasInterfaceWithImplementation", "", "method", "Lcom/sun/jdi/Method;", "hasOnlyInvokeStatic", "m", "isSynthetic", "typeComponent", "Lcom/sun/jdi/TypeComponent;", "isDelegateToDefaultInterfaceImpl", "idea"})
public final class KotlinSyntheticTypeComponentProvider
implements SyntheticTypeComponentProvider {
    private final IntRange LOAD_INSTRUCTIONS_WITH_INDEX = new IntRange((int)((byte)21), (int)((byte)25));
    private final IntRange LOAD_INSTRUCTIONS = new IntRange((int)((byte)(25 + 1)), (int)((byte)(46 - 1)));
    private final IntRange RETURN_INSTRUCTIONS = new IntRange((int)((byte)172), (int)((byte)177));

    public boolean isSynthetic(@Nullable TypeComponent typeComponent) {
        if (!(typeComponent instanceof Method)) {
            return false;
        }
        String typeName = typeComponent.declaringType().name();
        if (!FqNameUnsafe.isValid(typeName)) {
            return false;
        }
        try {
            boolean bl;
            block11: {
                boolean bl2;
                Location it;
                Iterable $receiver$iv;
                block10: {
                    if (this.isDelegateToDefaultInterfaceImpl((Method)typeComponent)) {
                        return true;
                    }
                    if (((Method)typeComponent).location().lineNumber() != 1) {
                        return false;
                    }
                    $receiver$iv = ((Method)typeComponent).allLineLocations();
                    for (Object element$iv : $receiver$iv) {
                        it = (Location)element$iv;
                        if (!(it.lineNumber() != 1)) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    return false;
                }
                $receiver$iv = typeComponent.declaringType().allLineLocations();
                for (Object element$iv : $receiver$iv) {
                    it = (Location)element$iv;
                    if (!(it.lineNumber() != 1)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
            return !bl;
        }
        catch (AbsentInformationException e) {
            return false;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    private final boolean isDelegateToDefaultInterfaceImpl(Method $receiver) {
        if ($receiver.allLineLocations().size() != 1) {
            return false;
        }
        if (!this.hasOnlyInvokeStatic($receiver)) {
            return false;
        }
        return this.hasInterfaceWithImplementation($receiver);
    }

    private final boolean hasOnlyInvokeStatic(Method m) {
        byte[] bytecodes = m.bytecodes();
        int i = 0;
        boolean isALoad0BeforeStaticCall = false;
        while (i < bytecodes.length) {
            byte nextInstr;
            byte instr = bytecodes[i];
            if (instr == (byte)42) {
                ++i;
                isALoad0BeforeStaticCall = true;
                continue;
            }
            if (RangesKt.intRangeContains((ClosedRange)((ClosedRange)this.LOAD_INSTRUCTIONS_WITH_INDEX), (byte)instr) || RangesKt.intRangeContains((ClosedRange)((ClosedRange)this.LOAD_INSTRUCTIONS), (byte)instr)) {
                ++i;
                if (RangesKt.intRangeContains((ClosedRange)((ClosedRange)this.LOAD_INSTRUCTIONS_WITH_INDEX), (byte)instr)) {
                    ++i;
                }
                if ((nextInstr = bytecodes[i]) != (byte)18) continue;
                i += 2;
                isALoad0BeforeStaticCall = false;
                continue;
            }
            if (instr == (byte)184) {
                if (!isALoad0BeforeStaticCall || (i += 3) != bytecodes.length - 1) continue;
                nextInstr = bytecodes[i];
                return RangesKt.intRangeContains((ClosedRange)((ClosedRange)this.RETURN_INSTRUCTIONS), (byte)nextInstr);
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasInterfaceWithImplementation(Method method) {
        boolean bl;
        block4: {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            ReferenceType referenceType = method.declaringType();
            if (!(referenceType instanceof ClassType)) {
                referenceType = null;
            }
            ClassType classType = (ClassType)referenceType;
            if (classType == null) {
                return false;
            }
            ClassType declaringType = classType;
            List<InterfaceType> interfaces = declaringType.allInterfaces();
            VirtualMachine vm = declaringType.virtualMachine();
            Iterable iterable = interfaces;
            Iterator iterator2 = $receiver$iv;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                InterfaceType it = (InterfaceType)element$iv$iv;
                Iterable list$iv$iv = vm.classesByName(it.name() + "$DefaultImpls");
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List traitImpls = (List)destination$iv$iv;
            $receiver$iv = traitImpls;
            for (Object element$iv : $receiver$iv) {
                ReferenceType it = (ReferenceType)element$iv;
                if (!(!it.methodsByName(method.name()).isEmpty())) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }
}

