/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.builtIns;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.BuiltInsSerializedResourcePaths;
import org.jetbrains.kotlin.idea.decompiler.builtIns.KotlinBuiltInClassFileType;
import org.jetbrains.kotlin.idea.decompiler.builtIns.KotlinBuiltInDecompiler;
import org.jetbrains.kotlin.idea.decompiler.builtIns.KotlinBuiltInDecompilerKt;
import org.jetbrains.kotlin.idea.decompiler.builtIns.KotlinBuiltInDeserializerForDecompiler;
import org.jetbrains.kotlin.idea.decompiler.builtIns.KotlinBuiltInPackageFileType;
import org.jetbrains.kotlin.idea.decompiler.builtIns.KotlinBuiltInStubBuilderKt;
import org.jetbrains.kotlin.idea.decompiler.common.ProtoBufUtilKt;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledText;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledTextFactoryKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.builtins.BuiltInsProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverImpl;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"decompilerRendererForBuiltIns", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "buildDecompiledTextForBuiltIns", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledText;", "builtInFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isInternalBuiltInFile", "", "virtualFile", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Package;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolverImpl;", "idea-analysis"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, strings={"decompilerRendererForBuiltIns", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "buildDecompiledTextForBuiltIns", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledText;", "builtInFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isInternalBuiltInFile", "", "virtualFile", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Package;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolverImpl;", "idea-analysis"})
public final class KotlinBuiltInDecompilerKt {
    private static final DescriptorRenderer decompilerRendererForBuiltIns = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)decompilerRendererForBuiltIns.1.INSTANCE));

    @NotNull
    public static final DecompiledText buildDecompiledTextForBuiltIns(@NotNull VirtualFile builtInFile) {
        DecompiledText decompiledText2;
        Intrinsics.checkParameterIsNotNull((Object)builtInFile, (String)"builtInFile");
        VirtualFile virtualFile = builtInFile.getParent();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        VirtualFile directory = virtualFile;
        Logger logger = KotlinBuiltInDecompiler.Companion.getLOG();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"KotlinBuiltInDecompiler.LOG");
        NameResolverImpl nameResolverImpl = KotlinBuiltInStubBuilderKt.readStringTable(directory, logger);
        if (nameResolverImpl == null) {
            Intrinsics.throwNpe();
        }
        NameResolverImpl nameResolver = nameResolverImpl;
        byte[] content2 = builtInFile.contentsToByteArray();
        FileType fileType = builtInFile.getFileType();
        if (Intrinsics.areEqual((Object)fileType, (Object)KotlinBuiltInPackageFileType.INSTANCE)) {
            FqName packageFqName = KotlinBuiltInDecompilerKt.packageFqName(ProtoBufUtilKt.toPackageProto(content2, BuiltInsSerializedResourcePaths.INSTANCE.getExtensionRegistry()), nameResolver);
            KotlinBuiltInDeserializerForDecompiler resolver = new KotlinBuiltInDeserializerForDecompiler(directory, packageFqName, nameResolver);
            decompiledText2 = DecompiledTextFactoryKt.buildDecompiledText(packageFqName, resolver.resolveDeclarationsInFacade(packageFqName), decompilerRendererForBuiltIns);
        } else if (Intrinsics.areEqual((Object)fileType, (Object)KotlinBuiltInClassFileType.INSTANCE)) {
            FqName packageFqName;
            ProtoBuf.Class classProto = ProtoBufUtilKt.toClassProto(content2, BuiltInsSerializedResourcePaths.INSTANCE.getExtensionRegistry());
            ClassId classId = nameResolver.getClassId(classProto.getFqName());
            FqName fqName2 = packageFqName = classId.getPackageFqName();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
            KotlinBuiltInDeserializerForDecompiler resolver = new KotlinBuiltInDeserializerForDecompiler(directory, fqName2, nameResolver);
            FqName fqName3 = packageFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"packageFqName");
            decompiledText2 = DecompiledTextFactoryKt.buildDecompiledText(fqName3, CollectionsKt.listOfNotNull((Object)resolver.resolveTopLevelClass(classId)), decompilerRendererForBuiltIns);
        } else {
            Void void_ = PreconditionsKt.error((Object)("Unexpected filetype " + builtInFile.getFileType()));
            throw null;
        }
        return decompiledText2;
    }

    @NotNull
    public static final FqName packageFqName(ProtoBuf.Package $receiver, @NotNull NameResolverImpl nameResolver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        return nameResolver.getPackageFqName(((Number)$receiver.getExtension(BuiltInsProtoBuf.packageFqName)).intValue());
    }

    public static final boolean isInternalBuiltInFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        FileType fileType = virtualFile.getFileType();
        if (Intrinsics.areEqual((Object)fileType, (Object)KotlinBuiltInPackageFileType.INSTANCE)) {
            ProtoBuf.Package packageProto = ProtoBufUtilKt.toPackageProto(virtualFile.contentsToByteArray(), BuiltInsSerializedResourcePaths.INSTANCE.getExtensionRegistry());
            return !packageProto.hasExtension(BuiltInsProtoBuf.packageFqName);
        }
        if (Intrinsics.areEqual((Object)fileType, (Object)KotlinBuiltInClassFileType.INSTANCE)) {
            boolean correspondsToInnerClass = StringsKt.contains$default((CharSequence)virtualFile.getNameWithoutExtension(), (char)'.', (boolean)false, (int)2, null);
            if (correspondsToInnerClass) {
                return true;
            }
            String classFileName = virtualFile.getNameWithoutExtension() + "." + JavaClassFileType.INSTANCE.getDefaultExtension();
            VirtualFile virtualFile2 = virtualFile.getParent();
            if (virtualFile2 == null) {
                Intrinsics.throwNpe();
            }
            boolean classFileForTheSameClassIsPresent = virtualFile2.findChild(classFileName) != null;
            return classFileForTheSameClassIsPresent;
        }
        Void void_ = PreconditionsKt.error((Object)("Unexpected filetype " + virtualFile.getFileType()));
        throw null;
    }
}

