/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.classFile;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.IDEKotlinBinaryClassCache;
import org.jetbrains.kotlin.idea.decompiler.classFile.ClassFileDecompilerUtilKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.DeserializerForClassfileDecompilerKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.KotlinClassFileDecompilerKt;
import org.jetbrains.kotlin.idea.decompiler.classFile.KotlinClassFileDecompilerKt$WhenMappings;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledText;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledTextFactoryKt;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.ResolverForDecompiler;
import org.jetbrains.kotlin.load.kotlin.JvmMetadataVersion;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0005\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"CURRENT_ABI_VERSION_MARKER", "", "FILE_ABI_VERSION_MARKER", "INCOMPATIBLE_ABI_VERSION_COMMENT", "getINCOMPATIBLE_ABI_VERSION_COMMENT", "()Ljava/lang/String;", "INCOMPATIBLE_ABI_VERSION_GENERAL_COMMENT", "getINCOMPATIBLE_ABI_VERSION_GENERAL_COMMENT", "decompilerRendererForClassFiles", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "buildDecompiledTextForClassFile", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledText;", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolver", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/ResolverForDecompiler;", "idea-analysis"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0005\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, strings={"CURRENT_ABI_VERSION_MARKER", "", "FILE_ABI_VERSION_MARKER", "INCOMPATIBLE_ABI_VERSION_COMMENT", "getINCOMPATIBLE_ABI_VERSION_COMMENT", "()Ljava/lang/String;", "INCOMPATIBLE_ABI_VERSION_GENERAL_COMMENT", "getINCOMPATIBLE_ABI_VERSION_GENERAL_COMMENT", "decompilerRendererForClassFiles", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "buildDecompiledTextForClassFile", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledText;", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolver", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/ResolverForDecompiler;", "idea-analysis"})
public final class KotlinClassFileDecompilerKt {
    private static final DescriptorRenderer decompilerRendererForClassFiles = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)decompilerRendererForClassFiles.1.INSTANCE));
    private static final String FILE_ABI_VERSION_MARKER = "FILE_ABI";
    private static final String CURRENT_ABI_VERSION_MARKER = "CURRENT_ABI";
    @NotNull
    private static final String INCOMPATIBLE_ABI_VERSION_GENERAL_COMMENT = "// This class file was compiled with different version of Kotlin compiler and can't be decompiled.";
    @NotNull
    private static final String INCOMPATIBLE_ABI_VERSION_COMMENT = "// This class file was compiled with different version of Kotlin compiler and can't be decompiled.\n//\n// Current compiler ABI version is CURRENT_ABI\n// File ABI version is FILE_ABI";

    @NotNull
    public static final String getINCOMPATIBLE_ABI_VERSION_GENERAL_COMMENT() {
        return INCOMPATIBLE_ABI_VERSION_GENERAL_COMMENT;
    }

    @NotNull
    public static final String getINCOMPATIBLE_ABI_VERSION_COMMENT() {
        return INCOMPATIBLE_ABI_VERSION_COMMENT;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DecompiledText buildDecompiledTextForClassFile(@NotNull VirtualFile classFile, @NotNull ResolverForDecompiler resolver) {
        DecompiledText decompiledText2;
        void classHeader;
        Intrinsics.checkParameterIsNotNull((Object)classFile, (String)"classFile");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        IDEKotlinBinaryClassCache.KotlinBinaryHeaderData kotlinBinaryHeaderData = IDEKotlinBinaryClassCache.getKotlinBinaryClassHeaderData$default(IDEKotlinBinaryClassCache.INSTANCE, classFile, null, 2, null);
        if (kotlinBinaryHeaderData == null) {
            Void void_ = PreconditionsKt.error((Object)("Decompiled data factory shouldn't be called on an unsupported file: " + classFile));
            throw null;
        }
        IDEKotlinBinaryClassCache.KotlinBinaryHeaderData kotlinBinaryHeaderData2 = kotlinBinaryHeaderData;
        KotlinClassHeader kotlinClassHeader = kotlinBinaryHeaderData2.component1();
        ClassId classId = kotlinBinaryHeaderData2.component2();
        kotlinBinaryHeaderData2 = null;
        if (!classHeader.getMetadataVersion().isCompatible()) {
            return new DecompiledText(StringsKt.replace$default((String)StringsKt.replace$default((String)INCOMPATIBLE_ABI_VERSION_COMMENT, (String)CURRENT_ABI_VERSION_MARKER, (String)JvmMetadataVersion.INSTANCE.toString(), (boolean)false, (int)4, null), (String)FILE_ABI_VERSION_MARKER, (String)classHeader.getMetadataVersion().toString(), (boolean)false, (int)4, null), MapsKt.mapOf());
        }
        switch (KotlinClassFileDecompilerKt$WhenMappings.$EnumSwitchMapping$0[classHeader.getKind().ordinal()]) {
            case 1: {
                void classId2;
                FqName fqName2 = classId2.getPackageFqName();
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.packageFqName");
                FqName fqName3 = classId2.asSingleFqName();
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"classId.asSingleFqName()");
                decompiledText2 = DecompiledTextFactoryKt.buildDecompiledText(fqName2, new ArrayList(resolver.resolveDeclarationsInFacade(fqName3)), decompilerRendererForClassFiles);
                break;
            }
            case 2: {
                void classId2;
                FqName fqName4 = classId2.getPackageFqName();
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName4, (String)"classId.packageFqName");
                decompiledText2 = DecompiledTextFactoryKt.buildDecompiledText(fqName4, CollectionsKt.listOfNotNull((Object)resolver.resolveTopLevelClass((ClassId)classId2)), decompilerRendererForClassFiles);
                break;
            }
            case 3: {
                void destination$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv;
                void classId2;
                List<KotlinJvmBinaryClass> partClasses = ClassFileDecompilerUtilKt.findMultifileClassParts(classFile, (ClassId)classId2, (KotlinClassHeader)classHeader);
                Iterable iterable = partClasses;
                void var7_6 = $receiver$iv;
                Collection collection = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    KotlinJvmBinaryClass partClass = (KotlinJvmBinaryClass)element$iv$iv;
                    FqName fqName5 = partClass.getClassId().asSingleFqName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fqName5, (String)"partClass.classId.asSingleFqName()");
                    Iterable list$iv$iv = resolver.resolveDeclarationsInFacade(fqName5);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List partMembers = (List)destination$iv$iv;
                FqName fqName6 = classId2.getPackageFqName();
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName6, (String)"classId.packageFqName");
                decompiledText2 = DecompiledTextFactoryKt.buildDecompiledText(fqName6, partMembers, decompilerRendererForClassFiles);
                break;
            }
            default: {
                void classId2;
                throw (Throwable)new UnsupportedOperationException("Unknown header kind: " + classHeader + ", class " + classId2);
            }
        }
        return decompiledText2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ DecompiledText buildDecompiledTextForClassFile$default(VirtualFile virtualFile, ResolverForDecompiler resolverForDecompiler, int n, Object object) {
        if ((n & 2) != 0) {
            resolverForDecompiler = DeserializerForClassfileDecompilerKt.DeserializerForClassfileDecompiler(virtualFile);
        }
        return KotlinClassFileDecompilerKt.buildDecompiledTextForClassFile(virtualFile, resolverForDecompiler);
    }

    public static /* bridge */ /* synthetic */ DecompiledText buildDecompiledTextForClassFile$default(VirtualFile virtualFile, ResolverForDecompiler resolverForDecompiler, int n) {
        return KotlinClassFileDecompilerKt.buildDecompiledTextForClassFile$default(virtualFile, resolverForDecompiler, n, null);
    }

    static {
        FILE_ABI_VERSION_MARKER = FILE_ABI_VERSION_MARKER;
        CURRENT_ABI_VERSION_MARKER = CURRENT_ABI_VERSION_MARKER;
        INCOMPATIBLE_ABI_VERSION_GENERAL_COMMENT = INCOMPATIBLE_ABI_VERSION_GENERAL_COMMENT;
        INCOMPATIBLE_ABI_VERSION_COMMENT = INCOMPATIBLE_ABI_VERSION_GENERAL_COMMENT + "\n" + "//\n" + ("// Current compiler ABI version is " + CURRENT_ABI_VERSION_MARKER + "\n") + ("// File ABI version is " + FILE_ABI_VERSION_MARKER);
    }
}

