/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.js;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.OldPackageFacadeClassUtils;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.decompiler.js.JsMetaFileUtils;
import org.jetbrains.kotlin.idea.decompiler.js.KotlinJavaScriptDeserializerForDecompiler;
import org.jetbrains.kotlin.idea.decompiler.js.KotlinJavaScriptMetaFileDecompilerKt;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledText;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledTextFactoryKt;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.ResolverForDecompiler;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a&\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"decompilerRendererForJS", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "buildDecompiledTextFromJsMetadata", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledText;", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolver", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/ResolverForDecompiler;", "resolveDeclarationsInPackage", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kotlin.jvm.PlatformType", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "idea-analysis"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a&\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, strings={"decompilerRendererForJS", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "buildDecompiledTextFromJsMetadata", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledText;", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolver", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/ResolverForDecompiler;", "resolveDeclarationsInPackage", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kotlin.jvm.PlatformType", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "idea-analysis"})
public final class KotlinJavaScriptMetaFileDecompilerKt {
    private static final DescriptorRenderer decompilerRendererForJS = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)decompilerRendererForJS.1.INSTANCE));

    @NotNull
    public static final DecompiledText buildDecompiledTextFromJsMetadata(@NotNull VirtualFile classFile, @NotNull ResolverForDecompiler resolver) {
        Intrinsics.checkParameterIsNotNull((Object)classFile, (String)"classFile");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        FqName packageFqName = JsMetaFileUtils.INSTANCE.getPackageFqName(classFile);
        boolean isPackageHeader = JsMetaFileUtils.INSTANCE.isPackageHeader(classFile);
        if (isPackageHeader) {
            return DecompiledTextFactoryKt.buildDecompiledText(packageFqName, (List<? extends DeclarationDescriptor>)KotlinJavaScriptMetaFileDecompilerKt.resolveDeclarationsInPackage(packageFqName, resolver), decompilerRendererForJS);
        }
        ClassId classId = JsMetaFileUtils.INSTANCE.getClassId(classFile);
        return DecompiledTextFactoryKt.buildDecompiledText(packageFqName, CollectionsKt.listOfNotNull((Object)resolver.resolveTopLevelClass(classId)), decompilerRendererForJS);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ DecompiledText buildDecompiledTextFromJsMetadata$default(VirtualFile virtualFile, ResolverForDecompiler resolverForDecompiler, int n, Object object) {
        if ((n & 2) != 0) {
            resolverForDecompiler = new KotlinJavaScriptDeserializerForDecompiler(virtualFile);
        }
        return KotlinJavaScriptMetaFileDecompilerKt.buildDecompiledTextFromJsMetadata(virtualFile, resolverForDecompiler);
    }

    public static /* bridge */ /* synthetic */ DecompiledText buildDecompiledTextFromJsMetadata$default(VirtualFile virtualFile, ResolverForDecompiler resolverForDecompiler, int n) {
        return KotlinJavaScriptMetaFileDecompilerKt.buildDecompiledTextFromJsMetadata$default(virtualFile, resolverForDecompiler, n, null);
    }

    private static final ArrayList<DeclarationDescriptor> resolveDeclarationsInPackage(FqName packageFqName, ResolverForDecompiler resolver) {
        FqName fqName2 = OldPackageFacadeClassUtils.getPackageClassFqName(packageFqName);
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"OldPackageFacadeClassUti\u2026lassFqName(packageFqName)");
        return new ArrayList<DeclarationDescriptor>((Collection)resolver.resolveDeclarationsInFacade(fqName2));
    }
}

