/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.editor.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterList;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/editor/fixers/KotlinFunctionParametersFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler;", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "psiElement", "Lcom/intellij/psi/PsiElement;", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, strings={"Lorg/jetbrains/kotlin/idea/editor/fixers/KotlinFunctionParametersFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler;", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "psiElement", "Lcom/intellij/psi/PsiElement;", "idea"})
public final class KotlinFunctionParametersFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor2, @NotNull PsiElement psiElement2) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)psiElement2, (String)"psiElement");
        if (!(psiElement2 instanceof KtNamedFunction)) {
            return;
        }
        KtParameterList parameterList2 = ((KtNamedFunction)psiElement2).getValueParameterList();
        if (parameterList2 == null) {
            KtTypeParameterList ktTypeParameterList;
            PsiElement identifier = ((KtNamedFunction)psiElement2).getNameIdentifier();
            if (identifier == null) {
                return;
            }
            int offset2 = Math.max(FixersUtilKt.getEnd(FixersUtilKt.getRange(identifier)), (ktTypeParameterList = ((KtNamedFunction)psiElement2).getTypeParameterList()) != null && (ktTypeParameterList = FixersUtilKt.getRange((PsiElement)ktTypeParameterList)) != null ? FixersUtilKt.getEnd((TextRange)ktTypeParameterList) : FixersUtilKt.getStart(FixersUtilKt.getRange(psiElement2)));
            editor.getDocument().insertString(offset2, (CharSequence)"()");
            processor2.registerUnresolvedError(offset2 + 1);
        } else {
            PsiElement rParen = parameterList2.getLastChild();
            if (rParen == null) {
                return;
            }
            if (Intrinsics.areEqual((Object)")", (Object)rParen.getText()) ^ true) {
                List<KtParameter> params2 = parameterList2.getParameters();
                int offset3 = params2.isEmpty() ? FixersUtilKt.getStart(FixersUtilKt.getRange((PsiElement)parameterList2)) + 1 : FixersUtilKt.getEnd(FixersUtilKt.getRange((PsiElement)CollectionsKt.last(params2)));
                editor.getDocument().insertString(offset3, (CharSequence)")");
            }
        }
    }
}

