/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.LineMarkerNavigator;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Function;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightClass;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.highlighter.markers.JavaPsiUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerProviderKt;
import org.jetbrains.kotlin.idea.highlighter.markers.OverridenFunctionMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.OverridenPropertyMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.ResolveWithParentsResult;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerNavigationHandler;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerTooltip;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eH\u0002\u001a(\u0010\u0010\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eH\u0002\u001a(\u0010\u0014\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eH\u0002\u001a\"\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eH\u0002\u001a\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0012H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"IMPLEMENTED_MARK", "Ljavax/swing/Icon;", "IMPLEMENTING_MARK", "OVERRIDDEN_FUNCTION", "Lcom/intellij/codeInsight/daemon/impl/MarkerType;", "OVERRIDDEN_MARK", "OVERRIDDEN_PROPERTY", "OVERRIDING_MARK", "SUBCLASSED_CLASS", "collectInheritedClassMarker", "", "element", "Lorg/jetbrains/kotlin/psi/KtClass;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "collectOverriddenFunctions", "functions", "", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "collectOverriddenPropertyAccessors", "properties", "Lorg/jetbrains/kotlin/psi/KtProperty;", "collectSuperDeclarationMarkers", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isImplementsAndNotOverrides", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "overriddenMembers", "idea"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eH\u0002\u001a(\u0010\u0010\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eH\u0002\u001a(\u0010\u0014\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eH\u0002\u001a\"\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eH\u0002\u001a\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0012H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, strings={"IMPLEMENTED_MARK", "Ljavax/swing/Icon;", "IMPLEMENTING_MARK", "OVERRIDDEN_FUNCTION", "Lcom/intellij/codeInsight/daemon/impl/MarkerType;", "OVERRIDDEN_MARK", "OVERRIDDEN_PROPERTY", "OVERRIDING_MARK", "SUBCLASSED_CLASS", "collectInheritedClassMarker", "", "element", "Lorg/jetbrains/kotlin/psi/KtClass;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "collectOverriddenFunctions", "functions", "", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "collectOverriddenPropertyAccessors", "properties", "Lorg/jetbrains/kotlin/psi/KtProperty;", "collectSuperDeclarationMarkers", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isImplementsAndNotOverrides", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "overriddenMembers", "idea"})
public final class KotlinLineMarkerProviderKt {
    private static final Icon OVERRIDING_MARK;
    private static final Icon IMPLEMENTING_MARK;
    private static final Icon OVERRIDDEN_MARK;
    private static final Icon IMPLEMENTED_MARK;
    private static final MarkerType SUBCLASSED_CLASS;
    private static final MarkerType OVERRIDDEN_FUNCTION;
    private static final MarkerType OVERRIDDEN_PROPERTY;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isImplementsAndNotOverrides(CallableMemberDescriptor descriptor2, Collection<? extends CallableMemberDescriptor> overriddenMembers) {
        Object element$iv;
        CallableMemberDescriptor it;
        if (!(Intrinsics.areEqual((Object)((Object)descriptor2.getModality()), (Object)((Object)Modality.ABSTRACT)) ^ true)) return false;
        Iterable $receiver$iv = overriddenMembers;
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while (Intrinsics.areEqual((Object)((Object)(it = (CallableMemberDescriptor)(element$iv = iterator2.next())).getModality()), (Object)((Object)Modality.ABSTRACT)));
        return false;
    }

    private static final void collectSuperDeclarationMarkers(KtDeclaration declaration, Collection<LineMarkerInfo<?>> result2) {
        PreconditionsKt.assert((declaration instanceof KtNamedFunction || declaration instanceof KtProperty ? 1 : 0) != 0);
        if (!declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return;
        }
        ResolveWithParentsResult resolveWithParents = SuperDeclarationMarkerKt.resolveDeclarationWithParents(declaration);
        if (resolveWithParents.getOverriddenDescriptors().isEmpty()) {
            return;
        }
        CallableMemberDescriptor callableMemberDescriptor = resolveWithParents.getDescriptor();
        if (callableMemberDescriptor == null) {
            Intrinsics.throwNpe();
        }
        boolean bl = KotlinLineMarkerProviderKt.isImplementsAndNotOverrides(callableMemberDescriptor, resolveWithParents.getOverriddenDescriptors());
        LineMarkerInfo marker = new LineMarkerInfo((PsiElement)declaration, declaration.getTextOffset(), bl ? IMPLEMENTING_MARK : OVERRIDING_MARK, 6, (Function)SuperDeclarationMarkerTooltip.INSTANCE, (GutterIconNavigationHandler)new SuperDeclarationMarkerNavigationHandler());
        result2.add(marker);
    }

    private static final void collectInheritedClassMarker(KtClass element2, Collection<LineMarkerInfo<?>> result2) {
        boolean isTrait = element2.isInterface();
        if (!(isTrait || element2.hasModifier(KtTokens.OPEN_KEYWORD) || element2.hasModifier(KtTokens.ABSTRACT_KEYWORD))) {
            return;
        }
        KtLightClass ktLightClass = LightClassUtilsKt.toLightClass(element2);
        if (ktLightClass == null) {
            return;
        }
        KtLightClass lightClass2 = ktLightClass;
        if (ClassInheritorsSearch.search((PsiClass)lightClass2, (boolean)false).findFirst() == null) {
            return;
        }
        PsiElement psiElement2 = element2.getNameIdentifier();
        if (psiElement2 == null) {
            psiElement2 = element2;
        }
        PsiElement anchor2 = psiElement2;
        result2.add(new LineMarkerInfo(anchor2, anchor2.getTextOffset(), isTrait ? IMPLEMENTED_MARK : OVERRIDDEN_MARK, 6, SUBCLASSED_CLASS.getTooltip(), SUBCLASSED_CLASS.getNavigationHandler()));
    }

    private static final void collectOverriddenPropertyAccessors(Collection<? extends KtProperty> properties2, Collection<LineMarkerInfo<?>> result2) {
        HashMap<PsiMethod, KtProperty> mappingToJava = new HashMap<PsiMethod, KtProperty>();
        for (KtProperty ktProperty : properties2) {
            if (!KtPsiUtilKt.isOverridable(ktProperty)) continue;
            LightClassUtil.PropertyAccessorsPsiMethods accessorsPsiMethods = LightClassUtil.INSTANCE.getLightClassPropertyMethods(ktProperty);
            for (PsiMethod psiMethod : accessorsPsiMethods) {
                mappingToJava.put(psiMethod, ktProperty);
            }
        }
        Collection collection = mappingToJava.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"mappingToJava.keys");
        Set<PsiClass> set = JavaPsiUtilsKt.collectContainingClasses(collection);
        for (KtProperty property3 : OverridenFunctionMarkerKt.getOverriddenDeclarations((Map)mappingToJava, set)) {
            ProgressManager.checkCanceled();
            PsiElement psiElement2 = property3.getNameIdentifier();
            if (psiElement2 == null) {
                psiElement2 = property3;
            }
            PsiElement anchor2 = psiElement2;
            result2.add(new LineMarkerInfo(anchor2, anchor2.getTextOffset(), OverridenPropertyMarkerKt.isImplemented(property3) ? IMPLEMENTED_MARK : OVERRIDDEN_MARK, 6, OVERRIDDEN_PROPERTY.getTooltip(), OVERRIDDEN_PROPERTY.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT));
        }
    }

    private static final void collectOverriddenFunctions(Collection<? extends KtNamedFunction> functions2, Collection<LineMarkerInfo<?>> result2) {
        HashMap<PsiMethod, KtNamedFunction> mappingToJava = new HashMap<PsiMethod, KtNamedFunction>();
        for (KtNamedFunction ktNamedFunction : functions2) {
            PsiMethod method;
            if (!KtPsiUtilKt.isOverridable(ktNamedFunction) || (method = LightClassUtil.INSTANCE.getLightClassMethod(ktNamedFunction)) == null) continue;
            mappingToJava.put(method, ktNamedFunction);
        }
        Collection collection = mappingToJava.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"mappingToJava.keys");
        Set<PsiClass> set = JavaPsiUtilsKt.collectContainingClasses(collection);
        for (KtNamedFunction function3 : OverridenFunctionMarkerKt.getOverriddenDeclarations((Map)mappingToJava, set)) {
            ProgressManager.checkCanceled();
            PsiElement psiElement2 = function3.getNameIdentifier();
            if (psiElement2 == null) {
                psiElement2 = function3;
            }
            PsiElement anchor2 = psiElement2;
            result2.add(new LineMarkerInfo(anchor2, anchor2.getTextOffset(), OverridenPropertyMarkerKt.isImplemented(function3) ? IMPLEMENTED_MARK : OVERRIDDEN_MARK, 6, OVERRIDDEN_FUNCTION.getTooltip(), OVERRIDDEN_FUNCTION.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT));
        }
    }

    static {
        Icon icon = AllIcons.Gutter.OverridingMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Gutter.OverridingMethod");
        OVERRIDING_MARK = icon;
        Icon icon2 = AllIcons.Gutter.ImplementingMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Gutter.ImplementingMethod");
        IMPLEMENTING_MARK = icon2;
        Icon icon3 = AllIcons.Gutter.OverridenMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.Gutter.OverridenMethod");
        OVERRIDDEN_MARK = icon3;
        Icon icon4 = AllIcons.Gutter.ImplementedMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon4, (String)"AllIcons.Gutter.ImplementedMethod");
        IMPLEMENTED_MARK = icon4;
        SUBCLASSED_CLASS = new MarkerType((Function)SUBCLASSED_CLASS.1.INSTANCE, new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element2) {
                Unit unit;
                PsiClass psiClass = JavaPsiUtilsKt.getPsiClass(element2);
                if (psiClass != null) {
                    PsiClass $receiver$iv = psiClass;
                    PsiClass it = $receiver$iv;
                    MarkerType.navigateToSubclassedClass((MouseEvent)e, (PsiClass)it);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
        });
        OVERRIDDEN_FUNCTION = new MarkerType((Function)OVERRIDDEN_FUNCTION.1.INSTANCE, new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element2) {
                Unit unit;
                PsiMethod psiMethod = JavaPsiUtilsKt.getPsiMethod(element2);
                if (psiMethod != null) {
                    PsiMethod $receiver$iv = psiMethod;
                    PsiMethod it = $receiver$iv;
                    OverridenFunctionMarkerKt.navigateToOverriddenMethod(e, it);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
        });
        OVERRIDDEN_PROPERTY = new MarkerType((Function)OVERRIDDEN_PROPERTY.1.INSTANCE, new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element2) {
                Unit unit;
                PsiElement psiElement2 = element2;
                if (psiElement2 != null) {
                    PsiElement $receiver$iv = psiElement2;
                    PsiElement it = $receiver$iv;
                    PsiElement psiElement3 = it.getParent();
                    if (psiElement3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
                    }
                    OverridenPropertyMarkerKt.navigateToPropertyOverriddenDeclarations(e, (KtProperty)psiElement3);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
        });
    }

    public static final /* synthetic */ void access$collectInheritedClassMarker(@NotNull KtClass element2, @NotNull Collection result2) {
        KotlinLineMarkerProviderKt.collectInheritedClassMarker(element2, result2);
    }

    public static final /* synthetic */ void access$collectSuperDeclarationMarkers(@NotNull KtDeclaration declaration, @NotNull Collection result2) {
        KotlinLineMarkerProviderKt.collectSuperDeclarationMarkers(declaration, result2);
    }

    public static final /* synthetic */ void access$collectOverriddenFunctions(@NotNull Collection functions2, @NotNull Collection result2) {
        KotlinLineMarkerProviderKt.collectOverriddenFunctions(functions2, result2);
    }

    public static final /* synthetic */ void access$collectOverriddenPropertyAccessors(@NotNull Collection properties2, @NotNull Collection result2) {
        KotlinLineMarkerProviderKt.collectOverriddenPropertyAccessors(properties2, result2);
    }
}

