/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.navigation.ListBackgroundUpdaterTask;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/markers/OverridingMethodsUpdater;", "Lcom/intellij/codeInsight/navigation/ListBackgroundUpdaterTask;", "myMethod", "Lcom/intellij/psi/PsiMethod;", "myRenderer", "Lcom/intellij/ide/util/PsiElementListCellRenderer;", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiMethod;Lcom/intellij/ide/util/PsiElementListCellRenderer;)V", "getCaption", "", "size", "", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, strings={"Lorg/jetbrains/kotlin/idea/highlighter/markers/OverridingMethodsUpdater;", "Lcom/intellij/codeInsight/navigation/ListBackgroundUpdaterTask;", "myMethod", "Lcom/intellij/psi/PsiMethod;", "myRenderer", "Lcom/intellij/ide/util/PsiElementListCellRenderer;", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiMethod;Lcom/intellij/ide/util/PsiElementListCellRenderer;)V", "getCaption", "", "size", "", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "idea"})
public final class OverridingMethodsUpdater
extends ListBackgroundUpdaterTask {
    private final PsiMethod myMethod;
    private final PsiElementListCellRenderer<? extends PsiElement> myRenderer;

    @NotNull
    public String getCaption(int size) {
        String string;
        if (this.myMethod.hasModifierProperty("abstract")) {
            string = DaemonBundle.message((String)"navigation.title.implementation.method", (Object[])new Object[]{this.myMethod.getName(), size});
            if (string == null) {
                Intrinsics.throwNpe();
            }
        } else {
            string = DaemonBundle.message((String)"navigation.title.overrider.method", (Object[])new Object[]{this.myMethod.getName(), size});
            if (string == null) {
                Intrinsics.throwNpe();
            }
        }
        return string;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        super.run(indicator);
        OverridingMethodsSearch.search((PsiMethod)this.myMethod, (boolean)true).forEach((Processor)new CommonProcessors.CollectProcessor<PsiMethod>(this, indicator){
            final /* synthetic */ OverridingMethodsUpdater this$0;
            final /* synthetic */ ProgressIndicator $indicator;

            public boolean process(@Nullable PsiMethod psiMethod) {
                if (!this.this$0.updateComponent((PsiElement)psiMethod, OverridingMethodsUpdater.access$getMyRenderer$p(this.this$0).getComparator())) {
                    this.$indicator.cancel();
                }
                this.$indicator.checkCanceled();
                return super.process((Object)psiMethod);
            }
            {
                this.this$0 = $outer;
                this.$indicator = $captured_local_variable$1;
            }
        });
    }

    public OverridingMethodsUpdater(@NotNull PsiMethod myMethod, @NotNull PsiElementListCellRenderer<? extends PsiElement> myRenderer) {
        Intrinsics.checkParameterIsNotNull((Object)myMethod, (String)"myMethod");
        Intrinsics.checkParameterIsNotNull(myRenderer, (String)"myRenderer");
        super(myMethod.getProject(), "Searching for overriding methods");
        this.myMethod = myMethod;
        this.myRenderer = myRenderer;
    }

    @NotNull
    public static final /* synthetic */ PsiElementListCellRenderer access$getMyRenderer$p(OverridingMethodsUpdater $this) {
        return $this.myRenderer;
    }
}

