/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u001a\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R%\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/OldStdlibApiFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "newElementCallback", "Lkotlin/Function2;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lcom/intellij/psi/PsiElement;", "(Lkotlin/jvm/functions/Function2;)V", "getNewElementCallback", "()Lkotlin/jvm/functions/Function2;", "applyFix", "", "project", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u001a\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R%\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, strings={"Lorg/jetbrains/kotlin/idea/inspections/OldStdlibApiFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "newElementCallback", "Lkotlin/Function2;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lcom/intellij/psi/PsiElement;", "(Lkotlin/jvm/functions/Function2;)V", "getNewElementCallback", "()Lkotlin/jvm/functions/Function2;", "applyFix", "", "project", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
public final class OldStdlibApiFix
implements LocalQuickFix {
    @NotNull
    private final Function2<Project, GlobalSearchScope, PsiElement> newElementCallback;

    @NotNull
    public String getName() {
        return "Replace with new qualified name";
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiJavaFile javaFile;
        Module scope2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        PsiElement element2 = descriptor2.getPsiElement();
        PsiReference psiReference = element2.getReference();
        if (psiReference == null) {
            return;
        }
        PsiReference reference2 = psiReference;
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element2);
        Module module2 = module;
        if (module2 == null || (module2 = module2.getModuleWithLibrariesScope()) == null) {
            module2 = SearchUtilKt.allScope(project);
        }
        Module module3 = scope2 = module2;
        Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"scope");
        PsiElement psiElement2 = (PsiElement)this.newElementCallback.invoke((Object)project, (Object)module3);
        if (psiElement2 == null) {
            return;
        }
        PsiElement newElement = psiElement2;
        PsiElement newReference = reference2.bindToElement(newElement);
        PsiFile psiFile = newReference.getContainingFile();
        if (!(psiFile instanceof PsiJavaFile)) {
            psiFile = null;
        }
        if ((javaFile = (PsiJavaFile)psiFile) != null) {
            JavaCodeStyleManager.getInstance((Project)project).removeRedundantImports(javaFile);
        }
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newReference);
    }

    @NotNull
    public final Function2<Project, GlobalSearchScope, PsiElement> getNewElementCallback() {
        return this.newElementCallback;
    }

    public OldStdlibApiFix(@NotNull Function2<? super Project, ? super GlobalSearchScope, ? extends PsiElement> newElementCallback) {
        Intrinsics.checkParameterIsNotNull(newElementCallback, (String)"newElementCallback");
        this.newElementCallback = newElementCallback;
    }
}

