/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/IntroduceBackingPropertyIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "Companion", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, strings={"Lorg/jetbrains/kotlin/idea/intentions/IntroduceBackingPropertyIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "Companion", "idea"})
public final class IntroduceBackingPropertyIntention
extends SelfTargetingIntention<KtProperty> {
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isApplicableTo(@NotNull KtProperty element2, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (!Companion.canIntroduceBackingProperty(element2)) {
            return false;
        }
        PsiElement psiElement2 = element2.getNameIdentifier();
        return Intrinsics.areEqual(psiElement2 != null && (psiElement2 = psiElement2.getTextRange()) != null ? Boolean.valueOf(psiElement2.containsOffset(caretOffset)) : null, (Object)true);
    }

    @Override
    public void applyTo(@NotNull KtProperty element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Companion.introduceBackingProperty(element2);
    }

    public IntroduceBackingPropertyIntention() {
        super(KtProperty.class, "Introduce backing property", null, 4, null);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\b*\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/IntroduceBackingPropertyIntention$Companion;", "", "()V", "canIntroduceBackingProperty", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "createBackingProperty", "", "createGetter", "element", "createSetter", "introduceBackingProperty", "replaceFieldReferences", "Lorg/jetbrains/kotlin/psi/KtElement;", "propertyName", "", "addAccessor", "newAccessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "idea"})
    @KotlinClass(version={1, 1, 0}, data={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\b*\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, strings={"Lorg/jetbrains/kotlin/idea/intentions/IntroduceBackingPropertyIntention$Companion;", "", "()V", "canIntroduceBackingProperty", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "createBackingProperty", "", "createGetter", "element", "createSetter", "introduceBackingProperty", "replaceFieldReferences", "Lorg/jetbrains/kotlin/psi/KtElement;", "propertyName", "", "addAccessor", "newAccessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "idea"})
    public static final class Companion {
        public final boolean canIntroduceBackingProperty(@NotNull KtProperty property2) {
            boolean bl;
            block6: {
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                String string = property2.getName();
                if (string == null) {
                    return false;
                }
                String name2 = string;
                BindingContext bindingContext2 = ResolutionUtils.getResolutionFacade(property2).analyzeFullyAndGetResult(CollectionsKt.listOf((Object)property2)).getBindingContext();
                DeclarationDescriptor declarationDescriptor = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, property2);
                if (!(declarationDescriptor instanceof PropertyDescriptor)) {
                    declarationDescriptor = null;
                }
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declarationDescriptor;
                if (propertyDescriptor == null) {
                    return false;
                }
                PropertyDescriptor descriptor2 = propertyDescriptor;
                if (Intrinsics.areEqual((Object)((Boolean)bindingContext2.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2)), (Object)false)) {
                    return false;
                }
                PsiElement psiElement2 = property2;
                KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClassOrObject.class, (boolean)true);
                if (ktClassOrObject == null) {
                    return false;
                }
                KtClassOrObject containingClass = ktClassOrObject;
                $receiver$iv = containingClass.getDeclarations();
                for (Object element$iv : $receiver$iv) {
                    KtDeclaration it = (KtDeclaration)element$iv;
                    if (!(it instanceof KtProperty && Intrinsics.areEqual((Object)((KtProperty)it).getName(), (Object)("_" + name2)))) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
            return bl;
        }

        public final void introduceBackingProperty(@NotNull KtProperty property2) {
            KtPropertyAccessor getter;
            Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
            this.createBackingProperty(property2);
            if (property2.getTypeReference() == null) {
                KotlinType type2 = SpecifyTypeExplicitlyIntention.Companion.getTypeForDeclaration(property2);
                SpecifyTypeExplicitlyIntention.Companion.addTypeAnnotation(null, property2, type2);
            }
            if ((getter = property2.getGetter()) == null) {
                this.createGetter(property2);
            } else {
                KtElement ktElement = getter;
                String string = property2.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property.name!!");
                this.replaceFieldReferences(ktElement, string);
            }
            if (property2.isVar()) {
                KtPropertyAccessor setter = property2.getSetter();
                if (setter == null) {
                    this.createSetter(property2);
                } else {
                    KtElement ktElement = setter;
                    String string = property2.getName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property.name!!");
                    this.replaceFieldReferences(ktElement, string);
                }
            }
            property2.setInitializer(null);
        }

        private final void createGetter(KtProperty element2) {
            KtPropertyAccessor newGetter;
            String body2 = "get() = _" + element2.getName();
            KtPropertyAccessor ktPropertyAccessor = KtPsiFactoryKt.KtPsiFactory(element2).createProperty("val x " + body2).getGetter();
            if (ktPropertyAccessor == null) {
                Intrinsics.throwNpe();
            }
            KtPropertyAccessor ktPropertyAccessor2 = newGetter = ktPropertyAccessor;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktPropertyAccessor2, (String)"newGetter");
            this.addAccessor(element2, ktPropertyAccessor2);
        }

        private final void createSetter(KtProperty element2) {
            KtPropertyAccessor newSetter;
            String body2 = "set(value) { _" + element2.getName() + " = value }";
            KtPropertyAccessor ktPropertyAccessor = KtPsiFactoryKt.KtPsiFactory(element2).createProperty("val x " + body2).getSetter();
            if (ktPropertyAccessor == null) {
                Intrinsics.throwNpe();
            }
            KtPropertyAccessor ktPropertyAccessor2 = newSetter = ktPropertyAccessor;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktPropertyAccessor2, (String)"newSetter");
            this.addAccessor(element2, ktPropertyAccessor2);
        }

        private final void addAccessor(KtProperty $receiver, KtPropertyAccessor newAccessor) {
            ASTNode semicolon = $receiver.getNode().findChildByType((IElementType)KtTokens.SEMICOLON);
            ASTNode aSTNode = semicolon;
            $receiver.addBefore(newAccessor, (PsiElement)(aSTNode != null ? aSTNode.getPsi() : null));
        }

        private final void createBackingProperty(KtProperty property2) {
            KtDeclaration backingProperty2 = CreateByPatternKt.buildDeclaration(KtPsiFactoryKt.KtPsiFactory(property2), (Function1<? super BuilderByPattern<KtDeclaration>, Unit>)((Function1)new Function1<BuilderByPattern<KtDeclaration>, Unit>(property2){
                final /* synthetic */ KtProperty $property;

                public final void invoke(BuilderByPattern<KtDeclaration> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    $receiver.appendFixedText("private ");
                    String string = this.$property.getValOrVarKeyword().getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property.valOrVarKeyword.text");
                    $receiver.appendFixedText(string);
                    $receiver.appendFixedText(" _" + this.$property.getName());
                    if (this.$property.getTypeReference() != null) {
                        $receiver.appendFixedText(": ");
                        $receiver.appendTypeReference(this.$property.getTypeReference());
                    }
                    if (this.$property.getInitializer() != null) {
                        $receiver.appendFixedText(" = ");
                        $receiver.appendExpression(this.$property.getInitializer());
                    }
                }
                {
                    this.$property = ktProperty;
                    super(1);
                }
            }));
            property2.getParent().addBefore((PsiElement)backingProperty2, (PsiElement)property2);
        }

        private final void replaceFieldReferences(KtElement element2, String propertyName) {
            element2.acceptChildren(new KtTreeVisitorVoid(element2, propertyName){
                final /* synthetic */ KtElement $element;
                final /* synthetic */ String $propertyName;

                public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    BindingContext bindingContext2 = ResolutionUtils.analyze$default(expression2, null, 1, null);
                    DeclarationDescriptor target = (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, expression2);
                    if (target instanceof SyntheticFieldDescriptor) {
                        expression2.replace((PsiElement)KtPsiFactoryKt.KtPsiFactory((PsiElement)this.$element).createSimpleName("_" + this.$propertyName));
                    }
                }

                public void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor) {
                    Intrinsics.checkParameterIsNotNull((Object)accessor, (String)"accessor");
                }
                {
                    this.$element = $captured_local_variable$0;
                    this.$propertyName = $captured_local_variable$1;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

