/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.framework.JsLibraryStdDetectionUtil;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryCoreUtil;
import org.jetbrains.kotlin.psi.KtFile;

public class ProjectStructureUtil {
    private static final Key<CachedValue<Boolean>> IS_KOTLIN_JS_MODULE = Key.create((String)"IS_KOTLIN_JS_MODULE");
    private static final Key<CachedValue<Boolean>> HAS_KOTLIN_JVM_MODULES = Key.create((String)"HAS_KOTLIN_JVM_MODULES");
    private static final Key<CachedValue<Boolean>> IS_DEPEND_ON_JVM_KOTLIN = Key.create((String)"KOTLIN_IS_DEPEND_ON_JVM_KOTLIN");

    private ProjectStructureUtil() {
    }

    public static boolean isJsKotlinModule(@NotNull KtFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/project/ProjectStructureUtil", "isJsKotlinModule"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return module != null && ProjectStructureUtil.isJsKotlinModule(module);
    }

    public static boolean isJavaKotlinModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/project/ProjectStructureUtil", "isJavaKotlinModule"));
        }
        GlobalSearchScope scope2 = module.getModuleWithDependenciesAndLibrariesScope(ProjectStructureUtil.hasKotlinFilesOnlyInTests(module));
        return KotlinRuntimeLibraryCoreUtil.getKotlinRuntimeMarkerClass(module.getProject(), scope2) != null;
    }

    public static boolean isJsKotlinModule(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/project/ProjectStructureUtil", "isJsKotlinModule"));
        }
        CachedValue result2 = (CachedValue)module.getUserData(IS_KOTLIN_JS_MODULE);
        if (result2 == null) {
            result2 = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Boolean>(){

                public CachedValueProvider.Result<Boolean> compute() {
                    return CachedValueProvider.Result.create((Object)(ProjectStructureUtil.getJSStandardLibrary(module) != null ? 1 : 0), (Object[])new Object[]{ProjectRootModificationTracker.getInstance((Project)module.getProject())});
                }
            }, false);
            module.putUserData(IS_KOTLIN_JS_MODULE, (Object)result2);
        }
        return (Boolean)result2.getValue();
    }

    public static boolean hasJvmKotlinModules(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/project/ProjectStructureUtil", "hasJvmKotlinModules"));
        }
        CachedValue result2 = (CachedValue)project.getUserData(HAS_KOTLIN_JVM_MODULES);
        if (result2 == null) {
            result2 = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<Boolean>(){

                public CachedValueProvider.Result<Boolean> compute() {
                    boolean hasJvmKotlinModules = false;
                    for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                        if (!ProjectStructureUtil.isJavaKotlinModule(module)) continue;
                        hasJvmKotlinModules = true;
                        break;
                    }
                    return CachedValueProvider.Result.create((Object)hasJvmKotlinModules, (Object[])new Object[]{ProjectRootModificationTracker.getInstance((Project)project)});
                }
            }, false);
            project.putUserData(HAS_KOTLIN_JVM_MODULES, (Object)result2);
        }
        return (Boolean)result2.getValue();
    }

    public static boolean isUsedInKotlinJavaModule(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/project/ProjectStructureUtil", "isUsedInKotlinJavaModule"));
        }
        CachedValue result2 = (CachedValue)module.getUserData(IS_DEPEND_ON_JVM_KOTLIN);
        if (result2 == null) {
            result2 = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Boolean>(){

                public CachedValueProvider.Result<Boolean> compute() {
                    boolean usedInKotlinModule = false;
                    HashSet dependentModules = new HashSet();
                    ModuleUtilCore.collectModulesDependsOn((Module)module, dependentModules);
                    for (Module module2 : dependentModules) {
                        if (!ProjectStructureUtil.isJavaKotlinModule(module2)) continue;
                        usedInKotlinModule = true;
                        break;
                    }
                    return CachedValueProvider.Result.create((Object)usedInKotlinModule, (Object[])new Object[]{ProjectRootModificationTracker.getInstance((Project)module.getProject())});
                }
            }, false);
            module.putUserData(IS_DEPEND_ON_JVM_KOTLIN, (Object)result2);
        }
        return (Boolean)result2.getValue();
    }

    @Nullable
    private static Library getJSStandardLibrary(final Module module) {
        return (Library)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Library>(){

            public Library compute() {
                final Ref jsLibrary = Ref.create();
                ModuleRootManager.getInstance((Module)module).orderEntries().librariesOnly().forEachLibrary((Processor)new Processor<Library>(){

                    public boolean process(Library library) {
                        if (JsLibraryStdDetectionUtil.hasJsStdlibJar(library)) {
                            jsLibrary.set((Object)library);
                            return false;
                        }
                        return true;
                    }
                });
                return (Library)jsLibrary.get();
            }
        });
    }

    public static boolean hasKotlinFilesInSources(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/project/ProjectStructureUtil", "hasKotlinFilesInSources"));
        }
        return FileTypeIndex.containsFileOfType((FileType)KotlinFileType.INSTANCE, (GlobalSearchScope)module.getModuleScope(false));
    }

    public static boolean hasKotlinFilesOnlyInTests(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/project/ProjectStructureUtil", "hasKotlinFilesOnlyInTests"));
        }
        return !ProjectStructureUtil.hasKotlinFilesInSources(module) && FileTypeIndex.containsFileOfType((FileType)KotlinFileType.INSTANCE, (GlobalSearchScope)module.getModuleScope(true));
    }
}

