/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddGenericUpperBoundFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "typeParameter", "upperBound", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtTypeParameter;Lorg/jetbrains/kotlin/types/KotlinType;)V", "renderedUpperBound", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Lcom/intellij/psi/PsiFile;", "Factory", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, strings={"Lorg/jetbrains/kotlin/idea/quickfix/AddGenericUpperBoundFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "typeParameter", "upperBound", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtTypeParameter;Lorg/jetbrains/kotlin/types/KotlinType;)V", "renderedUpperBound", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Lcom/intellij/psi/PsiFile;", "Factory", "idea"})
public final class AddGenericUpperBoundFix
extends KotlinQuickFixAction<KtTypeParameter> {
    private final String renderedUpperBound;
    public static final Factory Factory = new Factory(null);

    @NotNull
    public String getText() {
        return "Add '" + this.renderedUpperBound + "' as upper bound for " + ((KtTypeParameter)this.getElement()).getName();
    }

    @NotNull
    public String getFamilyName() {
        return "Add generic upper bound";
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!super.isAvailable(project, editor, file)) {
            return false;
        }
        return ((KtTypeParameter)this.getElement()).getName() != null && ((KtTypeParameter)this.getElement()).getExtendsBound() == null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        boolean bl = ((KtTypeParameter)this.getElement()).getExtendsBound() == null;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            void value$iv;
            if (value$iv == false) {
                String message$iv = "Don't know what to do with existing bounds";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        KtTypeReference typeReference = new KtPsiFactory(project).createType(this.renderedUpperBound);
        KtTypeReference ktTypeReference = ((KtTypeParameter)this.getElement()).setExtendsBound(typeReference);
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        KtTypeReference insertedTypeReference = ktTypeReference;
        KtElement ktElement = insertedTypeReference;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"insertedTypeReference");
        ShortenReferences.process$default(ShortenReferences.DEFAULT, ktElement, null, 2, null);
    }

    public AddGenericUpperBoundFix(@NotNull KtTypeParameter typeParameter, @NotNull KotlinType upperBound) {
        Intrinsics.checkParameterIsNotNull((Object)typeParameter, (String)"typeParameter");
        Intrinsics.checkParameterIsNotNull((Object)upperBound, (String)"upperBound");
        super((PsiElement)typeParameter);
        this.renderedUpperBound = IdeDescriptorRenderers.SOURCE_CODE.renderType(upperBound);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddGenericUpperBoundFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "argument", "Lorg/jetbrains/kotlin/types/KotlinType;", "upperBound", "createActionsByInferenceData", "", "inferenceData", "Lorg/jetbrains/kotlin/resolve/calls/inference/InferenceErrorData;", "doCreateActions", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, strings={"Lorg/jetbrains/kotlin/idea/quickfix/AddGenericUpperBoundFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "argument", "Lorg/jetbrains/kotlin/types/KotlinType;", "upperBound", "createActionsByInferenceData", "", "inferenceData", "Lorg/jetbrains/kotlin/resolve/calls/inference/InferenceErrorData;", "doCreateActions", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Factory
    extends KotlinIntentionActionsFactory {
        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            List<IntentionAction> list2;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            if (Intrinsics.areEqual(diagnosticFactory, Errors.UPPER_BOUND_VIOLATED)) {
                DiagnosticWithParameters2 upperBoundViolated = (DiagnosticWithParameters2)Errors.UPPER_BOUND_VIOLATED.cast(diagnostic);
                KotlinType kotlinType = (KotlinType)upperBoundViolated.getB();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"upperBoundViolated.b");
                KotlinType kotlinType2 = (KotlinType)upperBoundViolated.getA();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"upperBoundViolated.a");
                list2 = CollectionsKt.singletonOrEmptyList(this.createAction(kotlinType, kotlinType2));
            } else if (Intrinsics.areEqual(diagnosticFactory, Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED)) {
                InferenceErrorData inferenceData;
                InferenceErrorData inferenceErrorData = inferenceData = (InferenceErrorData)((DiagnosticWithParameters1)Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED.cast(diagnostic)).getA();
                Intrinsics.checkExpressionValueIsNotNull((Object)inferenceErrorData, (String)"inferenceData");
                list2 = this.createActionsByInferenceData(inferenceErrorData);
            } else {
                list2 = kotlin.collections.CollectionsKt.emptyList();
            }
            return list2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<IntentionAction> createActionsByInferenceData(InferenceErrorData inferenceData) {
            void destination$iv$iv;
            void $receiver$iv$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            ConstraintSystem successfulConstraintSystem = ConstraintSystemUtilsKt.filterConstraintsOut(inferenceData.constraintSystem, ConstraintPositionKind.TYPE_BOUND_POSITION);
            if (!successfulConstraintSystem.getStatus().isSuccessful()) {
                return kotlin.collections.CollectionsKt.emptyList();
            }
            TypeSubstitutor resultingSubstitutor2 = successfulConstraintSystem.getResultingSubstitutor();
            Iterable iterable = inferenceData.descriptor.getTypeParameters();
            void var5_5 = $receiver$iv;
            Collection collection = new ArrayList();
            void var7_7 = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                Boolean bl;
                IntentionAction intentionAction;
                Object element$iv$iv = element$iv$iv$iv;
                TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)element$iv$iv;
                if (ConstraintsUtil.checkUpperBoundIsSatisfied(successfulConstraintSystem, typeParameterDescriptor, inferenceData.call, true)) {
                    intentionAction = null;
                } else if ((KotlinType)kotlin.collections.CollectionsKt.singleOrNull(typeParameterDescriptor.getUpperBounds()) == null) {
                    intentionAction = null;
                } else if (resultingSubstitutor2.substitute(typeParameterDescriptor.getDefaultType(), Variance.INVARIANT) == null) {
                    intentionAction = null;
                } else {
                    KotlinType upperBound;
                    KotlinType argument2;
                    KotlinType kotlinType = argument2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"argument");
                    intentionAction = Factory.createAction(kotlinType, upperBound);
                }
                if (intentionAction != null) {
                    void $receiver$iv$iv$iv2;
                    IntentionAction intentionAction2 = intentionAction;
                    void it$iv$iv = $receiver$iv$iv$iv2;
                    bl = destination$iv$iv.add(it$iv$iv);
                    continue;
                }
                bl = null;
            }
            return (List)destination$iv$iv;
        }

        private final IntentionAction createAction(KotlinType argument2, KotlinType upperBound) {
            if (!upperBound.getConstructor().isDenotable()) {
                return null;
            }
            ClassifierDescriptor classifierDescriptor = argument2.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
                classifierDescriptor = null;
            }
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
            if (typeParameterDescriptor == null) {
                return null;
            }
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            PsiElement psiElement2 = DescriptorToSourceUtils.getSourceFromDescriptor(typeParameterDescriptor2);
            if (!(psiElement2 instanceof KtTypeParameter)) {
                psiElement2 = null;
            }
            KtTypeParameter ktTypeParameter = (KtTypeParameter)psiElement2;
            if (ktTypeParameter == null) {
                return null;
            }
            KtTypeParameter typeParameterDeclaration = ktTypeParameter;
            return new AddGenericUpperBoundFix(typeParameterDeclaration, upperBound);
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

