/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0015\u0016B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "element", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Lcom/intellij/psi/PsiFile;", "Companion", "MakeClassOpenFactory", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0015\u0016B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, strings={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "element", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Lcom/intellij/psi/PsiFile;", "Companion", "MakeClassOpenFactory", "idea"})
public class AddModifierFix
extends KotlinQuickFixAction<KtModifierListOwner> {
    private final KtModifierKeywordToken modifier;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        if (Intrinsics.areEqual((Object)((Object)this.modifier), (Object)((Object)KtTokens.ABSTRACT_KEYWORD)) || Intrinsics.areEqual((Object)((Object)this.modifier), (Object)((Object)KtTokens.OPEN_KEYWORD))) {
            return "Make " + Companion.getElementName((KtModifierListOwner)this.getElement()) + " " + this.modifier.getValue();
        }
        return "Add '" + this.modifier.getValue() + "' modifier";
    }

    @NotNull
    public String getFamilyName() {
        return "Add modifier";
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ((KtModifierListOwner)this.getElement()).addModifier(this.modifier);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return super.isAvailable(project, editor, file) && JetRefactoringUtilKt.canRefactor(this.getElement());
    }

    public AddModifierFix(@NotNull KtModifierListOwner element2, @NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)((Object)modifier), (String)"modifier");
        super((PsiElement)element2);
        this.modifier = modifier;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix$MakeClassOpenFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, strings={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix$MakeClassOpenFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class MakeClassOpenFactory
    extends KotlinSingleIntentionActionFactory {
        public static final MakeClassOpenFactory INSTANCE;

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
            }
            KtTypeReference typeReference = (KtTypeReference)psiElement2;
            BindingContext bindingContext2 = ResolutionUtils.analyze(typeReference, BodyResolveMode.PARTIAL);
            KotlinType kotlinType = (KotlinType)bindingContext2.get(BindingContext.TYPE, typeReference);
            if (kotlinType == null) {
                return null;
            }
            KotlinType type2 = kotlinType;
            ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
            if (classDescriptor == null) {
                return null;
            }
            ClassDescriptor classDescriptor2 = classDescriptor;
            PsiElement psiElement3 = DescriptorToSourceUtils.descriptorToDeclaration(classDescriptor2);
            if (!(psiElement3 instanceof KtClass)) {
                psiElement3 = null;
            }
            KtClass ktClass = (KtClass)psiElement3;
            if (ktClass == null) {
                return null;
            }
            KtClass declaration = ktClass;
            if (!JetRefactoringUtilKt.canRefactor(declaration)) {
                return null;
            }
            if (declaration.isEnum()) {
                return null;
            }
            KtModifierListOwner ktModifierListOwner = declaration;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.OPEN_KEYWORD");
            return new AddModifierFix(ktModifierListOwner, ktModifierKeywordToken);
        }

        private MakeClassOpenFactory() {
            INSTANCE = this;
        }

        static {
            new MakeClassOpenFactory();
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J&\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix$Companion;", "", "()V", "createFactory", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "T", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "modifierOwnerClass", "Ljava/lang/Class;", "getElementName", "", "modifierListOwner", "idea"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J&\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0007*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b\u00a8\u0006\u000e"}, strings={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix$Companion;", "", "()V", "createFactory", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "T", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "modifierOwnerClass", "Ljava/lang/Class;", "getElementName", "", "modifierListOwner", "idea"})
    public static final class Companion {
        @NotNull
        public final String getElementName(@NotNull KtModifierListOwner modifierListOwner) {
            Intrinsics.checkParameterIsNotNull((Object)modifierListOwner, (String)"modifierListOwner");
            String name2 = null;
            if (modifierListOwner instanceof PsiNameIdentifierOwner) {
                PsiElement nameIdentifier = ((PsiNameIdentifierOwner)modifierListOwner).getNameIdentifier();
                if (nameIdentifier != null) {
                    name2 = nameIdentifier.getText();
                }
            } else if (modifierListOwner instanceof KtPropertyAccessor) {
                name2 = ((KtPropertyAccessor)modifierListOwner).getNamePlaceholder().getText();
            }
            if (name2 == null) {
                name2 = modifierListOwner.getText();
            }
            return "'" + name2 + "'";
        }

        @NotNull
        public final KotlinSingleIntentionActionFactory createFactory(@NotNull KtModifierKeywordToken modifier) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)modifier), (String)"modifier");
            return this.createFactory(modifier, KtModifierListOwner.class);
        }

        @NotNull
        public final <T extends KtModifierListOwner> KotlinSingleIntentionActionFactory createFactory(@NotNull KtModifierKeywordToken modifier, @NotNull Class<T> modifierOwnerClass) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)modifier), (String)"modifier");
            Intrinsics.checkParameterIsNotNull(modifierOwnerClass, (String)"modifierOwnerClass");
            return new KotlinSingleIntentionActionFactory(modifierOwnerClass, modifier){
                final /* synthetic */ Class $modifierOwnerClass;
                final /* synthetic */ KtModifierKeywordToken $modifier;

                @Nullable
                public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                    Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                    KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)QuickFixUtil.getParentElementOfType(diagnostic, this.$modifierOwnerClass);
                    if (ktModifierListOwner == null) {
                        return null;
                    }
                    KtModifierListOwner modifierListOwner = ktModifierListOwner;
                    if (Intrinsics.areEqual((Object)((Object)this.$modifier), (Object)((Object)KtTokens.ABSTRACT_KEYWORD)) && modifierListOwner instanceof KtObjectDeclaration) {
                        return null;
                    }
                    KtModifierListOwner ktModifierListOwner2 = modifierListOwner;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktModifierListOwner2, (String)"modifierListOwner");
                    return new AddModifierFix(ktModifierListOwner2, this.$modifier);
                }
                {
                    this.$modifierOwnerClass = $captured_local_variable$0;
                    this.$modifier = $captured_local_variable$1;
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

