/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactoryWithDelegate;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0015\u0016\u0017B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Lcom/intellij/psi/PsiFile;", "Factory", "GenericVarianceConversion", "SmartCastImpossibleFactory", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0015\u0016\u0017B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, strings={"Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Lcom/intellij/psi/PsiFile;", "Factory", "GenericVarianceConversion", "SmartCastImpossibleFactory", "idea"})
public final class CastExpressionFix
extends KotlinQuickFixAction<KtExpression> {
    private final KotlinType type;

    @NotNull
    public String getFamilyName() {
        return "Cast expression";
    }

    @NotNull
    public String getText() {
        return "Cast expression '" + ((KtExpression)this.getElement()).getText() + "' to '" + IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType(this.type) + "'";
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        KotlinType expressionType;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!super.isAvailable(project, editor, file)) {
            return false;
        }
        KotlinType kotlinType = ResolutionUtils.analyze((KtElement)this.getElement(), BodyResolveMode.PARTIAL).getType((KtExpression)this.getElement());
        if (kotlinType == null) {
            return false;
        }
        KotlinType kotlinType2 = expressionType = kotlinType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"expressionType");
        return TypeUtilsKt.isSubtypeOf(this.type, kotlinType2) || TypeUtilsKt.isSubtypeOf(expressionType, this.type);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Unit unit;
        Object object;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String renderedType = IdeDescriptorRenderers.SOURCE_CODE.renderType(this.type);
        KtExpression expressionToInsert = CreateByPatternKt.createExpressionByPattern(KtPsiFactoryKt.KtPsiFactory((PsiElement)file), "$0 as $1", this.getElement(), renderedType);
        Object t = this.getElement();
        PsiElement result$iv = $receiver$iv.replace((PsiElement)expressionToInsert);
        if (result$iv instanceof KtExpression) {
            object = result$iv;
        } else {
            PsiElement psiElement2 = result$iv;
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression = ((KtParenthesizedExpression)psiElement2).getExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            object = ktExpression;
        }
        KtExpression newExpression2 = (KtExpression)object;
        KtExpression ktExpression = KtPsiUtil.safeDeparenthesize(newExpression2);
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS");
        }
        KtTypeReference ktTypeReference = ((KtBinaryExpressionWithTypeRHS)ktExpression).getRight();
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        KtElement ktElement = ktTypeReference;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"(KtPsiUtil.safeDeparenth\u2026ssionWithTypeRHS).right!!");
        ShortenReferences.process$default(ShortenReferences.DEFAULT, ktElement, null, 2, null);
        Editor editor2 = editor;
        if (editor2 != null && (editor2 = editor2.getCaretModel()) != null) {
            editor2.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)newExpression2));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    public CastExpressionFix(@NotNull KtExpression element2, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        super((PsiElement)element2);
        this.type = type2;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactoryWithDelegate;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/types/KotlinType;", "()V", "createFix", "Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix;", "originalElement", "data", "getElementOfInterest", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, strings={"Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactoryWithDelegate;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/types/KotlinType;", "()V", "createFix", "Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix;", "originalElement", "data", "getElementOfInterest", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static abstract class Factory
    extends KotlinSingleIntentionActionFactoryWithDelegate<KtExpression, KotlinType> {
        @Override
        @Nullable
        protected KtExpression getElementOfInterest(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtExpression)) {
                psiElement2 = null;
            }
            return (KtExpression)psiElement2;
        }

        @NotNull
        protected CastExpressionFix createFix(@NotNull KtExpression originalElement, @NotNull KotlinType data) {
            Intrinsics.checkParameterIsNotNull((Object)originalElement, (String)"originalElement");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return new CastExpressionFix(originalElement, data);
        }

        public Factory() {
            super(null, 1, null);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$SmartCastImpossibleFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$Factory;", "()V", "extractFixData", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin.jvm.PlatformType", "element", "Lorg/jetbrains/kotlin/psi/KtExpression;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, strings={"Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$SmartCastImpossibleFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$Factory;", "()V", "extractFixData", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin.jvm.PlatformType", "element", "Lorg/jetbrains/kotlin/psi/KtExpression;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class SmartCastImpossibleFactory
    extends Factory {
        public static final SmartCastImpossibleFactory INSTANCE;

        @Override
        @NotNull
        protected KotlinType extractFixData(@NotNull KtExpression element2, @NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            return (KotlinType)((DiagnosticWithParameters3)Errors.SMARTCAST_IMPOSSIBLE.cast(diagnostic)).getA();
        }

        private SmartCastImpossibleFactory() {
            INSTANCE = this;
        }

        static {
            new SmartCastImpossibleFactory();
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$GenericVarianceConversion;", "Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$Factory;", "()V", "extractFixData", "Lorg/jetbrains/kotlin/types/KotlinType;", "element", "Lorg/jetbrains/kotlin/psi/KtExpression;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, strings={"Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$GenericVarianceConversion;", "Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$Factory;", "()V", "extractFixData", "Lorg/jetbrains/kotlin/types/KotlinType;", "element", "Lorg/jetbrains/kotlin/psi/KtExpression;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class GenericVarianceConversion
    extends Factory {
        public static final GenericVarianceConversion INSTANCE;

        @Override
        @Nullable
        protected KotlinType extractFixData(@NotNull KtExpression element2, @NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            return FlexibleTypesKt.flexibility((KotlinType)((DiagnosticWithParameters2)ErrorsJvm.JAVA_TYPE_MISMATCH.cast(diagnostic)).getB()).getUpperBound();
        }

        private GenericVarianceConversion() {
            INSTANCE = this;
        }

        static {
            new GenericVarianceConversion();
        }
    }
}

