/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveTopLevelDeclarations;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.quickfix.GenerateUtilKt;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveTopLevelDeclarations.KotlinMoveTargetForDeferredFile;
import org.jetbrains.kotlin.idea.refactoring.move.moveTopLevelDeclarations.MoveKotlinTopLevelDeclarationsOptions;
import org.jetbrains.kotlin.idea.refactoring.move.moveTopLevelDeclarations.MoveKotlinTopLevelDeclarationsProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveTopLevelDeclarations.ui.MoveKotlinTopLevelDeclarationsDialog;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveTopLevelDeclarations/MoveDeclarationToSeparateFileIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, strings={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveTopLevelDeclarations/MoveDeclarationToSeparateFileIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea"})
public final class MoveDeclarationToSeparateFileIntention
extends SelfTargetingRangeIntention<KtClassOrObject>
implements LowPriorityAction {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtClassOrObject element2) {
        PsiElement keyword;
        PsiElement psiElement2;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (element2.getName() == null) {
            return null;
        }
        if (!(element2.getParent() instanceof KtFile)) {
            return null;
        }
        if (element2.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            return null;
        }
        if (element2.getContainingKtFile().getDeclarations().size() == 1) {
            return null;
        }
        KtClassOrObject ktClassOrObject = element2;
        if (ktClassOrObject instanceof KtClass) {
            psiElement2 = ((KtClass)element2).getClassOrInterfaceKeyword();
        } else if (ktClassOrObject instanceof KtObjectDeclaration) {
            psiElement2 = ((KtObjectDeclaration)element2).getObjectKeyword();
        } else {
            return null;
        }
        PsiElement psiElement3 = keyword = psiElement2;
        if (psiElement3 == null) {
            return null;
        }
        int startOffset = PsiUtilsKt.getStartOffset(psiElement3);
        PsiElement psiElement4 = element2.getNameIdentifier();
        if (psiElement4 == null) {
            return null;
        }
        int endOffset = PsiUtilsKt.getEndOffset(psiElement4);
        this.setText("Move '" + element2.getName() + "' to separate file");
        return new TextRange(startOffset, endOffset);
    }

    @Override
    public void applyTo(@NotNull KtClassOrObject element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (editor == null) {
            throw (Throwable)new IllegalArgumentException("This intention requires an editor");
        }
        KtFile file = element2.getContainingKtFile();
        Project project = file.getProject();
        int originalOffset = editor.getCaretModel().getOffset() - PsiUtilsKt.getStartOffset(element2);
        PsiDirectory psiDirectory = file.getContainingDirectory();
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory directory = psiDirectory;
        FqName packageName = file.getPackageFqName();
        String targetFileName = element2.getName() + ".kt";
        PsiFile targetFile = directory.findFile(targetFileName);
        if (targetFile != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw (Throwable)new CommonRefactoringUtil.RefactoringErrorHintException("File " + targetFileName + " already exists");
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(project, element2, packageName, directory, targetFile){
                final /* synthetic */ Project $project;
                final /* synthetic */ KtClassOrObject $element;
                final /* synthetic */ FqName $packageName;
                final /* synthetic */ PsiDirectory $directory;
                final /* synthetic */ PsiFile $targetFile;

                public final void run() {
                    Set set = SetsKt.setOf((Object)this.$element);
                    String string = this.$packageName.asString();
                    PsiFile psiFile = this.$targetFile;
                    if (!(psiFile instanceof KtFile)) {
                        psiFile = null;
                    }
                    new MoveKotlinTopLevelDeclarationsDialog(this.$project, set, string, this.$directory, (KtFile)psiFile, true, true, true, null).show();
                }
                {
                    this.$project = project;
                    this.$element = ktClassOrObject;
                    this.$packageName = fqName2;
                    this.$directory = psiDirectory;
                    this.$targetFile = psiFile;
                }
            });
            return;
        }
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        FqName fqName2 = packageName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageName");
        KotlinMoveTargetForDeferredFile moveTarget2 = new KotlinMoveTargetForDeferredFile(project2, fqName2, (Function1<? super KtFile, ? extends KtFile>)((Function1)new Function1<KtFile, KtFile>(targetFileName, directory, packageName){
            final /* synthetic */ String $targetFileName;
            final /* synthetic */ PsiDirectory $directory;
            final /* synthetic */ FqName $packageName;

            @NotNull
            public final KtFile invoke(@NotNull KtFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                PsiDirectory psiDirectory = this.$directory;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory, (String)"directory");
                return JetRefactoringUtilKt.createKotlinFile(this.$targetFileName, psiDirectory, this.$packageName.asString());
            }
            {
                this.$targetFileName = string;
                this.$directory = psiDirectory;
                this.$packageName = fqName2;
                super(1);
            }
        }));
        MoveKotlinTopLevelDeclarationsOptions moveOptions2 = new MoveKotlinTopLevelDeclarationsOptions(CollectionsKt.listOf((Object)element2), moveTarget2, false, false, true, false, new MoveCallback(directory, targetFileName, project, originalOffset){
            final /* synthetic */ PsiDirectory $directory;
            final /* synthetic */ String $targetFileName;
            final /* synthetic */ Project $project;
            final /* synthetic */ int $originalOffset;

            public final void refactoringCompleted() {
                Unit unit;
                PsiFile psiFile = this.$directory.findFile(this.$targetFileName);
                if (psiFile == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                }
                KtFile newFile = (KtFile)psiFile;
                KtDeclaration newDeclaration = (KtDeclaration)CollectionsKt.first(newFile.getDeclarations());
                NavigationUtil.activateFileWithPsiElement((PsiElement)((PsiElement)newFile));
                Editor editor = FileEditorManager.getInstance((Project)this.$project).getSelectedTextEditor();
                if (editor != null) {
                    GenerateUtilKt.moveCaret$default(editor, PsiUtilsKt.getStartOffset(newDeclaration) + this.$originalOffset, null, 2, null);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            {
                this.$directory = psiDirectory;
                this.$targetFileName = string;
                this.$project = project;
                this.$originalOffset = n;
            }
        }, 32, null);
        Project project3 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        new MoveKotlinTopLevelDeclarationsProcessor(project3, moveOptions2, null, 4, null).run();
    }

    public MoveDeclarationToSeparateFileIntention() {
        super(KtClassOrObject.class, "Move declaration to separate file", null, 4, null);
    }
}

