/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtLightClass;
import org.jetbrains.kotlin.asJava.KtLightClassForExplicitDeclaration;
import org.jetbrains.kotlin.asJava.KtLightClassForFacade;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameKotlinPsiProcessor;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\f\u0010\u0016\u001a\u00020\u0004*\u00020\tH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinClassProcessor;", "Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinPsiProcessor;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "findReferences", "", "Lcom/intellij/psi/PsiReference;", "getKtClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "showErrors", "editor", "Lcom/intellij/openapi/editor/Editor;", "prepareRenaming", "", "newName", "", "allRenames", "", "substituteElementToRename", "isCompanionObjectClassReference", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\f\u0010\u0016\u001a\u00020\u0004*\u00020\tH\u0002\u00a8\u0006\u0017"}, strings={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinClassProcessor;", "Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinPsiProcessor;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "findReferences", "", "Lcom/intellij/psi/PsiReference;", "getKtClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "showErrors", "editor", "Lcom/intellij/openapi/editor/Editor;", "prepareRenaming", "", "newName", "", "allRenames", "", "substituteElementToRename", "isCompanionObjectClassReference", "idea"})
public final class RenameKotlinClassProcessor
extends RenameKotlinPsiProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return element2 instanceof KtClassOrObject || element2 instanceof KtLightClass || element2 instanceof KtConstructor;
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return this.getKtClassOrObject(element2, true, editor);
    }

    public void prepareRenaming(@NotNull PsiElement element2, @NotNull String newName2, @NotNull Map<PsiElement, String> allRenames) {
        String nameWithoutExtensions;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)newName2, (String)"newName");
        Intrinsics.checkParameterIsNotNull(allRenames, (String)"allRenames");
        KtClassOrObject ktClassOrObject = this.getKtClassOrObject(element2, false, null);
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject classOrObject = ktClassOrObject;
        KtFile file = classOrObject.getContainingKtFile();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && Intrinsics.areEqual((Object)(nameWithoutExtensions = virtualFile.getNameWithoutExtension()), (Object)classOrObject.getName())) {
            KtFile ktFile = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"file");
            allRenames.put((PsiElement)ktFile, newName2 + "." + virtualFile.getExtension());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (element2 instanceof KtObjectDeclaration && ((KtObjectDeclaration)element2).isCompanion()) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv = super.findReferences(element2);
            Iterable iterable = $receiver$iv;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                PsiReference it = (PsiReference)element$iv$iv;
                if (!(!this.isCompanionObjectClassReference(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        Collection collection = super.findReferences(element2);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"super.findReferences(element)");
        return collection;
    }

    private final boolean isCompanionObjectClassReference(PsiReference $receiver) {
        if (!($receiver instanceof KtSimpleNameReference)) {
            return false;
        }
        BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)((KtSimpleNameReference)$receiver).getElement(), BodyResolveMode.PARTIAL);
        return bindingContext2.get(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, ((KtSimpleNameReference)$receiver).getElement()) != null;
    }

    /*
     * WARNING - void declaration
     */
    private final KtClassOrObject getKtClassOrObject(PsiElement element2, boolean showErrors, Editor editor) {
        KtClassOrObject ktClassOrObject;
        PsiElement psiElement2 = element2;
        if (psiElement2 instanceof KtLightClass) {
            if (element2 instanceof KtLightClassForExplicitDeclaration) {
                ktClassOrObject = ((KtLightClassForExplicitDeclaration)element2).getOrigin();
            } else {
                Object v1;
                if (element2 instanceof KtLightClassForFacade) {
                    if (showErrors) {
                        CommonRefactoringUtil.showErrorHint((Project)((KtLightClassForFacade)element2).getProject(), (Editor)editor, (String)KotlinBundle.message("rename.kotlin.package.class.error", new Object[0]), (String)RefactoringBundle.message((String)"rename.title"), (String)null);
                    }
                    v1 = null;
                } else {
                    Unit unit;
                    boolean bl = false;
                    if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                        void value$iv;
                        if (value$iv == false) {
                            String message$iv = "Should not be suggested to rename element of type " + ((KtLightClass)element2).getClass() + " " + element2;
                            throw (Throwable)((Object)new AssertionError((Object)message$iv));
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = Unit.INSTANCE;
                    }
                    v1 = null;
                }
                ktClassOrObject = v1;
            }
        } else if (psiElement2 instanceof KtConstructor) {
            ktClassOrObject = ((KtConstructor)element2).getContainingClassOrObject();
        } else {
            PsiElement psiElement3 = element2;
            if (!(psiElement3 instanceof KtClassOrObject)) {
                psiElement3 = null;
            }
            ktClassOrObject = (KtClassOrObject)psiElement3;
        }
        return ktClassOrObject;
    }
}

