/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.NotNullFunction;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.run.JetRunConfiguration;
import org.jetbrains.kotlin.idea.run.JetRunConfigurationType;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinRunConfigurationProducer;", "Lcom/intellij/execution/actions/RunConfigurationProducer;", "Lorg/jetbrains/kotlin/idea/run/JetRunConfiguration;", "()V", "getEntryPointContainer", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "location", "Lcom/intellij/execution/Location;", "isConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "setupConfigurationByQName", "", "module", "Lcom/intellij/openapi/module/Module;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "Companion", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014\u00a8\u0006\u0018"}, strings={"Lorg/jetbrains/kotlin/idea/run/KotlinRunConfigurationProducer;", "Lcom/intellij/execution/actions/RunConfigurationProducer;", "Lorg/jetbrains/kotlin/idea/run/JetRunConfiguration;", "()V", "getEntryPointContainer", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "location", "Lcom/intellij/execution/Location;", "isConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "setupConfigurationByQName", "", "module", "Lcom/intellij/openapi/module/Module;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "Companion", "idea"})
public final class KotlinRunConfigurationProducer
extends RunConfigurationProducer<JetRunConfiguration> {
    public static final Companion Companion = new Companion(null);

    protected boolean setupConfigurationFromContext(@NotNull JetRunConfiguration configuration2, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)configuration2), (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(sourceElement, (String)"sourceElement");
        Location location2 = context.getLocation();
        if (location2 == null) {
            return false;
        }
        Location location3 = location2;
        Module module = location3.getModule();
        if (module == null) {
            return false;
        }
        Module module2 = module;
        KtDeclarationContainer container2 = this.getEntryPointContainer(location3);
        FqName fqName2 = Companion.getStartClassFqName(container2);
        if (fqName2 == null) {
            return false;
        }
        FqName startClassFQName = fqName2;
        Module module3 = module2;
        Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"module");
        this.setupConfigurationByQName(module3, configuration2, startClassFQName);
        return true;
    }

    private final KtDeclarationContainer getEntryPointContainer(Location<?> location2) {
        PsiElement locationElement;
        if (location2 == null) {
            return null;
        }
        if (DumbService.getInstance((Project)location2.getProject()).isDumb()) {
            return null;
        }
        Module module = location2.getModule();
        if (module == null) {
            return null;
        }
        Module module2 = module;
        if (ProjectStructureUtil.isJsKotlinModule(module2)) {
            return null;
        }
        PsiElement psiElement2 = locationElement = location2.getPsiElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"locationElement");
        return Companion.getEntryPointContainer(psiElement2);
    }

    private final void setupConfigurationByQName(Module module, JetRunConfiguration configuration2, FqName fqName2) {
        configuration2.setModule(module);
        configuration2.setRunClass(fqName2.asString());
        configuration2.setGeneratedName();
    }

    public boolean isConfigurationFromContext(@NotNull JetRunConfiguration configuration2, @NotNull ConfigurationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)configuration2), (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        FqName fqName2 = Companion.getStartClassFqName(this.getEntryPointContainer(context.getLocation()));
        if (fqName2 == null) {
            return false;
        }
        FqName startClassFQName = fqName2;
        return Intrinsics.areEqual((Object)configuration2.getRunClass(), (Object)startClassFQName.asString()) && Intrinsics.areEqual((Object)context.getModule(), (Object)configuration2.getConfigurationModule().getModule());
    }

    public KotlinRunConfigurationProducer() {
        super((ConfigurationType)JetRunConfigurationType.getInstance());
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0004J\u0016\u0010\n\u001a\u0004\u0018\u00010\u0004*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinRunConfigurationProducer$Companion;", "", "()V", "getEntryPointContainer", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "locationElement", "Lcom/intellij/psi/PsiElement;", "getStartClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "container", "declarationContainer", "strict", "", "idea"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0004J\u0016\u0010\n\u001a\u0004\u0018\u00010\u0004*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, strings={"Lorg/jetbrains/kotlin/idea/run/KotlinRunConfigurationProducer$Companion;", "", "()V", "getEntryPointContainer", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "locationElement", "Lcom/intellij/psi/PsiElement;", "getStartClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "container", "declarationContainer", "strict", "", "idea"})
    public static final class Companion {
        @Nullable
        public final KtDeclarationContainer getEntryPointContainer(@NotNull PsiElement locationElement) {
            Intrinsics.checkParameterIsNotNull((Object)locationElement, (String)"locationElement");
            PsiFile psiFile = locationElement.getContainingFile();
            if (!(psiFile instanceof KtFile) || !ProjectRootsUtil.isInProjectOrLibSource((PsiElement)psiFile)) {
                return null;
            }
            ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade((KtElement)psiFile);
            MainFunctionDetector mainFunctionDetector2 = new MainFunctionDetector((NotNullFunction<KtNamedFunction, FunctionDescriptor>)((NotNullFunction)new NotNullFunction<KtNamedFunction, FunctionDescriptor>(resolutionFacade){
                final /* synthetic */ ResolutionFacade $resolutionFacade;

                @NotNull
                public final FunctionDescriptor fun(KtNamedFunction it) {
                    KtDeclaration ktDeclaration = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktDeclaration, (String)"it");
                    DeclarationDescriptor declarationDescriptor = this.$resolutionFacade.resolveToDescriptor(ktDeclaration);
                    if (declarationDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                    }
                    return (FunctionDescriptor)declarationDescriptor;
                }
                {
                    this.$resolutionFacade = resolutionFacade;
                }
            }));
            KtDeclarationContainer currentElement = this.declarationContainer(locationElement, false);
            while (currentElement != null) {
                KtDeclarationContainer entryPointContainer = currentElement;
                if (entryPointContainer instanceof KtClass) {
                    entryPointContainer = (KtDeclarationContainer)CollectionsKt.singleOrNull(((KtClass)entryPointContainer).getCompanionObjects());
                }
                if (entryPointContainer != null && mainFunctionDetector2.hasMain(entryPointContainer.getDeclarations())) {
                    return entryPointContainer;
                }
                KtDeclarationContainer ktDeclarationContainer = currentElement;
                if (ktDeclarationContainer == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
                }
                currentElement = this.declarationContainer((PsiElement)ktDeclarationContainer, true);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final FqName getStartClassFqName(@Nullable KtDeclarationContainer container2) {
            FqName fqName2;
            KtDeclarationContainer ktDeclarationContainer = container2;
            if (Intrinsics.areEqual((Object)ktDeclarationContainer, null)) {
                fqName2 = null;
            } else if (ktDeclarationContainer instanceof KtFile) {
                fqName2 = JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)container2);
            } else if (ktDeclarationContainer instanceof KtClassOrObject) {
                if (container2 instanceof KtObjectDeclaration && ((KtObjectDeclaration)container2).isCompanion()) {
                    void strict$iv;
                    void $receiver$iv;
                    KtClass containerClass;
                    PsiElement psiElement2 = (PsiElement)container2;
                    boolean bl = true;
                    KtClass ktClass = containerClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClass.class, (boolean)strict$iv);
                    fqName2 = ktClass != null ? ktClass.getFqName() : null;
                } else {
                    fqName2 = ((KtClassOrObject)container2).getFqName();
                }
            } else {
                KtDeclarationContainer ktDeclarationContainer2 = container2;
                if (ktDeclarationContainer2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
                }
                throw (Throwable)new IllegalArgumentException("Invalid entry-point container: " + ((PsiElement)ktDeclarationContainer2).getText());
            }
            return fqName2;
        }

        private final KtDeclarationContainer declarationContainer(PsiElement $receiver, boolean strict) {
            PsiElement element2 = strict ? PsiTreeUtil.getParentOfType((PsiElement)$receiver, (Class[])new Class[]{KtClassOrObject.class, KtFile.class}) : PsiTreeUtil.getNonStrictParentOfType((PsiElement)$receiver, (Class[])new Class[]{KtClassOrObject.class, KtFile.class});
            return (KtDeclarationContainer)element2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

