/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.versions.KotlinJavaScriptAbiVersionIndex;
import org.jetbrains.kotlin.idea.versions.KotlinMetadataVersionIndex;
import org.jetbrains.kotlin.idea.versions.KotlinUpdatePluginComponentKt;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinClassFileIndex;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinJavaScriptMetaFileIndex;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinModuleMappingIndex;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/versions/KotlinUpdatePluginComponent;", "Lcom/intellij/openapi/components/ApplicationComponent;", "()V", "disposeComponent", "", "getComponentName", "", "initComponent", "requestFullJarUpdate", "jarFilePath", "Ljava/io/File;", "idea"})
@KotlinClass(version={1, 1, 0}, data={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, strings={"Lorg/jetbrains/kotlin/idea/versions/KotlinUpdatePluginComponent;", "Lcom/intellij/openapi/components/ApplicationComponent;", "()V", "disposeComponent", "", "getComponentName", "", "initComponent", "requestFullJarUpdate", "jarFilePath", "Ljava/io/File;", "idea"})
public final class KotlinUpdatePluginComponent
implements ApplicationComponent {
    public void initComponent() {
        String installedKotlinVersion;
        Application application = ApplicationManager.getApplication();
        if (Intrinsics.areEqual((Object)(application != null ? Boolean.valueOf(application.isUnitTestMode()) : null), (Object)true)) {
            return;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        String string = installedKotlinVersion = propertiesComponent != null ? propertiesComponent.getValue(KotlinUpdatePluginComponentKt.access$getINSTALLED_KOTLIN_VERSION$p()) : null;
        if (installedKotlinVersion == null || Intrinsics.areEqual((Object)KotlinPluginUtil.getPluginVersion(), (Object)installedKotlinVersion) ^ true) {
            Unit unit;
            KotlinPaths ideaPluginPaths = PathUtil.getKotlinPathsForIdeaPlugin();
            File file = ideaPluginPaths.getRuntimePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"ideaPluginPaths.runtimePath");
            this.requestFullJarUpdate(file);
            File file2 = ideaPluginPaths.getReflectPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"ideaPluginPaths.reflectPath");
            this.requestFullJarUpdate(file2);
            File file3 = ideaPluginPaths.getRuntimeSourcesPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"ideaPluginPaths.runtimeSourcesPath");
            this.requestFullJarUpdate(file3);
            File file4 = ideaPluginPaths.getJsStdLibJarPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"ideaPluginPaths.jsStdLibJarPath");
            this.requestFullJarUpdate(file4);
            File file5 = ideaPluginPaths.getJsStdLibSrcJarPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"ideaPluginPaths.jsStdLibSrcJarPath");
            this.requestFullJarUpdate(file5);
            File file6 = ideaPluginPaths.getJdkAnnotationsPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"ideaPluginPaths.jdkAnnotationsPath");
            this.requestFullJarUpdate(file6);
            File file7 = ideaPluginPaths.getAndroidSdkAnnotationsPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)file7, (String)"ideaPluginPaths.androidSdkAnnotationsPath");
            this.requestFullJarUpdate(file7);
            FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
            fileBasedIndex.requestRebuild(KotlinMetadataVersionIndex.INSTANCE.getName());
            fileBasedIndex.requestRebuild(KotlinJavaScriptAbiVersionIndex.INSTANCE.getName());
            fileBasedIndex.requestRebuild(KotlinClassFileIndex.INSTANCE.getKEY());
            fileBasedIndex.requestRebuild(KotlinJavaScriptMetaFileIndex.INSTANCE.getKEY());
            fileBasedIndex.requestRebuild(KotlinModuleMappingIndex.INSTANCE.getKEY());
            PropertiesComponent propertiesComponent2 = PropertiesComponent.getInstance();
            if (propertiesComponent2 != null) {
                propertiesComponent2.setValue(KotlinUpdatePluginComponentKt.access$getINSTALLED_KOTLIN_VERSION$p(), KotlinPluginUtil.getPluginVersion());
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
    }

    @NotNull
    public String getComponentName() {
        return "ReindexBundledRuntimeComponent";
    }

    public void disposeComponent() {
    }

    private final void requestFullJarUpdate(File jarFilePath) {
        VirtualFile jarFile;
        VirtualFile localVirtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(jarFilePath);
        JarFileSystem jarFileSystem = JarFileSystem.getInstance();
        if (jarFileSystem == null) {
            Intrinsics.throwNpe();
        }
        VirtualFile virtualFile = localVirtualFile;
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        VirtualFile virtualFile2 = jarFile = jarFileSystem.getJarRootForLocalFile(virtualFile);
        if (virtualFile2 == null) {
            Intrinsics.throwNpe();
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile2, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(new VirtualFileVisitor.Option[0]){}));
        VirtualFile virtualFile3 = jarFile;
        if (virtualFile3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.newvfs.NewVirtualFile");
        }
        ((NewVirtualFile)virtualFile3).markDirtyRecursively();
    }
}

