/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.Annotations;
import org.jetbrains.kotlin.j2k.ast.DeferredElement;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.Member;
import org.jetbrains.kotlin.j2k.ast.Modifier;
import org.jetbrains.kotlin.j2k.ast.ModifierKt;
import org.jetbrains.kotlin.j2k.ast.Modifiers;
import org.jetbrains.kotlin.j2k.ast.Property;
import org.jetbrains.kotlin.j2k.ast.PropertyAccessor;
import org.jetbrains.kotlin.j2k.ast.Type;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0006\u0010\u0010\u001a\u00020\t\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u0012\u0006\u0010\u0014\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0007H\u0002R\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0017R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/j2k/ast/Property;", "Lorg/jetbrains/kotlin/j2k/ast/Member;", "identifier", "Lorg/jetbrains/kotlin/j2k/ast/Identifier;", "annotations", "Lorg/jetbrains/kotlin/j2k/ast/Annotations;", "modifiers", "Lorg/jetbrains/kotlin/j2k/ast/Modifiers;", "isVar", "", "type", "Lorg/jetbrains/kotlin/j2k/ast/Type;", "explicitType", "initializer", "Lorg/jetbrains/kotlin/j2k/ast/DeferredElement;", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "needInitializer", "getter", "Lorg/jetbrains/kotlin/j2k/ast/PropertyAccessor;", "setter", "isInInterface", "(Lorg/jetbrains/kotlin/j2k/ast/Identifier;Lorg/jetbrains/kotlin/j2k/ast/Annotations;Lorg/jetbrains/kotlin/j2k/ast/Modifiers;ZLorg/jetbrains/kotlin/j2k/ast/Type;ZLorg/jetbrains/kotlin/j2k/ast/DeferredElement;ZLorg/jetbrains/kotlin/j2k/ast/PropertyAccessor;Lorg/jetbrains/kotlin/j2k/ast/PropertyAccessor;Z)V", "getExplicitType", "()Z", "getIdentifier", "()Lorg/jetbrains/kotlin/j2k/ast/Identifier;", "getType", "()Lorg/jetbrains/kotlin/j2k/ast/Type;", "generateCode", "", "builder", "Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "presentationModifiers", "j2k"})
@KotlinClass(version={1, 1, 0}, data={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0006\u0010\u0010\u001a\u00020\t\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u0012\u0006\u0010\u0014\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0007H\u0002R\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0017R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006!"}, strings={"Lorg/jetbrains/kotlin/j2k/ast/Property;", "Lorg/jetbrains/kotlin/j2k/ast/Member;", "identifier", "Lorg/jetbrains/kotlin/j2k/ast/Identifier;", "annotations", "Lorg/jetbrains/kotlin/j2k/ast/Annotations;", "modifiers", "Lorg/jetbrains/kotlin/j2k/ast/Modifiers;", "isVar", "", "type", "Lorg/jetbrains/kotlin/j2k/ast/Type;", "explicitType", "initializer", "Lorg/jetbrains/kotlin/j2k/ast/DeferredElement;", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "needInitializer", "getter", "Lorg/jetbrains/kotlin/j2k/ast/PropertyAccessor;", "setter", "isInInterface", "(Lorg/jetbrains/kotlin/j2k/ast/Identifier;Lorg/jetbrains/kotlin/j2k/ast/Annotations;Lorg/jetbrains/kotlin/j2k/ast/Modifiers;ZLorg/jetbrains/kotlin/j2k/ast/Type;ZLorg/jetbrains/kotlin/j2k/ast/DeferredElement;ZLorg/jetbrains/kotlin/j2k/ast/PropertyAccessor;Lorg/jetbrains/kotlin/j2k/ast/PropertyAccessor;Z)V", "getExplicitType", "()Z", "getIdentifier", "()Lorg/jetbrains/kotlin/j2k/ast/Identifier;", "getType", "()Lorg/jetbrains/kotlin/j2k/ast/Type;", "generateCode", "", "builder", "Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "presentationModifiers", "j2k"})
public final class Property
extends Member {
    @NotNull
    private final Identifier identifier;
    private final boolean isVar;
    @NotNull
    private final Type type;
    private final boolean explicitType;
    private final DeferredElement<Expression> initializer;
    private final boolean needInitializer;
    private final PropertyAccessor getter;
    private final PropertyAccessor setter;
    private final boolean isInInterface;

    private final Modifiers presentationModifiers() {
        Modifiers modifiers = this.getModifiers();
        if (this.isInInterface) {
            modifiers = modifiers.without(Modifier.ABSTRACT);
        }
        if (modifiers.contains(Modifier.OVERRIDE)) {
            modifiers = ModifierKt.filter(modifiers, (Function1<? super Modifier, Boolean>)((Function1)presentationModifiers.1.INSTANCE));
        }
        return modifiers;
    }

    @Override
    public void generateCode(@NotNull CodeBuilder builder) {
        Element initializerToUse;
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        ModifierKt.appendWithSpaceAfter(builder.append(this.getAnnotations()), this.presentationModifiers()).append(this.isVar ? "var " : "val ").append(this.identifier);
        if (this.explicitType) {
            builder.append(":").append(this.type);
        }
        if ((initializerToUse = (Element)this.initializer).isEmpty() && this.needInitializer) {
            Expression expression2 = UtilsKt.getDefaultInitializer(this);
            Element element2 = initializerToUse = expression2 != null ? (Element)expression2 : (Element)Element.Empty.INSTANCE;
        }
        if (!initializerToUse.isEmpty()) {
            builder.append(" = ").append(initializerToUse);
        }
        if (this.getter != null) {
            builder.append("\n").append(this.getter);
        }
        if (this.setter != null) {
            builder.append("\n").append(this.setter);
        }
    }

    @NotNull
    public final Identifier getIdentifier() {
        return this.identifier;
    }

    public final boolean isVar() {
        return this.isVar;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    public final boolean getExplicitType() {
        return this.explicitType;
    }

    public Property(@NotNull Identifier identifier, @NotNull Annotations annotations2, @NotNull Modifiers modifiers, boolean isVar, @NotNull Type type2, boolean explicitType2, @NotNull DeferredElement<Expression> initializer2, boolean needInitializer, @Nullable PropertyAccessor getter, @Nullable PropertyAccessor setter, boolean isInInterface) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        Intrinsics.checkParameterIsNotNull((Object)annotations2, (String)"annotations");
        Intrinsics.checkParameterIsNotNull((Object)modifiers, (String)"modifiers");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull(initializer2, (String)"initializer");
        super(annotations2, modifiers);
        this.identifier = identifier;
        this.isVar = isVar;
        this.type = type2;
        this.explicitType = explicitType2;
        this.initializer = initializer2;
        this.needInitializer = needInitializer;
        this.getter = getter;
        this.setter = setter;
        this.isInInterface = isInInterface;
    }
}

