/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaAnnotationDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaDeprecatedAnnotationDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaRetentionAnnotationDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaTargetAnnotationDescriptor;
import org.jetbrains.kotlin.load.java.lazy.LazyJavaResolverContext;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaAnnotationDescriptorKt;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationOwner;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/load/java/components/JavaAnnotationMapper;", "", "()V", "JAVA_DEPRECATED_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "JAVA_DOCUMENTED_FQ_NAME", "JAVA_REPEATABLE_FQ_NAME", "JAVA_RETENTION_FQ_NAME", "JAVA_TARGET_FQ_NAME", "javaToKotlinNameMap", "", "getJavaToKotlinNameMap", "()Ljava/util/Map;", "kotlinToJavaNameMap", "findMappedJavaAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "kotlinName", "annotationOwner", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotationOwner;", "c", "Lorg/jetbrains/kotlin/load/java/lazy/LazyJavaResolverContext;", "mapOrResolveJavaAnnotation", "annotation", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotation;", "descriptor.loader.java"})
@KotlinClass(version={1, 1, 0}, data={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, strings={"Lorg/jetbrains/kotlin/load/java/components/JavaAnnotationMapper;", "", "()V", "JAVA_DEPRECATED_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "JAVA_DOCUMENTED_FQ_NAME", "JAVA_REPEATABLE_FQ_NAME", "JAVA_RETENTION_FQ_NAME", "JAVA_TARGET_FQ_NAME", "javaToKotlinNameMap", "", "getJavaToKotlinNameMap", "()Ljava/util/Map;", "kotlinToJavaNameMap", "findMappedJavaAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "kotlinName", "annotationOwner", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotationOwner;", "c", "Lorg/jetbrains/kotlin/load/java/lazy/LazyJavaResolverContext;", "mapOrResolveJavaAnnotation", "annotation", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotation;", "descriptor.loader.java"})
public final class JavaAnnotationMapper {
    private static final FqName JAVA_TARGET_FQ_NAME;
    private static final FqName JAVA_RETENTION_FQ_NAME;
    private static final FqName JAVA_DEPRECATED_FQ_NAME;
    private static final FqName JAVA_DOCUMENTED_FQ_NAME;
    private static final FqName JAVA_REPEATABLE_FQ_NAME;
    private static final Map<FqName, FqName> kotlinToJavaNameMap;
    @NotNull
    private static final Map<FqName, FqName> javaToKotlinNameMap;
    public static final JavaAnnotationMapper INSTANCE;

    @Nullable
    public final AnnotationDescriptor mapOrResolveJavaAnnotation(@NotNull JavaAnnotation annotation2, @NotNull LazyJavaResolverContext c) {
        AnnotationDescriptor annotationDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)annotation2, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        ClassId classId = annotation2.getClassId();
        if (Intrinsics.areEqual((Object)classId, (Object)ClassId.topLevel(JAVA_TARGET_FQ_NAME))) {
            annotationDescriptor = new JavaTargetAnnotationDescriptor(annotation2, c);
        } else if (Intrinsics.areEqual((Object)classId, (Object)ClassId.topLevel(JAVA_RETENTION_FQ_NAME))) {
            annotationDescriptor = new JavaRetentionAnnotationDescriptor(annotation2, c);
        } else if (Intrinsics.areEqual((Object)classId, (Object)ClassId.topLevel(JAVA_REPEATABLE_FQ_NAME))) {
            ClassDescriptor classDescriptor = c.getModule().getBuiltIns().getRepeatableAnnotation();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"c.module.builtIns.repeatableAnnotation");
            annotationDescriptor = new JavaAnnotationDescriptor(c, annotation2, classDescriptor);
        } else if (Intrinsics.areEqual((Object)classId, (Object)ClassId.topLevel(JAVA_DOCUMENTED_FQ_NAME))) {
            ClassDescriptor classDescriptor = c.getModule().getBuiltIns().getMustBeDocumentedAnnotation();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"c.module.builtIns.mustBeDocumentedAnnotation");
            annotationDescriptor = new JavaAnnotationDescriptor(c, annotation2, classDescriptor);
        } else {
            annotationDescriptor = Intrinsics.areEqual((Object)classId, (Object)ClassId.topLevel(JAVA_DEPRECATED_FQ_NAME)) ? (AnnotationDescriptor)null : (AnnotationDescriptor)LazyJavaAnnotationDescriptorKt.resolveAnnotation(c, annotation2);
        }
        return annotationDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final AnnotationDescriptor findMappedJavaAnnotation(@NotNull FqName kotlinName, @NotNull JavaAnnotationOwner annotationOwner, @NotNull LazyJavaResolverContext c) {
        AnnotationDescriptor annotationDescriptor;
        Object javaAnnotation;
        Intrinsics.checkParameterIsNotNull((Object)kotlinName, (String)"kotlinName");
        Intrinsics.checkParameterIsNotNull((Object)annotationOwner, (String)"annotationOwner");
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        if (Intrinsics.areEqual((Object)kotlinName, (Object)KotlinBuiltIns.FQ_NAMES.deprecated) && ((javaAnnotation = annotationOwner.findAnnotation(JAVA_DEPRECATED_FQ_NAME)) != null || annotationOwner.isDeprecatedInJavaDoc())) {
            return new JavaDeprecatedAnnotationDescriptor((JavaAnnotation)javaAnnotation, c);
        }
        FqName fqName2 = kotlinToJavaNameMap.get(kotlinName);
        if (fqName2 != null) {
            AnnotationDescriptor annotationDescriptor2;
            void $receiver$iv;
            javaAnnotation = fqName2;
            FqName it = (FqName)$receiver$iv;
            JavaAnnotation javaAnnotation2 = annotationOwner.findAnnotation(it);
            if (javaAnnotation2 != null) {
                void $receiver$iv2;
                JavaAnnotation it2;
                JavaAnnotation javaAnnotation3 = javaAnnotation2;
                JavaAnnotation javaAnnotation4 = it2 = (JavaAnnotation)$receiver$iv2;
                Intrinsics.checkExpressionValueIsNotNull((Object)javaAnnotation4, (String)"it");
                annotationDescriptor2 = INSTANCE.mapOrResolveJavaAnnotation(javaAnnotation4, c);
            } else {
                annotationDescriptor2 = null;
            }
            annotationDescriptor = annotationDescriptor2;
        } else {
            annotationDescriptor = null;
        }
        return annotationDescriptor;
    }

    @NotNull
    public final Map<FqName, FqName> getJavaToKotlinNameMap() {
        return javaToKotlinNameMap;
    }

    private JavaAnnotationMapper() {
        INSTANCE = this;
        JAVA_TARGET_FQ_NAME = new FqName(Target.class.getCanonicalName());
        JAVA_RETENTION_FQ_NAME = new FqName(Retention.class.getCanonicalName());
        JAVA_DEPRECATED_FQ_NAME = new FqName(Deprecated.class.getCanonicalName());
        JAVA_DOCUMENTED_FQ_NAME = new FqName(Documented.class.getCanonicalName());
        JAVA_REPEATABLE_FQ_NAME = new FqName("java.lang.annotation.Repeatable");
        kotlinToJavaNameMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)KotlinBuiltIns.FQ_NAMES.target, (Object)JAVA_TARGET_FQ_NAME), TuplesKt.to((Object)KotlinBuiltIns.FQ_NAMES.retention, (Object)JAVA_RETENTION_FQ_NAME), TuplesKt.to((Object)KotlinBuiltIns.FQ_NAMES.repeatable, (Object)JAVA_REPEATABLE_FQ_NAME), TuplesKt.to((Object)KotlinBuiltIns.FQ_NAMES.mustBeDocumented, (Object)JAVA_DOCUMENTED_FQ_NAME)});
        javaToKotlinNameMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)JAVA_TARGET_FQ_NAME, (Object)KotlinBuiltIns.FQ_NAMES.target), TuplesKt.to((Object)JAVA_RETENTION_FQ_NAME, (Object)KotlinBuiltIns.FQ_NAMES.retention), TuplesKt.to((Object)JAVA_DEPRECATED_FQ_NAME, (Object)KotlinBuiltIns.FQ_NAMES.deprecated), TuplesKt.to((Object)JAVA_REPEATABLE_FQ_NAME, (Object)KotlinBuiltIns.FQ_NAMES.repeatable), TuplesKt.to((Object)JAVA_DOCUMENTED_FQ_NAME, (Object)KotlinBuiltIns.FQ_NAMES.mustBeDocumented)});
    }

    static {
        new JavaAnnotationMapper();
    }
}

