/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J5\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0011J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J\u0012\u0010\u001b\u001a\u00020\u00152\b\b\u0001\u0010\u001c\u001a\u00020\u0013H\u0016R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;)V", "_stub", "get_stub", "()Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getName", "", "getObjectKeyword", "Lcom/intellij/psi/PsiElement;", "getTextOffset", "", "isCompanion", "", "isObjectLiteral", "setName", "name", "frontend"})
@KotlinClass(version={1, 1, 0}, data={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J5\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0011J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J\u0012\u0010\u001b\u001a\u00020\u00152\b\b\u0001\u0010\u001c\u001a\u00020\u0013H\u0016R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, strings={"Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;)V", "_stub", "get_stub", "()Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getName", "", "getObjectKeyword", "Lcom/intellij/psi/PsiElement;", "getTextOffset", "", "isCompanion", "", "isObjectLiteral", "setName", "name", "frontend"})
public final class KtObjectDeclaration
extends KtClassOrObject {
    private final KotlinObjectStub get_stub() {
        KotlinClassOrObjectStub kotlinClassOrObjectStub = (KotlinClassOrObjectStub)this.getStub();
        if (!(kotlinClassOrObjectStub instanceof KotlinObjectStub)) {
            kotlinClassOrObjectStub = null;
        }
        return (KotlinObjectStub)kotlinClassOrObjectStub;
    }

    @Override
    @Nullable
    public String getName() {
        String string = super.getName();
        if (string != null) {
            String $receiver$iv = string;
            String it = $receiver$iv;
            return it;
        }
        if (this.isCompanion() && !this.isTopLevel()) {
            return SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT.toString();
        }
        return null;
    }

    @Override
    @NotNull
    public PsiElement setName(@NonNls @NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        if (this.getNameIdentifier() == null) {
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            KtPsiFactory psiFactory = new KtPsiFactory(project);
            PsiElement result2 = this.addAfter(psiFactory.createIdentifier(name2), this.getObjectKeyword());
            this.addAfter(psiFactory.createWhiteSpace(), this.getObjectKeyword());
            PsiElement psiElement2 = result2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"result");
            return psiElement2;
        }
        PsiElement psiElement3 = super.setName(name2);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"super.setName(name)");
        return psiElement3;
    }

    public final boolean isCompanion() {
        KotlinObjectStub kotlinObjectStub = this.get_stub();
        return kotlinObjectStub != null ? kotlinObjectStub.isCompanion() : this.hasModifier(KtTokens.COMPANION_KEYWORD);
    }

    @Override
    public int getTextOffset() {
        PsiElement psiElement2 = this.getNameIdentifier();
        return psiElement2 != null && (psiElement2 = psiElement2.getTextRange()) != null ? psiElement2.getStartOffset() : this.getObjectKeyword().getTextRange().getStartOffset();
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        Intrinsics.checkParameterIsNotNull(visitor2, (String)"visitor");
        return visitor2.visitObjectDeclaration(this, data);
    }

    public final boolean isObjectLiteral() {
        KotlinObjectStub kotlinObjectStub = this.get_stub();
        return kotlinObjectStub != null ? kotlinObjectStub.isObjectLiteral() : this.getParent() instanceof KtObjectLiteralExpression;
    }

    @NotNull
    public final PsiElement getObjectKeyword() {
        PsiElement psiElement2 = this.findChildByType(KtTokens.OBJECT_KEYWORD);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return psiElement2;
    }

    public KtObjectDeclaration(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        super(node);
    }

    public KtObjectDeclaration(@NotNull KotlinObjectStub stub) {
        Intrinsics.checkParameterIsNotNull((Object)stub, (String)"stub");
        KotlinClassOrObjectStub kotlinClassOrObjectStub = stub;
        IStubElementType iStubElementType = KtStubElementTypes.OBJECT_DECLARATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)iStubElementType, (String)"KtStubElementTypes.OBJECT_DECLARATION");
        super(kotlinClassOrObjectStub, iStubElementType);
    }
}

