/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.bindingContextUtil;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000j\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a@\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0000\u0010\u0002\"\b\b\u0001\u0010\u0001*\u00020\u0003*\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00010\u00062\u0006\u0010\u0007\u001a\u0002H\u0002H\u0086\u0002\u00a2\u0006\u0002\u0010\b\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f\u001a\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004\u001a\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0004\u001a\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0004\u001a\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004\u001a\u0012\u0010\u0019\u001a\u00020\u0018*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004\u001a\u0012\u0010\u001a\u001a\u00020\u0018*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004\u001a*\u0010\u001b\u001a\u00020\u001c\"\u000e\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0\u001e*\b\u0012\u0004\u0012\u0002H\u001d0\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0010\u001a\u001c\u0010 \u001a\u00020\u001c*\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%\u00a8\u0006&"}, d2={"get", "V", "K", "", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "slice", "Lorg/jetbrains/kotlin/util/slicedMap/ReadOnlySlice;", "key", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/util/slicedMap/ReadOnlySlice;Ljava/lang/Object;)Ljava/lang/Object;", "getDataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "position", "Lcom/intellij/psi/PsiElement;", "getReferenceTargets", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "getTargetFunction", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "getTargetFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isUnreachableCode", "", "isUsedAsExpression", "isUsedAsStatement", "recordDataFlowInfo", "", "C", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "expression", "recordScope", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "frontend"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000j\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a@\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0000\u0010\u0002\"\b\b\u0001\u0010\u0001*\u00020\u0003*\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00010\u00062\u0006\u0010\u0007\u001a\u0002H\u0002H\u0086\u0002\u00a2\u0006\u0002\u0010\b\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f\u001a\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004\u001a\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0004\u001a\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0004\u001a\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004\u001a\u0012\u0010\u0019\u001a\u00020\u0018*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004\u001a\u0012\u0010\u001a\u001a\u00020\u0018*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004\u001a*\u0010\u001b\u001a\u00020\u001c\"\u000e\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0\u001e*\b\u0012\u0004\u0012\u0002H\u001d0\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0010\u001a\u001c\u0010 \u001a\u00020\u001c*\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%\u00a8\u0006&"}, strings={"get", "V", "K", "", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "slice", "Lorg/jetbrains/kotlin/util/slicedMap/ReadOnlySlice;", "key", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/util/slicedMap/ReadOnlySlice;Ljava/lang/Object;)Ljava/lang/Object;", "getDataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "position", "Lcom/intellij/psi/PsiElement;", "getReferenceTargets", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "getTargetFunction", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "getTargetFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isUnreachableCode", "", "isUsedAsExpression", "isUsedAsStatement", "recordDataFlowInfo", "", "C", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "expression", "recordScope", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "frontend"})
public final class BindingContextUtilsKt {
    @Nullable
    public static final <K, V> V get(BindingContext $receiver, @NotNull ReadOnlySlice<K, V> slice, K key) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(slice, (String)"slice");
        return $receiver.get(slice, key);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FunctionDescriptor getTargetFunctionDescriptor(KtReturnExpression $receiver, @NotNull BindingContext context) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        KtSimpleNameExpression targetLabel = $receiver.getTargetLabel();
        if (targetLabel != null) {
            SimpleFunctionDescriptor simpleFunctionDescriptor;
            PsiElement psiElement2 = (PsiElement)context.get(BindingContext.LABEL_TARGET, targetLabel);
            if (psiElement2 != null) {
                PsiElement $receiver$iv2 = psiElement2;
                PsiElement it = $receiver$iv2;
                simpleFunctionDescriptor = (SimpleFunctionDescriptor)context.get(BindingContext.FUNCTION, it);
            } else {
                simpleFunctionDescriptor = null;
            }
            return simpleFunctionDescriptor;
        }
        PsiElement it = (PsiElement)$receiver;
        ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
        BindingContext bindingContext2 = context;
        PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtDeclarationWithBody.class, (boolean)false);
        DeclarationDescriptor declarationDescriptor = bindingContext2.get(readOnlySlice, psiElement3);
        FunctionDescriptor containingFunctionDescriptor = DescriptorUtils.getParentOfType(declarationDescriptor, FunctionDescriptor.class, false);
        if (containingFunctionDescriptor == null) {
            return null;
        }
        return (FunctionDescriptor)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile((Sequence)SequencesKt.sequence((Object)containingFunctionDescriptor, (Function1)getTargetFunctionDescriptor.2.INSTANCE), (Function1)getTargetFunctionDescriptor.3.INSTANCE));
    }

    @Nullable
    public static final KtCallableDeclaration getTargetFunction(KtReturnExpression $receiver, @NotNull BindingContext context) {
        KtCallableDeclaration ktCallableDeclaration;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        FunctionDescriptor functionDescriptor = BindingContextUtilsKt.getTargetFunctionDescriptor($receiver, context);
        if (functionDescriptor != null) {
            FunctionDescriptor $receiver$iv = functionDescriptor;
            FunctionDescriptor it = $receiver$iv;
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(it);
            if (!(psiElement2 instanceof KtCallableDeclaration)) {
                psiElement2 = null;
            }
            ktCallableDeclaration = (KtCallableDeclaration)psiElement2;
        } else {
            ktCallableDeclaration = null;
        }
        return ktCallableDeclaration;
    }

    public static final boolean isUsedAsExpression(KtExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object v = context.get(BindingContext.USED_AS_EXPRESSION, $receiver);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    public static final boolean isUsedAsStatement(KtExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return !BindingContextUtilsKt.isUsedAsExpression($receiver, context);
    }

    public static final <C extends ResolutionContext<C>> void recordDataFlowInfo(ResolutionContext<C> $receiver, @Nullable KtExpression expression2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (expression2 == null) {
            return;
        }
        KotlinTypeInfo typeInfo = (KotlinTypeInfo)$receiver.trace.get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
        if (typeInfo != null) {
            BindingTrace bindingTrace = $receiver.trace;
            DataFlowInfo dataFlowInfo = $receiver.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, typeInfo.replaceDataFlowInfo(dataFlowInfo));
        } else if (Intrinsics.areEqual((Object)$receiver.dataFlowInfo, (Object)DataFlowInfo.EMPTY) ^ true) {
            BindingTrace bindingTrace = $receiver.trace;
            DataFlowInfo dataFlowInfo = $receiver.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"dataFlowInfo");
            bindingTrace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, TypeInfoFactoryKt.noTypeInfo(dataFlowInfo));
        }
    }

    public static final void recordScope(BindingTrace $receiver, @NotNull LexicalScope scope2, @Nullable KtElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        if (element2 != null) {
            HierarchicalScope hierarchicalScope = ScopeUtilsKt.takeSnapshot(scope2);
            if (hierarchicalScope == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.LexicalScope");
            }
            $receiver.record(BindingContext.LEXICAL_SCOPE, element2, (LexicalScope)hierarchicalScope);
        }
    }

    @NotNull
    public static final DataFlowInfo getDataFlowInfo(BindingContext $receiver, @NotNull PsiElement position) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        for (PsiElement element2 : PsiUtilsKt.getParentsWithSelf(position)) {
            Object $receiver$iv;
            Object object;
            PsiElement psiElement2 = element2;
            if (!(psiElement2 instanceof KtExpression)) {
                psiElement2 = null;
            }
            if ((object = (KtExpression)psiElement2) == null) continue;
            KtExpression ktExpression = object;
            Object it = (KtExpression)$receiver$iv;
            PsiElement parent2 = it.getParent();
            object = parent2 instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)it, (Object)((KtQualifiedExpression)parent2).getSelectorExpression()) ? (KotlinTypeInfo)null : (KotlinTypeInfo)$receiver.get(BindingContext.EXPRESSION_TYPE_INFO, it);
            if (object == null) continue;
            $receiver$iv = object;
            it = (KotlinTypeInfo)$receiver$iv;
            return ((KotlinTypeInfo)it).getDataFlowInfo();
        }
        DataFlowInfo dataFlowInfo = DataFlowInfo.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"DataFlowInfo.EMPTY");
        return dataFlowInfo;
    }

    public static final boolean isUnreachableCode(KtExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object v = context.get(BindingContext.UNREACHABLE_CODE, $receiver);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Collection<DeclarationDescriptor> getReferenceTargets(KtExpression $receiver, @NotNull BindingContext context) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        DeclarationDescriptor targetDescriptor = $receiver instanceof KtReferenceExpression ? (DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, $receiver) : (DeclarationDescriptor)null;
        Object object = targetDescriptor;
        if (object != null) {
            DeclarationDescriptor $receiver$iv = object;
            DeclarationDescriptor it = $receiver$iv;
            object = CollectionsKt.listOf((Object)it);
            if (object != null) {
                collection = (Collection)object;
                return collection;
            }
        }
        collection = CollectionsKt.orEmpty((Collection)((Collection)context.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, $receiver)));
        return collection;
    }
}

