/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class ReifiedTypeParameterSubstitutionChecker
implements CallChecker {
    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/calls/checkers/ReifiedTypeParameterSubstitutionChecker", "check"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/ReifiedTypeParameterSubstitutionChecker", "check"));
        }
        Map<TypeParameterDescriptor, KotlinType> typeArguments = resolvedCall.getTypeArguments();
        for (Map.Entry<TypeParameterDescriptor, KotlinType> entry : typeArguments.entrySet()) {
            TypeParameterDescriptor parameter = entry.getKey();
            KotlinType argument2 = entry.getValue();
            ClassifierDescriptor argumentDeclarationDescription = argument2.getConstructor().getDeclarationDescriptor();
            if (!parameter.isReified()) continue;
            if (argumentDeclarationDescription instanceof TypeParameterDescriptor && !((TypeParameterDescriptor)argumentDeclarationDescription).isReified()) {
                context.trace.report(Errors.TYPE_PARAMETER_AS_REIFIED.on(ReifiedTypeParameterSubstitutionChecker.getCallElement(context), parameter));
                continue;
            }
            if (!TypeUtilsKt.cannotBeReified(argument2)) continue;
            context.trace.report(Errors.REIFIED_TYPE_FORBIDDEN_SUBSTITUTION.on(ReifiedTypeParameterSubstitutionChecker.getCallElement(context), argument2));
        }
    }

    @NotNull
    private static PsiElement getCallElement(@NotNull BasicCallResolutionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/ReifiedTypeParameterSubstitutionChecker", "getCallElement"));
        }
        KtExpression callee = context.call.getCalleeExpression();
        KtElement ktElement = callee != null ? callee : context.call.getCallElement();
        if (ktElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/checkers/ReifiedTypeParameterSubstitutionChecker", "getCallElement"));
        }
        return ktElement;
    }
}

