/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.inline;

import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.FunctionAnalyzerExtension;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

public class InlineAnalyzerExtension
implements FunctionAnalyzerExtension.AnalyzerExtension {
    public static final InlineAnalyzerExtension INSTANCE = new InlineAnalyzerExtension();

    private InlineAnalyzerExtension() {
    }

    @Override
    public void process(final @NotNull FunctionDescriptor descriptor2, @NotNull KtNamedFunction function2, final @NotNull BindingTrace trace) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "process"));
        }
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "process"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "process"));
        }
        assert (InlineUtil.isInline(descriptor2)) : "This method should be invoked on inline function: " + descriptor2;
        InlineAnalyzerExtension.checkDefaults(descriptor2, function2, trace);
        InlineAnalyzerExtension.checkNotVirtual(descriptor2, function2, trace);
        InlineAnalyzerExtension.checkHasInlinableAndNullability(descriptor2, function2, trace);
        KtVisitorVoid visitor2 = new KtVisitorVoid(){

            @Override
            public void visitKtElement(@NotNull KtElement element2) {
                if (element2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension$1", "visitKtElement"));
                }
                super.visitKtElement(element2);
                element2.acceptChildren(this);
            }

            @Override
            public void visitClass(@NotNull KtClass klass) {
                if (klass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension$1", "visitClass"));
                }
                trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on(klass, klass, descriptor2));
            }

            @Override
            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                if (function2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension$1", "visitNamedFunction"));
                }
                if (function2.getParent().getParent() instanceof KtObjectDeclaration) {
                    super.visitNamedFunction(function2);
                } else {
                    trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on(function2, function2, descriptor2));
                }
            }
        };
        function2.acceptChildren(visitor2);
    }

    private static void checkDefaults(@NotNull FunctionDescriptor functionDescriptor, @NotNull KtFunction function2, @NotNull BindingTrace trace) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkDefaults"));
        }
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkDefaults"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkDefaults"));
        }
        List<KtParameter> jetParameters = function2.getValueParameters();
        for (ValueParameterDescriptor parameter : functionDescriptor.getValueParameters()) {
            KtParameter jetParameter;
            if (!DescriptorUtilsKt.hasDefaultValue(parameter) || !InlineAnalyzerExtension.checkInlinableParameter(parameter, jetParameter = jetParameters.get(parameter.getIndex()), functionDescriptor, null) && parameter.declaresDefaultValue()) continue;
            trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on(jetParameter, jetParameter, functionDescriptor));
        }
    }

    private static void checkNotVirtual(@NotNull FunctionDescriptor functionDescriptor, @NotNull KtFunction function2, @NotNull BindingTrace trace) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkNotVirtual"));
        }
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkNotVirtual"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkNotVirtual"));
        }
        if (Visibilities.isPrivate(functionDescriptor.getVisibility()) || functionDescriptor.getModality() == Modality.FINAL) {
            return;
        }
        if (functionDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor) {
            return;
        }
        trace.report(Errors.DECLARATION_CANT_BE_INLINED.on(function2));
    }

    private static void checkHasInlinableAndNullability(@NotNull FunctionDescriptor functionDescriptor, @NotNull KtFunction function2, @NotNull BindingTrace trace) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkHasInlinableAndNullability"));
        }
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkHasInlinableAndNullability"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkHasInlinableAndNullability"));
        }
        boolean hasInlinable = false;
        List<ValueParameterDescriptor> parameters2 = functionDescriptor.getValueParameters();
        int index2 = 0;
        for (ValueParameterDescriptor parameter : parameters2) {
            hasInlinable |= InlineAnalyzerExtension.checkInlinableParameter(parameter, function2.getValueParameters().get(index2++), functionDescriptor, trace);
        }
        ReceiverParameterDescriptor receiverParameter = functionDescriptor.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            KtTypeReference receiver = function2.getReceiverTypeReference();
            assert (receiver != null) : "Descriptor has a receiver but psi doesn't " + function2.getText();
            hasInlinable |= InlineAnalyzerExtension.checkInlinableParameter(receiverParameter, receiver, functionDescriptor, trace);
        }
        if (!(hasInlinable |= InlineUtil.containsReifiedTypeParameters(functionDescriptor))) {
            KtModifierList modifierList = function2.getModifierList();
            PsiElement inlineModifier = modifierList == null ? null : modifierList.getModifier(KtTokens.INLINE_KEYWORD);
            KtFunction reportOn = inlineModifier == null ? function2 : inlineModifier;
            trace.report(Errors.NOTHING_TO_INLINE.on(reportOn, functionDescriptor));
        }
    }

    public static boolean checkInlinableParameter(@NotNull ParameterDescriptor parameter, @NotNull KtElement expression2, @NotNull CallableDescriptor functionDescriptor, @Nullable BindingTrace trace) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkInlinableParameter"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkInlinableParameter"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension", "checkInlinableParameter"));
        }
        if (InlineUtil.isInlineLambdaParameter(parameter)) {
            if (parameter.getType().isMarkedNullable()) {
                if (trace != null) {
                    trace.report(Errors.NULLABLE_INLINE_PARAMETER.on(expression2, expression2, functionDescriptor));
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

