/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/FileClassAnnotationsChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "()V", "ALWAYS_APPLICABLE", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/name/FqName;", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "frontend.java"})
@KotlinClass(version={1, 1, 0}, data={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, strings={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/FileClassAnnotationsChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "()V", "ALWAYS_APPLICABLE", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/name/FqName;", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "frontend.java"})
public final class FileClassAnnotationsChecker
implements AdditionalAnnotationChecker {
    private static final HashSet<FqName> ALWAYS_APPLICABLE;
    public static final FileClassAnnotationsChecker INSTANCE;

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries2, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace) {
        boolean bl;
        ClassDescriptor classDescriptor;
        ArrayList fileAnnotationsToCheck;
        block6: {
            Intrinsics.checkParameterIsNotNull(entries2, (String)"entries");
            Intrinsics.checkParameterIsNotNull(actualTargets, (String)"actualTargets");
            Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
            fileAnnotationsToCheck = CollectionsKt.arrayListOf((Object[])new Pair[0]);
            for (KtAnnotationEntry pair2 : entries2) {
                AnnotationDescriptor descriptor2;
                KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = pair2.getUseSiteTarget();
                if (Intrinsics.areEqual((Object)((Object)(ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null)), (Object)((Object)AnnotationUseSiteTarget.FILE)) ^ true) continue;
                if ((AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, pair2) == null) {
                    continue;
                }
                if (TypeUtils.getClassDescriptor(descriptor2.getType()) == null) {
                    continue;
                }
                ClassDescriptor classDescriptor2 = classDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"classDescriptor");
                Set<KotlinTarget> applicableTargets = AnnotationChecker.Companion.applicableTargetSet(classDescriptor2);
                if (applicableTargets == null || !applicableTargets.contains((Object)KotlinTarget.FILE)) continue;
                fileAnnotationsToCheck.add(new Pair((Object)pair2, (Object)classDescriptor));
            }
            Iterable iterable = fileAnnotationsToCheck;
            for (KtAnnotationEntry element$iv : iterable) {
                Pair it = (Pair)element$iv;
                if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getClassId((ClassDescriptor)it.getSecond()).asSingleFqName(), (Object)JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS())) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (!bl) {
            return;
        }
        for (Pair pair2 : fileAnnotationsToCheck) {
            KtAnnotationEntry entry = (KtAnnotationEntry)pair2.component1();
            classDescriptor = (ClassDescriptor)pair2.component2();
            FqName classFqName = DescriptorUtilsKt.getClassId(classDescriptor).asSingleFqName();
            if (ALWAYS_APPLICABLE.contains(classFqName) || !(Intrinsics.areEqual((Object)((Object)DescriptorUtilsKt.getAnnotationRetention(classDescriptor)), (Object)((Object)KotlinRetention.SOURCE)) ^ true)) continue;
            trace.report(ErrorsJvm.ANNOTATION_IS_NOT_APPLICABLE_TO_MULTIFILE_CLASSES.on((KtAnnotationEntry)((PsiElement)entry), classFqName));
        }
    }

    private FileClassAnnotationsChecker() {
        INSTANCE = this;
        ALWAYS_APPLICABLE = SetsKt.hashSetOf((Object[])new FqName[]{JvmFileClassUtil.INSTANCE.getJVM_NAME(), JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS()});
    }

    static {
        new FileClassAnnotationsChecker();
    }
}

