/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.LabelResolver;
import org.jetbrains.kotlin.types.expressions.PreliminaryLoopVisitor;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class ControlStructureTypingVisitor
extends ExpressionTypingVisitor {
    public static final String RETURN_NOT_ALLOWED_MESSAGE = "Return not allowed";

    protected ControlStructureTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "<init>"));
        }
        super(facade);
    }

    @NotNull
    private DataFlowInfo checkCondition(@NotNull LexicalScope scope2, @Nullable KtExpression condition2, ExpressionTypingContext context) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "checkCondition"));
        }
        if (condition2 != null) {
            KotlinTypeInfo typeInfo = this.facade.getTypeInfo(condition2, (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(scope2)).replaceExpectedType(this.components.builtIns.getBooleanType())).replaceContextDependency(ContextDependency.INDEPENDENT));
            KotlinType conditionType = typeInfo.getType();
            if (conditionType != null && !this.components.builtIns.isBooleanOrSubtype(conditionType)) {
                context.trace.report(Errors.TYPE_MISMATCH_IN_CONDITION.on(condition2, conditionType));
            }
            DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "checkCondition"));
            }
            return dataFlowInfo;
        }
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "checkCondition"));
        }
        return dataFlowInfo;
    }

    @Override
    public KotlinTypeInfo visitIfExpression(@NotNull KtIfExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitIfExpression"));
        }
        return this.visitIfExpression(expression2, context, false);
    }

    public KotlinTypeInfo visitIfExpression(KtIfExpression ifExpression2, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        boolean jumpInElse;
        this.components.dataFlowAnalyzer.recordExpectedType(contextWithExpectedType.trace, ifExpression2, contextWithExpectedType.expectedType);
        ExpressionTypingContext context = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KtExpression condition2 = ifExpression2.getCondition();
        DataFlowInfo conditionDataFlowInfo = this.checkCondition(context.scope, condition2, context);
        KtExpression elseBranch = ifExpression2.getElse();
        KtExpression thenBranch = ifExpression2.getThen();
        LexicalWritableScope thenScope = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.THEN);
        LexicalWritableScope elseScope = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.ELSE);
        DataFlowInfo thenInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition2, true, context).and(conditionDataFlowInfo);
        DataFlowInfo elseInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition2, false, context).and(conditionDataFlowInfo);
        if (elseBranch == null) {
            if (thenBranch != null) {
                KotlinTypeInfo result2 = this.getTypeInfoWhenOnlyOneBranchIsPresent(thenBranch, thenScope, thenInfo, elseInfo, contextWithExpectedType, ifExpression2, isStatement);
                return result2.getJumpOutPossible() ? result2.replaceJumpOutPossible(true).replaceJumpFlowInfo(conditionDataFlowInfo) : result2;
            }
            return TypeInfoFactoryKt.createTypeInfo(this.components.builtIns.getUnitType(), thenInfo.or(elseInfo));
        }
        if (thenBranch == null) {
            return this.getTypeInfoWhenOnlyOneBranchIsPresent(elseBranch, elseScope, elseInfo, thenInfo, contextWithExpectedType, ifExpression2, isStatement);
        }
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)ifExpression2);
        KtBlockExpression thenBlock = psiFactory.wrapInABlockWrapper(thenBranch);
        KtBlockExpression elseBlock = psiFactory.wrapInABlockWrapper(elseBranch);
        Call callForIf = ControlStructureTypingUtils.createCallForSpecialConstruction(ifExpression2, ifExpression2, Lists.newArrayList((Object[])new KtBlockExpression[]{thenBlock, elseBlock}));
        MutableDataFlowInfoForArguments dataFlowInfoForArguments = ControlStructureTypingUtils.createDataFlowInfoForArgumentsForIfCall(callForIf, conditionDataFlowInfo, thenInfo, elseInfo);
        ResolvedCall<FunctionDescriptor> resolvedCall = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(callForIf, ControlStructureTypingUtils.ResolveConstruct.IF, Lists.newArrayList((Object[])new String[]{"thenBranch", "elseBranch"}), Lists.newArrayList((Object[])new Boolean[]{false, false}), contextWithExpectedType, dataFlowInfoForArguments);
        BindingContext bindingContext2 = context.trace.getBindingContext();
        KotlinTypeInfo thenTypeInfo = BindingContextUtils.getRecordedTypeInfo(thenBranch, bindingContext2);
        KotlinTypeInfo elseTypeInfo = BindingContextUtils.getRecordedTypeInfo(elseBranch, bindingContext2);
        assert (thenTypeInfo != null) : "'Then' branch of if expression  was not processed: " + ifExpression2;
        assert (elseTypeInfo != null) : "'Else' branch of if expression  was not processed: " + ifExpression2;
        KotlinType resultType = resolvedCall.getResultingDescriptor().getReturnType();
        KotlinType thenType = thenTypeInfo.getType();
        KotlinType elseType = elseTypeInfo.getType();
        DataFlowInfo thenDataFlowInfo = thenTypeInfo.getDataFlowInfo();
        DataFlowInfo elseDataFlowInfo = elseTypeInfo.getDataFlowInfo();
        if (resultType != null && thenType != null && elseType != null) {
            DataFlowValue resultValue = DataFlowValueFactory.createDataFlowValue(ifExpression2, resultType, context);
            DataFlowValue thenValue = DataFlowValueFactory.createDataFlowValue(thenBranch, thenType, context);
            thenDataFlowInfo = thenDataFlowInfo.assign(resultValue, thenValue);
            DataFlowValue elseValue = DataFlowValueFactory.createDataFlowValue(elseBranch, elseType, context);
            elseDataFlowInfo = elseDataFlowInfo.assign(resultValue, elseValue);
        }
        boolean loopBreakContinuePossible = thenTypeInfo.getJumpOutPossible() || elseTypeInfo.getJumpOutPossible();
        boolean jumpInThen = thenType != null && KotlinBuiltIns.isNothing(thenType);
        boolean bl = jumpInElse = elseType != null && KotlinBuiltIns.isNothing(elseType);
        DataFlowInfo resultDataFlowInfo = thenType == null && elseType == null ? thenDataFlowInfo.or(elseDataFlowInfo) : (thenType == null || jumpInThen && !jumpInElse ? elseDataFlowInfo : (elseType == null || jumpInElse && !jumpInThen ? thenDataFlowInfo : thenDataFlowInfo.or(elseDataFlowInfo)));
        return TypeInfoFactoryKt.createTypeInfo(resultType, resultDataFlowInfo, loopBreakContinuePossible, conditionDataFlowInfo);
    }

    @NotNull
    private KotlinTypeInfo getTypeInfoWhenOnlyOneBranchIsPresent(@NotNull KtExpression presentBranch, @NotNull LexicalWritableScope presentScope, @NotNull DataFlowInfo presentInfo, @NotNull DataFlowInfo otherInfo, @NotNull ExpressionTypingContext context, @NotNull KtIfExpression ifExpression2, boolean isStatement) {
        if (presentBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentBranch", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (presentScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentScope", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (presentInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentInfo", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (otherInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherInfo", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        if (ifExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifExpression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceDataFlowInfo(presentInfo)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KotlinTypeInfo typeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(presentScope, Collections.singletonList(presentBranch), CoercionStrategy.NO_COERCION, newContext);
        KotlinType type2 = typeInfo.getType();
        DataFlowInfo dataFlowInfo = type2 != null && KotlinBuiltIns.isNothing(type2) ? otherInfo : typeInfo.getDataFlowInfo().or(otherInfo);
        KotlinTypeInfo kotlinTypeInfo = this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(this.components.builtIns.getUnitType()), (KtExpression)ifExpression2, (ResolutionContext)context).replaceDataFlowInfo(dataFlowInfo);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getTypeInfoWhenOnlyOneBranchIsPresent"));
        }
        return kotlinTypeInfo;
    }

    @Override
    public KotlinTypeInfo visitWhileExpression(@NotNull KtWhileExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitWhileExpression"));
        }
        return this.visitWhileExpression(expression2, context, false);
    }

    public KotlinTypeInfo visitWhileExpression(KtWhileExpression expression2, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        KotlinTypeInfo bodyTypeInfo;
        if (!isStatement) {
            DataFlowAnalyzer cfr_ignored_0 = this.components.dataFlowAnalyzer;
            return DataFlowAnalyzer.illegalStatementType(expression2, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        PreliminaryLoopVisitor loopVisitor = PreliminaryLoopVisitor.visitLoop(expression2);
        context = (ExpressionTypingContext)context.replaceDataFlowInfo(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(context.dataFlowInfo));
        KtExpression condition2 = expression2.getCondition();
        DataFlowInfo dataFlowInfo = this.checkCondition(context.scope, condition2, context);
        KtExpression body2 = expression2.getBody();
        DataFlowInfo conditionInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition2, true, context).and(dataFlowInfo);
        if (body2 != null) {
            LexicalWritableScope scopeToExtend = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.WHILE_BODY);
            bodyTypeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(scopeToExtend, Collections.singletonList(body2), CoercionStrategy.NO_COERCION, (ExpressionTypingContext)context.replaceDataFlowInfo(conditionInfo));
        } else {
            bodyTypeInfo = TypeInfoFactoryKt.noTypeInfo(conditionInfo);
        }
        if (!this.containsJumpOutOfLoop(expression2, context)) {
            dataFlowInfo = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition2, false, context).and(dataFlowInfo);
        }
        if (body2 != null && KtPsiUtil.isTrueConstant(condition2)) {
            dataFlowInfo = dataFlowInfo.and(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(bodyTypeInfo.getJumpFlowInfo()));
        }
        return this.components.dataFlowAnalyzer.checkType(bodyTypeInfo.replaceType(this.components.builtIns.getUnitType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType).replaceDataFlowInfo(dataFlowInfo);
    }

    private boolean containsJumpOutOfLoop(final KtLoopExpression loopExpression, final ExpressionTypingContext context) {
        final boolean[] result2 = new boolean[]{false};
        loopExpression.accept(new KtTreeVisitor<List<KtLoopExpression>>(){

            @Override
            public Void visitBreakExpression(@NotNull KtBreakExpression breakExpression, List<KtLoopExpression> outerLoops) {
                PsiElement element2;
                if (breakExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakExpression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor$1", "visitBreakExpression"));
                }
                KtSimpleNameExpression targetLabel = breakExpression.getTargetLabel();
                PsiElement psiElement2 = element2 = targetLabel != null ? context.trace.get(BindingContext.LABEL_TARGET, targetLabel) : null;
                if (element2 == loopExpression || targetLabel == null && outerLoops.get(outerLoops.size() - 1) == loopExpression) {
                    result2[0] = true;
                }
                return null;
            }

            @Override
            public Void visitContinueExpression(@NotNull KtContinueExpression expression2, List<KtLoopExpression> outerLoops) {
                PsiElement element2;
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor$1", "visitContinueExpression"));
                }
                KtSimpleNameExpression targetLabel = expression2.getTargetLabel();
                if (targetLabel != null && (element2 = context.trace.get(BindingContext.LABEL_TARGET, targetLabel)) instanceof KtLoopExpression && !outerLoops.contains(element2)) {
                    result2[0] = true;
                }
                return null;
            }

            @Override
            public Void visitLoopExpression(@NotNull KtLoopExpression loopExpression2, List<KtLoopExpression> outerLoops) {
                if (loopExpression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExpression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor$1", "visitLoopExpression"));
                }
                ArrayList newOuterLoops = Lists.newArrayList(outerLoops);
                newOuterLoops.add(loopExpression2);
                return (Void)super.visitLoopExpression(loopExpression2, newOuterLoops);
            }
        }, Lists.newArrayList((Object[])new KtLoopExpression[]{loopExpression}));
        return result2[0];
    }

    @Override
    public KotlinTypeInfo visitDoWhileExpression(@NotNull KtDoWhileExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitDoWhileExpression"));
        }
        return this.visitDoWhileExpression(expression2, context, false);
    }

    public KotlinTypeInfo visitDoWhileExpression(KtDoWhileExpression expression2, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        KotlinTypeInfo bodyTypeInfo;
        if (!isStatement) {
            DataFlowAnalyzer cfr_ignored_0 = this.components.dataFlowAnalyzer;
            return DataFlowAnalyzer.illegalStatementType(expression2, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtExpression body2 = expression2.getBody();
        LexicalScope conditionScope = context.scope;
        PreliminaryLoopVisitor loopVisitor = PreliminaryLoopVisitor.visitLoop(expression2);
        context = (ExpressionTypingContext)context.replaceDataFlowInfo(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(context.dataFlowInfo));
        if (body2 instanceof KtLambdaExpression) {
            bodyTypeInfo = this.facade.getTypeInfo(body2, (ExpressionTypingContext)context.replaceScope(context.scope));
        } else if (body2 != null) {
            LexicalWritableScope writableScope = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.DO_WHILE_BODY);
            conditionScope = writableScope;
            List<KtExpression> block = body2 instanceof KtBlockExpression ? ((KtBlockExpression)body2).getStatements() : Collections.singletonList(body2);
            bodyTypeInfo = this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(writableScope, block, CoercionStrategy.NO_COERCION, context);
        } else {
            bodyTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        }
        KtExpression condition2 = expression2.getCondition();
        DataFlowInfo conditionDataFlowInfo = this.checkCondition(conditionScope, condition2, context);
        DataFlowInfo dataFlowInfo = !this.containsJumpOutOfLoop(expression2, context) ? this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(condition2, false, context).and(conditionDataFlowInfo) : context.dataFlowInfo;
        if (body2 != null) {
            dataFlowInfo = dataFlowInfo.and(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(bodyTypeInfo.getJumpFlowInfo()));
        }
        return this.components.dataFlowAnalyzer.checkType(bodyTypeInfo.replaceType(this.components.builtIns.getUnitType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType).replaceDataFlowInfo(dataFlowInfo);
    }

    @Override
    public KotlinTypeInfo visitForExpression(@NotNull KtForExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitForExpression"));
        }
        return this.visitForExpression(expression2, context, false);
    }

    public KotlinTypeInfo visitForExpression(KtForExpression expression2, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        KotlinTypeInfo loopRangeInfo;
        if (!isStatement) {
            DataFlowAnalyzer cfr_ignored_0 = this.components.dataFlowAnalyzer;
            return DataFlowAnalyzer.illegalStatementType(expression2, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        PreliminaryLoopVisitor loopVisitor = PreliminaryLoopVisitor.visitLoop(expression2);
        context = (ExpressionTypingContext)context.replaceDataFlowInfo(loopVisitor.clearDataFlowInfoForAssignedLocalVariables(context.dataFlowInfo));
        KtExpression loopRange = expression2.getLoopRange();
        KotlinType expectedParameterType = null;
        if (loopRange != null) {
            ExpressionReceiver loopRangeReceiver = ExpressionTypingUtils.getExpressionReceiver(this.facade, loopRange, (ExpressionTypingContext)context.replaceScope(context.scope));
            loopRangeInfo = this.facade.getTypeInfo(loopRange, context);
            if (loopRangeReceiver != null) {
                expectedParameterType = this.components.forLoopConventionsChecker.checkIterableConvention(loopRangeReceiver, context);
            }
        } else {
            loopRangeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        }
        LexicalWritableScope loopScope = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.FOR);
        KtParameter loopParameter = expression2.getLoopParameter();
        if (loopParameter != null) {
            VariableDescriptor variableDescriptor = this.createLoopParameterDescriptor(loopParameter, expectedParameterType, context);
            this.components.modifiersChecker.withTrace(context.trace).checkModifiersForLocalDeclaration(loopParameter, variableDescriptor);
            this.components.identifierChecker.checkDeclaration(loopParameter, context.trace);
            loopScope.addVariableDescriptor(variableDescriptor);
        } else {
            KtDestructuringDeclaration multiParameter = expression2.getDestructuringParameter();
            if (multiParameter != null && loopRange != null) {
                KotlinType elementType = expectedParameterType == null ? ErrorUtils.createErrorType("Loop range has no type") : expectedParameterType;
                TransientReceiver iteratorNextAsReceiver = new TransientReceiver(elementType);
                this.components.annotationResolver.resolveAnnotationsWithArguments((LexicalScope)loopScope, multiParameter.getModifierList(), context.trace);
                this.components.destructuringDeclarationResolver.defineLocalVariablesFromMultiDeclaration(loopScope, multiParameter, iteratorNextAsReceiver, loopRange, context);
                this.components.modifiersChecker.withTrace(context.trace).checkModifiersForDestructuringDeclaration(multiParameter);
                this.components.modifiersChecker.withTrace(context.trace).checkParameterHasNoValOrVar(multiParameter, Errors.VAL_OR_VAR_ON_LOOP_MULTI_PARAMETER);
                this.components.identifierChecker.checkDeclaration(multiParameter, context.trace);
            }
        }
        KtExpression body2 = expression2.getBody();
        KotlinTypeInfo bodyTypeInfo = body2 != null ? this.components.expressionTypingServices.getBlockReturnedTypeWithWritableScope(loopScope, Collections.singletonList(body2), CoercionStrategy.NO_COERCION, (ExpressionTypingContext)context.replaceDataFlowInfo(loopRangeInfo.getDataFlowInfo())) : loopRangeInfo;
        return this.components.dataFlowAnalyzer.checkType(bodyTypeInfo.replaceType(this.components.builtIns.getUnitType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType).replaceDataFlowInfo(loopRangeInfo.getDataFlowInfo());
    }

    private VariableDescriptor createLoopParameterDescriptor(KtParameter loopParameter, KotlinType expectedParameterType, ExpressionTypingContext context) {
        VariableDescriptor variableDescriptor;
        this.components.modifiersChecker.withTrace(context.trace).checkParameterHasNoValOrVar(loopParameter, Errors.VAL_OR_VAR_ON_LOOP_PARAMETER);
        KtTypeReference typeReference = loopParameter.getTypeReference();
        if (typeReference != null) {
            variableDescriptor = this.components.descriptorResolver.resolveLocalVariableDescriptor(context.scope, loopParameter, context.trace);
            KotlinType actualParameterType = variableDescriptor.getType();
            if (expectedParameterType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(expectedParameterType, actualParameterType)) {
                context.trace.report(Errors.TYPE_MISMATCH_IN_FOR_LOOP.on(typeReference, expectedParameterType, actualParameterType));
            }
        } else {
            if (expectedParameterType == null) {
                expectedParameterType = ErrorUtils.createErrorType("Error");
            }
            variableDescriptor = this.components.descriptorResolver.resolveLocalVariableDescriptor(loopParameter, expectedParameterType, context.trace, context.scope);
        }
        ExpressionTypingUtils.checkVariableShadowing(context.scope, context.trace, variableDescriptor);
        return variableDescriptor;
    }

    @Override
    public KotlinTypeInfo visitTryExpression(@NotNull KtTryExpression expression2, ExpressionTypingContext typingContext) {
        KotlinType type2;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitTryExpression"));
        }
        ExpressionTypingContext context = (ExpressionTypingContext)typingContext.replaceContextDependency(ContextDependency.INDEPENDENT);
        KtBlockExpression tryBlock2 = expression2.getTryBlock();
        List<KtCatchClause> catchClauses = expression2.getCatchClauses();
        KtFinallySection finallyBlock = expression2.getFinallyBlock();
        ArrayList<KotlinType> types2 = new ArrayList<KotlinType>();
        for (KtCatchClause catchClause : catchClauses) {
            KtParameter catchParameter = catchClause.getCatchParameter();
            KtExpression catchBody = catchClause.getCatchBody();
            if (catchParameter == null) continue;
            this.components.identifierChecker.checkDeclaration(catchParameter, context.trace);
            ModifiersChecker.ModifiersCheckingProcedure modifiersChecking = this.components.modifiersChecker.withTrace(context.trace);
            modifiersChecking.checkParameterHasNoValOrVar(catchParameter, Errors.VAL_OR_VAR_ON_CATCH_PARAMETER);
            ModifierCheckerCore.INSTANCE.check(catchParameter, context.trace, null);
            VariableDescriptor variableDescriptor = this.components.descriptorResolver.resolveLocalVariableDescriptor(context.scope, catchParameter, context.trace);
            KotlinType catchParameterType = variableDescriptor.getType();
            if (TypeUtils.isReifiedTypeParameter(catchParameterType)) {
                context.trace.report(Errors.REIFIED_TYPE_IN_CATCH_CLAUSE.on(catchParameter));
            }
            KotlinType throwableType = this.components.builtIns.getThrowable().getDefaultType();
            this.components.dataFlowAnalyzer.checkType(catchParameterType, (KtExpression)catchParameter, (ResolutionContext)context.replaceExpectedType(throwableType));
            if (catchBody == null) continue;
            LexicalWritableScope catchScope = ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.CATCH);
            catchScope.addVariableDescriptor(variableDescriptor);
            KotlinType type3 = this.facade.getTypeInfo(catchBody, (ExpressionTypingContext)context.replaceScope(catchScope)).getType();
            if (type3 == null) continue;
            types2.add(type3);
        }
        KotlinTypeInfo result2 = TypeInfoFactoryKt.noTypeInfo(context);
        if (finallyBlock != null) {
            result2 = this.facade.getTypeInfo(finallyBlock.getFinalExpression(), (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        }
        if ((type2 = this.facade.getTypeInfo(tryBlock2, context).getType()) != null) {
            types2.add(type2);
        }
        if (types2.isEmpty()) {
            return result2.clearType();
        }
        return result2.replaceType(CommonSupertypes.commonSupertype(types2));
    }

    @Override
    public KotlinTypeInfo visitThrowExpression(@NotNull KtThrowExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitThrowExpression"));
        }
        KtExpression thrownExpression = expression2.getThrownExpression();
        if (thrownExpression != null) {
            KotlinType throwableType = this.components.builtIns.getThrowable().getDefaultType();
            this.facade.getTypeInfo(thrownExpression, (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(throwableType)).replaceScope(context.scope)).replaceContextDependency(ContextDependency.INDEPENDENT));
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.components.builtIns.getNothingType(), context, expression2);
    }

    @Override
    public KotlinTypeInfo visitReturnExpression(@NotNull KtReturnExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitReturnExpression"));
        }
        KtElement labelTargetElement = LabelResolver.INSTANCE.resolveControlLabel(expression2, context);
        KtExpression returnedExpression = expression2.getReturnedExpression();
        KotlinType expectedType = TypeUtils.NO_EXPECTED_TYPE;
        KotlinType resultType = this.components.builtIns.getNothingType();
        KtDeclaration parentDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)expression2, KtDeclaration.class);
        if (parentDeclaration instanceof KtParameter) {
            context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression2));
        }
        if (expression2.getTargetLabel() == null) {
            while (parentDeclaration instanceof KtDestructuringDeclaration) {
                parentDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)parentDeclaration, KtDeclaration.class);
            }
            assert (parentDeclaration != null) : "Can't find parent declaration for " + expression2.getText();
            DeclarationDescriptor declarationDescriptor = context.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, parentDeclaration);
            Pair<FunctionDescriptor, PsiElement> containingFunInfo = BindingContextUtils.getContainingFunctionSkipFunctionLiterals(declarationDescriptor, false);
            FunctionDescriptor containingFunctionDescriptor = (FunctionDescriptor)containingFunInfo.getFirst();
            if (containingFunctionDescriptor != null) {
                if (!InlineUtil.checkNonLocalReturnUsage(containingFunctionDescriptor, expression2, context.trace) || ControlStructureTypingVisitor.isClassInitializer(containingFunInfo)) {
                    context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression2));
                    resultType = ErrorUtils.createErrorType(RETURN_NOT_ALLOWED_MESSAGE);
                }
                expectedType = ControlStructureTypingVisitor.getFunctionExpectedReturnType(containingFunctionDescriptor, (KtElement)containingFunInfo.getSecond(), context);
            } else {
                context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression2));
                resultType = ErrorUtils.createErrorType(RETURN_NOT_ALLOWED_MESSAGE);
            }
        } else if (labelTargetElement != null) {
            SimpleFunctionDescriptor functionDescriptor = context.trace.get(BindingContext.FUNCTION, labelTargetElement);
            if (functionDescriptor != null) {
                expectedType = ControlStructureTypingVisitor.getFunctionExpectedReturnType(functionDescriptor, labelTargetElement, context);
                if (!InlineUtil.checkNonLocalReturnUsage(functionDescriptor, expression2, context.trace)) {
                    context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression2));
                    resultType = ErrorUtils.createErrorType(RETURN_NOT_ALLOWED_MESSAGE);
                }
            } else {
                context.trace.report(Errors.NOT_A_RETURN_LABEL.on(expression2, expression2.getLabelName()));
            }
        }
        if (returnedExpression != null) {
            this.facade.getTypeInfo(returnedExpression, (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(expectedType)).replaceScope(context.scope)).replaceContextDependency(ContextDependency.INDEPENDENT));
        } else if (!(expectedType == null || TypeUtils.noExpectedType(expectedType) || KotlinBuiltIns.isUnit(expectedType) || TypeUtils.isDontCarePlaceholder(expectedType))) {
            context.trace.report(Errors.RETURN_TYPE_MISMATCH.on(expression2, expectedType));
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context, expression2);
    }

    private static boolean isClassInitializer(@NotNull Pair<FunctionDescriptor, PsiElement> containingFunInfo) {
        if (containingFunInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFunInfo", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "isClassInitializer"));
        }
        return containingFunInfo.getFirst() instanceof ConstructorDescriptor && !(containingFunInfo.getSecond() instanceof KtSecondaryConstructor);
    }

    @Override
    public KotlinTypeInfo visitBreakExpression(@NotNull KtBreakExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitBreakExpression"));
        }
        LabelResolver.INSTANCE.resolveControlLabel(expression2, context);
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.components.builtIns.getNothingType(), context, expression2).replaceJumpOutPossible(true);
    }

    @Override
    public KotlinTypeInfo visitContinueExpression(@NotNull KtContinueExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "visitContinueExpression"));
        }
        LabelResolver.INSTANCE.resolveControlLabel(expression2, context);
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.components.builtIns.getNothingType(), context, expression2).replaceJumpOutPossible(true);
    }

    @NotNull
    private static KotlinType getFunctionExpectedReturnType(@NotNull FunctionDescriptor descriptor2, @NotNull KtElement function2, @NotNull ExpressionTypingContext context) {
        KotlinType expectedType;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getFunctionExpectedReturnType"));
        }
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getFunctionExpectedReturnType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getFunctionExpectedReturnType"));
        }
        if (function2 instanceof KtSecondaryConstructor) {
            expectedType = DescriptorUtilsKt.getBuiltIns(descriptor2).getUnitType();
        } else if (function2 instanceof KtFunction) {
            KtFunction ktFunction = (KtFunction)function2;
            expectedType = context.trace.get(BindingContext.EXPECTED_RETURN_TYPE, ktFunction);
            if (expectedType == null && (ktFunction.getTypeReference() != null || ktFunction.hasBlockBody())) {
                expectedType = descriptor2.getReturnType();
            }
        } else {
            expectedType = descriptor2.getReturnType();
        }
        KotlinType kotlinType = expectedType != null ? expectedType : TypeUtils.NO_EXPECTED_TYPE;
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ControlStructureTypingVisitor", "getFunctionExpectedReturnType"));
        }
        return kotlinType;
    }
}

