/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.typesApproximation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.DelegatingFlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypeCapabilities;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.types.typesApproximation.ApproximationBounds;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt$WhenMappings;
import org.jetbrains.kotlin.types.typesApproximation.TypeArgument;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\r\u001a\u00020\u0002*\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0002\u001a\u0014\u0010\u0010\u001a\u00020\n*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0005*\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"approximateCapturedTypes", "Lorg/jetbrains/kotlin/types/typesApproximation/ApproximationBounds;", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "approximateCapturedTypesIfNecessary", "Lorg/jetbrains/kotlin/types/TypeProjection;", "typeProjection", "approximateContravariant", "", "approximateProjection", "Lorg/jetbrains/kotlin/types/typesApproximation/TypeArgument;", "typeArgument", "substituteCapturedTypesWithProjections", "replaceTypeArguments", "newTypeArguments", "", "toTypeArgument", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "toTypeProjection", "descriptors"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\r\u001a\u00020\u0002*\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0002\u001a\u0014\u0010\u0010\u001a\u00020\n*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0005*\u00020\nH\u0002\u00a8\u0006\u0014"}, strings={"approximateCapturedTypes", "Lorg/jetbrains/kotlin/types/typesApproximation/ApproximationBounds;", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "approximateCapturedTypesIfNecessary", "Lorg/jetbrains/kotlin/types/TypeProjection;", "typeProjection", "approximateContravariant", "", "approximateProjection", "Lorg/jetbrains/kotlin/types/typesApproximation/TypeArgument;", "typeArgument", "substituteCapturedTypesWithProjections", "replaceTypeArguments", "newTypeArguments", "", "toTypeArgument", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "toTypeProjection", "descriptors"})
public final class CapturedTypeApproximationKt {
    private static final TypeProjection toTypeProjection(TypeArgument $receiver) {
        Unit unit;
        boolean value$iv = $receiver.isConsistent();
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = "Only consistent enhanced type propection can be converted to type projection";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        Function1<Variance, Variance> removeProjectionIfRedundant$ = new Function1<Variance, Variance>($receiver){
            final /* synthetic */ TypeArgument receiver$0;

            @NotNull
            public final Variance invoke(@NotNull Variance variance) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)variance), (String)"variance");
                return Intrinsics.areEqual((Object)((Object)variance), (Object)((Object)this.receiver$0.getTypeParameter().getVariance())) ? Variance.INVARIANT : variance;
            }
            {
                this.receiver$0 = typeArgument;
                super(1);
            }
        };
        return Intrinsics.areEqual((Object)$receiver.getInProjection(), (Object)$receiver.getOutProjection()) ? new TypeProjectionImpl($receiver.getInProjection()) : (KotlinBuiltIns.isNothing($receiver.getInProjection()) && Intrinsics.areEqual((Object)((Object)$receiver.getTypeParameter().getVariance()), (Object)((Object)Variance.IN_VARIANCE)) ^ true ? new TypeProjectionImpl(removeProjectionIfRedundant$.invoke(Variance.OUT_VARIANCE), $receiver.getOutProjection()) : (KotlinBuiltIns.isNullableAny($receiver.getOutProjection()) ? new TypeProjectionImpl(removeProjectionIfRedundant$.invoke(Variance.IN_VARIANCE), $receiver.getInProjection()) : new TypeProjectionImpl(removeProjectionIfRedundant$.invoke(Variance.OUT_VARIANCE), $receiver.getOutProjection())));
    }

    private static final TypeArgument toTypeArgument(TypeProjection $receiver, TypeParameterDescriptor typeParameter) {
        TypeArgument typeArgument;
        switch (CapturedTypeApproximationKt$WhenMappings.$EnumSwitchMapping$0[TypeSubstitutor.combine(typeParameter.getVariance(), $receiver).ordinal()]) {
            case 1: {
                KotlinType kotlinType = $receiver.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"type");
                KotlinType kotlinType2 = $receiver.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"type");
                typeArgument = new TypeArgument(typeParameter, kotlinType, kotlinType2);
                break;
            }
            case 2: {
                KotlinType kotlinType = $receiver.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"type");
                KotlinType kotlinType3 = DescriptorUtilsKt.getBuiltIns(typeParameter).getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"typeParameter.builtIns.nullableAnyType");
                typeArgument = new TypeArgument(typeParameter, kotlinType, kotlinType3);
                break;
            }
            case 3: {
                KotlinType kotlinType = DescriptorUtilsKt.getBuiltIns(typeParameter).getNothingType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"typeParameter.builtIns.nothingType");
                KotlinType kotlinType4 = $receiver.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType4, (String)"type");
                typeArgument = new TypeArgument(typeParameter, kotlinType, kotlinType4);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return typeArgument;
    }

    @Nullable
    public static final TypeProjection approximateCapturedTypesIfNecessary(@Nullable TypeProjection typeProjection, boolean approximateContravariant) {
        if (typeProjection == null) {
            return null;
        }
        if (typeProjection.isStarProjection()) {
            return typeProjection;
        }
        KotlinType type2 = typeProjection.getType();
        if (!TypeUtils.containsSpecialType(type2, (Function1<KotlinType, Boolean>)((Function1)approximateCapturedTypesIfNecessary.1.INSTANCE))) {
            return typeProjection;
        }
        Variance howThisTypeIsUsed = typeProjection.getProjectionKind();
        if (Intrinsics.areEqual((Object)((Object)howThisTypeIsUsed), (Object)((Object)Variance.OUT_VARIANCE))) {
            KotlinType kotlinType = type2;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"type");
            ApproximationBounds<KotlinType> approximation = CapturedTypeApproximationKt.approximateCapturedTypes(kotlinType);
            return new TypeProjectionImpl(howThisTypeIsUsed, approximation.getUpper());
        }
        if (approximateContravariant) {
            KotlinType kotlinType = type2;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"type");
            KotlinType approximation = CapturedTypeApproximationKt.approximateCapturedTypes(kotlinType).getLower();
            return new TypeProjectionImpl(howThisTypeIsUsed, approximation);
        }
        return CapturedTypeApproximationKt.substituteCapturedTypesWithProjections(typeProjection);
    }

    private static final TypeProjection substituteCapturedTypesWithProjections(TypeProjection typeProjection) {
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new TypeConstructorSubstitution(){

            @Nullable
            public TypeProjection get(@NotNull TypeConstructor key) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                TypeConstructor typeConstructor2 = key;
                if (!(typeConstructor2 instanceof CapturedTypeConstructor)) {
                    typeConstructor2 = null;
                }
                CapturedTypeConstructor capturedTypeConstructor = (CapturedTypeConstructor)typeConstructor2;
                return capturedTypeConstructor != null ? capturedTypeConstructor.getTypeProjection() : null;
            }
        });
        return typeSubstitutor2.substituteWithoutApproximation(typeProjection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ApproximationBounds<KotlinType> approximateCapturedTypes(@NotNull KotlinType type2) {
        boolean bl;
        ArrayList<Object> upperBoundArguments;
        ArrayList<Object> lowerBoundArguments;
        block11: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            if (FlexibleTypesKt.isFlexible(type2)) {
                ApproximationBounds<KotlinType> boundsForFlexibleLower = CapturedTypeApproximationKt.approximateCapturedTypes(FlexibleTypesKt.lowerIfFlexible(type2));
                ApproximationBounds<KotlinType> boundsForFlexibleUpper = CapturedTypeApproximationKt.approximateCapturedTypes(FlexibleTypesKt.upperIfFlexible(type2));
                FlexibleTypeCapabilities extraCapabilities = FlexibleTypesKt.flexibility(type2).getExtraCapabilities();
                return new ApproximationBounds<KotlinType>(DelegatingFlexibleType.Companion.create(FlexibleTypesKt.lowerIfFlexible(boundsForFlexibleLower.getLower()), FlexibleTypesKt.upperIfFlexible(boundsForFlexibleUpper.getLower()), extraCapabilities), DelegatingFlexibleType.Companion.create(FlexibleTypesKt.lowerIfFlexible(boundsForFlexibleLower.getUpper()), FlexibleTypesKt.upperIfFlexible(boundsForFlexibleUpper.getUpper()), extraCapabilities));
            }
            TypeConstructor typeConstructor2 = type2.getConstructor();
            if (CapturedTypeConstructorKt.isCaptured(type2)) {
                ApproximationBounds<KotlinType> approximationBounds;
                TypeConstructor typeConstructor3 = typeConstructor2;
                if (typeConstructor3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor");
                }
                TypeProjection typeProjection = ((CapturedTypeConstructor)typeConstructor3).getTypeProjection();
                Function1<KotlinType, KotlinType> makeNullableIfNeeded$ = new Function1<KotlinType, KotlinType>(type2){
                    final /* synthetic */ KotlinType $type;

                    @NotNull
                    public final KotlinType invoke(KotlinType $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        return TypeUtils.makeNullableIfNeeded($receiver, this.$type.isMarkedNullable());
                    }
                    {
                        this.$type = kotlinType;
                        super(1);
                    }
                };
                KotlinType bound = makeNullableIfNeeded$.invoke(typeProjection.getType());
                switch (CapturedTypeApproximationKt$WhenMappings.$EnumSwitchMapping$1[typeProjection.getProjectionKind().ordinal()]) {
                    case 1: {
                        approximationBounds = new ApproximationBounds<KotlinType>(bound, TypeUtilsKt.getBuiltIns(type2).getNullableAnyType());
                        break;
                    }
                    case 2: {
                        approximationBounds = new ApproximationBounds<KotlinType>(makeNullableIfNeeded$.invoke(TypeUtilsKt.getBuiltIns(type2).getNothingType()), bound);
                        break;
                    }
                    default: {
                        throw (Throwable)((Object)new AssertionError((Object)("Only nontrivial projections should have been captured, not: " + typeProjection)));
                    }
                }
                return approximationBounds;
            }
            if (type2.getArguments().isEmpty() || type2.getArguments().size() != typeConstructor2.getParameters().size()) {
                return new ApproximationBounds<KotlinType>(type2, type2);
            }
            lowerBoundArguments = new ArrayList<Object>();
            upperBoundArguments = new ArrayList<Object>();
            Iterable iterable = type2.getArguments();
            Iterable iterable2 = typeConstructor2.getParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"typeConstructor.parameters");
            for (Pair bound : CollectionsKt.zip((Iterable)iterable, (Iterable)iterable2)) {
                void upper;
                void lower;
                TypeParameterDescriptor typeParameter;
                TypeProjection typeProjection = (TypeProjection)bound.component1();
                TypeParameterDescriptor typeParameterDescriptor = typeParameter = (TypeParameterDescriptor)bound.component2();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"typeParameter");
                TypeArgument typeArgument = CapturedTypeApproximationKt.toTypeArgument(typeProjection, typeParameterDescriptor);
                if (typeProjection.isStarProjection()) {
                    lowerBoundArguments.add(typeArgument);
                    upperBoundArguments.add(typeArgument);
                    continue;
                }
                ApproximationBounds<TypeArgument> approximationBounds = CapturedTypeApproximationKt.approximateProjection(typeArgument);
                TypeArgument typeArgument2 = approximationBounds.component1();
                TypeArgument typeArgument3 = approximationBounds.component2();
                approximationBounds = null;
                lowerBoundArguments.add(lower);
                upperBoundArguments.add(upper);
            }
            Iterable iterable3 = lowerBoundArguments;
            for (Object element$iv : $receiver$iv) {
                TypeArgument it = (TypeArgument)element$iv;
                if (!(!it.isConsistent())) continue;
                bl = true;
                break block11;
            }
            bl = false;
        }
        boolean lowerBoundIsTrivial = bl;
        KotlinType kotlinType = lowerBoundIsTrivial ? TypeUtilsKt.getBuiltIns(type2).getNothingType() : CapturedTypeApproximationKt.replaceTypeArguments(type2, (List<TypeArgument>)lowerBoundArguments);
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"if (lowerBoundIsTrivial)\u2026ents(lowerBoundArguments)");
        return new ApproximationBounds<KotlinType>(kotlinType, CapturedTypeApproximationKt.replaceTypeArguments(type2, (List<TypeArgument>)upperBoundArguments));
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinType replaceTypeArguments(KotlinType $receiver, List<TypeArgument> newTypeArguments) {
        List list2;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Unit unit;
        boolean value$iv22 = $receiver.getArguments().size() == newTypeArguments.size();
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv22) {
                String message$iv = "Incorrect type arguments " + newTypeArguments;
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        Iterable value$iv22 = newTypeArguments;
        KotlinType kotlinType = $receiver;
        void $i$a$1 = $receiver$iv;
        Collection message$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeArgument typeArgument = (TypeArgument)item$iv$iv;
            list2 = destination$iv$iv;
            TypeProjection typeProjection = CapturedTypeApproximationKt.toTypeProjection((TypeArgument)it);
            list2.add(typeProjection);
        }
        list2 = (List)destination$iv$iv;
        return TypeSubstitutionKt.replace$default(kotlinType, list2, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final ApproximationBounds<TypeArgument> approximateProjection(TypeArgument typeArgument) {
        void outUpper;
        void inLower;
        void outLower;
        void inUpper;
        Object object = CapturedTypeApproximationKt.approximateCapturedTypes(typeArgument.getInProjection());
        KotlinType kotlinType = ((ApproximationBounds)object).component1();
        KotlinType kotlinType2 = ((ApproximationBounds)object).component2();
        object = null;
        ApproximationBounds<KotlinType> approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(typeArgument.getOutProjection());
        object = approximationBounds.component1();
        KotlinType kotlinType3 = approximationBounds.component2();
        approximationBounds = null;
        return new ApproximationBounds<TypeArgument>(new TypeArgument(typeArgument.getTypeParameter(), (KotlinType)inUpper, (KotlinType)outLower), new TypeArgument(typeArgument.getTypeParameter(), (KotlinType)inLower, (KotlinType)outUpper));
    }
}

