/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorChecks;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\bR\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0018\u0010\n\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\tR\u0018\u0010\u000b\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0018\u0010\r\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\tR\u0018\u0010\u000f\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\tR\u0018\u0010\u0011\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\tR\u0018\u0010\u0013\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\tR\u0018\u0010\u0015\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/util/OperatorChecks;", "", "()V", "isKProperty", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;)Z", "isMember", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "isMemberOrExtension", "noDefaultsAndVarargs", "getNoDefaultsAndVarargs", "noValueParameters", "getNoValueParameters", "returnsBoolean", "getReturnsBoolean", "returnsInt", "getReturnsInt", "returnsUnit", "getReturnsUnit", "singleValueParameter", "getSingleValueParameter", "canBeOperator", "functionDescriptor", "descriptors"})
@KotlinClass(version={1, 1, 0}, data={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\bR\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0018\u0010\n\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\tR\u0018\u0010\u000b\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0018\u0010\r\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\tR\u0018\u0010\u000f\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\tR\u0018\u0010\u0011\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\tR\u0018\u0010\u0013\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\tR\u0018\u0010\u0015\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\t\u00a8\u0006\u0019"}, strings={"Lorg/jetbrains/kotlin/util/OperatorChecks;", "", "()V", "isKProperty", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;)Z", "isMember", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "isMemberOrExtension", "noDefaultsAndVarargs", "getNoDefaultsAndVarargs", "noValueParameters", "getNoValueParameters", "returnsBoolean", "getReturnsBoolean", "returnsInt", "getReturnsInt", "returnsUnit", "getReturnsUnit", "singleValueParameter", "getSingleValueParameter", "canBeOperator", "functionDescriptor", "descriptors"})
public final class OperatorChecks {
    public static final OperatorChecks INSTANCE;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canBeOperator(@NotNull FunctionDescriptor functionDescriptor) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        Name name2 = functionDescriptor.getName();
        FunctionDescriptor $receiver = functionDescriptor;
        if (!INSTANCE.isMemberOrExtension(functionDescriptor)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)OperatorNameConventions.GET, (Object)name2)) {
            if ($receiver.getValueParameters().size() < 1) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)OperatorNameConventions.SET, (Object)name2)) {
            boolean bl2;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.lastOrNull($receiver.getValueParameters());
            if (valueParameterDescriptor != null) {
                void $receiver$iv;
                ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor;
                ValueParameterDescriptor it2 = (ValueParameterDescriptor)$receiver$iv;
                bl2 = !DescriptorUtilsKt.hasDefaultValue(it2) && it2.getVarargElementType() == null;
            } else {
                bl2 = false;
            }
            boolean lastIsOk = bl2;
            if ($receiver.getValueParameters().size() < 2) return false;
            if (!lastIsOk) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)OperatorNameConventions.GET_VALUE, (Object)name2)) {
            if (!INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
            if ($receiver.getValueParameters().size() < 2) return false;
            if (!INSTANCE.isKProperty($receiver.getValueParameters().get(1))) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)OperatorNameConventions.SET_VALUE, (Object)name2)) {
            if (!INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
            if ($receiver.getValueParameters().size() < 3) return false;
            if (!INSTANCE.isKProperty($receiver.getValueParameters().get(1))) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)OperatorNameConventions.INVOKE, (Object)name2)) {
            bl = INSTANCE.isMemberOrExtension($receiver);
            return bl;
        } else {
            if (Intrinsics.areEqual((Object)OperatorNameConventions.CONTAINS, (Object)name2)) {
                if (!INSTANCE.getSingleValueParameter($receiver)) return false;
                if (!INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
                if (!INSTANCE.getReturnsBoolean($receiver)) return false;
                return true;
            }
            if (Intrinsics.areEqual((Object)OperatorNameConventions.ITERATOR, (Object)name2)) {
                bl = INSTANCE.getNoValueParameters($receiver);
                return bl;
            } else if (Intrinsics.areEqual((Object)OperatorNameConventions.NEXT, (Object)name2)) {
                bl = INSTANCE.getNoValueParameters($receiver);
                return bl;
            } else {
                if (Intrinsics.areEqual((Object)OperatorNameConventions.HAS_NEXT, (Object)name2)) {
                    if (!INSTANCE.getNoValueParameters($receiver)) return false;
                    if (!INSTANCE.getReturnsBoolean($receiver)) return false;
                    return true;
                }
                if (Intrinsics.areEqual((Object)OperatorNameConventions.RANGE_TO, (Object)name2)) {
                    if (!INSTANCE.getSingleValueParameter($receiver)) return false;
                    if (!INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
                    return true;
                }
                if (Intrinsics.areEqual((Object)OperatorNameConventions.EQUALS, (Object)name2)) {
                    Object element$iv;
                    FunctionDescriptor it;
                    canBeOperator.1.1 isAny$ = canBeOperator.1.1.INSTANCE;
                    if (!INSTANCE.isMember($receiver)) return false;
                    Iterable $receiver$iv = $receiver.getOverriddenDescriptors();
                    Iterator it2 = $receiver$iv.iterator();
                    do {
                        if (!it2.hasNext()) return false;
                    } while (!canBeOperator.1.1.INSTANCE.invoke((it = (FunctionDescriptor)(element$iv = it2.next())).getContainingDeclaration()));
                    return true;
                }
                if (Intrinsics.areEqual((Object)OperatorNameConventions.COMPARE_TO, (Object)name2)) {
                    if (!INSTANCE.getReturnsInt($receiver)) return false;
                    if (!INSTANCE.getSingleValueParameter($receiver)) return false;
                    if (!INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
                    return true;
                }
                if (OperatorNameConventions.BINARY_OPERATION_NAMES.contains(name2)) {
                    if (!INSTANCE.getSingleValueParameter($receiver)) return false;
                    if (!INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
                    return true;
                }
                if (OperatorNameConventions.SIMPLE_UNARY_OPERATION_NAMES.contains(name2)) {
                    bl = INSTANCE.getNoValueParameters($receiver);
                    return bl;
                } else {
                    if (Intrinsics.areEqual((Object)OperatorNameConventions.INC, (Object)name2) || Intrinsics.areEqual((Object)OperatorNameConventions.DEC, (Object)name2)) {
                        ReceiverParameterDescriptor receiverParameterDescriptor = $receiver.getDispatchReceiverParameter();
                        if (receiverParameterDescriptor == null) {
                            receiverParameterDescriptor = $receiver.getExtensionReceiverParameter();
                        }
                        ReceiverParameterDescriptor receiver = receiverParameterDescriptor;
                        if (!INSTANCE.isMemberOrExtension($receiver)) return false;
                        if (receiver == null) return false;
                        KotlinType kotlinType = $receiver.getReturnType();
                        if (kotlinType == null) return false;
                        KotlinType $receiver$iv = kotlinType;
                        KotlinType it = $receiver$iv;
                        KotlinType kotlinType2 = receiver.getType();
                        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"receiver.type");
                        boolean bl3 = TypeUtilsKt.isSubtypeOf(it, kotlinType2);
                        if (!bl3) return false;
                        return true;
                    }
                    if (OperatorNameConventions.ASSIGNMENT_OPERATIONS.contains(name2)) {
                        if (!INSTANCE.getReturnsUnit($receiver)) return false;
                        if (!INSTANCE.getSingleValueParameter($receiver)) return false;
                        if (!INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
                        return true;
                    }
                    if (!StringsKt.matches((CharSequence)name2.asString(), (Regex)OperatorNameConventions.COMPONENT_REGEX)) return false;
                    bl = INSTANCE.getNoValueParameters($receiver);
                }
            }
        }
        return bl;
    }

    private final boolean isKProperty(ValueParameterDescriptor $receiver) {
        boolean bl;
        KotlinType kotlinType = ReflectionTypes.Companion.createKPropertyStarType(DescriptorUtilsKt.getModule($receiver));
        if (kotlinType != null) {
            KotlinType kotlinType2 = TypeUtilsKt.makeNotNullable($receiver.getType());
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"type.makeNotNullable()");
            bl = TypeUtilsKt.isSubtypeOf(kotlinType, kotlinType2);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isMember(FunctionDescriptor $receiver) {
        return $receiver.getContainingDeclaration() instanceof ClassDescriptor;
    }

    private final boolean isMemberOrExtension(FunctionDescriptor $receiver) {
        return DescriptorUtilsKt.isExtension($receiver) || $receiver.getContainingDeclaration() instanceof ClassDescriptor;
    }

    private final boolean getNoValueParameters(FunctionDescriptor $receiver) {
        return $receiver.getValueParameters().isEmpty();
    }

    private final boolean getSingleValueParameter(FunctionDescriptor $receiver) {
        return $receiver.getValueParameters().size() == 1;
    }

    private final boolean getReturnsBoolean(FunctionDescriptor $receiver) {
        boolean bl;
        KotlinType kotlinType = $receiver.getReturnType();
        if (kotlinType != null) {
            KotlinType $receiver$iv = kotlinType;
            KotlinType it = $receiver$iv;
            bl = KotlinBuiltIns.isBoolean(it);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean getReturnsInt(FunctionDescriptor $receiver) {
        boolean bl;
        KotlinType kotlinType = $receiver.getReturnType();
        if (kotlinType != null) {
            KotlinType $receiver$iv = kotlinType;
            KotlinType it = $receiver$iv;
            bl = Intrinsics.areEqual((Object)DescriptorUtilsKt.getBuiltIns($receiver).getIntType(), (Object)it);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean getReturnsUnit(FunctionDescriptor $receiver) {
        boolean bl;
        KotlinType kotlinType = $receiver.getReturnType();
        if (kotlinType != null) {
            KotlinType $receiver$iv = kotlinType;
            KotlinType it = $receiver$iv;
            bl = Intrinsics.areEqual((Object)DescriptorUtilsKt.getBuiltIns($receiver).getUnitType(), (Object)it);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean getNoDefaultsAndVarargs(FunctionDescriptor $receiver) {
        boolean bl;
        block1: {
            Iterable $receiver$iv = $receiver.getValueParameters();
            for (Object element$iv : $receiver$iv) {
                ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                if (!DescriptorUtilsKt.hasDefaultValue(it) && it.getVarargElementType() == null) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private OperatorChecks() {
        INSTANCE = this;
    }

    static {
        new OperatorChecks();
    }
}

