/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.roots.DependencyScope;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDependencyData<T extends AbstractExternalEntityData>
extends AbstractExternalEntityData
implements DependencyData,
Named,
OrderAware {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final ModuleData myOwnerModule;
    @NotNull
    private final T myTarget;
    private DependencyScope myScope;
    private boolean myExported;
    private int myOrder;

    protected AbstractDependencyData(@NotNull ModuleData ownerModule, @NotNull T dependency) {
        if (ownerModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerModule", "com/intellij/openapi/externalSystem/model/project/AbstractDependencyData", "<init>"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/intellij/openapi/externalSystem/model/project/AbstractDependencyData", "<init>"));
        }
        super(ownerModule.getOwner());
        this.myScope = DependencyScope.COMPILE;
        this.myOwnerModule = ownerModule;
        this.myTarget = dependency;
    }

    @Override
    @NotNull
    public ModuleData getOwnerModule() {
        ModuleData moduleData = this.myOwnerModule;
        if (moduleData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/AbstractDependencyData", "getOwnerModule"));
        }
        return moduleData;
    }

    @Override
    @NotNull
    public T getTarget() {
        T t = this.myTarget;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/AbstractDependencyData", "getTarget"));
        }
        return t;
    }

    @Override
    @NotNull
    public DependencyScope getScope() {
        DependencyScope dependencyScope = this.myScope;
        if (dependencyScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/AbstractDependencyData", "getScope"));
        }
        return dependencyScope;
    }

    public void setScope(DependencyScope scope) {
        this.myScope = scope;
    }

    @Override
    public boolean isExported() {
        return this.myExported;
    }

    public void setExported(boolean exported) {
        this.myExported = exported;
    }

    @Override
    @Deprecated
    @NotNull
    public String getName() {
        String string = ((Named)this.myTarget).getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/AbstractDependencyData", "getName"));
        }
        return string;
    }

    @Override
    @Deprecated
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/externalSystem/model/project/AbstractDependencyData", "setName"));
        }
        ((Named)this.myTarget).setName(name);
    }

    @Override
    @NotNull
    public String getExternalName() {
        String string = ((Named)this.myTarget).getExternalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/AbstractDependencyData", "getExternalName"));
        }
        return string;
    }

    @Override
    public void setExternalName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/externalSystem/model/project/AbstractDependencyData", "setExternalName"));
        }
        ((Named)this.myTarget).setExternalName(name);
    }

    @Override
    @NotNull
    public String getInternalName() {
        String string = ((Named)this.myTarget).getInternalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/AbstractDependencyData", "getInternalName"));
        }
        return string;
    }

    @Override
    public void setInternalName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/externalSystem/model/project/AbstractDependencyData", "setInternalName"));
        }
        ((Named)this.myTarget).setInternalName(name);
    }

    @Override
    public int getOrder() {
        return this.myOrder;
    }

    public void setOrder(int order) {
        this.myOrder = order;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myScope.hashCode();
        result = 31 * result + this.myOwnerModule.hashCode();
        result = 31 * result + ((AbstractExternalEntityData)this.myTarget).hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AbstractDependencyData that = (AbstractDependencyData)o;
        return this.myScope.equals((Object)that.myScope) && this.myOwnerModule.equals(that.myOwnerModule) && ((AbstractExternalEntityData)this.myTarget).equals(that.myTarget);
    }

    public String toString() {
        return "dependency=" + this.getTarget() + "|scope=" + (Object)((Object)this.getScope()) + "|exported=" + this.isExported() + "|owner=" + this.getOwnerModule();
    }
}

