/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRegexpArrangementMatcher
implements ArrangementEntryMatcher {
    @NotNull
    private final String myPattern;
    @Nullable
    private final Pattern myCompiledPattern;

    public AbstractRegexpArrangementMatcher(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/codeStyle/arrangement/match/AbstractRegexpArrangementMatcher", "<init>"));
        }
        this.myPattern = pattern;
        Pattern p = null;
        try {
            p = Pattern.compile(pattern);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myCompiledPattern = p;
    }

    @Override
    public boolean isMatched(@NotNull ArrangementEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/psi/codeStyle/arrangement/match/AbstractRegexpArrangementMatcher", "isMatched"));
        }
        if (this.myCompiledPattern == null) {
            return false;
        }
        String text = this.getTextToMatch(entry);
        return text != null && this.myCompiledPattern.matcher(text).matches();
    }

    @Nullable
    protected abstract String getTextToMatch(@NotNull ArrangementEntry var1);

    @NotNull
    public String getPattern() {
        String string = this.myPattern;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/match/AbstractRegexpArrangementMatcher", "getPattern"));
        }
        return string;
    }

    public int hashCode() {
        return this.myPattern.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRegexpArrangementMatcher that = (AbstractRegexpArrangementMatcher)o;
        return this.myPattern.equals(that.myPattern);
    }

    public String toString() {
        return String.format("regexp '%s'", this.myPattern);
    }
}

