/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure.filtered;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FilteringTreeStructure
extends AbstractTreeStructure {
    private final ElementFilter<Object> myFilter;
    private final AbstractTreeStructure myBaseStructure;
    protected final FilteringNode myRoot;
    protected final HashSet<FilteringNode> myLeaves;
    private final Map<FilteringNode, List<FilteringNode>> myNodesCache;
    private final Map<Object, FilteringNode> myDescriptors2Nodes;

    public FilteringTreeStructure(@NotNull ElementFilter filter, @NotNull AbstractTreeStructure originalStructure) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/ui/treeStructure/filtered/FilteringTreeStructure", "<init>"));
        }
        if (originalStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalStructure", "com/intellij/ui/treeStructure/filtered/FilteringTreeStructure", "<init>"));
        }
        this(filter, originalStructure, true);
    }

    public FilteringTreeStructure(@NotNull ElementFilter filter, @NotNull AbstractTreeStructure originalStructure, boolean initNow) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/ui/treeStructure/filtered/FilteringTreeStructure", "<init>"));
        }
        if (originalStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalStructure", "com/intellij/ui/treeStructure/filtered/FilteringTreeStructure", "<init>"));
        }
        this.myLeaves = new HashSet();
        this.myNodesCache = new HashMap<FilteringNode, List<FilteringNode>>();
        this.myDescriptors2Nodes = new HashMap<Object, FilteringNode>();
        this.myFilter = filter;
        this.myBaseStructure = originalStructure;
        this.myRoot = new FilteringNode(null, this.myBaseStructure.getRootElement());
        if (initNow) {
            this.rebuild();
        }
    }

    public void rebuild() {
        this.myLeaves.clear();
        this.myNodesCache.clear();
        this.myDescriptors2Nodes.clear();
        this.addToCache(this.myRoot, false);
    }

    private void addToCache(FilteringNode node, boolean duplicate) {
        Object delegate = node.getDelegate();
        Object[] delegates = this.myBaseStructure.getChildElements(delegate);
        if (delegates == null || delegates.length == 0 || duplicate) {
            this.myLeaves.add(node);
        } else {
            ArrayList<FilteringNode> nodes = new ArrayList<FilteringNode>(delegates.length);
            for (Object d : delegates) {
                boolean isDuplicate = this.myDescriptors2Nodes.containsKey(d);
                if (isDuplicate) continue;
                FilteringNode n = new FilteringNode(node, d);
                this.myDescriptors2Nodes.put(d, n);
                nodes.add(n);
            }
            this.myNodesCache.put(node, nodes);
            for (FilteringNode n : nodes) {
                this.addToCache(n, false);
            }
            if (nodes.isEmpty()) {
                this.myLeaves.add(node);
            }
        }
    }

    public void refilter() {
        this.setUnknown(this.myRoot);
        for (FilteringNode node : this.myLeaves) {
            State state = this.getState(node);
            while (node != null && node.state != State.VISIBLE && node.state != state) {
                node.state = state;
                if ((node = node.getParentNode()) == null || state != State.HIDDEN) continue;
                state = this.getState(node);
            }
        }
    }

    private State getState(@NotNull FilteringNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ui/treeStructure/filtered/FilteringTreeStructure", "getState"));
        }
        return this.myFilter.shouldBeShowing(node.getDelegate()) ? State.VISIBLE : State.HIDDEN;
    }

    private void setUnknown(FilteringNode node) {
        if (node.state == State.UNKNOWN) {
            return;
        }
        node.state = State.UNKNOWN;
        List<FilteringNode> nodes = this.myNodesCache.get(node);
        if (nodes != null) {
            for (FilteringNode n : nodes) {
                this.setUnknown(n);
            }
        }
    }

    public FilteringNode getVisibleNodeFor(Object nodeObject) {
        return this.myDescriptors2Nodes.get(nodeObject);
    }

    @Override
    public FilteringNode getRootElement() {
        return this.myRoot;
    }

    @Override
    public Object[] getChildElements(Object element) {
        return ((FilteringNode)element).getChildren();
    }

    @Override
    public Object getParentElement(Object element) {
        return ((FilteringNode)element).getParent();
    }

    @Override
    public boolean isAlwaysLeaf(Object element) {
        return element instanceof FilteringNode && ((FilteringNode)element).isAlwaysLeaf();
    }

    @Override
    public boolean isToBuildChildrenInBackground(Object element) {
        return this.myBaseStructure.isToBuildChildrenInBackground(element);
    }

    @Override
    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        FilteringNode filteringNode = element instanceof FilteringNode ? (FilteringNode)element : new FilteringNode((SimpleNode)parentDescriptor, element);
        if (filteringNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/treeStructure/filtered/FilteringTreeStructure", "createDescriptor"));
        }
        return filteringNode;
    }

    @Override
    public void commit() {
        this.myBaseStructure.commit();
    }

    @Override
    public boolean hasSomethingToCommit() {
        return this.myBaseStructure.hasSomethingToCommit();
    }

    @Override
    @NotNull
    public ActionCallback asyncCommit() {
        ActionCallback actionCallback = this.myBaseStructure.asyncCommit();
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/treeStructure/filtered/FilteringTreeStructure", "asyncCommit"));
        }
        return actionCallback;
    }

    public FilteringNode createFilteringNode(Object delegate) {
        return new FilteringNode(null, delegate);
    }

    public class FilteringNode
    extends SimpleNode {
        private Object myDelegate;
        private State state;

        public FilteringNode(SimpleNode parent, Object delegate) {
            super(parent);
            this.state = State.VISIBLE;
            this.myDelegate = delegate;
        }

        public void setDelegate(Object delegate) {
            this.myDelegate = delegate;
        }

        public FilteringNode getParentNode() {
            return (FilteringNode)this.getParent();
        }

        public Object getDelegate() {
            return this.myDelegate;
        }

        public List<FilteringNode> children() {
            List nodes = (List)FilteringTreeStructure.this.myNodesCache.get(this);
            return nodes == null ? Collections.emptyList() : nodes;
        }

        @Override
        public String toString() {
            return String.valueOf(this.getDelegate());
        }

        @Override
        public boolean isContentHighlighted() {
            return this.myDelegate instanceof SimpleNode && ((SimpleNode)this.myDelegate).isContentHighlighted();
        }

        @Override
        public boolean isHighlightableContentNode(PresentableNodeDescriptor kid) {
            return this.myDelegate instanceof PresentableNodeDescriptor && ((PresentableNodeDescriptor)this.myDelegate).isHighlightableContentNode(kid);
        }

        @Override
        protected void updateFileStatus() {
        }

        @Override
        protected void doUpdate() {
            this.clearColoredText();
            if (this.myDelegate instanceof PresentableNodeDescriptor) {
                PresentableNodeDescriptor node = (PresentableNodeDescriptor)this.myDelegate;
                node.update();
                this.apply(node.getPresentation());
            } else if (this.myDelegate != null) {
                NodeDescriptor descriptor = FilteringTreeStructure.this.myBaseStructure.createDescriptor(this.myDelegate, this.getParentDescriptor());
                descriptor.update();
                this.setUniformIcon(descriptor.getIcon());
                this.setPlainText(this.myDelegate.toString());
            }
        }

        @Override
        public SimpleNode[] getChildren() {
            List nodes = (List)FilteringTreeStructure.this.myNodesCache.get(this);
            if (nodes == null) {
                return this.myDelegate instanceof SimpleNode ? (SimpleNode[])ContainerUtil.map((Object[])((SimpleNode)this.myDelegate).getChildren(), (Function)new Function<SimpleNode, SimpleNode>(){

                    public SimpleNode fun(SimpleNode node) {
                        return new FilteringNode(FilteringNode.this, node);
                    }
                }, (Object[])NO_CHILDREN) : NO_CHILDREN;
            }
            ArrayList<FilteringNode> result = new ArrayList<FilteringNode>();
            for (FilteringNode node : nodes) {
                if (node.state != State.VISIBLE) continue;
                result.add(node);
            }
            return result.toArray(new FilteringNode[result.size()]);
        }

        @Override
        public int getWeight() {
            if (this.getDelegate() instanceof SimpleNode) {
                return ((SimpleNode)this.getDelegate()).getWeight();
            }
            return super.getWeight();
        }

        @Override
        @NotNull
        public Object[] getEqualityObjects() {
            Object[] objectArray = new Object[]{this.myDelegate};
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/treeStructure/filtered/FilteringTreeStructure$FilteringNode", "getEqualityObjects"));
            }
            return objectArray;
        }

        @Override
        public boolean isAlwaysShowPlus() {
            if (this.myDelegate instanceof SimpleNode) {
                return ((SimpleNode)this.myDelegate).isAlwaysShowPlus();
            }
            return super.isAlwaysShowPlus();
        }

        @Override
        public boolean isAlwaysLeaf() {
            if (this.myDelegate instanceof SimpleNode) {
                return ((SimpleNode)this.myDelegate).isAlwaysLeaf();
            }
            return super.isAlwaysLeaf();
        }
    }

    protected static enum State {
        UNKNOWN,
        VISIBLE,
        HIDDEN;

    }
}

