/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileProcessor;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.refactoring.copy.CopyHandlerDelegateBase;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesCopyHandler
extends CopyHandlerDelegateBase {
    private static final Logger LOG = Logger.getInstance(PropertiesCopyHandler.class);

    public boolean canCopy(PsiElement[] elements, boolean fromUpdate) {
        String propertyName = null;
        for (PsiElement element : elements) {
            IProperty property = PropertiesImplUtil.getProperty(element);
            if (property == null) {
                return false;
            }
            if (propertyName == null) {
                propertyName = property.getKey();
                continue;
            }
            if (propertyName.equals(property.getKey())) continue;
            return false;
        }
        return propertyName != null;
    }

    public void doCopy(PsiElement[] elements, PsiDirectory defaultTargetDirectory) {
        IProperty representative = PropertiesImplUtil.getProperty(elements[0]);
        final String key = representative.getKey();
        if (key == null) {
            return;
        }
        ResourceBundle resourceBundle = representative.getPropertiesFile().getResourceBundle();
        List properties = ContainerUtil.mapNotNull(resourceBundle.getPropertiesFiles(), (Function)new NullableFunction<PropertiesFile, IProperty>(){

            @Nullable
            public IProperty fun(PropertiesFile propertiesFile) {
                return propertiesFile.findPropertyByKey(key);
            }
        });
        PropertiesCopyDialog dlg = new PropertiesCopyDialog(properties, resourceBundle);
        if (!properties.isEmpty() && dlg.showAndGet()) {
            String propertyNewName = dlg.getCurrentPropertyName();
            ResourceBundle destinationResourceBundle = dlg.getCurrentResourceBundle();
            PropertiesCopyHandler.copyPropertyToAnotherBundle(properties, propertyNewName, destinationResourceBundle);
        }
    }

    public void doClone(PsiElement element) {
    }

    private static void copyPropertyToAnotherBundle(@NotNull Collection<IProperty> properties, final @NotNull String newName, @NotNull ResourceBundle targetResourceBundle) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/lang/properties/editor/PropertiesCopyHandler", "copyPropertyToAnotherBundle"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/lang/properties/editor/PropertiesCopyHandler", "copyPropertyToAnotherBundle"));
        }
        if (targetResourceBundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetResourceBundle", "com/intellij/lang/properties/editor/PropertiesCopyHandler", "copyPropertyToAnotherBundle"));
        }
        HashMap propertiesFileMapping = new HashMap();
        for (IProperty property : properties) {
            PropertiesFile containingFile = property.getPropertiesFile();
            PropertiesFile matched = PropertiesCopyHandler.findWithMatchedSuffix(containingFile, targetResourceBundle);
            if (matched == null) continue;
            propertiesFileMapping.put(property, matched);
        }
        Project project = targetResourceBundle.getProject();
        if (properties.size() != propertiesFileMapping.size() && 1 == Messages.showYesNoDialog((Project)project, (String)"Source and target resource bundles properties files are not matched correctly. Copy properties anyway?", (String)"Resource Bundles Are not Matched", null)) {
            return;
        }
        if (!propertiesFileMapping.isEmpty()) {
            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable((Map)propertiesFileMapping, newName){
                final /* synthetic */ Map val$propertiesFileMapping;
                final /* synthetic */ String val$newName;
                {
                    this.val$propertiesFileMapping = map;
                    this.val$newName = string;
                }

                @Override
                public void run() {
                    if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)ContainerUtil.map(this.val$propertiesFileMapping.values(), (Function)new Function<PropertiesFile, PsiElement>(){

                        public PsiElement fun(PropertiesFile file) {
                            return file.getContainingFile();
                        }
                    }))) {
                        return;
                    }
                    for (Map.Entry entry : this.val$propertiesFileMapping.entrySet()) {
                        String value = ((IProperty)entry.getKey()).getValue();
                        PropertiesFile target = (PropertiesFile)entry.getValue();
                        target.addProperty(this.val$newName, value);
                    }
                }
            });
            IProperty representativeFromSourceBundle = (IProperty)ContainerUtil.getFirstItem(properties);
            LOG.assertTrue(representativeFromSourceBundle != null);
            ResourceBundle sourceResourceBundle = representativeFromSourceBundle.getPropertiesFile().getResourceBundle();
            if (sourceResourceBundle.equals(targetResourceBundle)) {
                DataManager.getInstance().getDataContextFromFocus().doWhenDone((Consumer)new Consumer<DataContext>(){

                    public void consume(DataContext context) {
                        FileEditor fileEditor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(context);
                        if (fileEditor instanceof ResourceBundleEditor) {
                            ResourceBundleEditor resourceBundleEditor = (ResourceBundleEditor)fileEditor;
                            resourceBundleEditor.updateTreeRoot();
                            resourceBundleEditor.selectProperty(newName);
                        }
                    }
                });
            } else {
                for (FileEditor editor : FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new ResourceBundleAsVirtualFile(targetResourceBundle), true)) {
                    ((ResourceBundleEditor)editor).updateTreeRoot();
                    ((ResourceBundleEditor)editor).selectProperty(newName);
                }
            }
        }
    }

    @Nullable
    private static PropertiesFile findWithMatchedSuffix(@NotNull PropertiesFile searchFile, @NotNull ResourceBundle resourceBundle) {
        if (searchFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchFile", "com/intellij/lang/properties/editor/PropertiesCopyHandler", "findWithMatchedSuffix"));
        }
        if (resourceBundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceBundle", "com/intellij/lang/properties/editor/PropertiesCopyHandler", "findWithMatchedSuffix"));
        }
        String targetSuffix = PropertiesCopyHandler.getPropertiesFileSuffix(searchFile, searchFile.getResourceBundle().getBaseName());
        String baseName = resourceBundle.getBaseName();
        for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
            if (!PropertiesCopyHandler.getPropertiesFileSuffix(propertiesFile, baseName).equals(targetSuffix)) continue;
            return propertiesFile;
        }
        return null;
    }

    @NotNull
    private static String getPropertiesFileSuffix(PropertiesFile searchFile, String baseName) {
        String suffix = FileUtil.getNameWithoutExtension((String)searchFile.getContainingFile().getName());
        String string = suffix = StringUtil.trimStart((String)suffix, (String)baseName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/PropertiesCopyHandler", "getPropertiesFileSuffix"));
        }
        return string;
    }

    private static class ResourceBundleAsFileSystemItem
    extends SyntheticFileSystemItem {
        private final ResourceBundle myResourceBundle;

        public ResourceBundleAsFileSystemItem(@NotNull ResourceBundle resourceBundle) {
            if (resourceBundle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceBundle", "com/intellij/lang/properties/editor/PropertiesCopyHandler$ResourceBundleAsFileSystemItem", "<init>"));
            }
            super(resourceBundle.getProject());
            this.myResourceBundle = resourceBundle;
        }

        public ResourceBundle getResourceBundle() {
            return this.myResourceBundle;
        }

        @NotNull
        public String getName() {
            String string = this.myResourceBundle.getBaseName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/PropertiesCopyHandler$ResourceBundleAsFileSystemItem", "getName"));
            }
            return string;
        }

        @Nullable
        public PsiFileSystemItem getParent() {
            return PsiManager.getInstance((Project)this.getProject()).findDirectory(this.myResourceBundle.getBaseDirectory());
        }

        public VirtualFile getVirtualFile() {
            return new ResourceBundleAsVirtualFile(this.myResourceBundle);
        }

        public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
            for (PropertiesFile propertiesFile : this.myResourceBundle.getPropertiesFiles()) {
                if (propertiesFile.getContainingFile().processChildren(processor)) continue;
                return false;
            }
            return true;
        }

        @Nullable
        public Icon getIcon(int flags) {
            return AllIcons.Nodes.ResourceBundle;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ResourceBundleAsFileSystemItem item = (ResourceBundleAsFileSystemItem)((Object)o);
            return this.myResourceBundle.equals(item.myResourceBundle);
        }

        public int hashCode() {
            return this.myResourceBundle.hashCode();
        }
    }

    private static class PropertiesCopyDialog
    extends DialogWrapper {
        @NotNull
        private final List<IProperty> myProperties;
        @NotNull
        private ResourceBundle myCurrentResourceBundle;
        private String myCurrentPropertyName;
        @NotNull
        private final Project myProject;
        private JBTextField myPropertyNameTextField;

        protected PropertiesCopyDialog(@NotNull List<IProperty> properties, @NotNull ResourceBundle currentResourceBundle) {
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/lang/properties/editor/PropertiesCopyHandler$PropertiesCopyDialog", "<init>"));
            }
            if (currentResourceBundle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentResourceBundle", "com/intellij/lang/properties/editor/PropertiesCopyHandler$PropertiesCopyDialog", "<init>"));
            }
            super(currentResourceBundle.getProject());
            this.myProperties = properties;
            this.myCurrentResourceBundle = currentResourceBundle;
            this.myCurrentPropertyName = ((IProperty)ContainerUtil.getFirstItem(properties)).getName();
            this.myProject = currentResourceBundle.getProject();
            this.init();
            this.initValidation();
        }

        @Nullable
        protected ValidationInfo doValidate() {
            if (StringUtil.isEmpty((String)this.myCurrentPropertyName)) {
                return new ValidationInfo("Property name must be not empty");
            }
            return PropertiesUtil.containsProperty(this.myCurrentResourceBundle, this.myCurrentPropertyName) ? new ValidationInfo(String.format("Property with name '%s' is already exist", this.myCurrentPropertyName)) : null;
        }

        public String getCurrentPropertyName() {
            return this.myCurrentPropertyName;
        }

        @NotNull
        public ResourceBundle getCurrentResourceBundle() {
            ResourceBundle resourceBundle = this.myCurrentResourceBundle;
            if (resourceBundle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/PropertiesCopyHandler$PropertiesCopyDialog", "getCurrentResourceBundle"));
            }
            return resourceBundle;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JLabel informationalLabel = new JLabel();
            informationalLabel.setText("Copy property " + ((IProperty)ContainerUtil.getFirstItem(this.myProperties)).getName());
            informationalLabel.setFont(informationalLabel.getFont().deriveFont(1));
            final HashSet resourceBundles = new HashSet();
            PropertiesReferenceManager.getInstance(this.myProject).processAllPropertiesFiles(new PropertiesFileProcessor(){

                @Override
                public boolean process(String baseName, PropertiesFile propertiesFile) {
                    resourceBundles.add(propertiesFile.getResourceBundle());
                    return true;
                }
            });
            List resourceBundleList = ContainerUtil.filter(resourceBundles, (Condition)new Condition<ResourceBundle>(){

                public boolean value(ResourceBundle resourceBundle) {
                    return resourceBundle.getBaseDirectory() != null;
                }
            });
            Collections.sort(resourceBundleList, new Comparator<ResourceBundle>(){

                @Override
                public int compare(ResourceBundle o1, ResourceBundle o2) {
                    return Comparing.compare((Comparable)((Object)o1.getBaseName()), (Comparable)((Object)o2.getBaseName()));
                }
            });
            List resourceBundlesAsFileSystemItems = ContainerUtil.map((Collection)resourceBundleList, (Function)new Function<ResourceBundle, PsiFileSystemItem>(){

                public PsiFileSystemItem fun(ResourceBundle resourceBundle) {
                    return new ResourceBundleAsFileSystemItem(resourceBundle);
                }
            });
            final ComboBoxWithWidePopup resourceBundleComboBox = new ComboBoxWithWidePopup((Object[])resourceBundlesAsFileSystemItems.toArray(new PsiFileSystemItem[resourceBundlesAsFileSystemItems.size()]));
            resourceBundleComboBox.setRenderer((ListCellRenderer)new GotoFileCellRenderer(500){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    UIUtil.setBackgroundRecursively((Component)component, (Color)(isSelected ? UIUtil.getListSelectionBackground() : resourceBundleComboBox.getBackground()));
                    return component;
                }
            });
            resourceBundleComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(@NotNull ItemEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/properties/editor/PropertiesCopyHandler$PropertiesCopyDialog$6", "itemStateChanged"));
                    }
                    PropertiesCopyDialog.this.myCurrentResourceBundle = ((ResourceBundleAsFileSystemItem)((Object)e.getItem())).getResourceBundle();
                }
            });
            resourceBundleComboBox.setSelectedItem((Object)new ResourceBundleAsFileSystemItem(this.myCurrentResourceBundle));
            this.myPropertyNameTextField = new JBTextField(((IProperty)ContainerUtil.getFirstItem(this.myProperties)).getKey());
            this.myPropertyNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    PropertiesCopyDialog.this.myCurrentPropertyName = PropertiesCopyDialog.this.myPropertyNameTextField.getText();
                }
            });
            return FormBuilder.createFormBuilder().addComponent((JComponent)informationalLabel).addLabeledComponent("&New name:", (JComponent)this.myPropertyNameTextField, 12).addLabeledComponent("&Destination resource bundle:", (JComponent)resourceBundleComboBox).getPanel();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myPropertyNameTextField;
        }
    }
}

