/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.PropertyManipulator;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyStub;
import com.intellij.lang.properties.psi.impl.PropertiesStubElementImpl;
import com.intellij.lang.properties.psi.impl.PropertyImplEscaper;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyImpl
extends PropertiesStubElementImpl<PropertyStub>
implements Property,
PsiLanguageInjectionHost {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.properties.psi.impl.PropertyImpl");

    public PropertyImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/properties/psi/impl/PropertyImpl", "<init>"));
        }
        super(node);
    }

    public PropertyImpl(PropertyStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public String toString() {
        return "Property{ key = " + this.getKey() + ", value = " + this.getValue() + "}";
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/properties/psi/impl/PropertyImpl", "setName"));
        }
        PropertyImpl property = (PropertyImpl)PropertiesElementFactory.createProperty(this.getProject(), name, "xxx");
        ASTNode keyNode = this.getKeyNode();
        ASTNode newKeyNode = property.getKeyNode();
        LOG.assertTrue(newKeyNode != null);
        if (keyNode == null) {
            this.getNode().addChild(newKeyNode);
        } else {
            this.getNode().replaceChild(keyNode, newKeyNode);
        }
        return this;
    }

    @Override
    public void setValue(@NotNull String value) throws IncorrectOperationException {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/properties/psi/impl/PropertyImpl", "setValue"));
        }
        ASTNode node = this.getValueNode();
        PropertyImpl property = (PropertyImpl)PropertiesElementFactory.createProperty(this.getProject(), "xxx", value);
        ASTNode valueNode = property.getValueNode();
        if (node == null) {
            if (valueNode != null) {
                this.getNode().addChild(valueNode);
            }
        } else if (valueNode == null) {
            this.getNode().removeChild(node);
        } else {
            this.getNode().replaceChild(node, valueNode);
        }
    }

    @Override
    public String getName() {
        return this.getUnescapedKey();
    }

    @Override
    public String getKey() {
        PropertyStub stub = (PropertyStub)this.getStub();
        if (stub != null) {
            return stub.getKey();
        }
        ASTNode node = this.getKeyNode();
        if (node == null) {
            return null;
        }
        return node.getText();
    }

    @Nullable
    public ASTNode getKeyNode() {
        return this.getNode().findChildByType(PropertiesTokenTypes.KEY_CHARACTERS);
    }

    @Nullable
    public ASTNode getValueNode() {
        return this.getNode().findChildByType(PropertiesTokenTypes.VALUE_CHARACTERS);
    }

    @Override
    public String getValue() {
        ASTNode node = this.getValueNode();
        if (node == null) {
            return "";
        }
        return node.getText();
    }

    @Override
    @Nullable
    public String getUnescapedValue() {
        return PropertyImpl.unescape(this.getValue());
    }

    public static String unescape(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        PropertyImpl.parseCharacters(s, sb, null);
        return sb.toString();
    }

    public static boolean parseCharacters(String s, StringBuilder outChars, @Nullable int[] sourceOffsets) {
        assert (sourceOffsets == null || sourceOffsets.length == s.length() + 1);
        int off = 0;
        int len = s.length();
        boolean result = true;
        int outOffset = outChars.length();
        while (off < len) {
            char aChar = s.charAt(off++);
            if (sourceOffsets != null) {
                sourceOffsets[outChars.length() - outOffset] = off - 1;
                sourceOffsets[outChars.length() + 1 - outOffset] = off;
            }
            if (aChar == '\\') {
                if ((aChar = s.charAt(off++)) == 'u') {
                    int value = 0;
                    boolean error = false;
                    block6: for (int i = 0; i < 4 && off < s.length(); ++i) {
                        aChar = s.charAt(off++);
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                outChars.append("\\u");
                                int start = off - i - 1;
                                int end = start + 4 < s.length() ? start + 4 : s.length();
                                outChars.append(s, start, end);
                                i = 4;
                                error = true;
                                off = end;
                            }
                        }
                    }
                    if (!error) {
                        outChars.append((char)value);
                    } else {
                        result = false;
                    }
                } else if (aChar == '\n') {
                    while (off < len && (s.charAt(off) == ' ' || s.charAt(off) == '\t')) {
                        ++off;
                    }
                } else if (aChar == 't') {
                    outChars.append('\t');
                } else if (aChar == 'r') {
                    outChars.append('\r');
                } else if (aChar == 'n') {
                    outChars.append('\n');
                } else if (aChar == 'f') {
                    outChars.append('\f');
                } else {
                    outChars.append(aChar);
                }
            } else {
                outChars.append(aChar);
            }
            if (sourceOffsets == null) continue;
            sourceOffsets[outChars.length() - outOffset] = off;
        }
        return result;
    }

    @Nullable
    public static TextRange trailingSpaces(String s) {
        if (s == null) {
            return null;
        }
        int off = 0;
        int len = s.length();
        int startSpaces = -1;
        while (off < len) {
            char aChar;
            if ((aChar = s.charAt(off++)) == '\\') {
                if (startSpaces == -1) {
                    startSpaces = off - 1;
                }
                if ((aChar = s.charAt(off++)) == 'u') {
                    int value = 0;
                    boolean error = false;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = off < s.length() ? s.charAt(off++) : (char)'\u0000';
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                int start = off - i - 1;
                                int end = start + 4 < s.length() ? start + 4 : s.length();
                                i = 4;
                                error = true;
                                off = end;
                                startSpaces = -1;
                            }
                        }
                    }
                    if (error) continue;
                    if (Character.isWhitespace(value)) {
                        if (startSpaces != -1) continue;
                        startSpaces = off - 1;
                        continue;
                    }
                    startSpaces = -1;
                    continue;
                }
                if (aChar == '\n') {
                    while (off < len && (s.charAt(off) == ' ' || s.charAt(off) == '\t')) {
                        ++off;
                    }
                    continue;
                }
                if (aChar == 't') {
                    if (startSpaces != -1) continue;
                    startSpaces = off;
                    continue;
                }
                if (aChar == 'r') {
                    if (startSpaces != -1) continue;
                    startSpaces = off;
                    continue;
                }
                if (aChar == 'n') {
                    if (startSpaces != -1) continue;
                    startSpaces = off;
                    continue;
                }
                if (aChar == 'f') {
                    if (startSpaces != -1) continue;
                    startSpaces = off;
                    continue;
                }
                if (Character.isWhitespace(aChar)) {
                    if (startSpaces != -1) continue;
                    startSpaces = off - 1;
                    continue;
                }
                startSpaces = -1;
                continue;
            }
            if (Character.isWhitespace(aChar)) {
                if (startSpaces != -1) continue;
                startSpaces = off - 1;
                continue;
            }
            startSpaces = -1;
        }
        return startSpaces == -1 ? null : new TextRange(startSpaces, len);
    }

    @Override
    @Nullable
    public String getUnescapedKey() {
        return PropertyImpl.unescape(this.getKey());
    }

    public Icon getIcon(int flags) {
        return PlatformIcons.PROPERTY_ICON;
    }

    public void delete() throws IncorrectOperationException {
        ASTNode parentNode = this.getParent().getNode();
        assert (parentNode != null);
        ASTNode node = this.getNode();
        ASTNode prev = node.getTreePrev();
        ASTNode next = node.getTreeNext();
        parentNode.removeChild(node);
        if ((prev == null || prev.getElementType() == TokenType.WHITE_SPACE) && next != null && next.getElementType() == TokenType.WHITE_SPACE) {
            parentNode.removeChild(next);
        }
    }

    @Override
    public PropertiesFile getPropertiesFile() {
        return (PropertiesFile)super.getContainingFile();
    }

    @Override
    public String getDocCommentText() {
        StringBuilder text = new StringBuilder();
        for (PsiElement doc = this.getPrevSibling(); doc != null; doc = doc.getPrevSibling()) {
            if (doc instanceof PsiWhiteSpace) {
                doc = doc.getPrevSibling();
            }
            if (!(doc instanceof PsiComment)) break;
            if (text.length() != 0) {
                text.insert(0, "\n");
            }
            String comment = doc.getText();
            text.insert(0, comment);
        }
        if (text.length() == 0) {
            return null;
        }
        return text.toString();
    }

    @Override
    @NotNull
    public PsiElement getPsiElement() {
        PropertyImpl propertyImpl = this;
        if (propertyImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/impl/PropertyImpl", "getPsiElement"));
        }
        return propertyImpl;
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.getProject());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/impl/PropertyImpl", "getUseScope"));
        }
        return globalSearchScope;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return PropertyImpl.this.getName();
            }

            public String getLocationString() {
                return PropertyImpl.this.getPropertiesFile().getName();
            }

            public Icon getIcon(boolean open) {
                return null;
            }
        };
    }

    public boolean isValidHost() {
        return true;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/properties/psi/impl/PropertyImpl", "updateText"));
        }
        return (PsiLanguageInjectionHost)new PropertyManipulator().handleContentChange((PsiElement)this, text);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        PropertyImplEscaper propertyImplEscaper = new PropertyImplEscaper(this);
        if (propertyImplEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/impl/PropertyImpl", "createLiteralTextEscaper"));
        }
        return propertyImplEscaper;
    }

    public char getKeyValueDelimiter() {
        PsiElement delimiter = this.findChildByType(PropertiesTokenTypes.KEY_VALUE_SEPARATOR);
        if (delimiter == null) {
            return ' ';
        }
        String text = delimiter.getText();
        LOG.assertTrue(text.length() == 1);
        return text.charAt(0);
    }

    public void replaceKeyValueDelimiterWithDefault() {
        PropertyImpl property = (PropertyImpl)PropertiesElementFactory.createProperty(this.getProject(), "yyy", "xxx");
        ASTNode oldDelimiter = this.getNode().findChildByType(PropertiesTokenTypes.KEY_VALUE_SEPARATOR);
        LOG.assertTrue(oldDelimiter != null);
        ASTNode newDelimiter = property.getNode().findChildByType(PropertiesTokenTypes.KEY_VALUE_SEPARATOR);
        LOG.assertTrue(newDelimiter != null);
        this.getNode().replaceChild(oldDelimiter, newDelimiter);
    }
}

