/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.JavaCompileOptions;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.Variant;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ProxyUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class AndroidGradleModel
implements AndroidModel,
Serializable {
    public static final String EXPLODED_BUNDLES = "exploded-bundles";
    public static final String EXPLODED_AAR = "exploded-aar";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getInstance(AndroidGradleModel.class);
    @NotNull
    private ProjectSystemId myProjectSystemId;
    @NotNull
    private String myModuleName;
    @NotNull
    private File myRootDirPath;
    @NotNull
    private AndroidProject myAndroidProject;
    @Nullable
    private transient CountDownLatch myProxyAndroidProjectLatch;
    @Nullable
    private AndroidProject myProxyAndroidProject;
    @NotNull
    private String mySelectedVariantName;
    private transient VirtualFile myRootDir;
    @NotNull
    private String mySelectedTestArtifactName;
    @Nullable
    private Boolean myOverridesManifestPackage;
    @Nullable
    private transient AndroidVersion myMinSdkVersion;
    @NotNull
    private Map<String, BuildTypeContainer> myBuildTypesByName;
    @NotNull
    private Map<String, ProductFlavorContainer> myProductFlavorsByName;
    @NotNull
    private Map<String, Variant> myVariantsByName;
    @NotNull
    private Set<File> myExtraGeneratedSourceFolders;
    private static final AndroidVersion NOT_SPECIFIED = new AndroidVersion(0, null);

    public AndroidGradleModel(@NotNull ProjectSystemId projectSystemId, @NotNull String moduleName, @NotNull File rootDirPath, @NotNull AndroidProject androidProject, @NotNull String selectedVariantName, @NotNull String selectedTestArtifactName) {
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/android/tools/idea/gradle/AndroidGradleModel", "<init>"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/AndroidGradleModel", "<init>"));
        }
        if (rootDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDirPath", "com/android/tools/idea/gradle/AndroidGradleModel", "<init>"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/AndroidGradleModel", "<init>"));
        }
        if (selectedVariantName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedVariantName", "com/android/tools/idea/gradle/AndroidGradleModel", "<init>"));
        }
        if (selectedTestArtifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedTestArtifactName", "com/android/tools/idea/gradle/AndroidGradleModel", "<init>"));
        }
        this.myBuildTypesByName = Maps.newHashMap();
        this.myProductFlavorsByName = Maps.newHashMap();
        this.myVariantsByName = Maps.newHashMap();
        this.myExtraGeneratedSourceFolders = Sets.newHashSet();
        this.myProjectSystemId = projectSystemId;
        this.myModuleName = moduleName;
        this.myRootDirPath = rootDirPath;
        this.myAndroidProject = androidProject;
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                AndroidGradleModel.this.myProxyAndroidProjectLatch = new CountDownLatch(1);
                AndroidGradleModel.this.myProxyAndroidProject = ProxyUtil.reproxy(AndroidProject.class, AndroidGradleModel.this.myAndroidProject);
                AndroidGradleModel.this.myProxyAndroidProjectLatch.countDown();
            }
        });
        this.populateBuildTypesByName();
        this.populateProductFlavorsByName();
        this.populateVariantsByName();
        this.setSelectedVariantName(selectedVariantName);
        this.setSelectedTestArtifactName(selectedTestArtifactName);
    }

    private void populateBuildTypesByName() {
        for (BuildTypeContainer container : this.myAndroidProject.getBuildTypes()) {
            String name = container.getBuildType().getName();
            this.myBuildTypesByName.put(name, container);
        }
    }

    private void populateProductFlavorsByName() {
        for (ProductFlavorContainer container : this.myAndroidProject.getProductFlavors()) {
            String name = container.getProductFlavor().getName();
            this.myProductFlavorsByName.put(name, container);
        }
    }

    private void populateVariantsByName() {
        for (Variant variant : this.myAndroidProject.getVariants()) {
            this.myVariantsByName.put(variant.getName(), variant);
        }
    }

    @NotNull
    public AndroidArtifact getMainArtifact() {
        AndroidArtifact androidArtifact = this.getSelectedVariant().getMainArtifact();
        if (androidArtifact == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getMainArtifact"));
        }
        return androidArtifact;
    }

    @Override
    @NotNull
    public SourceProvider getDefaultSourceProvider() {
        SourceProvider sourceProvider = this.getAndroidProject().getDefaultConfig().getSourceProvider();
        if (sourceProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getDefaultSourceProvider"));
        }
        return sourceProvider;
    }

    @Override
    @NotNull
    public List<SourceProvider> getActiveSourceProviders() {
        List<SourceProvider> list = this.getMainSourceProviders(this.mySelectedVariantName);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getActiveSourceProviders"));
        }
        return list;
    }

    @NotNull
    public List<SourceProvider> getMainSourceProviders(@NotNull String variantName) {
        if (variantName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantName", "com/android/tools/idea/gradle/AndroidGradleModel", "getMainSourceProviders"));
        }
        Variant variant = this.myVariantsByName.get(variantName);
        if (variant == null) {
            LOG.error("Unknown variant name '" + variantName + "' found in the module '" + this.myModuleName + "'");
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getMainSourceProviders"));
            }
            return immutableList;
        }
        ArrayList providers = Lists.newArrayList();
        providers.add(this.getDefaultSourceProvider());
        for (String flavor : variant.getProductFlavors()) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.add(productFlavor.getSourceProvider());
        }
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        SourceProvider multiFlavorProvider = mainArtifact.getMultiFlavorSourceProvider();
        if (multiFlavorProvider != null) {
            providers.add(multiFlavorProvider);
        }
        BuildTypeContainer buildType = this.findBuildType(variant.getBuildType());
        assert (buildType != null);
        providers.add(buildType.getSourceProvider());
        SourceProvider variantProvider = mainArtifact.getVariantSourceProvider();
        if (variantProvider != null) {
            providers.add(variantProvider);
        }
        ArrayList arrayList = providers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getMainSourceProviders"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<SourceProvider> getTestSourceProviders() {
        List<SourceProvider> list = this.getTestSourceProviders(this.mySelectedVariantName, this.mySelectedTestArtifactName);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getTestSourceProviders"));
        }
        return list;
    }

    @NotNull
    public List<SourceProvider> getTestSourceProviders(@NotNull String variantName, @NotNull String testArtifactName) {
        if (variantName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantName", "com/android/tools/idea/gradle/AndroidGradleModel", "getTestSourceProviders"));
        }
        if (testArtifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testArtifactName", "com/android/tools/idea/gradle/AndroidGradleModel", "getTestSourceProviders"));
        }
        if (!testArtifactName.equals("_android_test_") && !testArtifactName.equals("_unit_test_")) {
            LOG.error("Unknown artifact name '" + testArtifactName + "' found in the module '" + this.myModuleName + "'");
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getTestSourceProviders"));
            }
            return immutableList;
        }
        Variant variant = this.myVariantsByName.get(variantName);
        if (variant == null) {
            LOG.error("Unknown variant name '" + variantName + "' found in the module '" + this.myModuleName + "'");
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getTestSourceProviders"));
            }
            return immutableList;
        }
        ArrayList providers = Lists.newArrayList();
        Collection extraSourceProviders = this.getAndroidProject().getDefaultConfig().getExtraSourceProviders();
        providers.addAll(this.getSourceProvidersForTestArtifact(extraSourceProviders, testArtifactName));
        for (String flavor : variant.getProductFlavors()) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.addAll(this.getSourceProvidersForTestArtifact(productFlavor.getExtraSourceProviders(), testArtifactName));
        }
        BuildTypeContainer buildType = this.findBuildType(variant.getBuildType());
        assert (buildType != null);
        providers.addAll(this.getSourceProvidersForTestArtifact(buildType.getExtraSourceProviders(), testArtifactName));
        ArrayList arrayList = providers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getTestSourceProviders"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<SourceProvider> getAllSourceProviders() {
        Collection variants = this.myAndroidProject.getVariants();
        ArrayList providers = Lists.newArrayList();
        providers.add(this.getDefaultSourceProvider());
        Collection flavors = this.myAndroidProject.getProductFlavors();
        for (ProductFlavorContainer pfc : flavors) {
            providers.add(pfc.getSourceProvider());
        }
        for (Variant v : variants) {
            SourceProvider provider = v.getMainArtifact().getMultiFlavorSourceProvider();
            if (provider == null) continue;
            providers.add(provider);
        }
        Collection buildTypes = this.myAndroidProject.getBuildTypes();
        for (BuildTypeContainer btc : buildTypes) {
            providers.add(btc.getSourceProvider());
        }
        for (Variant v : variants) {
            SourceProvider provider = v.getMainArtifact().getVariantSourceProvider();
            if (provider == null) continue;
            providers.add(provider);
        }
        ArrayList arrayList = providers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getAllSourceProviders"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getApplicationId() {
        String string = this.getSelectedVariant().getMainArtifact().getApplicationId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getApplicationId"));
        }
        return string;
    }

    @Override
    @NotNull
    public Set<String> getAllApplicationIds() {
        HashSet ids = Sets.newHashSet();
        for (Variant v : this.myAndroidProject.getVariants()) {
            String applicationId = v.getMergedFlavor().getApplicationId();
            if (applicationId == null) continue;
            ids.add(applicationId);
        }
        HashSet hashSet = ids;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getAllApplicationIds"));
        }
        return hashSet;
    }

    @Override
    public Boolean isDebuggable() {
        BuildTypeContainer buildTypeContainer = this.findBuildType(this.getSelectedVariant().getBuildType());
        if (buildTypeContainer != null) {
            return buildTypeContainer.getBuildType().isDebuggable();
        }
        return null;
    }

    @Override
    @Nullable
    public AndroidVersion getMinSdkVersion() {
        if (this.myMinSdkVersion == null) {
            ApiVersion minSdkVersion = this.getSelectedVariant().getMergedFlavor().getMinSdkVersion();
            if (minSdkVersion != null && minSdkVersion.getCodename() != null) {
                ApiVersion defaultConfigVersion = this.getAndroidProject().getDefaultConfig().getProductFlavor().getMinSdkVersion();
                if (defaultConfigVersion != null) {
                    minSdkVersion = defaultConfigVersion;
                }
                List flavors = this.getSelectedVariant().getProductFlavors();
                for (String flavor : flavors) {
                    ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
                    assert (productFlavor != null);
                    ApiVersion flavorVersion = productFlavor.getProductFlavor().getMinSdkVersion();
                    if (flavorVersion == null) continue;
                    minSdkVersion = flavorVersion;
                    break;
                }
            }
            this.myMinSdkVersion = minSdkVersion != null ? LintUtils.convertVersion((ApiVersion)minSdkVersion, null) : NOT_SPECIFIED;
        }
        return this.myMinSdkVersion != NOT_SPECIFIED ? this.myMinSdkVersion : null;
    }

    @Override
    @Nullable
    public AndroidVersion getRuntimeMinSdkVersion() {
        ApiVersion minSdkVersion = this.getSelectedVariant().getMergedFlavor().getMinSdkVersion();
        if (minSdkVersion != null) {
            return new AndroidVersion(minSdkVersion.getApiLevel(), minSdkVersion.getCodename());
        }
        return null;
    }

    @Override
    @Nullable
    public AndroidVersion getTargetSdkVersion() {
        ApiVersion targetSdkVersion = this.getSelectedVariant().getMergedFlavor().getTargetSdkVersion();
        if (targetSdkVersion != null) {
            return new AndroidVersion(targetSdkVersion.getApiLevel(), targetSdkVersion.getCodename());
        }
        return null;
    }

    @Override
    @Nullable
    public Integer getVersionCode() {
        Variant variant = this.getSelectedVariant();
        ProductFlavor flavor = variant.getMergedFlavor();
        return flavor.getVersionCode();
    }

    @NotNull
    public ProjectSystemId getProjectSystemId() {
        ProjectSystemId projectSystemId = this.myProjectSystemId;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getProjectSystemId"));
        }
        return projectSystemId;
    }

    @Nullable
    public BuildTypeContainer findBuildType(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/AndroidGradleModel", "findBuildType"));
        }
        return this.myBuildTypesByName.get(name);
    }

    @NotNull
    public Set<String> getBuildTypes() {
        Set<String> set = this.myBuildTypesByName.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getBuildTypes"));
        }
        return set;
    }

    @NotNull
    public Set<String> getProductFlavors() {
        Set<String> set = this.myProductFlavorsByName.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getProductFlavors"));
        }
        return set;
    }

    @Nullable
    public ProductFlavorContainer findProductFlavor(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/AndroidGradleModel", "findProductFlavor"));
        }
        return this.myProductFlavorsByName.get(name);
    }

    @Nullable
    public BaseArtifact findSelectedTestArtifact(@NotNull Variant variant) {
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/AndroidGradleModel", "findSelectedTestArtifact"));
        }
        BaseArtifact artifact = this.getBaseArtifact(variant.getExtraAndroidArtifacts());
        if (artifact != null) {
            return artifact;
        }
        return this.getBaseArtifact(variant.getExtraJavaArtifacts());
    }

    @Nullable
    private BaseArtifact getBaseArtifact(@NotNull Iterable<? extends BaseArtifact> artifacts) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/android/tools/idea/gradle/AndroidGradleModel", "getBaseArtifact"));
        }
        for (BaseArtifact baseArtifact : artifacts) {
            if (!this.getSelectedTestArtifactName().equals(baseArtifact.getName())) continue;
            return baseArtifact;
        }
        return null;
    }

    @Nullable
    public BaseArtifact findSelectedTestArtifactInSelectedVariant() {
        return this.findSelectedTestArtifact(this.getSelectedVariant());
    }

    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getModuleName"));
        }
        return string;
    }

    @Override
    @NotNull
    public File getRootDirPath() {
        File file = this.myRootDirPath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getRootDirPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public VirtualFile getRootDir() {
        if (this.myRootDir == null) {
            VirtualFile found = VfsUtil.findFileByIoFile((File)this.myRootDirPath, (boolean)true);
            assert (found != null);
            this.myRootDir = found;
        }
        VirtualFile virtualFile = this.myRootDir;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getRootDir"));
        }
        return virtualFile;
    }

    @Override
    public boolean isGenerated(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/AndroidGradleModel", "isGenerated"));
        }
        VirtualFile buildFolder = VfsUtil.findFileByIoFile((File)this.myAndroidProject.getBuildFolder(), (boolean)false);
        return buildFolder != null && VfsUtilCore.isAncestor((VirtualFile)buildFolder, (VirtualFile)file, (boolean)false);
    }

    @NotNull
    public AndroidProject getAndroidProject() {
        AndroidProject androidProject = this.myAndroidProject;
        if (androidProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getAndroidProject"));
        }
        return androidProject;
    }

    @NotNull
    AndroidProject getProxyAndroidProject() {
        this.waitForAndroidProjectProxy();
        assert (this.myProxyAndroidProject != null);
        AndroidProject androidProject = this.myProxyAndroidProject;
        if (androidProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getProxyAndroidProject"));
        }
        return androidProject;
    }

    @NotNull
    public Variant getSelectedVariant() {
        Variant selected = this.myVariantsByName.get(this.mySelectedVariantName);
        assert (selected != null);
        Variant variant = selected;
        if (variant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getSelectedVariant"));
        }
        return variant;
    }

    public void setSelectedVariantName(@NotNull String name) {
        String newVariantName;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/AndroidGradleModel", "setSelectedVariantName"));
        }
        Collection<String> variantNames = this.getVariantNames();
        if (variantNames.contains(name)) {
            newVariantName = name;
        } else {
            ArrayList sorted = Lists.newArrayList(variantNames);
            Collections.sort(sorted);
            newVariantName = (String)sorted.get(0);
        }
        this.mySelectedVariantName = newVariantName;
        this.myOverridesManifestPackage = null;
        this.myMinSdkVersion = null;
    }

    public void setSelectedTestArtifactName(@NotNull String selectedTestArtifactName) {
        if (selectedTestArtifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedTestArtifactName", "com/android/tools/idea/gradle/AndroidGradleModel", "setSelectedTestArtifactName"));
        }
        assert (selectedTestArtifactName.equals("_android_test_") || selectedTestArtifactName.equals("_unit_test_"));
        this.mySelectedTestArtifactName = selectedTestArtifactName;
    }

    @NotNull
    public String getSelectedTestArtifactName() {
        String string = this.mySelectedTestArtifactName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getSelectedTestArtifactName"));
        }
        return string;
    }

    @NotNull
    public Collection<SourceProvider> getSourceProvidersForSelectedTestArtifact(@NotNull Iterable<SourceProviderContainer> containers) {
        if (containers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containers", "com/android/tools/idea/gradle/AndroidGradleModel", "getSourceProvidersForSelectedTestArtifact"));
        }
        Collection<SourceProvider> collection = this.getSourceProvidersForTestArtifact(containers, this.mySelectedTestArtifactName);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getSourceProvidersForSelectedTestArtifact"));
        }
        return collection;
    }

    @NotNull
    public Collection<SourceProvider> getSourceProvidersForTestArtifact(@NotNull Iterable<SourceProviderContainer> containers, @NotNull String testArtifactName) {
        if (containers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containers", "com/android/tools/idea/gradle/AndroidGradleModel", "getSourceProvidersForTestArtifact"));
        }
        if (testArtifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testArtifactName", "com/android/tools/idea/gradle/AndroidGradleModel", "getSourceProvidersForTestArtifact"));
        }
        HashSet providers = Sets.newHashSet();
        for (SourceProviderContainer container : containers) {
            if (!testArtifactName.equals(container.getArtifactName())) continue;
            providers.add(container.getSourceProvider());
        }
        HashSet hashSet = providers;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getSourceProvidersForTestArtifact"));
        }
        return hashSet;
    }

    @NotNull
    public Collection<String> getBuildTypeNames() {
        Set<String> set = this.myBuildTypesByName.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getBuildTypeNames"));
        }
        return set;
    }

    @NotNull
    public Collection<String> getProductFlavorNames() {
        Set<String> set = this.myProductFlavorsByName.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getProductFlavorNames"));
        }
        return set;
    }

    @NotNull
    public Collection<String> getVariantNames() {
        Set<String> set = this.myVariantsByName.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getVariantNames"));
        }
        return set;
    }

    @Nullable
    public LanguageLevel getJavaLanguageLevel() {
        JavaCompileOptions compileOptions = this.myAndroidProject.getJavaCompileOptions();
        String sourceCompatibility = compileOptions.getSourceCompatibility();
        return LanguageLevel.parse((String)sourceCompatibility);
    }

    public boolean isLibrary() {
        return this.getAndroidProject().isLibrary();
    }

    @Override
    public boolean overridesManifestPackage() {
        if (this.myOverridesManifestPackage == null) {
            this.myOverridesManifestPackage = this.getAndroidProject().getDefaultConfig().getProductFlavor().getApplicationId() != null;
            Variant variant = this.getSelectedVariant();
            List flavors = variant.getProductFlavors();
            for (String flavor : flavors) {
                ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
                assert (productFlavor != null);
                if (productFlavor.getProductFlavor().getApplicationId() == null) continue;
                this.myOverridesManifestPackage = true;
                break;
            }
        }
        return this.myOverridesManifestPackage;
    }

    public void registerExtraGeneratedSourceFolder(@NotNull File folderPath) {
        if (folderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderPath", "com/android/tools/idea/gradle/AndroidGradleModel", "registerExtraGeneratedSourceFolder"));
        }
        this.myExtraGeneratedSourceFolders.add(folderPath);
    }

    @NotNull
    public List<File> getExcludedFolderPaths() {
        File buildFolderPath = this.getAndroidProject().getBuildFolder();
        ArrayList excludedFolderPaths = Lists.newArrayList();
        if (buildFolderPath.isDirectory()) {
            for (File folderPath : FileUtil.notNullize((File[])buildFolderPath.listFiles())) {
                String folderName = folderPath.getName();
                if (folderName.equals("intermediates") || folderName.equals("generated")) continue;
                excludedFolderPaths.add(folderPath);
            }
            File intermediates = new File(buildFolderPath, "intermediates");
            if (intermediates.isDirectory()) {
                for (File folderPath : FileUtil.notNullize((File[])intermediates.listFiles())) {
                    String folderName = folderPath.getName();
                    if (folderName.equals(EXPLODED_AAR) || folderName.equals(EXPLODED_BUNDLES) || folderName.equals("manifest")) continue;
                    excludedFolderPaths.add(folderPath);
                }
            }
        } else {
            excludedFolderPaths.add(new File(buildFolderPath, "outputs"));
            excludedFolderPaths.add(new File(buildFolderPath, "tmp"));
        }
        ArrayList arrayList = excludedFolderPaths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getExcludedFolderPaths"));
        }
        return arrayList;
    }

    @NotNull
    public File[] getExtraGeneratedSourceFolders() {
        File[] fileArray = this.myExtraGeneratedSourceFolders.toArray(new File[this.myExtraGeneratedSourceFolders.size()]);
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getExtraGeneratedSourceFolders"));
        }
        return fileArray;
    }

    @Nullable
    public Collection<SyncIssue> getSyncIssues() {
        if (this.supportsIssueReporting()) {
            return this.myAndroidProject.getSyncIssues();
        }
        return null;
    }

    private boolean supportsIssueReporting() {
        FullRevision modelVersion;
        String original = this.myAndroidProject.getModelVersion();
        try {
            modelVersion = FullRevision.parseRevision((String)original);
        }
        catch (NumberFormatException e) {
            Logger.getInstance(AndroidGradleModel.class).warn("Failed to parse '" + original + "'", (Throwable)e);
            return false;
        }
        return modelVersion.compareTo(FullRevision.parseRevision((String)"1.1.0")) >= 0;
    }

    @Nullable
    public SourceFileContainerInfo containsSourceFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/AndroidGradleModel", "containsSourceFile"));
        }
        ProductFlavorContainer defaultConfig = this.myAndroidProject.getDefaultConfig();
        if (AndroidGradleModel.containsSourceFile(defaultConfig, file)) {
            return new SourceFileContainerInfo();
        }
        for (Variant variant : this.myAndroidProject.getVariants()) {
            AndroidArtifact artifact = variant.getMainArtifact();
            if (AndroidGradleModel.containsSourceFile((BaseArtifact)artifact, file)) {
                return new SourceFileContainerInfo(variant, (BaseArtifact)artifact);
            }
            for (AndroidArtifact extraArtifact : variant.getExtraAndroidArtifacts()) {
                if (!AndroidGradleModel.containsSourceFile((BaseArtifact)extraArtifact, file)) continue;
                return new SourceFileContainerInfo(variant, (BaseArtifact)extraArtifact);
            }
            String buildTypeName = variant.getBuildType();
            BuildTypeContainer buildTypeContainer = this.findBuildType(buildTypeName);
            if (buildTypeContainer != null) {
                if (AndroidGradleModel.containsFile(buildTypeContainer.getSourceProvider(), file)) {
                    return new SourceFileContainerInfo(variant);
                }
                for (SourceProviderContainer extraSourceProvider : buildTypeContainer.getExtraSourceProviders()) {
                    if (!AndroidGradleModel.containsFile(extraSourceProvider.getSourceProvider(), file)) continue;
                    return new SourceFileContainerInfo(variant);
                }
            }
            for (String flavorName : variant.getProductFlavors()) {
                ProductFlavorContainer flavor = this.findProductFlavor(flavorName);
                if (flavor == null || !AndroidGradleModel.containsSourceFile(flavor, file)) continue;
                return new SourceFileContainerInfo(variant);
            }
        }
        return null;
    }

    private static boolean containsSourceFile(@NotNull ProductFlavorContainer flavorContainer, @NotNull File file) {
        if (flavorContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavorContainer", "com/android/tools/idea/gradle/AndroidGradleModel", "containsSourceFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/AndroidGradleModel", "containsSourceFile"));
        }
        if (AndroidGradleModel.containsFile(flavorContainer.getSourceProvider(), file)) {
            return true;
        }
        for (SourceProviderContainer extraSourceProvider : flavorContainer.getExtraSourceProviders()) {
            if (!AndroidGradleModel.containsFile(extraSourceProvider.getSourceProvider(), file)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSourceFile(@NotNull BaseArtifact artifact, @NotNull File file) {
        AndroidArtifact android;
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/AndroidGradleModel", "containsSourceFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/AndroidGradleModel", "containsSourceFile"));
        }
        if (artifact instanceof AndroidArtifact && (AndroidGradleModel.containsFile((android = (AndroidArtifact)artifact).getGeneratedSourceFolders(), file) || AndroidGradleModel.containsFile(android.getGeneratedResourceFolders(), file))) {
            return true;
        }
        SourceProvider sourceProvider = artifact.getVariantSourceProvider();
        if (sourceProvider != null && AndroidGradleModel.containsFile(sourceProvider, file)) {
            return true;
        }
        sourceProvider = artifact.getMultiFlavorSourceProvider();
        return sourceProvider != null && AndroidGradleModel.containsFile(sourceProvider, file);
    }

    private static boolean containsFile(@NotNull SourceProvider sourceProvider, @NotNull File file) {
        if (sourceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProvider", "com/android/tools/idea/gradle/AndroidGradleModel", "containsFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/AndroidGradleModel", "containsFile"));
        }
        return AndroidGradleModel.containsFile(sourceProvider.getAidlDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getAssetsDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getCDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getCppDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getJavaDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getRenderscriptDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getResDirectories(), file) || AndroidGradleModel.containsFile(sourceProvider.getResourcesDirectories(), file);
    }

    private static boolean containsFile(@NotNull Collection<File> directories, @NotNull File file) {
        if (directories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "com/android/tools/idea/gradle/AndroidGradleModel", "containsFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/AndroidGradleModel", "containsFile"));
        }
        for (File directory : directories) {
            if (!FileUtil.isAncestor((File)directory, (File)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void waitForAndroidProjectProxy() {
        if (this.myProxyAndroidProjectLatch != null) {
            try {
                this.myProxyAndroidProjectLatch.await();
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.waitForAndroidProjectProxy();
        out.writeObject(this.myProjectSystemId);
        out.writeObject(this.myModuleName);
        out.writeObject(this.myRootDirPath);
        out.writeObject(this.myProxyAndroidProject);
        out.writeObject(this.mySelectedVariantName);
        out.writeObject(this.mySelectedTestArtifactName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.myProjectSystemId = (ProjectSystemId)in.readObject();
        this.myModuleName = (String)in.readObject();
        this.myRootDirPath = (File)in.readObject();
        this.myProxyAndroidProject = this.myAndroidProject = (AndroidProject)in.readObject();
        this.myBuildTypesByName = Maps.newHashMap();
        this.myProductFlavorsByName = Maps.newHashMap();
        this.myVariantsByName = Maps.newHashMap();
        this.myExtraGeneratedSourceFolders = Sets.newHashSet();
        this.populateBuildTypesByName();
        this.populateProductFlavorsByName();
        this.populateVariantsByName();
        this.setSelectedVariantName((String)in.readObject());
        this.setSelectedTestArtifactName((String)in.readObject());
    }

    @Nullable
    public static AndroidGradleModel get(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/AndroidGradleModel", "get"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? AndroidGradleModel.get(facet) : null;
    }

    @Nullable
    public static AndroidGradleModel get(@NotNull AndroidFacet androidFacet) {
        if (androidFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidFacet", "com/android/tools/idea/gradle/AndroidGradleModel", "get"));
        }
        AndroidModel androidModel = androidFacet.getAndroidModel();
        if (androidModel == null) {
            return null;
        }
        if (!(androidModel instanceof AndroidGradleModel)) {
            return null;
        }
        return (AndroidGradleModel)androidModel;
    }

    @NotNull
    public SourceProvider getBuildTypeSourceProvider() {
        Variant selectedVariant = this.getSelectedVariant();
        BuildTypeContainer buildType = this.findBuildType(selectedVariant.getBuildType());
        assert (buildType != null);
        SourceProvider sourceProvider = buildType.getSourceProvider();
        if (sourceProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getBuildTypeSourceProvider"));
        }
        return sourceProvider;
    }

    @NotNull
    public List<SourceProvider> getFlavorSourceProviders() {
        Variant selectedVariant = this.getSelectedVariant();
        List productFlavors = selectedVariant.getProductFlavors();
        ArrayList providers = Lists.newArrayList();
        for (String flavor : productFlavors) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.add(productFlavor.getSourceProvider());
        }
        ArrayList arrayList = providers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getFlavorSourceProviders"));
        }
        return arrayList;
    }

    public void syncSelectedVariantAndTestArtifact(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/gradle/AndroidGradleModel", "syncSelectedVariantAndTestArtifact"));
        }
        Variant variant = this.getSelectedVariant();
        JpsAndroidModuleProperties state = facet.getProperties();
        state.SELECTED_BUILD_VARIANT = variant.getName();
        state.SELECTED_TEST_ARTIFACT = this.getSelectedTestArtifactName();
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        BaseArtifact testArtifact = this.findSelectedTestArtifactInSelectedVariant();
        AndroidGradleModel.updateGradleTaskNames(state, mainArtifact, testArtifact);
    }

    static void updateGradleTaskNames(@NotNull JpsAndroidModuleProperties state, @NotNull AndroidArtifact mainArtifact, @Nullable BaseArtifact testArtifact) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/gradle/AndroidGradleModel", "updateGradleTaskNames"));
        }
        if (mainArtifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainArtifact", "com/android/tools/idea/gradle/AndroidGradleModel", "updateGradleTaskNames"));
        }
        state.ASSEMBLE_TASK_NAME = mainArtifact.getAssembleTaskName();
        state.COMPILE_JAVA_TASK_NAME = mainArtifact.getCompileTaskName();
        state.AFTER_SYNC_TASK_NAMES = Sets.newHashSet(AndroidGradleModel.getIdeSetupTasks((BaseArtifact)mainArtifact));
        if (testArtifact != null) {
            state.ASSEMBLE_TEST_TASK_NAME = testArtifact.getAssembleTaskName();
            state.COMPILE_JAVA_TEST_TASK_NAME = testArtifact.getCompileTaskName();
            state.AFTER_SYNC_TASK_NAMES.addAll(AndroidGradleModel.getIdeSetupTasks(testArtifact));
        } else {
            state.ASSEMBLE_TEST_TASK_NAME = "";
            state.COMPILE_JAVA_TEST_TASK_NAME = "";
        }
    }

    @NotNull
    private static Set<String> getIdeSetupTasks(@NotNull BaseArtifact artifact) {
        block9: {
            Set set;
            if (artifact == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/AndroidGradleModel", "getIdeSetupTasks"));
            }
            try {
                set = artifact.getIdeSetupTaskNames();
            }
            catch (NoSuchMethodError e) {
                if (artifact instanceof AndroidArtifact) {
                    HashSet hashSet = Sets.newHashSet((Object[])new String[]{((AndroidArtifact)artifact).getSourceGenTaskName()});
                    if (hashSet == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getIdeSetupTasks"));
                    }
                    return hashSet;
                }
            }
            catch (UnsupportedMethodException e) {
                if (!(artifact instanceof AndroidArtifact)) break block9;
                HashSet hashSet = Sets.newHashSet((Object[])new String[]{((AndroidArtifact)artifact).getSourceGenTaskName()});
                if (hashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getIdeSetupTasks"));
                }
                return hashSet;
            }
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getIdeSetupTasks"));
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/AndroidGradleModel", "getIdeSetupTasks"));
        }
        return set;
    }

    @Nullable
    public SourceProvider getMultiFlavorSourceProvider() {
        AndroidArtifact mainArtifact = this.getMainArtifact();
        return mainArtifact.getMultiFlavorSourceProvider();
    }

    @Nullable
    public SourceProvider getVariantSourceProvider() {
        AndroidArtifact mainArtifact = this.getMainArtifact();
        return mainArtifact.getVariantSourceProvider();
    }

    @Override
    public boolean getDataBindingEnabled() {
        return GradleUtil.dependsOn(this, "com.android.databinding:library");
    }

    public static class SourceFileContainerInfo {
        @Nullable
        public final Variant variant;
        @Nullable
        public final BaseArtifact artifact;

        SourceFileContainerInfo() {
            this(null);
        }

        SourceFileContainerInfo(@Nullable Variant variant) {
            this(variant, null);
        }

        SourceFileContainerInfo(@Nullable Variant variant, @Nullable BaseArtifact artifact) {
            this.variant = variant;
            this.artifact = artifact;
        }

        public void updateSelectedVariantIn(@NotNull DataNode<ModuleData> moduleNode) {
            DataNode androidProjectNode;
            if (moduleNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleNode", "com/android/tools/idea/gradle/AndroidGradleModel$SourceFileContainerInfo", "updateSelectedVariantIn"));
            }
            if (this.variant != null && (androidProjectNode = ExternalSystemApiUtil.find(moduleNode, AndroidProjectKeys.ANDROID_MODEL)) != null) {
                ((AndroidGradleModel)androidProjectNode.getData()).setSelectedVariantName(this.variant.getName());
            }
        }
    }
}

