/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CommonProcessors;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationUtil {
    public static final Set<String> ALL_ANNOTATIONS;
    @NonNls
    private static final String[] SIMPLE_NAMES;

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, boolean skipExternal, String ... annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        if (annotationNames.length == 0) {
            return null;
        }
        Set<String> set = annotationNames.length == 1 ? Collections.singleton(annotationNames[0]) : new HashSet<String>(Arrays.asList(annotationNames));
        return AnnotationUtil.findAnnotation(listOwner, set, skipExternal);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames, false);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames, boolean skipExternal) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        if (listOwner == null) {
            return null;
        }
        PsiAnnotation annotation2 = AnnotationUtil.findOwnAnnotation(listOwner, annotationNames);
        if (annotation2 != null) {
            return annotation2;
        }
        return skipExternal ? null : AnnotationUtil.findNonCodeAnnotation(listOwner, annotationNames);
    }

    private static PsiAnnotation findOwnAnnotation(final PsiModifierListOwner listOwner, Collection<String> annotationNames) {
        ConcurrentFactoryMap<Collection<String>, PsiAnnotation> map2 = CachedValuesManager.getCachedValue(listOwner, new CachedValueProvider<ConcurrentFactoryMap<Collection<String>, PsiAnnotation>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<ConcurrentFactoryMap<Collection<String>, PsiAnnotation>> compute() {
                ConcurrentFactoryMap<Collection<String>, PsiAnnotation> value = new ConcurrentFactoryMap<Collection<String>, PsiAnnotation>(){

                    @Override
                    @Nullable
                    protected PsiAnnotation create(Collection<String> annotationNames) {
                        PsiModifierList list2 = listOwner.getModifierList();
                        if (list2 == null) {
                            return null;
                        }
                        for (PsiAnnotation annotation2 : list2.getAnnotations()) {
                            if (!annotationNames.contains(annotation2.getQualifiedName())) continue;
                            return annotation2;
                        }
                        return null;
                    }
                };
                return CachedValueProvider.Result.create(value, PsiModificationTracker.MODIFICATION_COUNT);
            }
        });
        return (PsiAnnotation)map2.get(annotationNames);
    }

    private static PsiAnnotation findNonCodeAnnotation(final PsiModifierListOwner listOwner, Collection<String> annotationNames) {
        ConcurrentFactoryMap<Collection<String>, PsiAnnotation> map2 = CachedValuesManager.getCachedValue(listOwner, new CachedValueProvider<ConcurrentFactoryMap<Collection<String>, PsiAnnotation>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<ConcurrentFactoryMap<Collection<String>, PsiAnnotation>> compute() {
                ConcurrentFactoryMap<Collection<String>, PsiAnnotation> value = new ConcurrentFactoryMap<Collection<String>, PsiAnnotation>(){

                    @Override
                    @Nullable
                    protected PsiAnnotation create(Collection<String> annotationNames) {
                        Project project = listOwner.getProject();
                        ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance(project);
                        for (String annotationName : annotationNames) {
                            PsiAnnotation annotation2 = annotationsManager.findExternalAnnotation(listOwner, annotationName);
                            if (annotation2 == null) continue;
                            return annotation2;
                        }
                        InferredAnnotationsManager inferredAnnotationsManager = InferredAnnotationsManager.getInstance(project);
                        for (String annotationName : annotationNames) {
                            PsiAnnotation annotation3 = inferredAnnotationsManager.findInferredAnnotation(listOwner, annotationName);
                            if (annotation3 == null) continue;
                            return annotation3;
                        }
                        return null;
                    }
                };
                return CachedValueProvider.Result.create(value, PsiModificationTracker.MODIFICATION_COUNT);
            }
        });
        return (PsiAnnotation)map2.get(annotationNames);
    }

    public static <T extends PsiModifierListOwner> List<T> getSuperAnnotationOwners(final T element) {
        return (List)CachedValuesManager.getCachedValue(element, new CachedValueProvider<List<T>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<List<T>> compute() {
                LinkedHashSet result = ContainerUtil.newLinkedHashSet();
                if (element instanceof PsiMethod) {
                    AnnotationUtil.collectSuperMethods(result, ((PsiMethod)element).getHierarchicalMethodSignature(), element, JavaPsiFacade.getInstance(element.getProject()).getResolveHelper());
                } else if (element instanceof PsiClass) {
                    InheritanceUtil.processSupers((PsiClass)element, false, new CommonProcessors.CollectProcessor<PsiClass>(result));
                } else if (element instanceof PsiParameter) {
                    AnnotationUtil.collectSuperParameters(result, (PsiParameter)element);
                }
                ArrayList list2 = new ArrayList();
                list2.addAll(result);
                ArrayList dependencies = ContainerUtil.newArrayList(result);
                dependencies.add(PsiModificationTracker.MODIFICATION_COUNT);
                return CachedValueProvider.Result.create(list2, dependencies);
            }
        });
    }

    @Nullable
    public static PsiAnnotation findAnnotationInHierarchy(final @NotNull PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        PsiAnnotation directAnnotation = AnnotationUtil.findAnnotation(listOwner, annotationNames);
        if (directAnnotation != null) {
            return directAnnotation;
        }
        ConcurrentFactoryMap<Set<String>, PsiAnnotation> map2 = CachedValuesManager.getCachedValue(listOwner, new CachedValueProvider<ConcurrentFactoryMap<Set<String>, PsiAnnotation>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<ConcurrentFactoryMap<Set<String>, PsiAnnotation>> compute() {
                ConcurrentFactoryMap<Set<String>, PsiAnnotation> value = new ConcurrentFactoryMap<Set<String>, PsiAnnotation>(){

                    @Override
                    @Nullable
                    protected PsiAnnotation create(Set<String> annotationNames) {
                        for (PsiModifierListOwner superOwner : AnnotationUtil.getSuperAnnotationOwners(listOwner)) {
                            PsiAnnotation annotation2 = AnnotationUtil.findAnnotation(superOwner, annotationNames);
                            if (annotation2 == null) continue;
                            return annotation2;
                        }
                        return null;
                    }
                };
                return CachedValueProvider.Result.create(value, PsiModificationTracker.MODIFICATION_COUNT);
            }
        });
        return (PsiAnnotation)map2.get(annotationNames);
    }

    private static void collectSuperParameters(LinkedHashSet<PsiModifierListOwner> result, @NotNull PsiParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/AnnotationUtil", "collectSuperParameters"));
        }
        PsiElement scope2 = parameter.getDeclarationScope();
        if (!(scope2 instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)scope2;
        PsiElement parent2 = parameter.getParent();
        if (!(parent2 instanceof PsiParameterList)) {
            return;
        }
        int index2 = ((PsiParameterList)parent2).getParameterIndex(parameter);
        for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners(method)) {
            PsiParameter[] superParameters = superMethod.getParameterList().getParameters();
            if (index2 >= superParameters.length) continue;
            result.add(superParameters[index2]);
        }
    }

    private static void collectSuperMethods(LinkedHashSet<PsiModifierListOwner> result, @NotNull HierarchicalMethodSignature signature, @NotNull PsiElement place, @NotNull PsiResolveHelper resolveHelper) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/codeInsight/AnnotationUtil", "collectSuperMethods"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/AnnotationUtil", "collectSuperMethods"));
        }
        if (resolveHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveHelper", "com/intellij/codeInsight/AnnotationUtil", "collectSuperMethods"));
        }
        for (HierarchicalMethodSignature superSignature : signature.getSuperSignatures()) {
            PsiMethod superMethod = superSignature.getMethod();
            if (!resolveHelper.isAccessible(superMethod, place, null) || !result.add(superMethod)) continue;
            AnnotationUtil.collectSuperMethods(result, superSignature, place, resolveHelper);
        }
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations2, boolean checkHierarchy, boolean skipExternal) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        for (String annotation2 : annotations2) {
            if (!AnnotationUtil.isAnnotated(listOwner, annotation2, checkHierarchy, skipExternal)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls @NotNull String annotationFQN, boolean checkHierarchy, boolean skipExternal) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, checkHierarchy, skipExternal, null);
    }

    private static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls @NotNull String annotationFQN, boolean checkHierarchy, boolean skipExternal, @Nullable Set<PsiMember> processed) {
        block12: {
            PsiClass[] superClasses2;
            block13: {
                PsiMethod[] superMethods;
                Project project;
                if (listOwner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
                }
                if (annotationFQN == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
                }
                if (!listOwner.isValid()) {
                    return false;
                }
                PsiModifierList modifierList = listOwner.getModifierList();
                if (modifierList == null) {
                    return false;
                }
                PsiAnnotation annotation2 = modifierList.findAnnotation(annotationFQN);
                if (annotation2 != null) {
                    return true;
                }
                if (!(skipExternal || ExternalAnnotationsManager.getInstance(project = listOwner.getProject()).findExternalAnnotation(listOwner, annotationFQN) == null && InferredAnnotationsManager.getInstance(project).findInferredAnnotation(listOwner, annotationFQN) == null)) {
                    return true;
                }
                if (!checkHierarchy) break block12;
                if (!(listOwner instanceof PsiMethod)) break block13;
                PsiMethod method = (PsiMethod)listOwner;
                if (processed == null) {
                    processed = new THashSet<PsiMember>();
                }
                if (!processed.add(method)) {
                    return false;
                }
                for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                    if (!AnnotationUtil.isAnnotated(superMethod, annotationFQN, true, skipExternal, processed)) continue;
                    return true;
                }
                break block12;
            }
            if (!(listOwner instanceof PsiClass)) break block12;
            PsiClass clazz = (PsiClass)listOwner;
            if (processed == null) {
                processed = new THashSet<PsiMember>();
            }
            if (!processed.add(clazz)) {
                return false;
            }
            for (PsiClass superClass : superClasses2 = clazz.getSupers()) {
                if (!AnnotationUtil.isAnnotated(superClass, annotationFQN, true, skipExternal, processed)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        SIMPLE_NAMES = new String[]{"NotNull", "Nullable", "NonNls", "PropertyKey", "TestOnly", "Language", "Identifier", "Pattern", "PrintFormat", "RegExp", "Subst"};
        ALL_ANNOTATIONS = new HashSet<String>(2);
        ALL_ANNOTATIONS.add("org.jetbrains.annotations.Nullable");
        ALL_ANNOTATIONS.add("org.jetbrains.annotations.NotNull");
    }
}

