/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.CompressedAppendableFile;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.FileAccessorCache;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.RandomAccessFileWithLengthAndSizeTracking;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentHashMapValueStorage {
    @Nullable
    private RAReader myCompactionModeReader = null;
    private volatile long mySize;
    private final File myFile;
    private final String myPath;
    private final ExceptionalIOCancellationCallback myExceptionalIOCancellationCallback;
    private boolean myCompactionMode = false;
    private static final int CACHE_PROTECTED_QUEUE_SIZE = 10;
    private static final int CACHE_PROBATIONAL_QUEUE_SIZE = 20;
    private static final FileAccessorCache<String, RandomAccessFileWithLengthAndSizeTracking> ourRandomAccessFileCache = new FileAccessorCache<String, RandomAccessFileWithLengthAndSizeTracking>(20, 40){

        @Override
        protected RandomAccessFileWithLengthAndSizeTracking createAccessor(String path) throws IOException {
            return new RandomAccessFileWithLengthAndSizeTracking(path);
        }

        @Override
        protected void disposeAccessor(RandomAccessFileWithLengthAndSizeTracking fileAccessor) {
            this.disposeCloseable(fileAccessor);
        }
    };
    private static final boolean useSingleFileDescriptor = SystemProperties.getBooleanProperty("idea.use.single.file.descriptor.for.persistent.hash.map", true);
    private static final FileAccessorCache<String, DataOutputStream> ourAppendersCache = new FileAccessorCache<String, DataOutputStream>(10, 20){

        @Override
        protected DataOutputStream createAccessor(String path) throws IOException {
            OutputStream out = useSingleFileDescriptor ? new OutputStreamOverRandomAccessFileCache(path) : new FileOutputStream(path, true);
            return new DataOutputStream(new BufferedOutputStream(out));
        }

        @Override
        protected void disposeAccessor(DataOutputStream fileAccessor) {
            this.disposeCloseable(fileAccessor);
        }
    };
    private static final FileAccessorCache<String, RAReader> ourReadersCache = new FileAccessorCache<String, RAReader>(10, 20){

        @Override
        protected RAReader createAccessor(String path) throws IOException {
            return useSingleFileDescriptor ? new ReaderOverRandomAccessFileCache(path) : new FileReader(new File(path));
        }

        @Override
        protected void disposeAccessor(RAReader fileAccessor) {
            fileAccessor.dispose();
        }
    };
    private final CompressedAppendableFile myCompressedAppendableFile;
    public static final boolean COMPRESSION_ENABLED = SystemProperties.getBooleanProperty("idea.compression.enabled", true);
    private final byte[] myBuffer = new byte[1024];
    private final UnsyncByteArrayInputStream myBufferStreamWrapper = new UnsyncByteArrayInputStream(this.myBuffer);
    private final DataInputStream myBufferDataStreamWrapper = new DataInputStream(this.myBufferStreamWrapper);
    private long myChunksRemovalTime;
    private int myChunks;
    private static final boolean ourDumpChunkRemovalTime = SystemProperties.getBooleanProperty("idea.phmp.dump.chunk.removal.time", false);

    public PersistentHashMapValueStorage(String path) throws IOException {
        this.myExceptionalIOCancellationCallback = CreationTimeOptions.EXCEPTIONAL_IO_CANCELLATION.get();
        this.myPath = path;
        this.myFile = new File(path);
        this.myCompressedAppendableFile = COMPRESSION_ENABLED ? new MyCompressedAppendableFile() : null;
        this.mySize = this.myCompressedAppendableFile != null ? this.myCompressedAppendableFile.length() : this.myFile.length();
        if (this.mySize == 0L) {
            long currentLength;
            this.appendBytes(new ByteSequence("Header Record For PersistentHashMapValueStorage".getBytes()), 0L);
            FileAccessorCache.Handle<DataOutputStream> streamCacheValue = ourAppendersCache.getIfCached(this.myPath);
            if (streamCacheValue != null) {
                try {
                    IOUtil.syncStream(streamCacheValue.get());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    streamCacheValue.release();
                }
            }
            if ((currentLength = this.myFile.length()) > this.mySize) {
                Logger.getInstance(this.getClass().getName()).info("Avoided PSHM corruption due to write failure");
                this.mySize = currentLength;
            }
        }
    }

    public long appendBytes(ByteSequence data, long prevChunkAddress) throws IOException {
        return this.appendBytes(data.getBytes(), data.getOffset(), data.getLength(), prevChunkAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long appendBytes(byte[] data, int offset, int dataLength, long prevChunkAddress) throws IOException {
        assert (!this.myCompactionMode);
        long result = this.mySize;
        FileAccessorCache.Handle<DataOutputStream> appender = this.myCompressedAppendableFile != null ? null : ourAppendersCache.get(this.myPath);
        try {
            if (this.myCompressedAppendableFile != null) {
                BufferExposingByteArrayOutputStream stream = new BufferExposingByteArrayOutputStream();
                DataOutputStream testStream = new DataOutputStream(stream);
                this.saveData(data, offset, dataLength, prevChunkAddress, result, testStream);
                this.myCompressedAppendableFile.append(stream.getInternalBuffer(), stream.size());
                this.mySize += (long)stream.size();
            } else {
                DataOutputStream dataOutputStream = appender.get();
                dataOutputStream.resetWrittenBytesCount();
                this.saveData(data, offset, dataLength, prevChunkAddress, result, dataOutputStream);
                this.mySize += (long)dataOutputStream.resetWrittenBytesCount();
            }
        }
        finally {
            if (appender != null) {
                appender.release();
            }
        }
        return result;
    }

    private void saveData(byte[] data, int offset, int dataLength, long prevChunkAddress, long result, DataOutputStream dataOutputStream) throws IOException {
        DataInputOutputUtil.writeINT(dataOutputStream, dataLength);
        this.writePrevChunkAddress(prevChunkAddress, result, dataOutputStream);
        dataOutputStream.write(data, offset, dataLength);
    }

    public long compactValues(List<PersistentHashMap.CompactionRecordInfo> infos, PersistentHashMapValueStorage storage2) throws IOException {
        long lastReadOffset;
        PriorityQueue<PersistentHashMap.CompactionRecordInfo> records = new PriorityQueue<PersistentHashMap.CompactionRecordInfo>(infos.size(), new Comparator<PersistentHashMap.CompactionRecordInfo>(){

            @Override
            public int compare(PersistentHashMap.CompactionRecordInfo info, PersistentHashMap.CompactionRecordInfo info2) {
                long i = info.valueAddress - info2.valueAddress;
                return i > 0L ? -1 : (i < 0L ? 1 : 0);
            }
        });
        records.addAll(infos);
        int fileBufferLength = 262144;
        int maxRecordHeader = 15;
        byte[] buffer = new byte[262159];
        byte[] recordBuffer = new byte[]{};
        long lastConsumedOffset = lastReadOffset = this.mySize;
        long allRecordsStart = 0L;
        int fragments2 = 0;
        int newFragments = 0;
        int allRecordsLength = 0;
        byte[] stuffFromPreviousRecord = null;
        int bytesRead = (int)(this.mySize - this.mySize / 262144L * 262144L);
        long retained = 0L;
        long softMaxRetainedLimit = 0xA00000L;
        int blockSizeToWriteWhenSoftMaxRetainedLimitIsHit = 1024;
        long maxRetainedLimit = 0x6400000L;
        while (lastReadOffset != 0L) {
            long readStartOffset = lastReadOffset - (long)bytesRead;
            this.myCompactionModeReader.get(readStartOffset, buffer, 0, bytesRead);
            while (!records.isEmpty()) {
                PersistentHashMap.CompactionRecordInfo info = records.peek();
                if (info.valueAddress >= readStartOffset) {
                    byte[] b;
                    if (info.valueAddress >= lastReadOffset) {
                        throw new IOException("Value storage is corrupted: value file size:" + this.mySize + ", readStartOffset:" + readStartOffset + ", record address:" + info.valueAddress + "; file: " + this.myPath);
                    }
                    int recordStartInBuffer = (int)(info.valueAddress - readStartOffset);
                    this.myBufferStreamWrapper.init(buffer, recordStartInBuffer, buffer.length);
                    if (stuffFromPreviousRecord != null && 262144 - recordStartInBuffer < 15) {
                        if (allRecordsStart != 0L) {
                            this.myCompactionModeReader.get(allRecordsStart, buffer, bytesRead, 15);
                        } else {
                            int maxAdditionalBytes = Math.min(stuffFromPreviousRecord.length, 15);
                            for (int i = 0; i < maxAdditionalBytes; ++i) {
                                buffer[bytesRead + i] = stuffFromPreviousRecord[i];
                            }
                        }
                    }
                    int available = this.myBufferStreamWrapper.available();
                    int chunkSize = DataInputOutputUtil.readINT(this.myBufferDataStreamWrapper);
                    long prevChunkAddress = this.readPrevChunkAddress(info.valueAddress);
                    int dataOffset = available - this.myBufferStreamWrapper.available();
                    if (info.value != null) {
                        int defragmentedChunkSize = info.value.length + chunkSize;
                        if (prevChunkAddress == 0L) {
                            if (defragmentedChunkSize >= recordBuffer.length) {
                                recordBuffer = new byte[defragmentedChunkSize];
                            }
                            b = recordBuffer;
                        } else {
                            b = new byte[defragmentedChunkSize];
                            retained += (long)defragmentedChunkSize;
                        }
                        System.arraycopy(info.value, 0, b, chunkSize, info.value.length);
                    } else if (prevChunkAddress == 0L) {
                        if (chunkSize >= recordBuffer.length) {
                            recordBuffer = new byte[chunkSize];
                        }
                        b = recordBuffer;
                    } else {
                        b = new byte[chunkSize];
                        retained += (long)chunkSize;
                    }
                    int chunkSizeOutOfBuffer = Math.min(chunkSize, Math.max((int)(info.valueAddress + (long)dataOffset + (long)chunkSize - lastReadOffset), 0));
                    if (chunkSizeOutOfBuffer > 0) {
                        if (allRecordsStart != 0L) {
                            this.myCompactionModeReader.get(allRecordsStart, b, chunkSize - chunkSizeOutOfBuffer, chunkSizeOutOfBuffer);
                        } else {
                            int offsetInStuffFromPreviousRecord = Math.max((int)(info.valueAddress + (long)dataOffset - lastReadOffset), 0);
                            System.arraycopy(stuffFromPreviousRecord, offsetInStuffFromPreviousRecord, b, chunkSize - chunkSizeOutOfBuffer, chunkSizeOutOfBuffer);
                        }
                    }
                    stuffFromPreviousRecord = null;
                    allRecordsLength = 0;
                    allRecordsStart = 0;
                    lastConsumedOffset = info.valueAddress;
                    PersistentHashMapValueStorage.checkPreconditions(b, chunkSize, 0);
                    System.arraycopy(buffer, recordStartInBuffer + dataOffset, b, 0, chunkSize - chunkSizeOutOfBuffer);
                    ++fragments2;
                    records.remove(info);
                    if (info.value != null) {
                        chunkSize += info.value.length;
                        retained -= (long)info.value.length;
                        info.value = null;
                    }
                    if (prevChunkAddress == 0L) {
                        info.newValueAddress = storage2.appendBytes(b, 0, chunkSize, info.newValueAddress);
                        ++newFragments;
                        continue;
                    }
                    if (retained > 0xA00000L && b.length > 1024 || retained > 0x6400000L) {
                        ++newFragments;
                        info.newValueAddress = storage2.appendBytes(b, 0, chunkSize, info.newValueAddress);
                        info.value = null;
                        retained -= (long)b.length;
                    } else {
                        info.value = b;
                    }
                    info.valueAddress = prevChunkAddress;
                    records.add(info);
                    continue;
                }
                if (stuffFromPreviousRecord == null) {
                    stuffFromPreviousRecord = new byte[(int)(lastConsumedOffset - readStartOffset)];
                    System.arraycopy(buffer, 0, stuffFromPreviousRecord, 0, stuffFromPreviousRecord.length);
                    break;
                }
                allRecordsStart = readStartOffset;
                allRecordsLength += buffer.length;
                break;
            }
            lastReadOffset -= (long)bytesRead;
            bytesRead = 262144;
        }
        return (long)fragments2 | (long)newFragments << 32;
    }

    public ReadResult readBytes(long tailChunkAddress) throws IOException {
        PersistentHashMapValueStorage.forceAppender(this.myPath);
        this.checkCancellation();
        long startedTime = ourDumpChunkRemovalTime ? System.nanoTime() : 0L;
        long chunk = tailChunkAddress;
        int chunkCount = 0;
        byte[] result = null;
        RAReader reader = this.myCompactionModeReader;
        FileAccessorCache.Handle<RAReader> readerHandle = null;
        if (reader == null) {
            readerHandle = this.myCompressedAppendableFile != null ? null : ourReadersCache.get(this.myPath);
            reader = this.myCompressedAppendableFile != null ? null : readerHandle.get();
        }
        try {
            while (chunk != 0L) {
                if (chunk < 0L || chunk > this.mySize) {
                    throw new PersistentEnumeratorBase.CorruptedException(this.myFile);
                }
                int len = (int)Math.min((long)this.myBuffer.length, this.mySize - chunk);
                if (this.myCompressedAppendableFile != null) {
                    DataInputStream stream = this.myCompressedAppendableFile.getStream(chunk);
                    stream.readFully(this.myBuffer, 0, len);
                    stream.close();
                } else {
                    reader.get(chunk, this.myBuffer, 0, len);
                }
                this.myBufferStreamWrapper.init(this.myBuffer, 0, len);
                int chunkSize = DataInputOutputUtil.readINT(this.myBufferDataStreamWrapper);
                if (chunkSize < 0) {
                    throw new IOException("Value storage corrupted: negative chunk size: " + chunkSize);
                }
                long prevChunkAddress = this.readPrevChunkAddress(chunk);
                int headerOffset = len - this.myBufferStreamWrapper.available();
                byte[] b = new byte[(result != null ? result.length : 0) + chunkSize];
                if (result != null) {
                    System.arraycopy(result, 0, b, b.length - result.length, result.length);
                }
                result = b;
                PersistentHashMapValueStorage.checkPreconditions(result, chunkSize, 0);
                if (chunkSize < this.myBuffer.length - headerOffset) {
                    System.arraycopy(this.myBuffer, headerOffset, result, 0, chunkSize);
                } else if (this.myCompressedAppendableFile != null) {
                    DataInputStream stream = this.myCompressedAppendableFile.getStream(chunk + (long)headerOffset);
                    stream.readFully(result, 0, chunkSize);
                    stream.close();
                } else {
                    reader.get(chunk + (long)headerOffset, result, 0, chunkSize);
                }
                if (prevChunkAddress >= chunk) {
                    throw new PersistentEnumeratorBase.CorruptedException(this.myFile);
                }
                chunk = prevChunkAddress;
                ++chunkCount;
                if (prevChunkAddress != 0L) {
                    this.checkCancellation();
                }
                if ((long)result.length <= this.mySize || this.myCompressedAppendableFile != null) continue;
                throw new PersistentEnumeratorBase.CorruptedException(this.myFile);
            }
        }
        catch (OutOfMemoryError error) {
            result = null;
            throw new PersistentEnumeratorBase.CorruptedException(this.myFile);
        }
        finally {
            if (readerHandle != null) {
                readerHandle.release();
            }
        }
        if (chunkCount > 1 && !this.myCompactionMode) {
            this.checkCancellation();
            long endCompactionTime = ourDumpChunkRemovalTime ? System.nanoTime() : 0L;
            long diff = endCompactionTime - startedTime;
            this.myChunksRemovalTime += diff;
            this.myChunks += chunkCount;
            if (ourDumpChunkRemovalTime && chunkCount > 2) {
                System.out.println("Removed " + chunkCount + " chunks for " + diff / 1000000L + "ms, bytes: " + result.length + ", total: " + this.myChunksRemovalTime / 1000000L + "ms for " + this.myChunks + " chunks in " + this.myPath);
            }
            long l = this.appendBytes(new ByteSequence(result), 0L);
            return new ReadResult(l, result);
        }
        return new ReadResult(tailChunkAddress, result);
    }

    protected void checkCancellation() {
        if (this.myExceptionalIOCancellationCallback != null) {
            this.myExceptionalIOCancellationCallback.checkCancellation();
        }
    }

    private long readPrevChunkAddress(long chunk) throws IOException {
        long prevOffsetDiff = DataInputOutputUtil.readLONG(this.myBufferDataStreamWrapper);
        if (prevOffsetDiff >= chunk) {
            throw new IOException("readPrevChunkAddress:" + chunk + "," + prevOffsetDiff + "," + this.mySize + "," + this.myFile);
        }
        return prevOffsetDiff != 0L ? chunk - prevOffsetDiff : 0L;
    }

    private void writePrevChunkAddress(long prevChunkAddress, long currentChunkAddress, DataOutputStream dataOutputStream) throws IOException {
        if (currentChunkAddress < prevChunkAddress) {
            throw new IOException("writePrevChunkAddress:" + currentChunkAddress + "," + prevChunkAddress + "," + this.myFile);
        }
        long diff = currentChunkAddress - prevChunkAddress;
        DataInputOutputUtil.writeLONG(dataOutputStream, prevChunkAddress == 0L ? 0L : diff);
    }

    public long getSize() {
        return this.mySize;
    }

    private static void checkPreconditions(byte[] result, int chunkSize, int off) throws IOException {
        if (chunkSize < 0) {
            throw new IOException("Value storage corrupted: negative chunk size");
        }
        if (off < 0) {
            throw new IOException("Value storage corrupted: negative offset");
        }
        if (chunkSize > result.length - off) {
            throw new IOException("Value storage corrupted");
        }
    }

    public void force() {
        if (this.myCompressedAppendableFile != null) {
            this.myCompressedAppendableFile.force();
        }
        if (this.mySize < 0L) assert (false);
        PersistentHashMapValueStorage.forceAppender(this.myPath);
    }

    private static void forceAppender(String path) {
        FileAccessorCache.Handle<DataOutputStream> cached = ourAppendersCache.getIfCached(path);
        if (cached != null) {
            try {
                cached.get().flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                cached.release();
            }
        }
    }

    public void dispose() {
        if (this.myCompressedAppendableFile != null) {
            this.myCompressedAppendableFile.dispose();
        }
        if (this.mySize < 0L) assert (false);
        ourReadersCache.remove(this.myPath);
        ourAppendersCache.remove(this.myPath);
        ourRandomAccessFileCache.remove(this.myPath);
        if (this.myCompactionModeReader != null) {
            this.myCompactionModeReader.dispose();
            this.myCompactionModeReader = null;
        }
    }

    public void switchToCompactionMode() {
        ourReadersCache.remove(this.myPath);
        ourRandomAccessFileCache.remove(this.myPath);
        this.myCompactionModeReader = this.myCompressedAppendableFile != null ? new RAReader(){

            @Override
            public void get(long addr, byte[] dst, int off, int len) throws IOException {
                DataInputStream stream = PersistentHashMapValueStorage.this.myCompressedAppendableFile.getStream(addr);
                stream.readFully(dst, off, len);
                stream.close();
            }

            @Override
            public void dispose() {
            }
        } : new FileReader(this.myFile);
        this.myCompactionMode = true;
    }

    public static PersistentHashMapValueStorage create(String path) throws IOException {
        return new PersistentHashMapValueStorage(path);
    }

    private class MyCompressedAppendableFile
    extends CompressedAppendableFile {
        public MyCompressedAppendableFile() {
            super(PersistentHashMapValueStorage.this.myFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected InputStream getChunkInputStream(File appendFile, long offset, int pageSize) throws IOException {
            PersistentHashMapValueStorage.forceAppender(PersistentHashMapValueStorage.this.myPath);
            FileAccessorCache.Handle fileAccessor = ourReadersCache.get(PersistentHashMapValueStorage.this.myPath);
            byte[] bytes = new byte[pageSize];
            ((RAReader)fileAccessor.get()).get(offset, bytes, 0, pageSize);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
            if (byteArrayInputStream2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/PersistentHashMapValueStorage$MyCompressedAppendableFile", "getChunkInputStream"));
            }
            return byteArrayInputStream2;
            finally {
                fileAccessor.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void saveChunk(BufferExposingByteArrayOutputStream compressedChunk, long endOfFileOffset) throws IOException {
            FileAccessorCache.Handle streamCacheValue = ourAppendersCache.get(PersistentHashMapValueStorage.this.myPath);
            try {
                ((DataOutputStream)streamCacheValue.get()).write(compressedChunk.getInternalBuffer(), 0, compressedChunk.size());
            }
            finally {
                streamCacheValue.release();
            }
            streamCacheValue = ourAppendersCache.get(PersistentHashMapValueStorage.this.myPath + ".s");
            try {
                DataInputOutputUtil.writeINT((DataOutput)streamCacheValue.get(), compressedChunk.size());
            }
            finally {
                streamCacheValue.release();
            }
        }

        @Override
        @NotNull
        protected File getChunksFile() {
            File file = PersistentHashMapValueStorage.this.myFile;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/PersistentHashMapValueStorage$MyCompressedAppendableFile", "getChunksFile"));
            }
            return file;
        }

        @Override
        protected File getChunkLengthFile() {
            return new File(PersistentHashMapValueStorage.this.myFile.getPath() + ".s");
        }

        @Override
        public synchronized void force() {
            super.force();
            PersistentHashMapValueStorage.forceAppender(PersistentHashMapValueStorage.this.myPath + ".s");
        }

        @Override
        public synchronized void dispose() {
            super.dispose();
            ourAppendersCache.remove(PersistentHashMapValueStorage.this.myPath + ".s");
            ourRandomAccessFileCache.remove(PersistentHashMapValueStorage.this.myPath + ".s");
        }
    }

    private static class OutputStreamOverRandomAccessFileCache
    extends OutputStream {
        private final String myPath;

        public OutputStreamOverRandomAccessFileCache(String path) throws IOException {
            this.myPath = path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            FileAccessorCache.Handle fileAccessor = ourRandomAccessFileCache.get(this.myPath);
            RandomAccessFileWithLengthAndSizeTracking file = (RandomAccessFileWithLengthAndSizeTracking)fileAccessor.get();
            try {
                file.seek(file.length());
                file.write(b, off, len);
            }
            finally {
                fileAccessor.release();
            }
        }

        @Override
        public void write(int b) throws IOException {
            byte[] r = new byte[]{(byte)(b & 0xFF)};
            this.write(r);
        }
    }

    private static class FileReader
    implements RAReader {
        private final RandomAccessFile myFile;

        private FileReader(File file) {
            try {
                this.myFile = new RandomAccessFile(file, "r");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void get(long addr, byte[] dst, int off, int len) throws IOException {
            this.myFile.seek(addr);
            this.myFile.read(dst, off, len);
        }

        @Override
        public void dispose() {
            try {
                this.myFile.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ReaderOverRandomAccessFileCache
    implements RAReader {
        private String myPath;

        private ReaderOverRandomAccessFileCache(String path) {
            this.myPath = path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void get(long addr, byte[] dst, int off, int len) throws IOException {
            FileAccessorCache.Handle fileAccessor = ourRandomAccessFileCache.get(this.myPath);
            try {
                RandomAccessFileWithLengthAndSizeTracking file = (RandomAccessFileWithLengthAndSizeTracking)fileAccessor.get();
                file.seek(addr);
                file.read(dst, off, len);
            }
            finally {
                fileAccessor.release();
            }
        }

        @Override
        public void dispose() {
        }
    }

    private static interface RAReader {
        public void get(long var1, byte[] var3, int var4, int var5) throws IOException;

        public void dispose();
    }

    public static class ReadResult {
        public final long offset;
        public final byte[] buffer;

        public ReadResult(long offset, byte[] buffer) {
            this.offset = offset;
            this.buffer = buffer;
        }
    }

    public static interface ExceptionalIOCancellationCallback {
        public void checkCancellation();
    }

    public static class CreationTimeOptions {
        public static final ThreadLocal<ExceptionalIOCancellationCallback> EXCEPTIONAL_IO_CANCELLATION = new ThreadLocal();
    }
}

