/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.repl.messages;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.repl.messages.DiagnosticMessageHolder;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/messages/ReplIdeDiagnosticMessageHolder;", "Lorg/jetbrains/kotlin/cli/jvm/repl/messages/DiagnosticMessageHolder;", "()V", "diagnostics", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "", "renderedDiagnostics", "getRenderedDiagnostics", "()Ljava/lang/String;", "report", "", "diagnostic", "file", "Lcom/intellij/psi/PsiFile;", "render", "kotlin-compiler"})
@KotlinClass(version={1, 1, 0}, data={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, strings={"Lorg/jetbrains/kotlin/cli/jvm/repl/messages/ReplIdeDiagnosticMessageHolder;", "Lorg/jetbrains/kotlin/cli/jvm/repl/messages/DiagnosticMessageHolder;", "()V", "diagnostics", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "", "renderedDiagnostics", "getRenderedDiagnostics", "()Ljava/lang/String;", "report", "", "diagnostic", "file", "Lcom/intellij/psi/PsiFile;", "render", "kotlin-compiler"})
public final class ReplIdeDiagnosticMessageHolder
implements DiagnosticMessageHolder {
    private final ArrayList<Pair<Diagnostic, String>> diagnostics = CollectionsKt.arrayListOf(new Pair[0]);

    @Override
    public void report(@NotNull Diagnostic diagnostic, @NotNull PsiFile file, @NotNull String render) {
        Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(render, "render");
        this.diagnostics.add(new Pair<Diagnostic, String>(diagnostic, render));
    }

    @Override
    @NotNull
    public String getRenderedDiagnostics() {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document errorReport = docBuilder.newDocument();
        Element rootElement = errorReport.createElement("report");
        errorReport.appendChild(rootElement);
        for (Pair<Diagnostic, String> pair : this.diagnostics) {
            Diagnostic diagnostic = pair.component1();
            String message = pair.component2();
            TextRange errorRange = DiagnosticUtils.firstRange(diagnostic.getTextRanges());
            Element reportEntry = errorReport.createElement("reportEntry");
            reportEntry.setAttribute("severity", diagnostic.getSeverity().toString());
            reportEntry.setAttribute("rangeStart", String.valueOf(errorRange.getStartOffset()));
            reportEntry.setAttribute("rangeEnd", String.valueOf(errorRange.getEndOffset()));
            reportEntry.appendChild(errorReport.createTextNode(StringUtil.escapeXml(message)));
            rootElement.appendChild(reportEntry);
        }
        DOMImplementation dOMImplementation = errorReport.getImplementation();
        if (dOMImplementation == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.ls.DOMImplementationLS");
        }
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)dOMImplementation);
        LSSerializer lsSerializer = domImplementation.createLSSerializer();
        String string = lsSerializer.writeToString(errorReport);
        Intrinsics.checkExpressionValueIsNotNull(string, "lsSerializer.writeToString(errorReport)");
        return string;
    }
}

