/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.Closeable;
import java.io.File;
import java.io.FilterInputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\r\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0010"}, d2={"CLASSPATH_FILE_ID_DIGEST", "", "getCLASSPATH_FILE_ID_DIGEST", "()Ljava/lang/String;", "DEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS", "", "getDEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS", "()J", "DEFAULT_CLASSPATH_WATCH_PERIOD_MS", "getDEFAULT_CLASSPATH_WATCH_PERIOD_MS", "isClasspathFile", "", "file", "Ljava/io/File;", "md5Digest", "", "kotlin-compiler"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\r\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0010"}, strings={"CLASSPATH_FILE_ID_DIGEST", "", "getCLASSPATH_FILE_ID_DIGEST", "()Ljava/lang/String;", "DEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS", "", "getDEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS", "()J", "DEFAULT_CLASSPATH_WATCH_PERIOD_MS", "getDEFAULT_CLASSPATH_WATCH_PERIOD_MS", "isClasspathFile", "", "file", "Ljava/io/File;", "md5Digest", "", "kotlin-compiler"})
public final class LazyClasspathWatcherKt {
    @NotNull
    private static final String CLASSPATH_FILE_ID_DIGEST = "MD5";
    private static final long DEFAULT_CLASSPATH_WATCH_PERIOD_MS = 1000L;
    private static final long DEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS = 300000L;

    @NotNull
    public static final String getCLASSPATH_FILE_ID_DIGEST() {
        return CLASSPATH_FILE_ID_DIGEST;
    }

    public static final long getDEFAULT_CLASSPATH_WATCH_PERIOD_MS() {
        return DEFAULT_CLASSPATH_WATCH_PERIOD_MS;
    }

    public static final long getDEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS() {
        return DEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS;
    }

    public static final boolean isClasspathFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        return file.isFile() && CollectionsKt.listOf("class", "jar").contains(StringsKt.toLowerCase(FilesKt.getExtension(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] md5Digest(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        MessageDigest md = MessageDigest.getInstance(CLASSPATH_FILE_ID_DIGEST);
        Closeable $receiver$iv = new DigestInputStream(FilesKt.inputStream($receiver), md);
        boolean closed$iv = false;
        try {
            Object it = (DigestInputStream)$receiver$iv;
            byte[] buf = new byte[1024];
            while (((FilterInputStream)it).read(buf) != -1) {
            }
            ((FilterInputStream)it).close();
            it = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            closed$iv = true;
            try {
                $receiver$iv.close();
            }
            catch (Exception closeException$iv) {
                // empty catch block
            }
            throw (Throwable)e$iv;
        }
        finally {
            if (!closed$iv) {
                $receiver$iv.close();
            }
        }
        byte[] byArray = md.digest();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "md.digest()");
        return byArray;
    }

    static {
        CLASSPATH_FILE_ID_DIGEST = CLASSPATH_FILE_ID_DIGEST;
        DEFAULT_CLASSPATH_WATCH_PERIOD_MS = 1000L;
        DEFAULT_CLASSPATH_DIGEST_WATCH_PERIOD_MS = 300000L;
    }
}

