/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import com.google.common.collect.Maps;
import com.google.dart.compiler.backend.js.ast.JsDynamicScope;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.intellij.openapi.util.Factory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.js.config.Config;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.StandardClasses;
import org.jetbrains.kotlin.js.translate.context.generator.Generator;
import org.jetbrains.kotlin.js.translate.context.generator.Rule;
import org.jetbrains.kotlin.js.translate.intrinsic.Intrinsics;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.ManglingUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;

public final class StaticContext {
    @NotNull
    private final JsProgram program;
    @NotNull
    private final BindingTrace bindingTrace;
    @NotNull
    private final Namer namer;
    @NotNull
    private final Intrinsics intrinsics;
    @NotNull
    private final StandardClasses standardClasses;
    @NotNull
    private final ReflectionTypes reflectionTypes;
    @NotNull
    private final JsScope rootScope;
    @NotNull
    private final Generator<JsName> names;
    @NotNull
    private final Map<FqName, JsName> packageNames;
    @NotNull
    private final Generator<JsScope> scopes;
    @NotNull
    private final Generator<JsExpression> qualifiers;
    @NotNull
    private final Generator<Boolean> qualifierIsNull;
    @NotNull
    private final Map<JsScope, JsFunction> scopeToFunction;
    @NotNull
    private final Config config;
    @NotNull
    private final EcmaVersion ecmaVersion;

    public static StaticContext generateStaticContext(@NotNull BindingTrace bindingTrace, @NotNull Config config, @NotNull ModuleDescriptor moduleDescriptor) {
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/kotlin/js/translate/context/StaticContext", "generateStaticContext"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/translate/context/StaticContext", "generateStaticContext"));
        }
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "generateStaticContext"));
        }
        JsProgram program = new JsProgram("main");
        Namer namer = Namer.newInstance(program.getRootScope());
        Intrinsics intrinsics = new Intrinsics();
        StandardClasses standardClasses = StandardClasses.bindImplementations(namer.getKotlinScope());
        return new StaticContext(program, bindingTrace, namer, intrinsics, standardClasses, program.getRootScope(), config, moduleDescriptor);
    }

    private StaticContext(@NotNull JsProgram program, @NotNull BindingTrace bindingTrace, @NotNull Namer namer, @NotNull Intrinsics intrinsics, @NotNull StandardClasses standardClasses, @NotNull JsScope rootScope2, @NotNull Config config, @NotNull ModuleDescriptor moduleDescriptor) {
        if (program == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "program", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (namer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namer", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (intrinsics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intrinsics", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (standardClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "standardClasses", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (rootScope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootScope", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        this.names = new NameGenerator();
        this.packageNames = Maps.newHashMap();
        this.scopes = new ScopeGenerator();
        this.qualifiers = new QualifierGenerator();
        this.qualifierIsNull = new QualifierIsNullGenerator();
        this.scopeToFunction = Maps.newHashMap();
        this.program = program;
        this.bindingTrace = bindingTrace;
        this.namer = namer;
        this.intrinsics = intrinsics;
        this.rootScope = rootScope2;
        this.standardClasses = standardClasses;
        this.config = config;
        this.ecmaVersion = config.getTarget();
        this.reflectionTypes = new ReflectionTypes(moduleDescriptor);
    }

    public boolean isEcma5() {
        return this.ecmaVersion == EcmaVersion.v5;
    }

    @NotNull
    public JsProgram getProgram() {
        JsProgram jsProgram = this.program;
        if (jsProgram == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getProgram"));
        }
        return jsProgram;
    }

    @NotNull
    public BindingTrace getBindingTrace() {
        BindingTrace bindingTrace = this.bindingTrace;
        if (bindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getBindingTrace"));
        }
        return bindingTrace;
    }

    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.bindingTrace.getBindingContext();
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getBindingContext"));
        }
        return bindingContext;
    }

    @NotNull
    public Intrinsics getIntrinsics() {
        Intrinsics intrinsics = this.intrinsics;
        if (intrinsics == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getIntrinsics"));
        }
        return intrinsics;
    }

    @NotNull
    public Namer getNamer() {
        Namer namer = this.namer;
        if (namer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNamer"));
        }
        return namer;
    }

    @NotNull
    public ReflectionTypes getReflectionTypes() {
        ReflectionTypes reflectionTypes = this.reflectionTypes;
        if (reflectionTypes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getReflectionTypes"));
        }
        return reflectionTypes;
    }

    @NotNull
    public JsScope getRootScope() {
        JsScope jsScope = this.rootScope;
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getRootScope"));
        }
        return jsScope;
    }

    @NotNull
    public JsScope getScopeForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getScopeForDescriptor"));
        }
        JsScope scope2 = this.scopes.get(descriptor2.getOriginal());
        assert (scope2 != null) : "Must have a scope for descriptor";
        JsScope jsScope = scope2;
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getScopeForDescriptor"));
        }
        return jsScope;
    }

    @NotNull
    public JsFunction getFunctionWithScope(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getFunctionWithScope"));
        }
        JsScope scope2 = this.getScopeForDescriptor(descriptor2);
        JsFunction function = this.scopeToFunction.get(scope2);
        assert (scope2.equals(function.getScope())) : "Inconsistency.";
        JsFunction jsFunction = function;
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getFunctionWithScope"));
        }
        return jsFunction;
    }

    @NotNull
    public JsNameRef getQualifiedReference(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifiedReference"));
        }
        if (descriptor2 instanceof PackageViewDescriptor) {
            JsNameRef jsNameRef = this.getQualifiedReference(((PackageViewDescriptor)descriptor2).getFqName());
            if (jsNameRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifiedReference"));
            }
            return jsNameRef;
        }
        if (descriptor2 instanceof PackageFragmentDescriptor) {
            JsNameRef jsNameRef = this.getQualifiedReference(((PackageFragmentDescriptor)descriptor2).getFqName());
            if (jsNameRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifiedReference"));
            }
            return jsNameRef;
        }
        JsNameRef jsNameRef = new JsNameRef(this.getNameForDescriptor(descriptor2), this.getQualifierForDescriptor(descriptor2));
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifiedReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsNameRef getQualifiedReference(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifiedReference"));
        }
        JsNameRef jsNameRef = new JsNameRef(this.getNameForPackage(packageFqName), packageFqName.isRoot() ? null : this.getQualifierForParentPackage(packageFqName.parent()));
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifiedReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsName getNameForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForDescriptor"));
        }
        JsName name = this.names.get(descriptor2.getOriginal());
        assert (name != null) : "Must have name for descriptor";
        JsName jsName = name;
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForDescriptor"));
        }
        return jsName;
    }

    @NotNull
    public JsName getNameForPackage(final @NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForPackage"));
        }
        JsName jsName = ContainerUtil.getOrCreate(this.packageNames, packageFqName, new Factory<JsName>(){

            @Override
            public JsName create() {
                String name = Namer.generatePackageName(packageFqName);
                return StaticContext.this.getRootScope().declareName(name);
            }
        });
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForPackage"));
        }
        return jsName;
    }

    @NotNull
    private JsNameRef getQualifierForParentPackage(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifierForParentPackage"));
        }
        JsNameRef result = null;
        JsNameRef qualifier2 = null;
        FqName fqName2 = packageFqName;
        while (true) {
            JsNameRef ref = this.getNameForPackage(fqName2).makeRef();
            if (qualifier2 == null) {
                result = ref;
            } else {
                qualifier2.setQualifier(ref);
            }
            qualifier2 = ref;
            if (fqName2.isRoot()) break;
            fqName2 = fqName2.parent();
        }
        JsNameRef jsNameRef = result;
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifierForParentPackage"));
        }
        return jsNameRef;
    }

    @NotNull
    public Config getConfig() {
        Config config = this.config;
        if (config == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getConfig"));
        }
        return config;
    }

    @NotNull
    public JsName declarePropertyOrPropertyAccessorName(@NotNull DeclarationDescriptor descriptor2, @NotNull String name, boolean fresh) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "declarePropertyOrPropertyAccessorName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/translate/context/StaticContext", "declarePropertyOrPropertyAccessorName"));
        }
        JsScope scope2 = this.getEnclosingScope(descriptor2);
        JsName jsName = fresh ? scope2.declareFreshName(name) : scope2.declareName(name);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "declarePropertyOrPropertyAccessorName"));
        }
        return jsName;
    }

    @NotNull
    private JsScope getEnclosingScope(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getEnclosingScope"));
        }
        DeclarationDescriptor containingDeclaration = JsDescriptorUtils.getContainingDeclaration(descriptor2);
        JsScope jsScope = this.getScopeForDescriptor(containingDeclaration.getOriginal());
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getEnclosingScope"));
        }
        return jsScope;
    }

    @Nullable
    public JsExpression getQualifierForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifierForDescriptor"));
        }
        if (this.qualifierIsNull.get(descriptor2.getOriginal()) != null) {
            return null;
        }
        return this.qualifiers.get(descriptor2.getOriginal());
    }

    private static class QualifierIsNullGenerator
    extends Generator<Boolean> {
        private QualifierIsNullGenerator() {
            Rule<Boolean> propertiesInClassHaveNoQualifiers = new Rule<Boolean>(){

                @Override
                public Boolean apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$QualifierIsNullGenerator$1", "apply"));
                    }
                    if (descriptor2 instanceof PropertyDescriptor && descriptor2.getContainingDeclaration() instanceof ClassDescriptor) {
                        return true;
                    }
                    return null;
                }
            };
            this.addRule(propertiesInClassHaveNoQualifiers);
        }
    }

    private final class QualifierGenerator
    extends Generator<JsExpression> {
        public QualifierGenerator() {
            Rule<JsExpression> standardObjectsHaveKotlinQualifier = new Rule<JsExpression>(){

                @Override
                public JsExpression apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$QualifierGenerator$1", "apply"));
                    }
                    if (!StaticContext.this.standardClasses.isStandardObject(descriptor2)) {
                        return null;
                    }
                    return StaticContext.this.namer.kotlinObject();
                }
            };
            Rule<JsExpression> packageLevelDeclarationsHaveEnclosingPackagesNamesAsQualifier = new Rule<JsExpression>(){

                @Override
                public JsExpression apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$QualifierGenerator$2", "apply"));
                    }
                    if (AnnotationsUtils.isNativeObject(descriptor2)) {
                        return null;
                    }
                    DeclarationDescriptor containingDescriptor = JsDescriptorUtils.getContainingDeclaration(descriptor2);
                    if (!(containingDescriptor instanceof PackageFragmentDescriptor)) {
                        return null;
                    }
                    JsNameRef result = StaticContext.this.getQualifierForParentPackage(((PackageFragmentDescriptor)containingDescriptor).getFqName());
                    String moduleName = JsDescriptorUtils.getExternalModuleName(descriptor2);
                    if (moduleName == null) {
                        return result;
                    }
                    if ("<unknown>".equals(moduleName)) {
                        return null;
                    }
                    return JsAstUtils.replaceRootReference(result, StaticContext.this.namer.getModuleReference(StaticContext.this.program.getStringLiteral(moduleName)));
                }
            };
            Rule<JsExpression> constructorOrCompanionObjectHasTheSameQualifierAsTheClass = new Rule<JsExpression>(){

                @Override
                public JsExpression apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$QualifierGenerator$3", "apply"));
                    }
                    if (descriptor2 instanceof ConstructorDescriptor || DescriptorUtils.isCompanionObject(descriptor2)) {
                        return StaticContext.this.getQualifierForDescriptor(descriptor2.getContainingDeclaration());
                    }
                    return null;
                }
            };
            Rule<JsExpression> libraryObjectsHaveKotlinQualifier = new Rule<JsExpression>(){

                @Override
                public JsExpression apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$QualifierGenerator$4", "apply"));
                    }
                    if (AnnotationsUtils.isLibraryObject(descriptor2)) {
                        return StaticContext.this.namer.kotlinObject();
                    }
                    return null;
                }
            };
            Rule<JsExpression> nativeObjectsHaveNativePartOfFullQualifier = new Rule<JsExpression>(){

                @Override
                public JsExpression apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$QualifierGenerator$5", "apply"));
                    }
                    if (descriptor2 instanceof ConstructorDescriptor || !AnnotationsUtils.isNativeObject(descriptor2)) {
                        return null;
                    }
                    DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
                    if (containingDeclaration != null && AnnotationsUtils.isNativeObject(containingDeclaration)) {
                        return StaticContext.this.getQualifiedReference(containingDeclaration);
                    }
                    return null;
                }
            };
            Rule<JsExpression> staticMembersHaveContainerQualifier = new Rule<JsExpression>(){

                @Override
                public JsExpression apply(@NotNull DeclarationDescriptor descriptor2) {
                    CallableDescriptor callableDescriptor;
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$QualifierGenerator$6", "apply"));
                    }
                    if (descriptor2 instanceof CallableDescriptor && !AnnotationsUtils.isNativeObject(descriptor2) && DescriptorUtils.isStaticDeclaration(callableDescriptor = (CallableDescriptor)descriptor2)) {
                        return StaticContext.this.getQualifiedReference(callableDescriptor.getContainingDeclaration());
                    }
                    return null;
                }
            };
            this.addRule(libraryObjectsHaveKotlinQualifier);
            this.addRule(constructorOrCompanionObjectHasTheSameQualifierAsTheClass);
            this.addRule(standardObjectsHaveKotlinQualifier);
            this.addRule(packageLevelDeclarationsHaveEnclosingPackagesNamesAsQualifier);
            this.addRule(nativeObjectsHaveNativePartOfFullQualifier);
            this.addRule(staticMembersHaveContainerQualifier);
        }
    }

    private final class ScopeGenerator
    extends Generator<JsScope> {
        public ScopeGenerator() {
            Rule<JsScope> generateNewScopesForClassesWithNoAncestors = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$ScopeGenerator$1", "apply"));
                    }
                    if (!(descriptor2 instanceof ClassDescriptor)) {
                        return null;
                    }
                    if (JsDescriptorUtils.getSuperclass((ClassDescriptor)descriptor2) == null) {
                        return StaticContext.this.getRootScope().innerObjectScope("Scope for class " + descriptor2.getName());
                    }
                    return null;
                }
            };
            Rule<JsScope> generateInnerScopesForDerivedClasses = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$ScopeGenerator$2", "apply"));
                    }
                    if (!(descriptor2 instanceof ClassDescriptor)) {
                        return null;
                    }
                    ClassDescriptor superclass = JsDescriptorUtils.getSuperclass((ClassDescriptor)descriptor2);
                    if (superclass == null) {
                        return null;
                    }
                    return StaticContext.this.getScopeForDescriptor(superclass).innerObjectScope("Scope for class " + descriptor2.getName());
                }
            };
            Rule<JsScope> generateNewScopesForPackageDescriptors = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$ScopeGenerator$3", "apply"));
                    }
                    if (!(descriptor2 instanceof PackageFragmentDescriptor)) {
                        return null;
                    }
                    return StaticContext.this.getRootScope().innerObjectScope("Package " + descriptor2.getName());
                }
            };
            Rule<JsScope> generateInnerScopesForMembers = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$ScopeGenerator$4", "apply"));
                    }
                    JsScope enclosingScope = StaticContext.this.getEnclosingScope(descriptor2);
                    return enclosingScope.innerObjectScope("Scope for member " + descriptor2.getName());
                }
            };
            Rule<JsScope> createFunctionObjectsForCallableDescriptors = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$ScopeGenerator$5", "apply"));
                    }
                    if (!(descriptor2 instanceof CallableDescriptor)) {
                        return null;
                    }
                    JsScope enclosingScope = StaticContext.this.getEnclosingScope(descriptor2);
                    JsFunction correspondingFunction = JsAstUtils.createFunctionWithEmptyBody(enclosingScope);
                    assert (!StaticContext.this.scopeToFunction.containsKey(correspondingFunction.getScope())) : "Scope to function value overridden for " + descriptor2;
                    StaticContext.this.scopeToFunction.put(correspondingFunction.getScope(), correspondingFunction);
                    return correspondingFunction.getScope();
                }
            };
            this.addRule(createFunctionObjectsForCallableDescriptors);
            this.addRule(generateNewScopesForClassesWithNoAncestors);
            this.addRule(generateInnerScopesForDerivedClasses);
            this.addRule(generateNewScopesForPackageDescriptors);
            this.addRule(generateInnerScopesForMembers);
        }
    }

    private final class NameGenerator
    extends Generator<JsName> {
        public NameGenerator() {
            Rule<JsName> namesForDynamic = new Rule<JsName>(){

                @Override
                @Nullable
                public JsName apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$NameGenerator$1", "apply"));
                    }
                    if (DynamicCallsKt.isDynamic(descriptor2)) {
                        String name = descriptor2.getName().asString();
                        return JsDynamicScope.INSTANCE.declareName(name);
                    }
                    return null;
                }
            };
            Rule<JsName> namesForStandardClasses = new Rule<JsName>(){

                @Override
                @Nullable
                public JsName apply(@NotNull DeclarationDescriptor data) {
                    if (data == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/kotlin/js/translate/context/StaticContext$NameGenerator$2", "apply"));
                    }
                    if (!StaticContext.this.standardClasses.isStandardObject(data)) {
                        return null;
                    }
                    return StaticContext.this.standardClasses.getStandardObjectName(data);
                }
            };
            Rule<JsName> memberDeclarationsInsideParentsScope = new Rule<JsName>(){

                @Override
                @Nullable
                public JsName apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$NameGenerator$3", "apply"));
                    }
                    JsScope scope2 = StaticContext.this.getEnclosingScope(descriptor2);
                    return scope2.declareFreshName(ManglingUtils.getSuggestedName(descriptor2));
                }
            };
            Rule<JsName> constructorOrCompanionObjectHasTheSameNameAsTheClass = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$NameGenerator$4", "apply"));
                    }
                    if (descriptor2 instanceof ConstructorDescriptor && ((ConstructorDescriptor)descriptor2).isPrimary() || DescriptorUtils.isCompanionObject(descriptor2)) {
                        return StaticContext.this.getNameForDescriptor(descriptor2.getContainingDeclaration());
                    }
                    return null;
                }
            };
            Rule<JsName> propertyOrPropertyAccessor = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor2) {
                    PropertyDescriptor propertyDescriptor;
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$NameGenerator$5", "apply"));
                    }
                    if (descriptor2 instanceof PropertyAccessorDescriptor) {
                        propertyDescriptor = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
                    } else if (descriptor2 instanceof PropertyDescriptor) {
                        propertyDescriptor = (PropertyDescriptor)descriptor2;
                    } else {
                        return null;
                    }
                    String nameFromAnnotation = AnnotationsUtils.getNameForAnnotatedObjectWithOverrides(propertyDescriptor);
                    if (nameFromAnnotation != null) {
                        return StaticContext.this.declarePropertyOrPropertyAccessorName(descriptor2, nameFromAnnotation, false);
                    }
                    String propertyName = ManglingUtils.getSuggestedName((DeclarationDescriptor)propertyDescriptor);
                    if (!DescriptorUtils.isExtension(propertyDescriptor)) {
                        if (Visibilities.isPrivate(propertyDescriptor.getVisibility())) {
                            propertyName = ManglingUtils.getMangledName(propertyDescriptor, propertyName);
                        }
                        return StaticContext.this.declarePropertyOrPropertyAccessorName(descriptor2, propertyName, false);
                    }
                    assert (!(descriptor2 instanceof PropertyDescriptor)) : "descriptor should not be instance of PropertyDescriptor: " + descriptor2;
                    boolean isGetter = descriptor2 instanceof PropertyGetterDescriptor;
                    String accessorName = Namer.getNameForAccessor(propertyName, isGetter, false);
                    return StaticContext.this.declarePropertyOrPropertyAccessorName(descriptor2, accessorName, false);
                }
            };
            Rule<JsName> predefinedObjectsHasUnobfuscatableNames = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor2) {
                    String name;
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$NameGenerator$6", "apply"));
                    }
                    if (descriptor2 instanceof CallableMemberDescriptor && !((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors().isEmpty()) {
                        return null;
                    }
                    if (descriptor2 instanceof ConstructorDescriptor) {
                        DeclarationDescriptor classDescriptor = descriptor2.getContainingDeclaration();
                        assert (classDescriptor != null);
                        descriptor2 = classDescriptor;
                    }
                    if ((name = AnnotationsUtils.getNameForAnnotatedObjectWithOverrides(descriptor2)) != null) {
                        return StaticContext.this.getEnclosingScope(descriptor2).declareName(name);
                    }
                    return null;
                }
            };
            Rule<JsName> overridingDescriptorsReferToOriginalName = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$NameGenerator$7", "apply"));
                    }
                    if (!(descriptor2 instanceof FunctionDescriptor)) {
                        return null;
                    }
                    FunctionDescriptor overriddenDescriptor = JsDescriptorUtils.getOverriddenDescriptor((FunctionDescriptor)descriptor2);
                    if (overriddenDescriptor == null) {
                        return null;
                    }
                    JsScope scope2 = StaticContext.this.getEnclosingScope(descriptor2);
                    JsName result = StaticContext.this.getNameForDescriptor(overriddenDescriptor);
                    scope2.declareName(result.getIdent());
                    return result;
                }
            };
            this.addRule(namesForDynamic);
            this.addRule(namesForStandardClasses);
            this.addRule(constructorOrCompanionObjectHasTheSameNameAsTheClass);
            this.addRule(propertyOrPropertyAccessor);
            this.addRule(predefinedObjectsHasUnobfuscatableNames);
            this.addRule(overridingDescriptorsReferToOriginalName);
            this.addRule(memberDeclarationsInsideParentsScope);
        }
    }
}

