/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadataKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/InlineMetadata;", "", "tag", "Lcom/google/dart/compiler/backend/js/ast/JsStringLiteral;", "function", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "(Lcom/google/dart/compiler/backend/js/ast/JsStringLiteral;Lcom/google/dart/compiler/backend/js/ast/JsFunction;)V", "getFunction", "()Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "functionWithMetadata", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "getFunctionWithMetadata", "()Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "getTag", "()Lcom/google/dart/compiler/backend/js/ast/JsStringLiteral;", "Companion", "kotlin-compiler"})
@KotlinClass(version={1, 1, 0}, data={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, strings={"Lorg/jetbrains/kotlin/js/translate/expression/InlineMetadata;", "", "tag", "Lcom/google/dart/compiler/backend/js/ast/JsStringLiteral;", "function", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "(Lcom/google/dart/compiler/backend/js/ast/JsStringLiteral;Lcom/google/dart/compiler/backend/js/ast/JsFunction;)V", "getFunction", "()Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "functionWithMetadata", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "getFunctionWithMetadata", "()Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "getTag", "()Lcom/google/dart/compiler/backend/js/ast/JsStringLiteral;", "Companion", "kotlin-compiler"})
public final class InlineMetadata {
    @NotNull
    private final JsStringLiteral tag;
    @NotNull
    private final JsFunction function;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final JsExpression getFunctionWithMetadata() {
        List<JsExpression> propertiesList = CollectionsKt.listOf(this.tag, this.function);
        return new JsInvocation((JsExpression)Namer.CREATE_INLINE_FUNCTION, propertiesList);
    }

    @NotNull
    public final JsStringLiteral getTag() {
        return this.tag;
    }

    @NotNull
    public final JsFunction getFunction() {
        return this.function;
    }

    public InlineMetadata(@NotNull JsStringLiteral tag, @NotNull JsFunction function) {
        Intrinsics.checkParameterIsNotNull(tag, "tag");
        Intrinsics.checkParameterIsNotNull(function, "function");
        this.tag = tag;
        this.function = function;
    }

    @JvmStatic
    @NotNull
    public static final InlineMetadata compose(@NotNull JsFunction function, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        return Companion.compose(function, descriptor2);
    }

    @JvmStatic
    @Nullable
    public static final InlineMetadata decompose(@Nullable JsExpression expression) {
        return Companion.decompose(expression);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0014\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/InlineMetadata$Companion;", "", "()V", "compose", "Lorg/jetbrains/kotlin/js/translate/expression/InlineMetadata;", "function", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "decompose", "expression", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "decomposeCreateFunctionCall", "call", "Lcom/google/dart/compiler/backend/js/ast/JsInvocation;", "kotlin-compiler"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0014\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, strings={"Lorg/jetbrains/kotlin/js/translate/expression/InlineMetadata$Companion;", "", "()V", "compose", "Lorg/jetbrains/kotlin/js/translate/expression/InlineMetadata;", "function", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "decompose", "expression", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "decomposeCreateFunctionCall", "call", "Lcom/google/dart/compiler/backend/js/ast/JsInvocation;", "kotlin-compiler"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final InlineMetadata compose(@NotNull JsFunction function, @NotNull CallableDescriptor descriptor2) {
            JsStringLiteral tag;
            Intrinsics.checkParameterIsNotNull(function, "function");
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            JsProgram program = function.getScope().getProgram();
            JsStringLiteral jsStringLiteral = tag = program.getStringLiteral(Namer.getFunctionTag(descriptor2));
            Intrinsics.checkExpressionValueIsNotNull(jsStringLiteral, "tag");
            return new InlineMetadata(jsStringLiteral, function);
        }

        @JvmStatic
        @Nullable
        public final InlineMetadata decompose(@Nullable JsExpression expression) {
            JsExpression jsExpression = expression;
            return jsExpression instanceof JsInvocation ? this.decomposeCreateFunctionCall((JsInvocation)expression) : (InlineMetadata)null;
        }

        private final InlineMetadata decomposeCreateFunctionCall(JsInvocation call) {
            if (Intrinsics.areEqual(Namer.CREATE_INLINE_FUNCTION, call.getQualifier()) ^ true) {
                return null;
            }
            List<JsExpression> arguments2 = call.getArguments();
            if (arguments2.size() != InlineMetadataKt.access$getMETADATA_PROPERTIES_COUNT$p()) {
                return null;
            }
            JsExpression jsExpression = arguments2.get(0);
            if (!(jsExpression instanceof JsStringLiteral)) {
                jsExpression = null;
            }
            JsStringLiteral tag = (JsStringLiteral)jsExpression;
            JsExpression jsExpression2 = arguments2.get(1);
            if (!(jsExpression2 instanceof JsFunction)) {
                jsExpression2 = null;
            }
            JsFunction function = (JsFunction)jsExpression2;
            if (tag == null || function == null) {
                return null;
            }
            return new InlineMetadata(tag, function);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

