/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslatorKt;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0003\u0011\u0012\u0013B%\b\u0002\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiver", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/google/dart/compiler/backend/js/ast/JsExpression;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "isNativeFunctionCall", "", "removeLastUndefinedArguments", "", "result", "", "translate", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "ArgumentsInfo", "ArgumentsKind", "Companion", "kotlin-compiler"})
@KotlinClass(version={1, 1, 0}, data={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0003\u0011\u0012\u0013B%\b\u0002\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, strings={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiver", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/google/dart/compiler/backend/js/ast/JsExpression;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "isNativeFunctionCall", "", "removeLastUndefinedArguments", "", "result", "", "translate", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "ArgumentsInfo", "ArgumentsKind", "Companion", "kotlin-compiler"})
public final class CallArgumentTranslator
extends AbstractTranslator {
    private final boolean isNativeFunctionCall;
    private final ResolvedCall<?> resolvedCall;
    private final JsExpression receiver;
    public static final Companion Companion = new Companion(null);

    private final void removeLastUndefinedArguments(List<JsExpression> result) {
        int i;
        for (i = result.size() - 1; i >= 0 && !(Intrinsics.areEqual(result.get(i), this.context().namer().getUndefinedExpression()) ^ true); --i) {
        }
        result.subList(i + 1, result.size()).clear();
    }

    private final ArgumentsInfo translate() {
        List<ValueParameterDescriptor> valueParameters = this.resolvedCall.getResultingDescriptor().getValueParameters();
        if (valueParameters.isEmpty()) {
            return new ArgumentsInfo(CollectionsKt.listOf(), false, null, null, 8, null);
        }
        boolean hasSpreadOperator = false;
        TemporaryConstVariable cachedReceiver = null;
        List result = new ArrayList(valueParameters.size());
        List<ResolvedValueArgument> valueArgumentsByIndex = this.resolvedCall.getValueArgumentsByIndex();
        if (valueArgumentsByIndex == null) {
            throw (Throwable)new IllegalStateException("Failed to arrange value arguments by index: " + this.resolvedCall.getResultingDescriptor());
        }
        List argsBeforeVararg = null;
        boolean argumentsShouldBeExtractedToTmpVars = false;
        SmartList<TranslationContext> argContexts = new SmartList<TranslationContext>();
        ArgumentsKind kind = ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT;
        List concatArguments = null;
        for (ValueParameterDescriptor parameterDescriptor : valueParameters) {
            ResolvedValueArgument actualArgument = valueArgumentsByIndex.get(parameterDescriptor.getIndex());
            TranslationContext argContext = this.context().innerBlock();
            if (actualArgument instanceof VarargValueArgument) {
                List<ValueArgument> arguments2 = actualArgument.getArguments();
                int size = arguments2.size();
                for (int i = 0; i != size; ++i) {
                    if (arguments2.get(i).getSpreadElement() == null) continue;
                    hasSpreadOperator = true;
                    break;
                }
                if (hasSpreadOperator) {
                    if (this.isNativeFunctionCall) {
                        argsBeforeVararg = result;
                        result = new SmartList();
                        SmartList list2 = new SmartList();
                        List<ValueArgument> list3 = arguments2;
                        Intrinsics.checkExpressionValueIsNotNull(list3, "arguments");
                        List list4 = list2;
                        TranslationContext translationContext = argContext;
                        Intrinsics.checkExpressionValueIsNotNull(translationContext, "argContext");
                        kind = CallArgumentTranslator.Companion.translateValueArguments(list3, list4, translationContext);
                        List<ValueArgument> list5 = arguments2;
                        Intrinsics.checkExpressionValueIsNotNull(list5, "arguments");
                        concatArguments = CallArgumentTranslator.Companion.prepareConcatArguments(list5, list2);
                    } else {
                        List<ValueArgument> list6 = arguments2;
                        Intrinsics.checkExpressionValueIsNotNull(list6, "arguments");
                        TranslationContext translationContext = argContext;
                        Intrinsics.checkExpressionValueIsNotNull(translationContext, "argContext");
                        kind = CallArgumentTranslator.Companion.translateVarargArgument(list6, result, translationContext, size > 1);
                    }
                } else {
                    List<ValueArgument> list7 = arguments2;
                    Intrinsics.checkExpressionValueIsNotNull(list7, "arguments");
                    TranslationContext translationContext = argContext;
                    Intrinsics.checkExpressionValueIsNotNull(translationContext, "argContext");
                    kind = CallArgumentTranslator.Companion.translateVarargArgument(list7, result, translationContext, !this.isNativeFunctionCall);
                }
            } else {
                ResolvedValueArgument resolvedValueArgument = actualArgument;
                Intrinsics.checkExpressionValueIsNotNull(resolvedValueArgument, "actualArgument");
                TranslationContext translationContext = argContext;
                Intrinsics.checkExpressionValueIsNotNull(translationContext, "argContext");
                kind = CallArgumentTranslator.Companion.translateSingleArgument(resolvedValueArgument, result, translationContext);
            }
            this.context().moveVarsFrom(argContext);
            argContexts.add(argContext);
            boolean bl = argumentsShouldBeExtractedToTmpVars = argumentsShouldBeExtractedToTmpVars || !argContext.currentBlockIsEmpty();
            if (!Intrinsics.areEqual((Object)kind, (Object)ArgumentsKind.HAS_EMPTY_EXPRESSION_ARGUMENT)) continue;
            break;
        }
        if (argumentsShouldBeExtractedToTmpVars) {
            List list8 = argContexts;
            TranslationContext translationContext = this.context();
            Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
            CallArgumentTranslator.Companion.extractArguments(result, list8, translationContext, Intrinsics.areEqual((Object)kind, (Object)ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT));
        }
        if (this.isNativeFunctionCall && hasSpreadOperator) {
            Unit unit;
            Unit unit2;
            String message$iv;
            boolean value$iv;
            boolean parameterDescriptor = argsBeforeVararg != null;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                if (!value$iv) {
                    message$iv = "argsBeforeVararg should not be null";
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = Unit.INSTANCE;
            }
            value$iv = concatArguments != null;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                if (!value$iv) {
                    message$iv = "concatArguments should not be null";
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            List list9 = concatArguments;
            if (list9 == null) {
                Intrinsics.throwNpe();
            }
            list9.addAll(result);
            List list10 = argsBeforeVararg;
            if (list10 == null) {
                Intrinsics.throwNpe();
            }
            if (!list10.isEmpty()) {
                concatArguments.add(0, new JsArrayLiteral(argsBeforeVararg));
            }
            result = new SmartList<JsExpression>(CallArgumentTranslator.Companion.concatArgumentsIfNeeded(concatArguments));
            if (this.receiver != null) {
                cachedReceiver = this.context().getOrDeclareTemporaryConstVariable(this.receiver);
                JsNameRef jsNameRef = cachedReceiver.reference();
                Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "cachedReceiver.reference()");
                result.add(0, jsNameRef);
            } else {
                JsNullLiteral jsNullLiteral = JsLiteral.NULL;
                Intrinsics.checkExpressionValueIsNotNull(jsNullLiteral, "JsLiteral.NULL");
                result.add(0, jsNullLiteral);
            }
        }
        this.removeLastUndefinedArguments(result);
        return new ArgumentsInfo(result, hasSpreadOperator, cachedReceiver, null, 8, null);
    }

    private CallArgumentTranslator(ResolvedCall<?> resolvedCall, JsExpression receiver, TranslationContext context) {
        super(context);
        this.resolvedCall = resolvedCall;
        this.receiver = receiver;
        this.isNativeFunctionCall = AnnotationsUtils.isNativeObject((DeclarationDescriptor)this.resolvedCall.getCandidateDescriptor());
    }

    public /* synthetic */ CallArgumentTranslator(@NotNull ResolvedCall resolvedCall, @Nullable JsExpression receiver, @NotNull TranslationContext context, DefaultConstructorMarker $constructor_marker) {
        this(resolvedCall, receiver, context);
    }

    @JvmStatic
    @NotNull
    public static final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return Companion.translate(resolvedCall, receiver, context);
    }

    @JvmStatic
    @NotNull
    public static final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall, @Nullable JsExpression receiver, @NotNull TranslationContext context, @NotNull JsBlock block) {
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(block, "block");
        return Companion.translate(resolvedCall, receiver, context, block);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J?\u0010\u0018\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "", "valueArguments", "", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "hasSpreadOperator", "", "cachedReceiver", "Lorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;", "reifiedArguments", "(Ljava/util/List;ZLorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;Ljava/util/List;)V", "getCachedReceiver", "()Lorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;", "getHasSpreadOperator", "()Z", "getReifiedArguments", "()Ljava/util/List;", "translateArguments", "getTranslateArguments", "getValueArguments", "component1", "component2", "component3", "component4", "copy", "kotlin-compiler"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J?\u0010\u0018\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0019"}, strings={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "", "valueArguments", "", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "hasSpreadOperator", "", "cachedReceiver", "Lorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;", "reifiedArguments", "(Ljava/util/List;ZLorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;Ljava/util/List;)V", "getCachedReceiver", "()Lorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;", "getHasSpreadOperator", "()Z", "getReifiedArguments", "()Ljava/util/List;", "translateArguments", "getTranslateArguments", "getValueArguments", "component1", "component2", "component3", "component4", "copy", "kotlin-compiler"})
    public static final class ArgumentsInfo {
        @NotNull
        private final List<JsExpression> valueArguments;
        private final boolean hasSpreadOperator;
        @Nullable
        private final TemporaryConstVariable cachedReceiver;
        @NotNull
        private final List<JsExpression> reifiedArguments;

        @NotNull
        public final List<JsExpression> getTranslateArguments() {
            return CollectionsKt.plus((Collection)this.reifiedArguments, (Iterable)this.valueArguments);
        }

        @NotNull
        public final List<JsExpression> getValueArguments() {
            return this.valueArguments;
        }

        public final boolean getHasSpreadOperator() {
            return this.hasSpreadOperator;
        }

        @Nullable
        public final TemporaryConstVariable getCachedReceiver() {
            return this.cachedReceiver;
        }

        @NotNull
        public final List<JsExpression> getReifiedArguments() {
            return this.reifiedArguments;
        }

        public ArgumentsInfo(@NotNull List<? extends JsExpression> valueArguments2, boolean hasSpreadOperator, @Nullable TemporaryConstVariable cachedReceiver, @NotNull List<? extends JsExpression> reifiedArguments) {
            Intrinsics.checkParameterIsNotNull(valueArguments2, "valueArguments");
            Intrinsics.checkParameterIsNotNull(reifiedArguments, "reifiedArguments");
            this.valueArguments = valueArguments2;
            this.hasSpreadOperator = hasSpreadOperator;
            this.cachedReceiver = cachedReceiver;
            this.reifiedArguments = reifiedArguments;
        }

        public /* synthetic */ ArgumentsInfo(List list2, boolean bl, TemporaryConstVariable temporaryConstVariable, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                list3 = CollectionsKt.listOf();
            }
            this(list2, bl, temporaryConstVariable, list3);
        }

        @NotNull
        public final List<JsExpression> component1() {
            return this.valueArguments;
        }

        public final boolean component2() {
            return this.hasSpreadOperator;
        }

        @Nullable
        public final TemporaryConstVariable component3() {
            return this.cachedReceiver;
        }

        @NotNull
        public final List<JsExpression> component4() {
            return this.reifiedArguments;
        }

        @NotNull
        public final ArgumentsInfo copy(@NotNull List<? extends JsExpression> valueArguments2, boolean hasSpreadOperator, @Nullable TemporaryConstVariable cachedReceiver, @NotNull List<? extends JsExpression> reifiedArguments) {
            Intrinsics.checkParameterIsNotNull(valueArguments2, "valueArguments");
            Intrinsics.checkParameterIsNotNull(reifiedArguments, "reifiedArguments");
            return new ArgumentsInfo(valueArguments2, hasSpreadOperator, cachedReceiver, reifiedArguments);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ArgumentsInfo copy$default(ArgumentsInfo argumentsInfo, List list2, boolean bl, TemporaryConstVariable temporaryConstVariable, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = argumentsInfo.valueArguments;
            }
            if ((n & 2) != 0) {
                bl = argumentsInfo.hasSpreadOperator;
            }
            if ((n & 4) != 0) {
                temporaryConstVariable = argumentsInfo.cachedReceiver;
            }
            if ((n & 8) != 0) {
                list3 = argumentsInfo.reifiedArguments;
            }
            return argumentsInfo.copy(list2, bl, temporaryConstVariable, (List<? extends JsExpression>)list3);
        }

        public static /* bridge */ /* synthetic */ ArgumentsInfo copy$default(ArgumentsInfo argumentsInfo, List list2, boolean bl, TemporaryConstVariable temporaryConstVariable, List list3, int n) {
            return ArgumentsInfo.copy$default(argumentsInfo, list2, bl, temporaryConstVariable, list3, n, null);
        }

        public String toString() {
            return "ArgumentsInfo(valueArguments=" + this.valueArguments + ", hasSpreadOperator=" + this.hasSpreadOperator + ", cachedReceiver=" + this.cachedReceiver + ", reifiedArguments=" + this.reifiedArguments + ")";
        }

        public int hashCode() {
            List<JsExpression> list2 = this.valueArguments;
            int n = (list2 != null ? ((Object)list2).hashCode() : 0) * 31;
            int n2 = this.hasSpreadOperator ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            TemporaryConstVariable temporaryConstVariable = this.cachedReceiver;
            List<JsExpression> list3 = this.reifiedArguments;
            return ((n + n2) * 31 + (temporaryConstVariable != null ? temporaryConstVariable.hashCode() : 0)) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ArgumentsInfo)) break block3;
                    ArgumentsInfo argumentsInfo = (ArgumentsInfo)object;
                    if (!Intrinsics.areEqual(this.valueArguments, argumentsInfo.valueArguments) || !(this.hasSpreadOperator == argumentsInfo.hasSpreadOperator) || !Intrinsics.areEqual(this.cachedReceiver, argumentsInfo.cachedReceiver) || !Intrinsics.areEqual(this.reifiedArguments, argumentsInfo.reifiedArguments)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsKind;", "", "(Ljava/lang/String;I)V", "HAS_EMPTY_EXPRESSION_ARGUMENT", "HAS_NOT_EMPTY_EXPRESSION_ARGUMENT", "kotlin-compiler"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, strings={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsKind;", "", "(Ljava/lang/String;I)V", "HAS_EMPTY_EXPRESSION_ARGUMENT", "HAS_NOT_EMPTY_EXPRESSION_ARGUMENT", "kotlin-compiler"})
    private static final class ArgumentsKind
    extends Enum<ArgumentsKind> {
        public static final /* enum */ ArgumentsKind HAS_EMPTY_EXPRESSION_ARGUMENT;
        public static final /* enum */ ArgumentsKind HAS_NOT_EMPTY_EXPRESSION_ARGUMENT;
        private static final /* synthetic */ ArgumentsKind[] $VALUES;

        static {
            ArgumentsKind[] argumentsKindArray = new ArgumentsKind[2];
            ArgumentsKind[] argumentsKindArray2 = argumentsKindArray;
            argumentsKindArray[0] = HAS_EMPTY_EXPRESSION_ARGUMENT = new ArgumentsKind();
            argumentsKindArray[1] = HAS_NOT_EMPTY_EXPRESSION_ARGUMENT = new ArgumentsKind();
            $VALUES = argumentsKindArray;
        }

        public static ArgumentsKind[] values() {
            return (ArgumentsKind[])$VALUES.clone();
        }

        public static ArgumentsKind valueOf(String string) {
            return Enum.valueOf(ArgumentsKind.class, string);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J4\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J&\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\fH\u0007J.\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\r\u001a\u00020\fH\u0002J,\u0010 \u001a\u00020\u001c2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\r\u001a\u00020\fH\u0002J4\u0010!\u001a\u00020\u001c2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u000fH\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$Companion;", "", "()V", "concatArgumentsIfNeeded", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "concatArguments", "", "extractArguments", "", "argExpressions", "", "argContexts", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "context", "toTmpVars", "", "prepareConcatArguments", "arguments", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "list", "translate", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiver", "block", "Lcom/google/dart/compiler/backend/js/ast/JsBlock;", "translateSingleArgument", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsKind;", "actualArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "result", "translateValueArguments", "translateVarargArgument", "shouldWrapVarargInArray", "kotlin-compiler"})
    @KotlinClass(version={1, 1, 0}, data={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J4\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J&\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\fH\u0007J.\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\r\u001a\u00020\fH\u0002J,\u0010 \u001a\u00020\u001c2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\r\u001a\u00020\fH\u0002J4\u0010!\u001a\u00020\u001c2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u000fH\u0002\u00a8\u0006#"}, strings={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$Companion;", "", "()V", "concatArgumentsIfNeeded", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "concatArguments", "", "extractArguments", "", "argExpressions", "", "argContexts", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "context", "toTmpVars", "", "prepareConcatArguments", "arguments", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "list", "translate", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiver", "block", "Lcom/google/dart/compiler/backend/js/ast/JsBlock;", "translateSingleArgument", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsKind;", "actualArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "result", "translateValueArguments", "translateVarargArgument", "shouldWrapVarargInArray", "kotlin-compiler"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
            Intrinsics.checkParameterIsNotNull(context, "context");
            JsBlock jsBlock = context.dynamicContext().jsBlock();
            Intrinsics.checkExpressionValueIsNotNull(jsBlock, "context.dynamicContext().jsBlock()");
            return this.translate(resolvedCall, receiver, context, jsBlock);
        }

        @JvmStatic
        @NotNull
        public final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall, @Nullable JsExpression receiver, @NotNull TranslationContext context, @NotNull JsBlock block) {
            TranslationContext innerContext;
            Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
            Intrinsics.checkParameterIsNotNull(context, "context");
            Intrinsics.checkParameterIsNotNull(block, "block");
            TranslationContext translationContext = innerContext = context.innerBlock(block);
            Intrinsics.checkExpressionValueIsNotNull(translationContext, "innerContext");
            CallArgumentTranslator argumentTranslator = new CallArgumentTranslator(resolvedCall, receiver, translationContext, null);
            ArgumentsInfo result = argumentTranslator.translate();
            context.moveVarsFrom(innerContext);
            Object callDescriptor = resolvedCall.getCandidateDescriptor();
            if (CallExpressionTranslator.shouldBeInlined(callDescriptor)) {
                Map<TypeParameterDescriptor, KotlinType> typeArgs = resolvedCall.getTypeArguments();
                return CallArgumentTranslatorKt.access$addReifiedTypeArgsTo(typeArgs, result, context);
            }
            return result;
        }

        private final ArgumentsKind translateSingleArgument(ResolvedValueArgument actualArgument, List<JsExpression> result, TranslationContext context) {
            JsExpression jsExpression;
            List<ValueArgument> valueArguments2 = actualArgument.getArguments();
            if (actualArgument instanceof DefaultValueArgument) {
                JsExpression jsExpression2 = context.namer().getUndefinedExpression();
                Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "context.namer().undefinedExpression");
                result.add(jsExpression2);
                return ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT;
            }
            PreconditionsKt.assert(actualArgument instanceof ExpressionValueArgument);
            PreconditionsKt.assert(valueArguments2.size() == 1);
            KtExpression argumentExpression = valueArguments2.get(0).getArgumentExpression();
            PreconditionsKt.assert(argumentExpression != null);
            if (argumentExpression == null) {
                Intrinsics.throwNpe();
            }
            JsExpression jsExpression3 = jsExpression = Translation.translateAsExpression(argumentExpression, context);
            Intrinsics.checkExpressionValueIsNotNull(jsExpression3, "jsExpression");
            result.add(jsExpression3);
            if (JsAstUtils.isEmptyExpression(jsExpression)) {
                return ArgumentsKind.HAS_EMPTY_EXPRESSION_ARGUMENT;
            }
            return ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT;
        }

        private final ArgumentsKind translateVarargArgument(List<? extends ValueArgument> arguments2, List<JsExpression> result, TranslationContext context, boolean shouldWrapVarargInArray) {
            if (arguments2.isEmpty()) {
                if (shouldWrapVarargInArray) {
                    result.add((JsExpression)new JsArrayLiteral(CollectionsKt.<JsExpression>listOf()));
                }
                return ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT;
            }
            List list2 = shouldWrapVarargInArray ? (arguments2.size() == 1 ? (List)new SmartList() : (List)new ArrayList(arguments2.size())) : result;
            ArgumentsKind resultKind = this.translateValueArguments(arguments2, list2, context);
            if (shouldWrapVarargInArray) {
                List<JsExpression> concatArguments = this.prepareConcatArguments(arguments2, list2);
                JsExpression concatExpression = this.concatArgumentsIfNeeded(concatArguments);
                result.add(concatExpression);
            }
            return resultKind;
        }

        private final ArgumentsKind translateValueArguments(List<? extends ValueArgument> arguments2, List<JsExpression> list2, TranslationContext context) {
            ArgumentsKind resultKind = ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT;
            SmartList<TranslationContext> argContexts = new SmartList<TranslationContext>();
            boolean argumentsShouldBeExtractedToTmpVars = false;
            for (ValueArgument valueArgument : arguments2) {
                JsExpression argExpression;
                KtExpression argumentExpression = valueArgument.getArgumentExpression();
                PreconditionsKt.assert(argumentExpression != null);
                if (argumentExpression == null) {
                    Intrinsics.throwNpe();
                }
                TranslationContext argContext = context.innerBlock();
                JsExpression jsExpression = argExpression = Translation.translateAsExpression(argumentExpression, argContext);
                Intrinsics.checkExpressionValueIsNotNull(jsExpression, "argExpression");
                list2.add(jsExpression);
                context.moveVarsFrom(argContext);
                argContexts.add(argContext);
                boolean bl = argumentsShouldBeExtractedToTmpVars = argumentsShouldBeExtractedToTmpVars || !argContext.currentBlockIsEmpty();
                if (!JsAstUtils.isEmptyExpression(argExpression)) continue;
                resultKind = ArgumentsKind.HAS_EMPTY_EXPRESSION_ARGUMENT;
                break;
            }
            if (argumentsShouldBeExtractedToTmpVars) {
                this.extractArguments(list2, (List<? extends TranslationContext>)argContexts, context, Intrinsics.areEqual((Object)resultKind, (Object)ArgumentsKind.HAS_NOT_EMPTY_EXPRESSION_ARGUMENT));
            }
            return resultKind;
        }

        private final JsExpression concatArgumentsIfNeeded(List<? extends JsExpression> concatArguments) {
            Unit unit;
            boolean value$iv = concatArguments.size() > 0;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                if (!value$iv) {
                    String message$iv = "concatArguments.size should not be 0";
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            if (concatArguments.size() > 1) {
                return new JsInvocation((JsExpression)new JsNameRef("concat", concatArguments.get(0)), concatArguments.subList(1, concatArguments.size()));
            }
            return concatArguments.get(0);
        }

        /*
         * WARNING - void declaration
         */
        private final List<JsExpression> prepareConcatArguments(List<? extends ValueArgument> arguments2, List<? extends JsExpression> list2) {
            Unit unit;
            Unit unit2;
            boolean value$iv = arguments2.size() != 0;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                if (!value$iv) {
                    String message$iv = "arguments.size should not be 0";
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = Unit.INSTANCE;
            }
            value$iv = arguments2.size() == list2.size();
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                if (!value$iv) {
                    String message$iv = "arguments.size: " + arguments2.size() + " != list.size: " + list2.size();
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            SmartList<JsExpression> concatArguments = new SmartList<JsExpression>();
            List lastArrayContent = new SmartList();
            int size = arguments2.size();
            int $i$f$assert = 0;
            int n = size - 1;
            if ($i$f$assert <= n) {
                while (true) {
                    void index2;
                    ValueArgument valueArgument = arguments2.get((int)index2);
                    JsExpression expressionArgument = list2.get((int)index2);
                    if (valueArgument.getSpreadElement() != null) {
                        if (lastArrayContent.size() > 0) {
                            concatArguments.add(new JsArrayLiteral(lastArrayContent));
                            concatArguments.add(expressionArgument);
                            lastArrayContent = new SmartList();
                        } else {
                            concatArguments.add(expressionArgument);
                        }
                    } else {
                        lastArrayContent.add(expressionArgument);
                    }
                    if (index2 == n) break;
                    ++index2;
                }
            }
            if (lastArrayContent.size() > 0) {
                concatArguments.add(new JsArrayLiteral(lastArrayContent));
            }
            return concatArguments;
        }

        /*
         * WARNING - void declaration
         */
        private final void extractArguments(List<JsExpression> argExpressions, List<? extends TranslationContext> argContexts, TranslationContext context, boolean toTmpVars) {
            int n;
            IntRange intRange = CollectionsKt.getIndices((Collection)argExpressions);
            int n2 = intRange.getFirst();
            if (n2 <= (n = intRange.getLast())) {
                while (true) {
                    void i;
                    TranslationContext argContext = argContexts.get((int)i);
                    JsExpression jsArgExpression = argExpressions.get((int)i);
                    if (argContext.currentBlockIsEmpty() && TranslationUtils.isCacheNeeded(jsArgExpression)) {
                        if (toTmpVars) {
                            TemporaryVariable temporaryVariable = context.declareTemporary(jsArgExpression);
                            context.addStatementToCurrentBlock(temporaryVariable.assignmentExpression().makeStmt());
                            JsNameRef jsNameRef = temporaryVariable.reference();
                            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "temporaryVariable.reference()");
                            argExpressions.set((int)i, jsNameRef);
                        } else {
                            context.addStatementToCurrentBlock(jsArgExpression.makeStmt());
                        }
                    } else {
                        context.addStatementsToCurrentBlockFrom(argContext);
                    }
                    if (i == n) break;
                    ++i;
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

