/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocElementTypes;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocElementImpl;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0016J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0002R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocTag;", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocElementImpl;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "knownTag", "Lorg/jetbrains/kotlin/kdoc/parser/KDocKnownTag;", "getKnownTag", "()Lorg/jetbrains/kotlin/kdoc/parser/KDocKnownTag;", "childrenAfterTagName", "", "getContent", "", "getName", "getSubjectLink", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocLink;", "getSubjectName", "hasSubject", "", "contentChildren", "kotlin-compiler"})
@KotlinClass(version={1, 1, 0}, data={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0016J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0002R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, strings={"Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocTag;", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocElementImpl;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "knownTag", "Lorg/jetbrains/kotlin/kdoc/parser/KDocKnownTag;", "getKnownTag", "()Lorg/jetbrains/kotlin/kdoc/parser/KDocKnownTag;", "childrenAfterTagName", "", "getContent", "", "getName", "getSubjectLink", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocLink;", "getSubjectName", "hasSubject", "", "contentChildren", "kotlin-compiler"})
public class KDocTag
extends KDocElementImpl {
    @Override
    @Nullable
    public String getName() {
        Object tagName = this.findChildByType(KDocTokens.TAG_NAME);
        if (tagName != null) {
            return StringsKt.substring(tagName.getText(), 1);
        }
        return null;
    }

    @Nullable
    public String getSubjectName() {
        KDocLink kDocLink = this.getSubjectLink();
        return kDocLink != null ? kDocLink.getLinkText() : null;
    }

    @Nullable
    public final KDocLink getSubjectLink() {
        List<ASTNode> children = this.childrenAfterTagName();
        if (this.hasSubject(children)) {
            ASTNode aSTNode = CollectionsKt.firstOrNull(children);
            PsiElement psiElement = aSTNode != null ? aSTNode.getPsi() : null;
            if (!(psiElement instanceof KDocLink)) {
                psiElement = null;
            }
            return (KDocLink)psiElement;
        }
        return null;
    }

    @Nullable
    public final KDocKnownTag getKnownTag() {
        return this.getName() != null ? KDocKnownTag.findByTagName(this.getName()) : (KDocKnownTag)null;
    }

    private final boolean hasSubject(List<? extends ASTNode> contentChildren) {
        KDocKnownTag kDocKnownTag = this.getKnownTag();
        if (kDocKnownTag != null ? kDocKnownTag.isReferenceRequired() : false) {
            ASTNode aSTNode = CollectionsKt.firstOrNull(contentChildren);
            return Intrinsics.areEqual(aSTNode != null ? aSTNode.getElementType() : null, KDocTokens.MARKDOWN_LINK);
        }
        return false;
    }

    private final List<ASTNode> childrenAfterTagName() {
        ASTNode it;
        Object item$iv;
        Object $receiver$iv = this.getNode().getChildren(null);
        boolean yielding$iv = false;
        ArrayList<Object> list$iv = new ArrayList<Object>();
        for (int i = 0; i < ((Object[])$receiver$iv).length; ++i) {
            item$iv = $receiver$iv[i];
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            it = (ASTNode)item$iv;
            if (Intrinsics.areEqual(it.getElementType(), KDocTokens.TAG_NAME)) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        $receiver$iv = list$iv;
        yielding$iv = false;
        list$iv = new ArrayList();
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv = iterator2.next();
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            it = (ASTNode)item$iv;
            if (Intrinsics.areEqual(it.getElementType(), TokenType.WHITE_SPACE)) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        return list$iv;
    }

    @NotNull
    public String getContent() {
        StringBuilder builder = new StringBuilder();
        boolean contentStarted = false;
        boolean afterAsterisk = false;
        List<ASTNode> children = this.childrenAfterTagName();
        if (this.hasSubject(children)) {
            children = CollectionsKt.drop((Iterable)children, 1);
        }
        for (ASTNode node : children) {
            IElementType type2 = node.getElementType();
            if (KDocTokens.CONTENT_TOKENS.contains(type2)) {
                String string;
                if (!contentStarted || afterAsterisk) {
                    string = StringsKt.trimStart(node.getText());
                } else {
                    String string2 = node.getText();
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull(string2, "node.text");
                }
                builder.append(string);
                contentStarted = true;
                afterAsterisk = false;
            }
            if (Intrinsics.areEqual(type2, KDocTokens.LEADING_ASTERISK)) {
                afterAsterisk = true;
            }
            if (Intrinsics.areEqual(type2, TokenType.WHITE_SPACE) && contentStarted) {
                builder.append(StringsKt.repeat("\n", StringUtil.countNewLines(node.getText())));
            }
            if (!Intrinsics.areEqual(type2, KDocElementTypes.KDOC_TAG)) continue;
            break;
        }
        return StringsKt.trimEnd(builder.toString(), ' ', '\t');
    }

    public KDocTag(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        super(node);
    }
}

