/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin.header;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.JvmBytecodeBinaryVersion;
import org.jetbrains.kotlin.load.kotlin.JvmMetadataVersion;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

public class ReadKotlinClassHeaderAnnotationVisitor
implements KotlinJvmBinaryClass.AnnotationVisitor {
    private static final boolean IGNORE_OLD_METADATA = "true".equals(System.getProperty("kotlin.ignore.old.metadata"));
    private static final Map<ClassId, KotlinClassHeader.Kind> HEADER_KINDS = new HashMap<ClassId, KotlinClassHeader.Kind>();
    private JvmMetadataVersion metadataVersion = null;
    private JvmBytecodeBinaryVersion bytecodeVersion = null;
    private String multifileClassName = null;
    private String[] data = null;
    private String[] strings = null;
    private KotlinClassHeader.Kind headerKind = null;

    @Nullable
    public KotlinClassHeader createHeader() {
        if (this.headerKind == null) {
            return null;
        }
        if (this.metadataVersion == null || !this.metadataVersion.isCompatible()) {
            this.data = null;
        } else if (this.shouldHaveData() && this.data == null) {
            return null;
        }
        return new KotlinClassHeader(this.headerKind, this.metadataVersion != null ? this.metadataVersion : JvmMetadataVersion.INVALID_VERSION, this.bytecodeVersion != null ? this.bytecodeVersion : JvmBytecodeBinaryVersion.INVALID_VERSION, this.data, this.strings, this.multifileClassName);
    }

    private boolean shouldHaveData() {
        return this.headerKind == KotlinClassHeader.Kind.CLASS || this.headerKind == KotlinClassHeader.Kind.FILE_FACADE || this.headerKind == KotlinClassHeader.Kind.MULTIFILE_CLASS_PART;
    }

    @Override
    @Nullable
    public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull ClassId classId, @NotNull SourceElement source) {
        if (classId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "visitAnnotation"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "visitAnnotation"));
        }
        FqName fqName2 = classId.asSingleFqName();
        if (fqName2.equals(JvmAnnotationNames.METADATA)) {
            return new KotlinMetadataArgumentVisitor();
        }
        if (IGNORE_OLD_METADATA) {
            return null;
        }
        if (this.headerKind != null) {
            return null;
        }
        KotlinClassHeader.Kind newKind = HEADER_KINDS.get(classId);
        if (newKind != null) {
            this.headerKind = newKind;
            return new HeaderAnnotationArgumentVisitor();
        }
        return null;
    }

    @Override
    public void visitEnd() {
    }

    static /* synthetic */ String[] access$602(ReadKotlinClassHeaderAnnotationVisitor x0, String[] x1) {
        x0.data = x1;
        return x1;
    }

    static /* synthetic */ String[] access$702(ReadKotlinClassHeaderAnnotationVisitor x0, String[] x1) {
        x0.strings = x1;
        return x1;
    }

    static {
        HEADER_KINDS.put(ClassId.topLevel(JvmAnnotationNames.KOTLIN_CLASS), KotlinClassHeader.Kind.CLASS);
        HEADER_KINDS.put(ClassId.topLevel(JvmAnnotationNames.KOTLIN_FILE_FACADE), KotlinClassHeader.Kind.FILE_FACADE);
        HEADER_KINDS.put(ClassId.topLevel(JvmAnnotationNames.KOTLIN_MULTIFILE_CLASS), KotlinClassHeader.Kind.MULTIFILE_CLASS);
        HEADER_KINDS.put(ClassId.topLevel(JvmAnnotationNames.KOTLIN_MULTIFILE_CLASS_PART), KotlinClassHeader.Kind.MULTIFILE_CLASS_PART);
        HEADER_KINDS.put(ClassId.topLevel(JvmAnnotationNames.KOTLIN_SYNTHETIC_CLASS), KotlinClassHeader.Kind.SYNTHETIC_CLASS);
    }

    private static abstract class CollectStringArrayAnnotationVisitor
    implements KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor {
        private final List<String> strings = new ArrayList<String>();

        @Override
        public void visit(@Nullable Object value) {
            if (value instanceof String) {
                this.strings.add((String)value);
            }
        }

        @Override
        public void visitEnum(@NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
            if (enumClassId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$CollectStringArrayAnnotationVisitor", "visitEnum"));
            }
            if (enumEntryName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$CollectStringArrayAnnotationVisitor", "visitEnum"));
            }
        }

        @Override
        public void visitEnd() {
            this.visitEnd(this.strings.toArray(new String[this.strings.size()]));
        }

        protected abstract void visitEnd(@NotNull String[] var1);
    }

    private class HeaderAnnotationArgumentVisitor
    implements KotlinJvmBinaryClass.AnnotationArgumentVisitor {
        private HeaderAnnotationArgumentVisitor() {
        }

        @Override
        public void visit(@Nullable Name name, @Nullable Object value) {
            if (name == null) {
                return;
            }
            String string = name.asString();
            if ("version".equals(string)) {
                if (value instanceof int[]) {
                    ReadKotlinClassHeaderAnnotationVisitor.this.metadataVersion = new JvmMetadataVersion((int[])value);
                    if (ReadKotlinClassHeaderAnnotationVisitor.this.bytecodeVersion == null) {
                        ReadKotlinClassHeaderAnnotationVisitor.this.bytecodeVersion = new JvmBytecodeBinaryVersion((int[])value);
                    }
                }
            } else if ("multifileClassName".equals(string)) {
                ReadKotlinClassHeaderAnnotationVisitor.this.multifileClassName = value instanceof String ? (String)value : null;
            }
        }

        @Override
        @Nullable
        public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitArray"));
            }
            String string = name.asString();
            if ("data".equals(string) || "filePartClassNames".equals(string)) {
                return this.dataArrayVisitor();
            }
            if ("strings".equals(string)) {
                return this.stringsArrayVisitor();
            }
            return null;
        }

        @NotNull
        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor dataArrayVisitor() {
            CollectStringArrayAnnotationVisitor collectStringArrayAnnotationVisitor = new CollectStringArrayAnnotationVisitor(){

                @Override
                protected void visitEnd(@NotNull String[] data) {
                    if (data == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor$1", "visitEnd"));
                    }
                    ReadKotlinClassHeaderAnnotationVisitor.access$602(ReadKotlinClassHeaderAnnotationVisitor.this, data);
                }
            };
            if (collectStringArrayAnnotationVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "dataArrayVisitor"));
            }
            return collectStringArrayAnnotationVisitor;
        }

        @NotNull
        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor stringsArrayVisitor() {
            CollectStringArrayAnnotationVisitor collectStringArrayAnnotationVisitor = new CollectStringArrayAnnotationVisitor(){

                @Override
                protected void visitEnd(@NotNull String[] data) {
                    if (data == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor$2", "visitEnd"));
                    }
                    ReadKotlinClassHeaderAnnotationVisitor.access$702(ReadKotlinClassHeaderAnnotationVisitor.this, data);
                }
            };
            if (collectStringArrayAnnotationVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "stringsArrayVisitor"));
            }
            return collectStringArrayAnnotationVisitor;
        }

        @Override
        public void visitEnum(@NotNull Name name, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitEnum"));
            }
            if (enumClassId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitEnum"));
            }
            if (enumEntryName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitEnum"));
            }
        }

        @Override
        @Nullable
        public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull Name name, @NotNull ClassId classId) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitAnnotation"));
            }
            if (classId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitAnnotation"));
            }
            return null;
        }

        @Override
        public void visitEnd() {
        }
    }

    private class KotlinMetadataArgumentVisitor
    implements KotlinJvmBinaryClass.AnnotationArgumentVisitor {
        private KotlinMetadataArgumentVisitor() {
        }

        @Override
        public void visit(@Nullable Name name, @Nullable Object value) {
            if (name == null) {
                return;
            }
            String string = name.asString();
            if ("k".equals(string)) {
                if (value instanceof Integer) {
                    ReadKotlinClassHeaderAnnotationVisitor.this.headerKind = KotlinClassHeader.Kind.getById((Integer)value);
                }
            } else if ("mv".equals(string)) {
                if (value instanceof int[]) {
                    ReadKotlinClassHeaderAnnotationVisitor.this.metadataVersion = new JvmMetadataVersion((int[])value);
                }
            } else if ("bv".equals(string)) {
                if (value instanceof int[]) {
                    ReadKotlinClassHeaderAnnotationVisitor.this.bytecodeVersion = new JvmBytecodeBinaryVersion((int[])value);
                }
            } else if ("xs".equals(string) && value instanceof String) {
                ReadKotlinClassHeaderAnnotationVisitor.this.multifileClassName = (String)value;
            }
        }

        @Override
        @Nullable
        public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$KotlinMetadataArgumentVisitor", "visitArray"));
            }
            String string = name.asString();
            if ("d1".equals(string)) {
                return this.dataArrayVisitor();
            }
            if ("d2".equals(string)) {
                return this.stringsArrayVisitor();
            }
            return null;
        }

        @NotNull
        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor dataArrayVisitor() {
            CollectStringArrayAnnotationVisitor collectStringArrayAnnotationVisitor = new CollectStringArrayAnnotationVisitor(){

                @Override
                protected void visitEnd(@NotNull String[] result) {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$KotlinMetadataArgumentVisitor$1", "visitEnd"));
                    }
                    ReadKotlinClassHeaderAnnotationVisitor.access$602(ReadKotlinClassHeaderAnnotationVisitor.this, result);
                }
            };
            if (collectStringArrayAnnotationVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$KotlinMetadataArgumentVisitor", "dataArrayVisitor"));
            }
            return collectStringArrayAnnotationVisitor;
        }

        @NotNull
        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor stringsArrayVisitor() {
            CollectStringArrayAnnotationVisitor collectStringArrayAnnotationVisitor = new CollectStringArrayAnnotationVisitor(){

                @Override
                protected void visitEnd(@NotNull String[] result) {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$KotlinMetadataArgumentVisitor$2", "visitEnd"));
                    }
                    ReadKotlinClassHeaderAnnotationVisitor.access$702(ReadKotlinClassHeaderAnnotationVisitor.this, result);
                }
            };
            if (collectStringArrayAnnotationVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$KotlinMetadataArgumentVisitor", "stringsArrayVisitor"));
            }
            return collectStringArrayAnnotationVisitor;
        }

        @Override
        public void visitEnum(@NotNull Name name, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$KotlinMetadataArgumentVisitor", "visitEnum"));
            }
            if (enumClassId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$KotlinMetadataArgumentVisitor", "visitEnum"));
            }
            if (enumEntryName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$KotlinMetadataArgumentVisitor", "visitEnum"));
            }
        }

        @Override
        @Nullable
        public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull Name name, @NotNull ClassId classId) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$KotlinMetadataArgumentVisitor", "visitAnnotation"));
            }
            if (classId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$KotlinMetadataArgumentVisitor", "visitAnnotation"));
            }
            return null;
        }

        @Override
        public void visitEnd() {
        }
    }
}

