/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.PreconditionsKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a8\u0006\u0004"}, d2={"findMemberWithMaxVisibility", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "descriptors", "", "kotlin-compiler"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a8\u0006\u0004"}, strings={"findMemberWithMaxVisibility", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "descriptors", "", "kotlin-compiler"})
public final class VisibilityUtilKt {
    @NotNull
    public static final CallableMemberDescriptor findMemberWithMaxVisibility(@NotNull Collection<? extends CallableMemberDescriptor> descriptors) {
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        PreconditionsKt.assert(CollectionsKt.isNotEmpty(descriptors));
        CallableMemberDescriptor descriptor2 = null;
        for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
            if (descriptor2 == null) {
                descriptor2 = callableMemberDescriptor;
                continue;
            }
            Integer result = Visibilities.compare(descriptor2.getVisibility(), callableMemberDescriptor.getVisibility());
            if (result == null || ((Number)result).intValue() >= 0) continue;
            descriptor2 = callableMemberDescriptor;
        }
        CallableMemberDescriptor callableMemberDescriptor = descriptor2;
        if (callableMemberDescriptor == null) {
            Intrinsics.throwNpe();
        }
        return callableMemberDescriptor;
    }
}

