/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateWithBoundDispatchReceiver;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateWithBoundDispatchReceiverImpl;
import org.jetbrains.kotlin.resolve.calls.tower.ErrorDescriptorDiagnostic;
import org.jetbrains.kotlin.resolve.calls.tower.LowPriorityDescriptorDiagnostic;
import org.jetbrains.kotlin.resolve.calls.tower.ResolutionDiagnostic;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTower;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerLevel;
import org.jetbrains.kotlin.resolve.calls.tower.SynthesizedDescriptorDiagnostic;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;
import org.jetbrains.kotlin.resolve.calls.tower.UsedSmartCastForDispatchReceiver;
import org.jetbrains.kotlin.resolve.calls.tower.VisibilityError;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JG\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0004\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0005\u001a\u00020\u00068DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/AbstractScopeTowerLevel;", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerLevel;", "scopeTower", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTower;", "(Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTower;)V", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "getLocation", "()Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "getScopeTower", "()Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTower;", "createCandidateDescriptor", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateWithBoundDispatchReceiver;", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "descriptor", "dispatchReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "specialError", "Lorg/jetbrains/kotlin/resolve/calls/tower/ResolutionDiagnostic;", "dispatchReceiverSmartCastType", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;Lorg/jetbrains/kotlin/resolve/calls/tower/ResolutionDiagnostic;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateWithBoundDispatchReceiver;", "kotlin-compiler"})
@KotlinClass(version={1, 1, 0}, data={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JG\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0004\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0005\u001a\u00020\u00068DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/tower/AbstractScopeTowerLevel;", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerLevel;", "scopeTower", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTower;", "(Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTower;)V", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "getLocation", "()Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "getScopeTower", "()Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTower;", "createCandidateDescriptor", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateWithBoundDispatchReceiver;", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "descriptor", "dispatchReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "specialError", "Lorg/jetbrains/kotlin/resolve/calls/tower/ResolutionDiagnostic;", "dispatchReceiverSmartCastType", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;Lorg/jetbrains/kotlin/resolve/calls/tower/ResolutionDiagnostic;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateWithBoundDispatchReceiver;", "kotlin-compiler"})
public abstract class AbstractScopeTowerLevel
implements ScopeTowerLevel {
    @NotNull
    private final ScopeTower scopeTower;

    @NotNull
    protected final LookupLocation getLocation() {
        return this.scopeTower.getLocation();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final <D extends CallableDescriptor> CandidateWithBoundDispatchReceiver<D> createCandidateDescriptor(@NotNull D descriptor2, @Nullable ReceiverValue dispatchReceiver, @Nullable ResolutionDiagnostic specialError, @Nullable KotlinType dispatchReceiverSmartCastType) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        SmartList<ResolutionDiagnostic> diagnostics = new SmartList<ResolutionDiagnostic>();
        CollectionsKt.addIfNotNull((Collection)diagnostics, specialError);
        if (ErrorUtils.isError(descriptor2)) {
            diagnostics.add(ErrorDescriptorDiagnostic.INSTANCE);
        } else {
            Boolean bl;
            if (AnnotationsForResolveKt.hasLowPriorityInOverloadResolution(descriptor2)) {
                diagnostics.add(LowPriorityDescriptorDiagnostic.INSTANCE);
            }
            if (TowerUtilsKt.isSynthesized(descriptor2)) {
                diagnostics.add(SynthesizedDescriptorDiagnostic.INSTANCE);
            }
            if (dispatchReceiverSmartCastType != null) {
                diagnostics.add(new UsedSmartCastForDispatchReceiver(dispatchReceiverSmartCastType));
            }
            DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = Visibilities.findInvisibleMember(dispatchReceiver, descriptor2, this.scopeTower.getLexicalScope().getOwnerDescriptor());
            if (declarationDescriptorWithVisibility != null) {
                void $receiver$iv;
                DeclarationDescriptorWithVisibility it;
                DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility2 = declarationDescriptorWithVisibility;
                DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility3 = it = (DeclarationDescriptorWithVisibility)$receiver$iv;
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptorWithVisibility3, "it");
                bl = diagnostics.add(new VisibilityError(declarationDescriptorWithVisibility3));
            } else {
                bl = null;
            }
        }
        return new CandidateWithBoundDispatchReceiverImpl<D>(dispatchReceiver, descriptor2, (List<? extends ResolutionDiagnostic>)diagnostics);
    }

    @NotNull
    protected static /* bridge */ /* synthetic */ CandidateWithBoundDispatchReceiver createCandidateDescriptor$default(AbstractScopeTowerLevel abstractScopeTowerLevel, CallableDescriptor callableDescriptor, ReceiverValue receiverValue, ResolutionDiagnostic resolutionDiagnostic, KotlinType kotlinType, int n, Object object) {
        if ((n & 4) != 0) {
            resolutionDiagnostic = null;
        }
        if ((n & 8) != 0) {
            kotlinType = null;
        }
        return abstractScopeTowerLevel.createCandidateDescriptor(callableDescriptor, receiverValue, resolutionDiagnostic, kotlinType);
    }

    protected static /* bridge */ /* synthetic */ CandidateWithBoundDispatchReceiver createCandidateDescriptor$default(AbstractScopeTowerLevel abstractScopeTowerLevel, CallableDescriptor callableDescriptor, ReceiverValue receiverValue, ResolutionDiagnostic resolutionDiagnostic, KotlinType kotlinType, int n) {
        return AbstractScopeTowerLevel.createCandidateDescriptor$default(abstractScopeTowerLevel, callableDescriptor, receiverValue, resolutionDiagnostic, kotlinType, n, null);
    }

    @NotNull
    protected final ScopeTower getScopeTower() {
        return this.scopeTower;
    }

    public AbstractScopeTowerLevel(@NotNull ScopeTower scopeTower) {
        Intrinsics.checkParameterIsNotNull(scopeTower, "scopeTower");
        this.scopeTower = scopeTower;
    }
}

