/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import java.io.IOException;
import java.io.OutputStream;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.StringTable;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.Interner;

public class StringTableImpl
implements StringTable {
    private final Interner<String> strings = new Interner();
    private final Interner<FqNameProto> qualifiedNames = new Interner();

    public int getSimpleNameIndex(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/serialization/StringTableImpl", "getSimpleNameIndex"));
        }
        return this.getStringIndex(name.asString());
    }

    @Override
    public int getStringIndex(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "org/jetbrains/kotlin/serialization/StringTableImpl", "getStringIndex"));
        }
        return this.strings.intern(string);
    }

    @Override
    public int getFqNameIndex(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/StringTableImpl", "getFqNameIndex"));
        }
        if (ErrorUtils.isError(descriptor2)) {
            throw new IllegalStateException("Cannot get FQ name of error class: " + descriptor2);
        }
        ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
        builder.setKind(ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS);
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            FqName packageFqName = ((PackageFragmentDescriptor)containingDeclaration).getFqName();
            if (!packageFqName.isRoot()) {
                builder.setParentQualifiedName(this.getPackageFqNameIndex(packageFqName));
            }
        } else if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor outerClass = (ClassDescriptor)containingDeclaration;
            builder.setParentQualifiedName(this.getFqNameIndex(outerClass));
        } else {
            throw new IllegalStateException("Cannot get FQ name of local class: " + descriptor2);
        }
        builder.setShortName(this.getStringIndex(descriptor2.getName().asString()));
        return this.qualifiedNames.intern(new FqNameProto(builder));
    }

    public int getPackageFqNameIndex(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/serialization/StringTableImpl", "getPackageFqNameIndex"));
        }
        int result = -1;
        for (Name segment : fqName2.pathSegments()) {
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
            builder.setShortName(this.getSimpleNameIndex(segment));
            if (result != -1) {
                builder.setParentQualifiedName(result);
            }
            result = this.qualifiedNames.intern(new FqNameProto(builder));
        }
        return result;
    }

    @NotNull
    public Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> buildProto() {
        ProtoBuf.StringTable.Builder strings = ProtoBuf.StringTable.newBuilder();
        for (String simpleName : this.strings.getAllInternedObjects()) {
            strings.addString(simpleName);
        }
        ProtoBuf.QualifiedNameTable.Builder qualifiedNames = ProtoBuf.QualifiedNameTable.newBuilder();
        for (FqNameProto fqName2 : this.qualifiedNames.getAllInternedObjects()) {
            qualifiedNames.addQualifiedName(fqName2.fqName);
        }
        Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> pair = new Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable>(strings.build(), qualifiedNames.build());
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/StringTableImpl", "buildProto"));
        }
        return pair;
    }

    @Override
    public void serializeTo(@NotNull OutputStream output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "org/jetbrains/kotlin/serialization/StringTableImpl", "serializeTo"));
        }
        try {
            Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> protos = this.buildProto();
            protos.getFirst().writeDelimitedTo(output);
            protos.getSecond().writeDelimitedTo(output);
        }
        catch (IOException e) {
            throw ExceptionUtilsKt.rethrow(e);
        }
    }

    private static final class FqNameProto {
        public final ProtoBuf.QualifiedNameTable.QualifiedName.Builder fqName;

        public FqNameProto(@NotNull ProtoBuf.QualifiedNameTable.QualifiedName.Builder fqName2) {
            if (fqName2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/serialization/StringTableImpl$FqNameProto", "<init>"));
            }
            this.fqName = fqName2;
        }

        public int hashCode() {
            int result = 13;
            result = 31 * result + this.fqName.getParentQualifiedName();
            result = 31 * result + this.fqName.getShortName();
            result = 31 * result + this.fqName.getKind().hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder other = ((FqNameProto)obj).fqName;
            return this.fqName.getParentQualifiedName() == other.getParentQualifiedName() && this.fqName.getShortName() == other.getShortName() && this.fqName.getKind() == other.getKind();
        }
    }
}

