/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;
import org.jetbrains.kotlin.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingComponents;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitorDispatcher;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class ExpressionTypingServices {
    private final ExpressionTypingFacade expressionTypingFacade;
    private final ExpressionTypingComponents expressionTypingComponents;
    @NotNull
    private final AnnotationChecker annotationChecker;
    @NotNull
    private final StatementFilter statementFilter;

    public ExpressionTypingServices(@NotNull ExpressionTypingComponents components, @NotNull AnnotationChecker annotationChecker, @NotNull StatementFilter statementFilter, @NotNull ExpressionTypingVisitorDispatcher.ForDeclarations facade) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "<init>"));
        }
        if (annotationChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationChecker", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "<init>"));
        }
        if (statementFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementFilter", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "<init>"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "<init>"));
        }
        this.expressionTypingComponents = components;
        this.annotationChecker = annotationChecker;
        this.statementFilter = statementFilter;
        this.expressionTypingFacade = facade;
    }

    @NotNull
    public StatementFilter getStatementFilter() {
        StatementFilter statementFilter = this.statementFilter;
        if (statementFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getStatementFilter"));
        }
        return statementFilter;
    }

    @NotNull
    public KotlinType safeGetType(@NotNull LexicalScope scope2, @NotNull KtExpression expression, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "safeGetType"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "safeGetType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "safeGetType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "safeGetType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "safeGetType"));
        }
        KotlinType type2 = this.getType(scope2, expression, expectedType, dataFlowInfo, trace);
        KotlinType kotlinType = type2 != null ? type2 : ErrorUtils.createErrorType("Type for " + expression.getText());
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "safeGetType"));
        }
        return kotlinType;
    }

    @NotNull
    public KotlinTypeInfo getTypeInfo(@NotNull LexicalScope scope2, @NotNull KtExpression expression, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace, boolean isStatement) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeInfo"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeInfo"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeInfo"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeInfo"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeInfo"));
        }
        ExpressionTypingContext context = ExpressionTypingContext.newContext(trace, scope2, dataFlowInfo, expectedType);
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingFacade.getTypeInfo(expression, context, isStatement);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeInfo"));
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinTypeInfo getTypeInfo(@NotNull KtExpression expression, @NotNull ResolutionContext resolutionContext) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeInfo"));
        }
        if (resolutionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionContext", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeInfo"));
        }
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingFacade.getTypeInfo(expression, ExpressionTypingContext.newContext(resolutionContext));
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeInfo"));
        }
        return kotlinTypeInfo;
    }

    @Nullable
    public KotlinType getType(@NotNull LexicalScope scope2, @NotNull KtExpression expression, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getType"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getType"));
        }
        return this.getTypeInfo(scope2, expression, expectedType, dataFlowInfo, trace, false).getType();
    }

    public void checkFunctionReturnType(@NotNull LexicalScope functionInnerScope, @NotNull KtDeclarationWithBody function, @NotNull FunctionDescriptor functionDescriptor, @NotNull DataFlowInfo dataFlowInfo, @Nullable KotlinType expectedReturnType, BindingTrace trace) {
        if (functionInnerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionInnerScope", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "checkFunctionReturnType"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "checkFunctionReturnType"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "checkFunctionReturnType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "checkFunctionReturnType"));
        }
        if (expectedReturnType == null) {
            expectedReturnType = functionDescriptor.getReturnType();
            if (!function.hasBlockBody() && !function.hasDeclaredReturnType()) {
                expectedReturnType = TypeUtils.NO_EXPECTED_TYPE;
            }
        }
        this.checkFunctionReturnType(function, ExpressionTypingContext.newContext(trace, functionInnerScope, dataFlowInfo, expectedReturnType != null ? expectedReturnType : TypeUtils.NO_EXPECTED_TYPE));
    }

    void checkFunctionReturnType(KtDeclarationWithBody function, ExpressionTypingContext context) {
        KtExpression bodyExpression = function.getBodyExpression();
        if (bodyExpression == null) {
            return;
        }
        boolean blockBody = function.hasBlockBody();
        ExpressionTypingContext newContext = blockBody ? (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE) : context;
        this.expressionTypingFacade.getTypeInfo(bodyExpression, newContext, blockBody);
    }

    @NotNull
    public KotlinTypeInfo getBlockReturnedType(KtBlockExpression expression, ExpressionTypingContext context, boolean isStatement) {
        KotlinTypeInfo kotlinTypeInfo = this.getBlockReturnedType(expression, isStatement ? CoercionStrategy.COERCION_TO_UNIT : CoercionStrategy.NO_COERCION, context);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBlockReturnedType"));
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinTypeInfo getBlockReturnedType(@NotNull KtBlockExpression expression, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBlockReturnedType"));
        }
        if (coercionStrategyForLastExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coercionStrategyForLastExpression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBlockReturnedType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBlockReturnedType"));
        }
        List<KtExpression> block = StatementFilterKt.filterStatements(this.statementFilter, expression);
        DeclarationDescriptor containingDescriptor = context.scope.getOwnerDescriptor();
        LexicalWritableScope scope2 = new LexicalWritableScope(context.scope, containingDescriptor, false, null, new TraceBasedRedeclarationHandler(context.trace), LexicalScopeKind.CODE_BLOCK);
        scope2.changeLockLevel(LexicalWritableScope.LockLevel.BOTH);
        KotlinTypeInfo r = block.isEmpty() ? this.expressionTypingComponents.dataFlowAnalyzer.createCheckedTypeInfo(this.expressionTypingComponents.builtIns.getUnitType(), context, expression) : this.getBlockReturnedTypeWithWritableScope(scope2, block, coercionStrategyForLastExpression, (ExpressionTypingContext)context.replaceStatementFilter(this.statementFilter));
        scope2.changeLockLevel(LexicalWritableScope.LockLevel.READING);
        if (containingDescriptor instanceof ScriptDescriptor) {
            context.trace.record(BindingContext.SCRIPT_SCOPE, (ScriptDescriptor)containingDescriptor, scope2);
        }
        KotlinTypeInfo kotlinTypeInfo = r;
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBlockReturnedType"));
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinType getBodyExpressionType(@NotNull BindingTrace trace, @NotNull LexicalScope outerScope, @NotNull DataFlowInfo dataFlowInfo, @NotNull KtDeclarationWithBody function, @NotNull FunctionDescriptor functionDescriptor) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBodyExpressionType"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBodyExpressionType"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBodyExpressionType"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBodyExpressionType"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBodyExpressionType"));
        }
        KtExpression bodyExpression = function.getBodyExpression();
        assert (bodyExpression != null);
        LexicalScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(outerScope, functionDescriptor, trace);
        ExpressionTypingContext context = ExpressionTypingContext.newContext(trace, functionInnerScope, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE);
        KotlinTypeInfo typeInfo = this.expressionTypingFacade.getTypeInfo(bodyExpression, context, function.hasBlockBody());
        KotlinType type2 = typeInfo.getType();
        if (type2 != null) {
            KotlinType kotlinType = type2;
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBodyExpressionType"));
            }
            return kotlinType;
        }
        KotlinType kotlinType = ErrorUtils.createErrorType("Error function type");
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBodyExpressionType"));
        }
        return kotlinType;
    }

    KotlinTypeInfo getBlockReturnedTypeWithWritableScope(@NotNull LexicalWritableScope scope2, @NotNull List<? extends KtElement> block, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingContext context) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBlockReturnedTypeWithWritableScope"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBlockReturnedTypeWithWritableScope"));
        }
        if (coercionStrategyForLastExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coercionStrategyForLastExpression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBlockReturnedTypeWithWritableScope"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getBlockReturnedTypeWithWritableScope"));
        }
        if (block.isEmpty()) {
            return TypeInfoFactoryKt.createTypeInfo(this.expressionTypingComponents.builtIns.getUnitType(), context);
        }
        ExpressionTypingVisitorDispatcher.ForBlock blockLevelVisitor = new ExpressionTypingVisitorDispatcher.ForBlock(this.expressionTypingComponents, this.annotationChecker, scope2);
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(scope2)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KotlinTypeInfo result = TypeInfoFactoryKt.noTypeInfo(context);
        DataFlowInfo beforeJumpInfo = newContext.dataFlowInfo;
        boolean jumpOutPossible = false;
        Iterator<? extends KtElement> iterator2 = block.iterator();
        while (iterator2.hasNext()) {
            KtElement statement = iterator2.next();
            if (!(statement instanceof KtExpression)) continue;
            KtExpression statementExpression = (KtExpression)statement;
            if (!iterator2.hasNext()) {
                result = this.getTypeOfLastExpressionInBlock(statementExpression, (ExpressionTypingContext)newContext.replaceExpectedType(context.expectedType), coercionStrategyForLastExpression, blockLevelVisitor);
                if (result.getType() != null && statementExpression.getParent() instanceof KtBlockExpression) {
                    DataFlowValue lastExpressionValue = DataFlowValueFactory.createDataFlowValue(statementExpression, result.getType(), context);
                    DataFlowValue blockExpressionValue = DataFlowValueFactory.createDataFlowValue((KtBlockExpression)statementExpression.getParent(), result.getType(), context);
                    result = result.replaceDataFlowInfo(result.getDataFlowInfo().assign(blockExpressionValue, lastExpressionValue));
                }
            } else {
                result = blockLevelVisitor.getTypeInfo(statementExpression, (ExpressionTypingContext)newContext.replaceContextDependency(ContextDependency.INDEPENDENT), true);
            }
            DataFlowInfo newDataFlowInfo = result.getDataFlowInfo();
            if (!jumpOutPossible) {
                beforeJumpInfo = result.getJumpFlowInfo();
                jumpOutPossible = result.getJumpOutPossible();
            }
            if (newDataFlowInfo != context.dataFlowInfo) {
                newContext = (ExpressionTypingContext)newContext.replaceDataFlowInfo(newDataFlowInfo);
            }
            blockLevelVisitor = new ExpressionTypingVisitorDispatcher.ForBlock(this.expressionTypingComponents, this.annotationChecker, scope2);
        }
        return result.replaceJumpOutPossible(jumpOutPossible).replaceJumpFlowInfo(beforeJumpInfo);
    }

    private KotlinTypeInfo getTypeOfLastExpressionInBlock(@NotNull KtExpression statementExpression, @NotNull ExpressionTypingContext context, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingInternals blockLevelVisitor) {
        if (statementExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementExpression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeOfLastExpressionInBlock"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeOfLastExpressionInBlock"));
        }
        if (coercionStrategyForLastExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coercionStrategyForLastExpression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeOfLastExpressionInBlock"));
        }
        if (blockLevelVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockLevelVisitor", "org/jetbrains/kotlin/types/expressions/ExpressionTypingServices", "getTypeOfLastExpressionInBlock"));
        }
        if (context.expectedType != TypeUtils.NO_EXPECTED_TYPE) {
            KotlinType expectedType = context.expectedType == TypeUtils.UNIT_EXPECTED_TYPE || coercionStrategyForLastExpression == CoercionStrategy.COERCION_TO_UNIT && KotlinBuiltIns.isUnit(context.expectedType) ? TypeUtils.UNIT_EXPECTED_TYPE : context.expectedType;
            return blockLevelVisitor.getTypeInfo(statementExpression, (ExpressionTypingContext)context.replaceExpectedType(expectedType), true);
        }
        KotlinTypeInfo result = blockLevelVisitor.getTypeInfo(statementExpression, context, true);
        if (coercionStrategyForLastExpression == CoercionStrategy.COERCION_TO_UNIT) {
            KtBinaryExpression binaryExpression;
            IElementType operationType;
            boolean mightBeUnit = false;
            if (statementExpression instanceof KtDeclaration) {
                mightBeUnit = true;
            }
            if (statementExpression instanceof KtBinaryExpression && ((operationType = (binaryExpression = (KtBinaryExpression)statementExpression).getOperationToken()) == KtTokens.EQ || OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType))) {
                mightBeUnit = true;
            }
            if (mightBeUnit) {
                assert (result.getType() == null || KotlinBuiltIns.isUnit(result.getType()));
                result = result.replaceType(this.expressionTypingComponents.builtIns.getUnitType());
            }
        }
        return result;
    }
}

