/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util.slicedMap;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.BasicWritableSlice;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.RewritePolicy;
import org.jetbrains.kotlin.util.slicedMap.SlicedMap;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class Slices {
    private static final Logger LOG = Logger.getInstance(Slices.class);
    public static final RewritePolicy ONLY_REWRITE_TO_EQUAL = new RewritePolicy(){

        @Override
        public <K> boolean rewriteProcessingNeeded(K key) {
            return true;
        }

        @Override
        public <K, V> boolean processRewrite(WritableSlice<K, V> slice, K key, V oldValue, V newValue) {
            if (!(oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue))) {
                LOG.error("Rewrite at slice " + slice + " key: " + key + " old value: " + oldValue + '@' + System.identityHashCode(oldValue) + " new value: " + newValue + '@' + System.identityHashCode(newValue) + (key instanceof KtElement ? "\n" + PsiUtilsKt.getElementTextWithContext((KtElement)key) : ""));
            }
            return true;
        }
    };

    private Slices() {
    }

    public static <K, V> SliceBuilder<K, V> sliceBuilder() {
        return new SliceBuilder(ONLY_REWRITE_TO_EQUAL);
    }

    public static <K, V> WritableSlice<K, V> createSimpleSlice() {
        return new BasicWritableSlice(ONLY_REWRITE_TO_EQUAL);
    }

    public static <K, V> WritableSlice<K, V> createCollectiveSlice() {
        return new BasicWritableSlice(ONLY_REWRITE_TO_EQUAL, true);
    }

    public static <K> WritableSlice<K, Boolean> createSimpleSetSlice() {
        return new SetSlice(RewritePolicy.DO_NOTHING);
    }

    public static <K> WritableSlice<K, Boolean> createCollectiveSetSlice() {
        return new SetSlice(RewritePolicy.DO_NOTHING, true);
    }

    public static class SetSlice<K>
    extends BasicWritableSlice<K, Boolean> {
        protected SetSlice(RewritePolicy rewritePolicy) {
            this(rewritePolicy, false);
        }

        protected SetSlice(RewritePolicy rewritePolicy, boolean collective) {
            super(rewritePolicy, collective);
        }

        @Override
        public Boolean computeValue(SlicedMap map2, K key, Boolean value, boolean valueNotFound) {
            Boolean result = super.computeValue(map2, key, value, valueNotFound);
            return result != null ? result : false;
        }
    }

    public static class SliceBuilder<K, V> {
        private List<ReadOnlySlice<K, V>> furtherLookupSlices;
        private final RewritePolicy rewritePolicy;
        private String debugName;

        private SliceBuilder(RewritePolicy rewritePolicy) {
            this.rewritePolicy = rewritePolicy;
        }

        public SliceBuilder<K, V> setFurtherLookupSlices(ReadOnlySlice<K, V> ... furtherLookupSlices) {
            this.furtherLookupSlices = Arrays.asList(furtherLookupSlices);
            return this;
        }

        public SliceBuilder<K, V> setDebugName(@NotNull String debugName) {
            if (debugName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/util/slicedMap/Slices$SliceBuilder", "setDebugName"));
            }
            this.debugName = debugName;
            return this;
        }

        public WritableSlice<K, V> build() {
            BasicWritableSlice<K, V> result = this.doBuild();
            if (this.debugName != null) {
                result.setDebugName(this.debugName);
            }
            return result;
        }

        private BasicWritableSlice<K, V> doBuild() {
            if (this.furtherLookupSlices != null) {
                return new BasicWritableSlice<K, V>(this.rewritePolicy){

                    @Override
                    public V computeValue(SlicedMap map2, K key, V value, boolean valueNotFound) {
                        if (valueNotFound) {
                            for (ReadOnlySlice slice : SliceBuilder.this.furtherLookupSlices) {
                                Object v = map2.get(slice, key);
                                if (v == null) continue;
                                return v;
                            }
                            return null;
                        }
                        return super.computeValue(map2, key, value, false);
                    }
                };
            }
            return new BasicWritableSlice(this.rewritePolicy);
        }
    }
}

